/*
 * Decompiled with CFR 0.152.
 */
package pmr.gui;

import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import pmr.PMR;

public class LuzTT
extends JLabel {
    static List<LuzTT> luces = new ArrayList<LuzTT>();
    PMR pmr;
    String name_luz;
    TipoLuz tipo;
    ImageIcon on;
    ImageIcon off;
    boolean prevenc;

    LuzTT(TipoLuz tipo, PMR pmr) {
        this.pmr = pmr;
        this.tipo = tipo;
        this.setHorizontalAlignment(0);
        luces.add(this);
        this.name_luz = tipo == TipoLuz.CON ? "CONL" : tipo.name();
        this.resize(1.0f);
    }

    boolean encendida() {
        if (this.pmr.client == null) {
            return false;
        }
        if (this.tipo == TipoLuz.RF && this.pmr.client.rf()) {
            return true;
        }
        if (this.tipo == TipoLuz.OC && this.pmr.client.ocupado()) {
            return true;
        }
        if (this.tipo == TipoLuz.CON && this.pmr.client.con()) {
            return true;
        }
        return this.tipo == TipoLuz.ML && this.pmr.descolgado;
    }

    public void update() {
        boolean enc = this.encendida();
        this.setIcon(enc ? this.on : this.off);
        if (this.prevenc != enc) {
            this.pmr.arduino.sendData("tt::luz::" + (this.tipo == TipoLuz.megafonia ? "alt" : this.tipo.name().toLowerCase()) + '=' + (enc ? (char)'1' : '0'));
        }
        this.prevenc = enc;
    }

    void resize(float scale) {
        URL location = this.getClass().getResource("/Content/Luces/" + this.name_luz + ".png");
        ImageIcon ic = new ImageIcon(location);
        Image img = ic.getImage();
        Image newimg = img.getScaledInstance((int)((float)img.getWidth(ic.getImageObserver()) * (scale /= 2.0f)), (int)((float)img.getHeight(ic.getImageObserver()) * scale), 4);
        this.on = new ImageIcon(newimg);
        location = this.getClass().getResource("/Content/Luces/" + this.name_luz + "_off.png");
        ic = new ImageIcon(location);
        img = ic.getImage();
        newimg = img.getScaledInstance((int)((float)img.getWidth(ic.getImageObserver()) * scale), (int)((float)img.getHeight(ic.getImageObserver()) * scale), 4);
        this.off = new ImageIcon(newimg);
    }

    static enum TipoLuz {
        RF,
        OC,
        INT,
        megafonia,
        TDC,
        ML,
        CON;

    }
}

