/*
 * Decompiled with CFR 0.152.
 */
package pmr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import pmr.PMR;
import streaming.Input;
import streaming.Output;

public class Client {
    Socket client;
    int canalconectado = -1;
    PMR pmr;
    InputStream in;
    OutputStream out;
    Output audioOut;
    Hashtable<Integer, String> ips = new Hashtable();
    boolean p2p = false;
    boolean enviando;
    boolean recibiendo;

    Client(PMR pmr) {
        this.pmr = pmr;
        try {
            FileReader fileReader = new FileReader("pmr_ips.ini");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] token = line.trim().split("=");
                if (token.length == 2) {
                    String[] canales;
                    String ip = token[0].trim();
                    String[] stringArray = canales = token[1].trim().split(",");
                    int n = canales.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String canal = stringArray[n2];
                        this.ips.put(Integer.parseInt(canal), ip);
                        ++n2;
                    }
                }
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.ips.isEmpty()) {
            String ip = JOptionPane.showInputDialog("IP a la que conectarse");
            this.p2p = true;
            int i = 0;
            while (i < 100) {
                this.ips.put(i, ip);
                ++i;
            }
        }
        new Timer(500, arg0 -> new Thread(() -> this.update()).start()).start();
        new Timer(10000, arg0 -> new Thread(() -> this.alive()).start()).start();
        new Thread(() -> {
            while (true) {
                this.recibirMensaje();
            }
        }).start();
    }

    synchronized void update() {
        if (this.pmr.canal == -1 || this.pmr.modo == PMR.Modo.C) {
            this.canalconectado = -1;
        } else if (this.pmr.canal != this.canalconectado) {
            try {
                if (this.client != null) {
                    this.client.close();
                }
                this.client = new Socket(this.ips.getOrDefault(this.pmr.canal, "127.0.0.1"), this.p2p ? 48300 + this.pmr.canal : 48301);
                this.in = this.client.getInputStream();
                this.out = this.client.getOutputStream();
                this.out.write(new byte[]{(byte)this.pmr.canal, 1});
                this.canalconectado = this.pmr.canal;
                this.alive();
            }
            catch (IOException e) {
                this.client = null;
                this.canalconectado = -1;
                e.printStackTrace();
            }
        }
    }

    public boolean conectado() {
        return this.client != null && this.client.isConnected();
    }

    public boolean rf() {
        return this.pmr.canal >= 0 && !this.conectado();
    }

    public boolean ocupado() {
        return this.conectado() && this.recibiendo;
    }

    public boolean con() {
        if (this.conectado() && this.enviando) {
            return true;
        }
        if (this.pmr.estado == PMR.Estado.MensajeEnviado) {
            return System.currentTimeMillis() / 500L % 2L == 0L;
        }
        return false;
    }

    public synchronized boolean enviar(byte[] datos) {
        if (this.enviando) {
            return false;
        }
        if (this.pmr.ntren < 0) {
            return false;
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        this.enviando = true;
        o.write((byte)(this.pmr.ntren / 65536));
        o.write((byte)(this.pmr.ntren / 256 % 256));
        o.write((byte)(this.pmr.ntren % 256));
        o.write(datos, 0, datos.length);
        byte[] b = o.toByteArray();
        try {
            int i = 0;
            while (i < b.length) {
                this.out.write(b[i]);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.enviando = false;
            return true;
        }
        catch (IOException e) {
            this.client = null;
            this.canalconectado = -1;
            e.printStackTrace();
            this.enviando = false;
            return false;
        }
    }

    public boolean enviarMensaje(PMR.Mensajes mensaje) {
        return this.enviar(new byte[]{(byte)mensaje.getId()});
    }

    public boolean enviarTexto(String texto) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(-1);
        byte[] tb = texto.getBytes();
        o.write((byte)tb.length);
        o.write(tb, 0, tb.length);
        return this.enviar(o.toByteArray());
    }

    public void enviarAudio() {
        while (this.enviando) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.enviando = true;
        Input in = new Input();
        try {
            while (this.pmr.estado == PMR.Estado.ComunicacionEstablecida && this.pmr.descolgado) {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write((byte)(this.pmr.ntren / 65536));
                o.write((byte)(this.pmr.ntren / 256 % 256));
                o.write((byte)(this.pmr.ntren % 256));
                o.write(-3);
                o.write(in.getAudio());
                this.out.write(o.toByteArray());
            }
            this.out.write(new byte[]{-1, -1, -1, -4});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.enviando = false;
        in.stop();
    }

    public void alive() {
        if (this.client == null) {
            return;
        }
        this.enviar(new byte[]{-2});
    }

    void recibirMensaje() {
        if (this.client == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            int trn = this.in.read();
            if (trn == -1) {
                throw new EOFException();
            }
            this.recibiendo = true;
            trn = this.in.read() + trn * 256;
            trn = this.in.read() + trn * 256;
            int code = this.in.read();
            if (code != 253 && code != PMR.Mensajes.Hable.getId() && code != PMR.Mensajes.HableConPMovil.getId() && code != PMR.Mensajes.LlamadaGeneral.getId() && code != PMR.Mensajes.ConexionMegafonia.getId()) {
                if (this.audioOut != null) {
                    this.audioOut.stop();
                    this.audioOut = null;
                }
                if (this.pmr.estado == PMR.Estado.ComunicacionEstablecida || this.pmr.estado == PMR.Estado.ComunicacionRecibida) {
                    this.pmr.mensaje_recibido = null;
                    this.pmr.estado = PMR.Estado.Normal;
                    this.pmr.descolgado = false;
                }
            }
            if (code == 255) {
                int length = this.in.read();
                byte[] data = new byte[length];
                int i = 0;
                while (i < length) {
                    data[i] = (byte)this.in.read();
                    ++i;
                }
                if (trn == this.pmr.ntren) {
                    this.pmr.textoRecibido(new String(data));
                }
            } else if (code == 253) {
                if (this.audioOut == null && trn == this.pmr.ntren) {
                    this.audioOut = new Output();
                }
                byte[] data = new byte[Input.BUFFERSIZE];
                int numread = 0;
                while (numread < Input.BUFFERSIZE) {
                    numread += this.in.read(data, numread, Input.BUFFERSIZE - numread);
                }
                if (this.pmr.estado == PMR.Estado.ComunicacionEstablecida && this.pmr.descolgado || this.pmr.estado == PMR.Estado.ComunicacionRecibida) {
                    if (this.audioOut == null) {
                        this.audioOut = new Output();
                    }
                    this.audioOut.play(data);
                }
            } else if (code != 252 && (trn == this.pmr.ntren || trn == 0xFFFFFF)) {
                this.pmr.mensajeRecibido(PMR.Mensajes.fromId(code));
            }
            if (code != 253) {
                this.recibiendo = false;
            }
        }
        catch (IOException e) {
            this.client = null;
            this.canalconectado = -1;
            this.recibiendo = false;
            e.printStackTrace();
        }
    }
}

