/*
 * Decompiled with CFR 0.152.
 */
package streaming;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class Input {
    public static int BUFFERSIZE = 2048;
    TargetDataLine microphone;

    public Input() {
        AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, true);
        try {
            this.microphone = AudioSystem.getTargetDataLine(format);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            this.microphone = (TargetDataLine)AudioSystem.getLine(info);
            this.microphone.open(format);
            this.microphone.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.microphone != null) {
            this.microphone.close();
        }
    }

    public byte[] getAudio() {
        if (this.microphone == null) {
            return null;
        }
        byte[] data = new byte[BUFFERSIZE];
        int bytesRead = 0;
        try {
            while (bytesRead < BUFFERSIZE) {
                bytesRead += this.microphone.read(data, bytesRead, data.length - bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }
}

