/*
 * Decompiled with CFR 0.152.
 */
package pmr;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import javax.swing.Timer;
import pmr.Arduino;
import pmr.Client;
import pmr.gui.BotonTT;
import pmr.gui.PanelTT;

public class PMR {
    PanelTT panel;
    Modo modo = Modo.A;
    int canal = -1;
    int ntren = -1;
    public Client client;
    public Arduino arduino;
    HashMap<Mensajes, String> mensajes_tierra = new HashMap();
    HashMap<Mensajes, String> mensajes_tren = new HashMap();
    Estado estado;
    String datos_introduciendose;
    Mensajes mensaje_enviado;
    Mensajes mensaje_recibido;
    long tiempo_mensaje;
    String texto_recibido;
    String texto_enviado;
    public boolean descolgado = false;
    TextKeyboard teclado_texto;
    boolean enviar_bien = false;
    boolean preguntar_hora = false;
    boolean ontop = false;
    Timer envio_mensaje;
    Timer envio_texto;

    public static void main(String[] args) {
        new PMR();
    }

    public PMR() {
        this.arduino = new Arduino(this);
        try {
            FileReader fileReader = new FileReader("pmr_cfg.ini");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] token = line.trim().split("=");
                if (token.length == 2) {
                    token[0] = token[0].trim();
                    token[1] = token[1].trim();
                    if (token[0].equalsIgnoreCase("preguntarhora")) {
                        String val = token[1];
                        this.preguntar_hora = val.equals("1") || val.equalsIgnoreCase("true");
                    }
                }
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.estado = Estado.Normal;
        this.panel = new PanelTT(this);
        this.mensajes_tren.put(Mensajes.PidoHablar, "PIDO HABLAR");
        this.mensajes_tren.put(Mensajes.EntroBanda, "ENTRO BANDA");
        this.mensajes_tren.put(Mensajes.ConformeTren, "  C O N F O R M E");
        this.mensajes_tren.put(Mensajes.DetenidoSe\u00f1al, "DETENIDO ANTE SE\u00d1AL");
        this.mensajes_tren.put(Mensajes.DetenidoTren, "DETENIDO TREN");
        this.mensajes_tren.put(Mensajes.SigoMarcha, "SIGO MARCHA");
        this.mensajes_tren.put(Mensajes.AveriaIF, "AVERIA IF");
        this.mensajes_tren.put(Mensajes.Incidencia, "INCIDENCIA");
        this.mensajes_tren.put(Mensajes.ServicioExterior, "SERVICIO EXTERIOR");
        this.mensajes_tren.put(Mensajes.PeticionVia, "PETICION VIA");
        this.mensajes_tren.put(Mensajes.LlegadaPunto, "LLEGADA A UN PUNTO");
        this.mensajes_tren.put(Mensajes.SalidaPunto, "SALIDA DE UN PUNTO");
        this.mensajes_tren.put(Mensajes.PeticionManiobra, "PETICION MANIOBRA");
        this.mensajes_tren.put(Mensajes.FinManiobra, "FIN DE MANIOBRA");
        this.mensajes_tren.put(Mensajes.Emergencia, "EMERGENCIA");
        this.mensajes_tren.put(Mensajes.Hable, "    H A B L E");
        this.mensajes_tren.put(Mensajes.SupresionParada, " SUPRESION PARADA");
        this.mensajes_tren.put(Mensajes.ConexionMegafonia, "CONEXION MEGAFONIA");
        this.mensajes_tren.put(Mensajes.ReduzcaMarcha, "  REDUZCA MARCHA");
        this.mensajes_tren.put(Mensajes.AutModC, "AUT. MOD. C");
        this.mensajes_tren.put(Mensajes.AtentoSe\u00f1al, "  ATENTO SE\u00d1AL");
        this.mensajes_tren.put(Mensajes.BajePantografo, " BAJE  PANTOGRAFO");
        this.mensajes_tren.put(Mensajes.SubaPantografo, " SUBA  PANTOGRAFO");
        this.mensajes_tren.put(Mensajes.AltoUrgente, "   ALTO URGENTE");
        this.mensajes_tren.put(Mensajes.AtPasoNivel, "AT. PASO A NIVEL");
        this.mensajes_tren.put(Mensajes.ConcesionVia, "CONCESION VIA");
        this.mensajes_tren.put(Mensajes.ConcesionManiobra, "CONCESION MANIOBRA");
        this.mensajes_tren.put(Mensajes.ConformeTierra, "  C O N F O R M E");
        this.mensajes_tren.put(Mensajes.HableConPMovil, "HABLE CON P. MOVIL");
        this.mensajes_tren.put(Mensajes.LlamadaGeneral, "LLAMADA GENERAL");
        this.updateState();
        new Timer(500, arg0 -> this.updateState()).start();
        this.client = new Client(this);
    }

    String numero_canal() {
        if (this.canal < 0) {
            return "__";
        }
        return String.format("%02d", this.canal);
    }

    String numero_tren() {
        if (this.ntren < 0) {
            return "______";
        }
        return String.format("%06d", this.ntren);
    }

    void mensajeRecibido(Mensajes mensaje) {
        BotonTT.playSound("TT_Aviso.wav");
        this.mensaje_recibido = mensaje;
        if (this.mensaje_recibido == Mensajes.Hable || this.mensaje_recibido == Mensajes.HableConPMovil) {
            this.estado = Estado.ComunicacionEstablecida;
        } else if (this.mensaje_recibido == Mensajes.LlamadaGeneral || this.mensaje_recibido == Mensajes.ConexionMegafonia) {
            this.estado = Estado.ComunicacionRecibida;
        } else {
            this.estado = Estado.MensajeRecibido;
            this.enviar_bien = this.mensaje_recibido != Mensajes.ConformeTierra;
            this.tiempo_mensaje = System.currentTimeMillis();
        }
        this.updateState();
    }

    void textoRecibido(String texto) {
        BotonTT.playSound("TT_Aviso.wav");
        this.estado = Estado.TextoRecibido;
        this.texto_recibido = texto;
        this.updateState();
    }

    void enviarMensaje(Mensajes mensaje) {
        if (this.envio_mensaje != null) {
            this.envio_mensaje.stop();
        }
        this.envio_mensaje = new Timer(1000, null);
        this.envio_mensaje.setRepeats(false);
        this.envio_mensaje.addActionListener(arg0 -> {
            if (this.mensaje_enviado == null || this.estado != Estado.MensajeEnviado) {
                if (this.envio_mensaje != null) {
                    this.envio_mensaje.stop();
                }
                return;
            }
            new Thread(() -> {
                boolean enviado;
                if (this.envio_mensaje != null) {
                    this.envio_mensaje.stop();
                }
                if (enviado = this.client.enviarMensaje(mensaje)) {
                    this.estado = Estado.Normal;
                    this.mensaje_enviado = null;
                    this.updateState();
                } else if (this.envio_mensaje != null) {
                    this.envio_mensaje.start();
                }
            }).start();
        });
        this.envio_mensaje.start();
    }

    void enviarTexto(String texto) {
        if (this.envio_texto != null) {
            this.envio_texto.stop();
        }
        this.envio_texto = new Timer(1000, null);
        this.envio_texto.setRepeats(false);
        this.envio_texto.addActionListener(arg0 -> {
            if (this.texto_enviado == null || this.estado != Estado.TextoEnviado) {
                if (this.envio_texto != null) {
                    this.envio_texto.stop();
                }
                return;
            }
            new Thread(() -> {
                boolean enviado;
                if (this.envio_texto != null) {
                    this.envio_texto.stop();
                }
                if (enviado = this.client.enviarTexto(texto)) {
                    this.estado = Estado.Normal;
                    this.texto_enviado = null;
                    this.updateState();
                } else if (this.envio_texto != null) {
                    this.envio_texto.start();
                }
            }).start();
        });
        this.envio_texto.start();
    }

    void updateState() {
        String texto = "";
        if (this.mensaje_recibido != null && this.mensaje_recibido != Mensajes.Hable && this.mensaje_recibido != Mensajes.HableConPMovil && this.mensaje_recibido != Mensajes.ConexionMegafonia && this.mensaje_recibido != Mensajes.LlamadaGeneral && System.currentTimeMillis() - this.tiempo_mensaje > 20000L) {
            this.mensaje_recibido = null;
            this.enviar_bien = false;
            this.estado = Estado.Normal;
        }
        if (this.mensaje_recibido != null) {
            texto = String.valueOf(texto) + "<" + this.mensajes_tren.get((Object)this.mensaje_recibido);
            int i = this.mensajes_tren.get((Object)this.mensaje_recibido).length();
            while (i < 18) {
                texto = String.valueOf(texto) + " ";
                ++i;
            }
            texto = String.valueOf(texto) + ">";
        } else if (this.estado == Estado.TextoRecibido) {
            texto = "\"" + this.texto_recibido.toUpperCase();
            int i = this.texto_recibido.length();
            while (i < 38) {
                texto = String.valueOf(texto) + " ";
                ++i;
            }
            texto = String.valueOf(texto) + "\"";
        } else if (this.estado == Estado.TextoEnviado || this.estado == Estado.IntroduceTexto) {
            boolean t = this.teclado_texto.tiempo_pasado();
            texto = "\"" + this.texto_enviado.toUpperCase() + (t ? "_" : "");
            int i = this.texto_enviado.length() + (t ? 1 : 0);
            while (i < 38) {
                texto = String.valueOf(texto) + " ";
                ++i;
            }
            texto = String.valueOf(texto) + "\"";
        } else {
            String datos = "MD:" + this.modo.name() + " CN:" + this.numero_canal();
            datos = this.modo == Modo.A ? String.valueOf(datos) + " TR:" + this.numero_tren() : String.valueOf(datos) + "          ";
            texto = datos;
        }
        if (this.estado == Estado.MensajeSeleccionado || this.estado == Estado.MensajeEnviado) {
            texto = String.valueOf(texto) + this.mensajes_tren.get((Object)this.mensaje_enviado);
            int i = this.mensajes_tren.get((Object)this.mensaje_enviado).length();
            while (i < 19) {
                texto = String.valueOf(texto) + " ";
                ++i;
            }
            texto = String.valueOf(texto) + (this.estado == Estado.MensajeSeleccionado ? "\u2192" : ">");
        } else if (this.estado == Estado.IntroduceCanal) {
            texto = String.valueOf(texto) + ">NUMERO DE CANAL? " + this.datos_introduciendose;
            int i = 0;
            while (i < 2 - this.datos_introduciendose.length()) {
                texto = String.valueOf(texto) + "_";
                ++i;
            }
        } else if (this.estado == Estado.IntroduceTren) {
            texto = String.valueOf(texto) + ">NUMERO TREN? " + this.datos_introduciendose;
            int i = 0;
            while (i < 6 - this.datos_introduciendose.length()) {
                texto = String.valueOf(texto) + "_";
                ++i;
            }
        } else if (this.estado == Estado.IntroduceModo) {
            texto = String.valueOf(texto) + ">MODO.........?  " + this.datos_introduciendose;
        } else if (this.estado == Estado.IntroduceHora) {
            texto = String.valueOf(texto) + ">HORA.............?";
        } else if (this.enviar_bien) {
            texto = String.valueOf(texto) + " ENVIAR \" B I E N \" ";
        }
        this.panel.display.setText(texto);
        this.arduino.sendData("tt::estado=" + texto);
    }

    public Mensajes getMensaje(BotonTT.TipoBoton code) {
        try {
            return Mensajes.valueOf(code.name());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void pulsacion(BotonTT.TipoBoton code) {
        boolean valida = false;
        int num = -1;
        if (code == BotonTT.TipoBoton.N0) {
            num = 0;
        } else if (code == BotonTT.TipoBoton.N1) {
            num = 1;
        } else if (code == BotonTT.TipoBoton.N2) {
            num = 2;
        } else if (code == BotonTT.TipoBoton.N3) {
            num = 3;
        } else if (code == BotonTT.TipoBoton.N4) {
            num = 4;
        } else if (code == BotonTT.TipoBoton.N5) {
            num = 5;
        } else if (code == BotonTT.TipoBoton.N6) {
            num = 6;
        } else if (code == BotonTT.TipoBoton.N7) {
            num = 7;
        } else if (code == BotonTT.TipoBoton.N8) {
            num = 8;
        } else if (code == BotonTT.TipoBoton.N9) {
            num = 9;
        }
        if (num >= 0) {
            if (this.estado == Estado.IntroduceCanal) {
                if (this.datos_introduciendose.length() < 2) {
                    this.datos_introduciendose = String.valueOf(this.datos_introduciendose) + Integer.toString(num);
                    valida = true;
                }
            } else if (this.estado == Estado.IntroduceTren) {
                if (this.datos_introduciendose.length() < 6) {
                    this.datos_introduciendose = String.valueOf(this.datos_introduciendose) + Integer.toString(num);
                    valida = true;
                }
            } else if (this.estado == Estado.IntroduceTexto) {
                this.texto_enviado = this.teclado_texto.get(num);
            }
        } else if (code == BotonTT.TipoBoton.Modo) {
            if (this.estado == Estado.IntroduceModo) {
                this.datos_introduciendose = this.datos_introduciendose.equals("A") ? "C" : (this.datos_introduciendose.equals("C") ? "D" : "A");
                valida = true;
            } else if (this.estado == Estado.Normal) {
                this.estado = Estado.IntroduceModo;
                this.datos_introduciendose = this.modo.name();
                valida = true;
            }
        } else if (code == BotonTT.TipoBoton.Canal) {
            if (this.estado == Estado.Normal) {
                this.estado = Estado.IntroduceCanal;
                this.datos_introduciendose = "";
                this.canal = -1;
                valida = true;
            }
        } else if (code == BotonTT.TipoBoton.Tren) {
            if (this.estado == Estado.Normal && this.modo == Modo.A) {
                this.estado = Estado.IntroduceTren;
                this.datos_introduciendose = "";
                this.ntren = -1;
                valida = true;
            }
        } else if (code == BotonTT.TipoBoton.CLR) {
            if (this.estado == Estado.IntroduceCanal || this.estado == Estado.IntroduceTren) {
                this.datos_introduciendose = "";
                valida = true;
            } else if (this.estado == Estado.MensajeSeleccionado || this.estado == Estado.MensajeEnviado) {
                this.mensaje_enviado = null;
                this.estado = Estado.Normal;
                valida = true;
            } else if (this.estado == Estado.IntroduceTexto) {
                this.texto_enviado = null;
                this.estado = Estado.Normal;
                valida = true;
            } else if (this.estado == Estado.TextoRecibido) {
                this.texto_recibido = null;
                this.estado = Estado.Normal;
                valida = true;
            }
        } else if (code == BotonTT.TipoBoton.TXT) {
            if (this.estado == Estado.Normal) {
                this.estado = Estado.IntroduceTexto;
                this.texto_enviado = "";
                this.teclado_texto = new TextKeyboard();
                valida = true;
            }
        } else if (code == BotonTT.TipoBoton.Confirmacion) {
            if (this.estado == Estado.IntroduceCanal) {
                if (this.datos_introduciendose.length() == 2) {
                    this.canal = Integer.parseInt(this.datos_introduciendose);
                    this.estado = this.preguntar_hora ? Estado.IntroduceHora : Estado.Normal;
                    valida = true;
                }
            } else if (this.estado == Estado.IntroduceTren) {
                if (this.datos_introduciendose.length() == 6) {
                    this.ntren = Integer.parseInt(this.datos_introduciendose);
                    this.estado = this.preguntar_hora ? Estado.IntroduceHora : Estado.Normal;
                    valida = true;
                }
            } else if (this.estado == Estado.IntroduceModo) {
                this.modo = this.datos_introduciendose.equals("C") ? Modo.C : (this.datos_introduciendose.equals("D") ? Modo.D : Modo.A);
                this.ntren = -1;
                this.canal = -1;
                this.estado = Estado.Normal;
                valida = true;
            } else if (this.estado == Estado.IntroduceHora) {
                this.estado = Estado.Normal;
                valida = true;
            } else if (this.estado == Estado.MensajeSeleccionado) {
                this.estado = Estado.MensajeEnviado;
                this.enviar_bien = false;
                this.mensaje_recibido = null;
                valida = true;
                this.enviarMensaje(this.mensaje_enviado);
            } else if (this.estado == Estado.IntroduceTexto) {
                this.estado = Estado.TextoEnviado;
                valida = true;
                this.enviarTexto(this.texto_enviado);
            }
        } else if (code == BotonTT.TipoBoton.ML) {
            if (this.estado == Estado.ComunicacionEstablecida) {
                if (this.descolgado) {
                    this.estado = Estado.Normal;
                    this.mensaje_recibido = null;
                    this.descolgado = false;
                } else {
                    this.descolgado = true;
                    new Thread(() -> this.client.enviarAudio()).start();
                }
                valida = true;
            }
        } else if (code == BotonTT.TipoBoton.Emergencia) {
            this.estado = Estado.MensajeSeleccionado;
            this.mensaje_enviado = Mensajes.Emergencia;
            valida = true;
        } else if (code == BotonTT.TipoBoton.Bien) {
            if (this.modo == Modo.A && this.ntren != -1 && this.canal != -1 && this.estado != Estado.ComunicacionEstablecida && this.estado != Estado.ComunicacionRecibida) {
                this.estado = Estado.MensajeSeleccionado;
                this.mensaje_enviado = Mensajes.ConformeTren;
                valida = true;
            }
        } else if (this.getMensaje(code) != null) {
            if (this.modo == Modo.A && this.ntren != -1 && this.canal != -1 && this.estado != Estado.ComunicacionEstablecida && this.estado != Estado.ComunicacionRecibida) {
                this.estado = Estado.MensajeSeleccionado;
                this.mensaje_enviado = this.getMensaje(code);
                valida = true;
            }
        } else if (code == BotonTT.TipoBoton.OnOff) {
            this.estado = Estado.Normal;
            this.mensaje_recibido = null;
            this.mensaje_enviado = null;
            this.enviar_bien = false;
            this.ntren = -1;
            this.canal = -1;
            valida = true;
        }
        if (valida) {
            BotonTT.playSound("TT_Bip.wav");
        }
        this.updateState();
    }

    static enum Estado {
        Normal,
        IntroduceModo,
        IntroduceCanal,
        IntroduceTren,
        IntroduceHora,
        IntroduceTexto,
        TextoEnviado,
        MensajeSeleccionado,
        MensajeEnviado,
        MensajeRecibido,
        TextoRecibido,
        ComunicacionEstablecida,
        ComunicacionRecibida;

    }

    public static enum Mensajes {
        PidoHablar,
        EntroBanda,
        ConformeTren,
        DetenidoSe\u00f1al,
        DetenidoTren,
        SigoMarcha,
        AveriaIF,
        Incidencia,
        ServicioExterior,
        PeticionVia,
        LlegadaPunto,
        SalidaPunto,
        PeticionManiobra,
        FinManiobra,
        Emergencia,
        Hable,
        SupresionParada,
        ConexionMegafonia,
        ReduzcaMarcha,
        AutModC,
        AtentoSe\u00f1al,
        BajePantografo,
        SubaPantografo,
        AltoUrgente,
        AtPasoNivel,
        ConcesionVia,
        ConcesionManiobra,
        ConformeTierra,
        HableConPMovil,
        LlamadaGeneral;


        public int getId() {
            return this.ordinal();
        }

        public static Mensajes fromId(int Id) {
            return Mensajes.values()[Id];
        }
    }

    static enum Modo {
        A,
        B,
        C,
        D;

    }

    class TextKeyboard {
        String cadena = "";
        int ultimo = -1;
        int index = -1;
        long tiempo;
        String[] nums = new String[]{"ABC0", "DEF1", "GHI2", "JKL3", "MN\u00d14", "OPQ5", "RST6", "UVW7", "XYZ8", " -?9"};

        TextKeyboard() {
        }

        public boolean tiempo_pasado() {
            return this.tiempo + 2000L < System.currentTimeMillis();
        }

        String get(int pulsado) {
            if (this.tiempo_pasado() || pulsado != this.ultimo) {
                this.cadena = String.valueOf(this.cadena) + this.nums[pulsado].charAt(0);
                this.index = 0;
            } else {
                this.index = (this.index + 1) % 4;
                this.cadena = String.valueOf(this.cadena.substring(0, this.cadena.length() - 1)) + this.nums[pulsado].charAt(this.index);
            }
            this.tiempo = System.currentTimeMillis();
            this.ultimo = pulsado;
            return this.cadena;
        }
    }
}

