/*
 * Decompiled with CFR 0.152.
 */
package pmr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import pmr.PMR;

public class Arduino {
    PMR pmr;
    Socket s;
    OutputStream out;
    BufferedReader in;

    public static Socket getSocket() {
        Socket s = null;
        while (s == null) {
            String ip = "localhost";
            try {
                DatagramSocket ds = new DatagramSocket(null);
                ds.setBroadcast(true);
                ds.bind(new InetSocketAddress("0.0.0.0", 5091));
                ds.setSoTimeout(1000);
                byte[] buff = new byte[50];
                DatagramPacket packet = new DatagramPacket(buff, buff.length);
                ds.receive(packet);
                ip = packet.getAddress().getCanonicalHostName();
                ds.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                s = new Socket(ip, 5090);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (s != null && s.isConnected()) continue;
            s = null;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    void setup() {
        this.s = Arduino.getSocket();
        try {
            this.in = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
            this.out = this.s.getOutputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String s;
        while ((s = this.readData()) != null) {
            this.parse(s);
        }
        return;
    }

    public Arduino(PMR pmr) {
        this.pmr = pmr;
        new Thread(() -> {
            while (true) {
                this.setup();
                this.in = null;
                this.out = null;
                this.s = null;
            }
        }).start();
    }

    void parse(String s) {
        if (s == null) {
            return;
        }
    }

    static boolean matches(String topic, String var) {
        if (topic.startsWith("register(")) {
            topic = topic.substring(9, topic.length() - 1);
        }
        if (topic.startsWith("get(")) {
            topic = topic.substring(4, topic.length() - 1);
        }
        String[] t1 = topic.split("::");
        String[] t2 = var.split("::");
        int i = 0;
        while (i < t1.length && i < t2.length) {
            if (t1[i].equals("*")) {
                return true;
            }
            if (!t1[i].equals("+") && !t1[i].equals(t2[i])) break;
            if (i + 1 == t1.length && t1.length == t2.length) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void subscribe(String topic) {
        this.sendData("register(" + topic + ")");
    }

    public void sendData(String s) {
        if (this.out == null) {
            return;
        }
        s = String.valueOf(s) + '\n';
        char[] c = s.toCharArray();
        try {
            int i = 0;
            while (i < c.length) {
                this.out.write(c[i]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String readData() {
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

