/*
 * Decompiled with CFR 0.152.
 */
package pcr.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import pcr.PCR;
import pcr.gui.BotonPCR;
import pmr.PMR;

public class PanelPCR
extends JFrame {
    private JTextField textField;
    private JTextField trainNumber;
    public JTextArea textLlamadaEnt;
    public JTextArea textLlamadaSal;
    public PCR pcr;
    public List<BotonPCR> botones = new ArrayList<BotonPCR>();

    public PanelPCR(PCR pcr) {
        this.pcr = pcr;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        JPanel panelEnviarMensaje = new JPanel();
        panelEnviarMensaje.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "Mensaje de texto", 4, 2, null, new Color(0, 0, 0)));
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)panelEnviarMensaje, gbc);
        panelEnviarMensaje.setLayout(new BorderLayout());
        this.textField = new JTextField();
        this.textField.setHorizontalAlignment(2);
        panelEnviarMensaje.add((Component)this.textField, "Center");
        this.textField.setColumns(14);
        JPanel panelBotones = new JPanel();
        panelBotones.setBorder(new TitledBorder(null, "Acciones", 4, 2, null, null));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 5;
        gbc.weightx = 1.0;
        this.add((Component)panelBotones, gbc);
        panelBotones.setLayout(new GridLayout(6, 2));
        this.botones.add(new BotonPCR("Hable", BotonPCR.Botones.Hable));
        this.botones.add(new BotonPCR("Conexi\u00f3n Megafonia", BotonPCR.Botones.ConexionMegafonia));
        this.botones.add(new BotonPCR("Conforme", BotonPCR.Botones.ConformeTierra));
        this.botones.add(new BotonPCR("Autorizo sistema C", BotonPCR.Botones.AutModC));
        this.botones.add(new BotonPCR("Suprima parada", BotonPCR.Botones.SupresionParada));
        this.botones.add(new BotonPCR("Atento a se\u00f1al", BotonPCR.Botones.AtentoSe\u00f1al));
        this.botones.add(new BotonPCR("Reduzca marcha", BotonPCR.Botones.ReduzcaMarcha));
        this.botones.add(new BotonPCR("Baje pantografo", BotonPCR.Botones.BajePantografo));
        this.botones.add(new BotonPCR("Suba pantografo", BotonPCR.Botones.SubaPantografo));
        this.botones.add(new BotonPCR("Parada inmediata", BotonPCR.Botones.AltoUrgente));
        this.botones.add(new BotonPCR("Texto", BotonPCR.Botones.Texto));
        this.botones.add(new BotonPCR("Llamada general", BotonPCR.Botones.LlamadaGeneral));
        for (BotonPCR b : this.botones) {
            panelBotones.add(b);
        }
        BotonPCR.setPressedActions(this);
        JPanel panelMensajes = new JPanel();
        panelMensajes.setBorder(new TitledBorder(null, "Mensajes", 4, 2, null, null));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        this.add((Component)panelMensajes, gbc);
        panelMensajes.setLayout(new GridLayout());
        this.textLlamadaEnt = new JTextArea();
        this.textLlamadaEnt.setWrapStyleWord(true);
        this.textLlamadaEnt.setText("");
        this.textLlamadaEnt.setFont(new Font("Monospaced", 0, 11));
        this.textLlamadaEnt.setEditable(false);
        JScrollPane scrollpaneLE = new JScrollPane();
        scrollpaneLE.setBorder(new TitledBorder(null, "Entrantes", 4, 2, null, null));
        panelMensajes.add(scrollpaneLE);
        scrollpaneLE.setViewportView(this.textLlamadaEnt);
        this.textLlamadaSal = new JTextArea();
        this.textLlamadaSal.setText("");
        this.textLlamadaSal.setFont(new Font("Monospaced", 0, 11));
        this.textLlamadaSal.setEditable(false);
        JScrollPane scrollpaneLS = new JScrollPane();
        scrollpaneLS.setBorder(new TitledBorder(null, "Salientes", 4, 2, null, null));
        panelMensajes.add(scrollpaneLS);
        scrollpaneLS.setViewportView(this.textLlamadaSal);
        JPanel panelListaTren = new JPanel();
        panelListaTren.setBorder(new TitledBorder(new EtchedBorder(1, new Color(255, 255, 255), new Color(160, 160, 160)), "N\u00ba de tren", 4, 2, null, new Color(0, 0, 0)));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)panelListaTren, gbc);
        panelListaTren.setLayout(new BorderLayout());
        this.trainNumber = new JTextField();
        this.trainNumber.setHorizontalAlignment(2);
        this.trainNumber.setColumns(14);
        panelListaTren.add((Component)this.trainNumber, "Center");
        gbc.gridx = 0;
        gbc.gridy = 3;
        JCheckBox onTop = new JCheckBox("Traer al frente");
        onTop.addActionListener(arg -> this.setAlwaysOnTop(onTop.isSelected()));
        this.add((Component)onTop, gbc);
        JButton listaTrenes = new JButton("Trenes en l\u00ednea");
        listaTrenes.addActionListener(arg0 -> {
            ArrayList<Integer> old = new ArrayList<Integer>();
            for (Integer i : pCR.listatrenes.keySet()) {
                if (pCR.listatrenes.get(i) >= System.currentTimeMillis() - 30000L) continue;
                old.add(i);
            }
            for (Integer i : old) {
                pCR.listatrenes.remove(i);
            }
            String trenes = "";
            if (pCR.listatrenes.isEmpty()) {
                trenes = "Sin trenes en la banda de regulaci\u00f3n";
            } else {
                for (Integer i : pCR.listatrenes.keySet()) {
                    trenes = String.valueOf(trenes) + i.toString() + "\n";
                }
            }
            JOptionPane.showMessageDialog(this, trenes, "Lista de trenes", 1);
        });
        ++gbc.gridy;
        this.add((Component)listaTrenes, gbc);
        this.setSize(700, 500);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                Dimension size = PanelPCR.this.getSize();
                float scale = (float)Math.min(size.getHeight() / 500.0, size.getWidth() / 700.0);
                if (scale > 0.0f) {
                    PanelPCR.this.textLlamadaSal.setFont(new Font("Monospaced", 0, (int)(11.0f * scale)));
                    PanelPCR.this.textLlamadaEnt.setFont(new Font("Monospaced", 0, (int)(11.0f * scale)));
                }
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
    }

    void send(PMR.Mensajes msg) {
        int trn = -1;
        try {
            trn = Integer.parseInt(this.trainNumber.getText());
        }
        catch (Exception e) {
            return;
        }
        this.pcr.enviarMensaje(msg, trn);
    }

    void sendText() {
        String textoRevisado = this.textField.getText().replace("\n", "").replace("\r", "");
        this.pcr.enviarTexto(textoRevisado, Integer.parseInt(this.trainNumber.getText()));
        this.textField.setText("");
    }
}

