/*
 * Decompiled with CFR 0.152.
 */
package pcr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pcr.PCR;
import pmr.PMR;
import streaming.Input;
import streaming.Output;

public class Server {
    boolean local;
    List<Socket> sockets = new ArrayList<Socket>();
    HashMap<Socket, OutputStream> outputs = new HashMap();
    String ip = "local";
    PCR pcr;
    Output audioOut;
    boolean enviando = false;

    public void read(Socket s) {
        try {
            InputStream in = s.getInputStream();
            int trn = in.read();
            if (trn == -1) {
                throw new EOFException();
            }
            trn = in.read() + trn * 256;
            trn = in.read() + trn * 256;
            int code = in.read();
            if (code == -1) {
                throw new EOFException();
            }
            if (code == 255) {
                int length = in.read();
                byte[] data = new byte[length];
                int i = 0;
                while (i < length) {
                    data[i] = (byte)in.read();
                    ++i;
                }
                this.pcr.textoRecibido(new String(data), trn);
            } else if (code == 254) {
                this.pcr.listatrenes.put(trn, System.currentTimeMillis());
            } else if (code == 253) {
                if (this.audioOut == null) {
                    this.audioOut = new Output();
                }
                byte[] data = new byte[Input.BUFFERSIZE];
                int numread = 0;
                while (numread < Input.BUFFERSIZE) {
                    numread += in.read(data, numread, Input.BUFFERSIZE - numread);
                }
                this.audioOut.play(data);
                int trn2 = -1;
                if (trn == this.pcr.hable_pm1) {
                    trn2 = this.pcr.hable_pm2;
                } else if (trn == this.pcr.hable_pm2) {
                    trn2 = this.pcr.hable_pm1;
                }
            } else if (code != 252) {
                this.pcr.mensajeRecibido(PMR.Mensajes.fromId(code), trn);
            }
            if (code != 253 && this.audioOut != null) {
                this.audioOut.stop();
                this.audioOut = null;
            }
        }
        catch (EOFException e) {
            this.sockets.remove(s);
            this.outputs.remove(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    Server(PCR pcr) {
        this.pcr = pcr;
        try {
            FileReader fileReader = new FileReader("pmr_ips.ini");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] token = line.trim().split("=");
                if (token.length == 2) {
                    String[] canales;
                    String ip = token[0].trim();
                    String[] stringArray = canales = token[1].trim().split(",");
                    int n = canales.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String canal = stringArray[n2];
                        if (Integer.parseInt(canal) == pcr.canal) {
                            this.ip = ip;
                            break;
                        }
                        ++n2;
                    }
                }
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Thread(() -> {
            if (this.ip.equals("local")) {
                try {
                    ServerSocket ss = new ServerSocket(48300 + pCR.canal);
                    while (true) {
                        Socket s;
                        block16: {
                            s = ss.accept();
                            try {
                                InputStream in = s.getInputStream();
                                if (in.read() != pCR.canal) continue;
                                if (in.read() != 1) {
                                }
                                break block16;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        this.outputs.put(s, s.getOutputStream());
                        this.sockets.add(s);
                        new Thread(() -> {
                            while (this.sockets.contains(s)) {
                                this.read(s);
                            }
                        }).start();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                while (true) {
                    try {
                        while (true) {
                            Socket s;
                            if ((s = new Socket(this.ip, 48301)) != null) {
                                OutputStream out = s.getOutputStream();
                                byte[] byArray = new byte[2];
                                byArray[0] = (byte)pCR.canal;
                                out.write(byArray);
                                this.outputs.put(s, out);
                                this.sockets.add(s);
                                while (this.sockets.contains(s)) {
                                    this.read(s);
                                }
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFast(byte[] data) {
        ArrayList<Socket> old = new ArrayList<Socket>();
        for (Socket s : this.sockets) {
            try {
                OutputStream out = this.outputs.get(s);
                out.write(data);
            }
            catch (IOException e) {
                ArrayList<Socket> arrayList = old;
                synchronized (arrayList) {
                    old.add(s);
                    e.printStackTrace();
                }
            }
        }
        for (Socket s : old) {
            this.sockets.remove(s);
            this.outputs.remove(s);
        }
    }

    void enviar(int tren, byte[] bytes) {
        if (this.enviando) {
            return;
        }
        this.enviando = true;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write((byte)(tren / 65536));
        o.write((byte)(tren / 256 % 256));
        o.write((byte)(tren % 256));
        o.write(bytes, 0, bytes.length);
        byte[] b = o.toByteArray();
        ArrayList old = new ArrayList();
        for (Socket s : this.sockets) {
            new Thread(() -> {
                try {
                    OutputStream out = this.outputs.get(s);
                    int i = 0;
                    while (i < b.length) {
                        out.write(b[i]);
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    List list2 = old;
                    synchronized (list2) {
                        old.add(s);
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        for (Socket s : old) {
            this.sockets.remove(s);
            this.outputs.remove(s);
        }
        this.enviando = false;
    }

    void enviarMensaje(PMR.Mensajes mensaje, int tren) {
        this.enviar(tren, new byte[]{(byte)mensaje.getId()});
    }

    void enviarTexto(String texto, int tren) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(-1);
        byte[] tb = texto.getBytes();
        o.write((byte)tb.length);
        o.write(tb, 0, tb.length);
        this.enviar(tren, o.toByteArray());
    }

    public void enviarAudio(int tren) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (this.enviando) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.enviando = true;
        Input in = new Input();
        while (this.pcr.hablando) {
            this.writeFast(new byte[]{-1, -1, -1, -3});
            this.writeFast(in.getAudio());
        }
        this.writeFast(new byte[]{-1, -1, -1, -4});
        this.enviando = false;
        in.stop();
    }
}

