/*
 * Decompiled with CFR 0.152.
 */
package pcr;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javax.swing.JOptionPane;
import pcr.Server;
import pcr.gui.BotonPCR;
import pcr.gui.PanelPCR;
import pmr.PMR;
import pmr.gui.BotonTT;

public class PCR {
    Server server;
    PanelPCR panel;
    int canal;
    public HashMap<Integer, Long> listatrenes = new HashMap();
    boolean hablando;
    boolean llamadaGeneral = false;
    int hable_pm1 = -1;
    int hable_pm2 = -1;
    HashMap<PMR.Mensajes, String> mensajes_tren = new HashMap();
    HashMap<PMR.Mensajes, String> mensajes_ctc = new HashMap();

    public static void main(String[] args) {
        new PCR();
    }

    PCR() {
        this.canal = Integer.parseInt(JOptionPane.showInputDialog("Numero de canal"));
        this.server = new Server(this);
        this.panel = new PanelPCR(this);
        this.panel.setTitle("Puesto central. Canal " + this.canal);
        this.mensajes_tren.put(PMR.Mensajes.PidoHablar, "PIDO HABLAR");
        this.mensajes_tren.put(PMR.Mensajes.EntroBanda, "ENTRO BANDA");
        this.mensajes_tren.put(PMR.Mensajes.ConformeTren, "CONFORME");
        this.mensajes_tren.put(PMR.Mensajes.DetenidoSe\u00f1al, "DETENIDO ANTE SE\u00d1AL");
        this.mensajes_tren.put(PMR.Mensajes.DetenidoTren, "DETENIDO TREN");
        this.mensajes_tren.put(PMR.Mensajes.SigoMarcha, "SIGO MARCHA");
        this.mensajes_tren.put(PMR.Mensajes.AveriaIF, "AVERIA IF");
        this.mensajes_tren.put(PMR.Mensajes.Incidencia, "INCIDENCIA");
        this.mensajes_tren.put(PMR.Mensajes.ServicioExterior, "SERVICIO EXTERIOR");
        this.mensajes_tren.put(PMR.Mensajes.PeticionVia, "PETICION VIA");
        this.mensajes_tren.put(PMR.Mensajes.LlegadaPunto, "LLEGADA A UN PUNTO");
        this.mensajes_tren.put(PMR.Mensajes.SalidaPunto, "SALIDA DE UN PUNTO");
        this.mensajes_tren.put(PMR.Mensajes.PeticionManiobra, "PETICION MANIOBRA");
        this.mensajes_tren.put(PMR.Mensajes.FinManiobra, "FIN DE MANIOBRA");
        this.mensajes_tren.put(PMR.Mensajes.Emergencia, "EMERGENCIA");
        this.mensajes_ctc.put(PMR.Mensajes.Hable, "HABLE");
        this.mensajes_ctc.put(PMR.Mensajes.SupresionParada, "SUPRESION PARADA");
        this.mensajes_ctc.put(PMR.Mensajes.ConexionMegafonia, "CONEXION MEGAGONIA");
        this.mensajes_ctc.put(PMR.Mensajes.ReduzcaMarcha, "REDUZCA MARCHA");
        this.mensajes_ctc.put(PMR.Mensajes.AutModC, "AUTOZIZADO MODO C");
        this.mensajes_ctc.put(PMR.Mensajes.AtentoSe\u00f1al, "ATENTO A SE\u00d1AL");
        this.mensajes_ctc.put(PMR.Mensajes.BajePantografo, "BAJE PANTOGRAFO");
        this.mensajes_ctc.put(PMR.Mensajes.SubaPantografo, "SUBA PANTOGRAFO");
        this.mensajes_ctc.put(PMR.Mensajes.AltoUrgente, "ALTO URGENTE");
        this.mensajes_ctc.put(PMR.Mensajes.AtPasoNivel, "ATENTO PASO NIVEL");
        this.mensajes_ctc.put(PMR.Mensajes.ConcesionVia, "CONCESION VIA");
        this.mensajes_ctc.put(PMR.Mensajes.ConcesionManiobra, "CONCESION MANIOBRA");
        this.mensajes_ctc.put(PMR.Mensajes.ConformeTierra, "CONFORME");
        this.mensajes_ctc.put(PMR.Mensajes.HableConPMovil, "HABLE CON PUESTO MOVIL");
        this.mensajes_ctc.put(PMR.Mensajes.LlamadaGeneral, "LLAMADA GENERAL");
    }

    public void enviarMensaje(PMR.Mensajes mensaje, int tren) {
        if (mensaje == PMR.Mensajes.LlamadaGeneral) {
            if (this.llamadaGeneral) {
                this.hablando = false;
                this.llamadaGeneral = false;
                for (BotonPCR b : this.panel.botones) {
                    b.setEnabled(true);
                }
            } else {
                for (BotonPCR b : this.panel.botones) {
                    b.setEnabled("Llamada general".equals(b.getText()));
                }
                this.llamadaGeneral = true;
                this.hablando = true;
                this.server.enviarMensaje(mensaje, 0xFFFFFF);
                new Thread(() -> this.server.enviarAudio(0xFFFFFF)).start();
            }
        } else {
            if (mensaje == PMR.Mensajes.Hable) {
                if (this.hablando) {
                    for (BotonPCR b : this.panel.botones) {
                        b.setEnabled(true);
                    }
                    this.hablando = false;
                    return;
                }
                for (BotonPCR b : this.panel.botones) {
                    b.setEnabled("Hable".equals(b.getText()));
                }
                this.hablando = true;
                new Thread(() -> this.server.enviarAudio(tren)).start();
            }
            this.server.enviarMensaje(mensaje, tren);
            this.panel.textLlamadaSal.append("[" + this.getTime() + "] Canal " + this.canal + " Tren " + tren + ": " + this.mensajes_ctc.get((Object)mensaje) + "\r\n");
        }
    }

    public synchronized void mensajeRecibido(PMR.Mensajes mensaje, int tren) {
        BotonTT.playSound("TT_Aviso.wav");
        this.panel.textLlamadaEnt.append("[" + this.getTime() + "] Canal " + this.canal + " Tren " + tren + ": " + this.mensajes_tren.get((Object)mensaje) + "\r\n");
        if (mensaje == PMR.Mensajes.Emergencia) {
            this.hablando = false;
            this.llamadaGeneral = false;
            while (this.server.enviando) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.enviarMensaje(PMR.Mensajes.Hable, tren);
        }
    }

    public void enviarTexto(String texto, int tren) {
        this.server.enviarTexto(texto, tren);
        this.panel.textLlamadaSal.append("[" + this.getTime() + "] Canal " + this.canal + " Tren " + tren + ": " + texto.toUpperCase() + "\r\n");
    }

    public void textoRecibido(String texto, int tren) {
        this.panel.textLlamadaEnt.append("[" + this.getTime() + "] Canal " + this.canal + " Tren " + tren + ": " + texto + "\r\n");
    }

    private String getTime() {
        LocalTime time = LocalTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        return time.format(formatter);
    }
}

