//#define USE_LOCOMOTIVE
using ORTS.Common;
using ORTS.Scripting.Api;
using ORTS.Scripting.Api.ETCS;
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO.Ports;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Linq;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using Orts.Common;
using Event = Orts.Common.Event;
using Orts.Simulation.Signalling;
using System.Globalization;
using Orts.Simulation.RollingStocks;
namespace ORTS.Scripting.Script
{
    public class ServerTCS : TrainControlSystem
    {
        public Client c=null;
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        List<InteractiveTCS> tcs = new List<InteractiveTCS>();
        public void RequestModule(string module)
        {
            if (c != null) c.WriteLine("request_module("+module+")");
        }
        public void Register(string parameter)
        {
            if (c != null) c.WriteLine("register("+parameter+")");
        }
        public void RemoveParameter(string parameter)
        {
            if (c != null) c.WriteLine("unregister("+parameter+")");
        }
        public void SendParameter(string parameter, string value)
        {
            if (c != null) c.WriteLine(parameter+"="+value);
        }
        Parameter GetParameter(string parameter)
        {
            Parameter compared = new Parameter(parameter);
            Parameter p = null;
            parameters.TryGetValue(compared, out p);
            return p;
        }
        float LocomotiveOverspeedMpS;
        public override void Initialize()
        {
            Activated = false;
            tcs.Add(new HM(this));
            if(GetBoolParameter("ASFA","Digital",false)) tcs.Add(new ASFADigital(this));
            else tcs.Add(new ASFAclasico(this));
            tcs.Add(new ETCS(this));
            
            
             foreach(InteractiveTCS i in tcs)
            {
                i.Activated = true;
                i.Initialize();
            }
            
            LocomotiveOverspeedMpS = MpS.FromKpH(GetIntParameter("General", "Sobrevelocidad", 500));
        }
        void InitializeValues()
        {
            foreach(InteractiveTCS i in tcs)
            {
                parameters.UnionWith(i.GetParameters());
            }
            
            Parameter p = null;
            p = new Parameter("speed");
            p.GetValue = () => MpS.ToKpH(SpeedMpS()).ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("distance");
            p.GetValue = () => Locomotive().Train.DistanceTravelledM.ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("train_orientation");
            p.GetValue = () => (IsFlipped() || IsRearCab() ? "-1" : "1").ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("acceleration");
            p.GetValue = () => AccelerationMpSS().ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("cruise_speed");
            p.SetValue = (string val) => cruise_speed=MpS.FromKpH(float.Parse(val, CultureInfo.InvariantCulture.NumberFormat));
            parameters.Add(p);
            
            p = new Parameter("train_length");
            p.GetValue = () => TrainLengthM().ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("master_key");
            p.GetValue = () => IsCabPowerSupplyOn() && IsLowVoltagePowerSupplyOn() ? "1" : "0";
            parameters.Add(p);
            
            /*p = new Parameter("controller::line_voltage");
            p.GetValue = () => (((MSTSElectricLocomotive)Locomotive()). ElectricPowerSupply.PantographVoltageV).ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("controller::ammeter");
            p.GetValue = () => {
                double val = Locomotive().FilteredMotiveForceN / Locomotive().MaxForceN * Locomotive().MaxCurrentA;
                return val.ToString().Replace(',','.');
            };
            parameters.Add(p);*/
            
            p = new Parameter("controller::throttle");
            p.SetValue = (string val) => {
                float value = float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat);
                userThrottle = value;
            };
            parameters.Add(p);
            
            p = new Parameter("controller::brake::dynamic");
            p.SetValue = (string val) => {
                float value = float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat);
                userDynamic = value;
            };
            parameters.Add(p);
            
            p = new Parameter("controller::brake::train");
            p.SetValue = (string val) => {
                float value = float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat);
                #if USE_LOCOMOTIVE
                Locomotive().TrainBrakeController.SetValue(value);
                #endif
            };
            parameters.Add(p);
            
            p = new Parameter("controller::direction");
            p.SetValue = (string val) =>
            {
                if(val=="1") direction = Direction.Forward;
                else if(val=="-1") direction = Direction.Reverse;
                else direction = Direction.N;
            };
            p.GetValue = () => {
                if (CurrentDirection() == Direction.Forward) return "1";
                else if (CurrentDirection() == Direction.Reverse) return "-1";
                else return "0";
            };
            parameters.Add(p);
            
            p = new Parameter("controller::headlight");
            p.SetValue = (string val) => 
            {
                if(val=="3") SignalEvent(Event._HeadlightOn);
                else if(val=="2") SignalEvent(Event._HeadlightDim);
                else SignalEvent(Event._HeadlightOff);
            };
            parameters.Add(p);
            
            p = new Parameter("controller::wipers");
             p.SetValue = (string val) => 
            {
                if(val=="3"||val=="1") SignalEvent(Event.WiperOn);
                else SignalEvent(Event.WiperOff);
            };
            parameters.Add(p);
            
            p = new Parameter("controller::sander");
            p.SetValue = (string val) => 
            {
                if(val=="1" || val == "true") SignalEventToTrain(Event.SanderOn);
                else SignalEventToTrain(Event.SanderOff);
            };
            parameters.Add(p);
            
            p = new Parameter("controller::horn");
            p.SetValue = (string val) => 
            {
                if(val=="1" || val == "true") SetHorn(true);
                else SetHorn(false);
            };
            parameters.Add(p);
            
            /*p = new Parameter("controller::bell");
            p.SetValue = (string val) => Locomotive.ManualBell = val != "true";
            parameters.Add(p);*/
            
            /*p = new Parameter("simulator_time");
            p.GetValue = () => ClockTime().ToString().Replace(',','.');
            parameters.Add(p);*/
        }
        float prevDynamic=0;
        float prevThrottle=0;
        float userThrottle=0;
        void setThrottle(float thr)
        {
            if (prevThrottle == thr) return;
            SetThrottleController(thr);
            prevThrottle = thr;
        }
        float userDynamic=0;
        void setDynamicBrake(float dyn)
        {
            if (prevDynamic == dyn) return;
            SetDynamicBrakeController(dyn);
            prevDynamic = dyn;
        }
        float ATFval=0;
        bool ServerAvailable = true;
        int UpdateCount=0;
        public override void Update()
        {
            if(!IsTrainControlEnabled())
            {
                if (c!=null)
                {
                    foreach(Parameter p in parameters)
                    {
                        p.RemoveClient(c);
                    }
                    c.Stop();
                    c = null;
                }
                return;
            }
            if (UpdateCount<4)
            {
                UpdateCount++;
                return;
            }
            if (UpdateCount == 4)
            {
                InitializeValues();
                UpdateCount++;
            }
            if(c==null && ServerAvailable)
            {
                try{
                    TcpClient cl = new TcpClient();
                    cl.Connect("127.0.0.1", 5090);
                    c = new TCPClient(cl);
                } catch(Exception e)
                {
                    ServerAvailable = false;
                    c = null;
                    return;
                }
                c.WriteLine("register(controller::throttle)");
                c.WriteLine("register(cruise_speed)");
                c.WriteLine("register(controller::brake::dynamic)");
                c.WriteLine("register(controller::brake::train)");
                c.WriteLine("register(controller::direction)");
                c.WriteLine("register(controller::horn)");
                c.WriteLine("register(controller::bell)");
                c.WriteLine("register(controller::wipers)");
                c.WriteLine("register(controller::sander)");
                c.WriteLine("register(controller::headlight)");
                c.WriteLine("register(hm::pressed)");
                c.WriteLine("register(+::emergency)");
                c.WriteLine("register(+::fullbrake)");
                c.WriteLine("register(+::tractioncutoff)");
                c.WriteLine("register(etcs::neutral_section)");
                c.WriteLine("register(etcs::lower_pantographs)");
                c.WriteLine("register(etcs::dmi::command)");
                c.WriteLine("register(etcs::atf)");
                
                Register("asfa::pulsador::ilum::*");
                Register("asfa::pulsador::basico");
                Register("asfa::pulsador::conex");
                Register("asfa::leds::*");
                Register("asfa::pantalla::habilitada");
                Register("asfa::pantalla::activa");
                foreach(InteractiveTCS i in tcs)
                {
                    if (i is ASFADigital)
                    {
                        int T = GetIntParameter("ASFA", "TipoTren", -1);
                        if (T > 0) SendParameter("asfa::selector_tipo", T.ToString());
                    }
                }
            }
            if (c != null)
            {
                string s = c.ReadLine();
                while(s!=null)
                {
                    if(s.StartsWith("register(") || s.StartsWith("get("))
                    {
                        int div = s.IndexOf('(');
                        int fin = s.LastIndexOf(')');
                        if(div<=0 || fin<=0)
                        {
                            s = c.ReadLine();
                            continue;
                        }
                        string fun = s.Substring(0, div);
                        string param = s.Substring(div+1, fin-div-1);
                        foreach (Parameter p in parameters)
                        {
                            if(p!=null && p.GetValue!=null && p.Matches(param))
                            {
                                if(fun == "register")
                                {
                                    Register r;
                                    if (p.name == "speed" || p.name == "simulator_time") r = new NumericRegister(0.2f);
                                    if (p.name == "acceleration") r = new NumericRegister(0.05f);
                                    else if (p.name == "distance") r = new NumericRegister(0.5f);
                                    else r = new DiscreteRegister(false);
                                    p.registers[r] = c;
                                }
                                else c.WriteLine(p.name + '=' + p.GetValue());
                            }
                        }
                    }
                    else if(s.Contains('='))
                    {
                        int pos = s.IndexOf('=');
                        string param = s.Substring(0, pos);
                        string val = s.Substring(pos+1);
                        if(param != "connected") 
                        {
                            Parameter ps = GetParameter(param);
                            if(ps != null && ps.SetValue!=null) ps.SetValue(val);
                        }
                    }
                    s = c.ReadLine();
                }
                foreach(Parameter p in parameters)
                {
                    p.Send();
                }
            }
#if USE_LOCOMOTIVE
            if (GetControlMode() == TRAIN_CONTROL.OUT_OF_CONTROL) Locomotive().Train.ManualResetOutOfControlMode();
#endif
            foreach(InteractiveTCS i in tcs)
            {
                i.Update();
            }
            bool Emergency = false;
            bool FullBrake = false;
            bool TCO = false;
            foreach(InteractiveTCS i in tcs)
            {
                if(i.Emergency) Emergency = true;
                if(i.FullBrake) FullBrake = true;
                if(i.TCO) TCO = true;
            }
            //cruise_speed = Locomotive().ThrottleController.CurrentValue * MpS.FromKpH(120);
            if(cruise_speed>MpS.FromKpH(15) && !IsDirectionNeutral() && userDynamic == 0)
            {
                ATFon = true;
                ATF(cruise_speed, ref ATFval);
                if (userThrottle==0) setThrottle(Math.Max(0,ATFval));
                else setThrottle(Math.Max(0,Math.Min(ATFval,userThrottle)));
                /*Locomotive().ThrottleIntervention = Math.Max(0,ATFval);
                Locomotive().DynamicBrakeIntervention = ATFval>0 ? -1 : Math.Max(-ATFval,0);*/
                setDynamicBrake(Math.Max(-ATFval,0));
            }
            else
            {
                ATFval = 0;
                ATFon = false;
                setThrottle(userThrottle);
                setDynamicBrake(userDynamic);
            }
            //SetCabDisplayControl(39, (int)(cruise_speed*3.6));
            SetDirection();
            SetEmergencyBrake(Emergency/*||IsDirectionNeutral()*/);
            SetFullBrake(FullBrake);
            SetTractionAuthorization(!TCO && (!DoesBrakeCutPower() || BrakeCutsPowerAtBrakeCylinderPressureBar() > LocomotiveBrakeCylinderPressureBar())); 
            if (FrenoApoyo && DynamicBrakePercent() <= 29.99f) SetDynamicBrakeController(0.3f);
            if (FrenoApoyo && SpeedMpS() < MpS.FromKpH(60)) SetFrenoApoyo(false);
            SetOverspeedWarningDisplay(SpeedMpS()>LocomotiveOverspeedMpS);
        }
        Direction direction=Direction.N;
        Direction prevDirection;
        void SetDirection()
        {
            if(direction==prevDirection && CurrentDirection()!=prevDirection)
            {
                direction = CurrentDirection();
            }
            if(direction!=CurrentDirection())
            {
                #if USE_LOCOMOTIVE
                Locomotive().SetDirection(direction);
                #endif
            }
            prevDirection = CurrentDirection();
        }
        bool FrenoApoyo=false;
        float FrenoOriginal;
        void SetFrenoApoyo(bool apply)
        {
            if (apply != FrenoApoyo)
            {
                FrenoApoyo = apply;
                if (FrenoApoyo)
                {
                    if (DynamicBrakePercent() < 30)
                    {
                        SetDynamicBrakeController(0.3f);
                        FrenoOriginal = DynamicBrakePercent()/100;
                    }
                    else FrenoOriginal = 0.3f;
                }
                else
                {
                    if (FrenoOriginal <= 0 || ThrottlePercent() > 0) SetDynamicBrakeController(0);
                    else if (Math.Abs(DynamicBrakePercent()-30)<0.1f) SetDynamicBrakeController(FrenoOriginal);
                }
            }
        }
        public override void HandleEvent(TCSEvent evt, string message) 
        {
            switch(evt)
            {
                case TCSEvent.CircuitBreakerOpen:
                    if (SpeedMpS() > MpS.FromKpH(60)) SetFrenoApoyo(true);
                    break;
                case TCSEvent.CircuitBreakerClosed:
                    SetFrenoApoyo(false);
                    break;
                
            }
            foreach(InteractiveTCS e in tcs)
            {
                e.HandleEvent(evt, message);
            }
        }
        bool ATFon = false;
        float cruise_speed=0;
        double LastTime=0;
        double p_error=0;
        double i_error=0;
        float ATF_brake=0;
        double p_coef = 2;
        double i_coef = 0.001;
        double d_coef = 0.4;
        protected void ATF(double limit, ref float value)
        {
            double error = limit-SpeedMpS();
            double dt = ClockTime()-LastTime;
            if (dt < 0.0001f) return;
            if(Math.Abs(error)<1)
            {
                i_error += (error+p_error)*dt/2;
            }
            else i_error = 0;
            double d_error = (error-p_error)/dt;
            double p_out = p_coef*error;
            double i_out = i_coef*i_error;
            double d_out = d_coef*d_error;
            double diff = d_out+p_out+i_out;
            value = Math.Max(Math.Min((float)diff,1),-1);
            LastTime = ClockTime();
            p_error = error;
        }
    }
    public abstract class Client
    {
        public virtual void Start()
        {
            WriteLine("connected=true");
        }
        public abstract void WriteLine(string s);
        public abstract string ReadLine();
        public abstract void Stop();
    }
    public class TCPClient : Client
    {
        TcpClient client;
        NetworkStream stream;
        StreamReader reader;
        Task<string> t;
        public TCPClient(TcpClient c)
        {
            client = c;
            stream = client.GetStream();
            reader = new StreamReader(stream, System.Text.Encoding.UTF8);
        }
        public override void Start()
        {
            base.Start();
        }
        public override void Stop()
        {
            client.Close();
        }
        public override void WriteLine(string s)
        {
            byte[] b = System.Text.Encoding.UTF8.GetBytes(s + "\r\n");
            stream.WriteAsync(b, 0, b.Length);
        }
        public override string ReadLine()
        {
            /*while (stream.DataAvailable)
            {
                buff += (char)stream.ReadByte();
            }
            int ind = buff.IndexOf('\n');
            if (ind >= 0)
            {
                string res = buff.Substring(0, ind);
                buff = buff.Substring(ind + 1);
                if (res.Length>0 && res[res.Length-1] == '\r') return res.Substring(0,res.Length-1);
                return res;
            }*/
            string res = null;
            if (t == null) t = reader.ReadLineAsync();
            if (t.IsCompleted)
            {
                res = t.Result;
                t = null;
            }
            return res;
        }
    }
    public abstract class Register
    {
        public bool FirstSent = false;
        public Func<string, bool> HasToSend;
        public Action<string> Sent;
    }
    public class DiscreteRegister : Register
    {
        string prev = "";
        public DiscreteRegister(bool repeat)
        {
            HasToSend = (string val) => repeat || val != prev;
            Sent = (string val) => prev = val;
        }
    }
    public class NumericRegister : Register
    {
        float prev = 0;
        public NumericRegister(float margin)
        {
            HasToSend = (string val) => {
                float curr = float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat);
                return Math.Abs(curr - prev) > margin || (prev != 0 && curr == 0);
            };
            Sent = (string val) => prev = float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat);
        }
    }
    public class Parameter
    {
        public Dictionary<Register, Client> registers;
        public readonly string name;
        public Parameter(string name)
        {
            registers = new Dictionary<Register, Client>();
            this.name = name;
        }
        public Func<string> GetValue;
        public Action<string> SetValue;
        public void Send()
        {
            if(GetValue == null) return;
            string val = GetValue();
            if (val == null) return;
            foreach (Register r in registers.Keys)
            {
                if (r.HasToSend(val) || !r.FirstSent)
                {
                    r.FirstSent = true;
                    registers[r].WriteLine(name + '=' + val);
                    if(r.Sent!=null) r.Sent(val);
                }
            }
        }
        public bool Matches(string topic)
        {
            string[] t1 = topic.Split(new string[]{"::"}, StringSplitOptions.None);
            string[] t2 = name.Split(new string[]{"::"}, StringSplitOptions.None);
            for (int i=0; i<t1.Length && i<t2.Length; i++)
            {
                if (t1[i] == "*")
                    return true;
                if (t1[i] != "+" && t1[i] != t2[i])
                    return false;
            }
            return t1.Length == t2.Length;
        }
        public void RemoveClient(Client c)
        {
            foreach(var item in registers.Where(kvp => kvp.Value == c).ToList())
            {
                registers.Remove(item.Key);
            }
        }
        public override bool Equals(object obj)
        {
            if (obj is Parameter) return name.Equals((obj as Parameter).name);
            return name.Equals(obj);
        }
        public override int GetHashCode()
        {
            return name.GetHashCode();
        }
    }
    public abstract class InteractiveTCS : TrainControlSystem
    {
        public ServerTCS tcs;
        public bool Emergency = false;
        public bool FullBrake = false;
        public bool TCO = false;
        public abstract List<Parameter> GetParameters();
        public InteractiveTCS(ServerTCS tcs)
        {
            this.tcs = tcs;
        }
    }
    public class HM : InteractiveTCS
    {
        float HMReleasedAlertDelayS;
        float HMReleasedEmergencyDelayS;
        float HMPressedAlertDelayS;
        float HMPressedEmergencyDelayS;

        public bool Pressed = false;
        Timer HMPressedAlertTimer;
        Timer HMPressedEmergencyTimer;
        Timer HMReleasedAlertTimer;
        Timer HMReleasedEmergencyTimer;

        public HM(ServerTCS tcs) : base(tcs)
        {
            SetVigilanceAlarm = (value) => { if (Activated) tcs.SetVigilanceAlarm(value); };
            SetVigilanceAlarmDisplay = (value) => { if (Activated) tcs.SetVigilanceAlarmDisplay(value); };
            SetVigilanceEmergencyDisplay = (value) => { if (Activated) tcs.SetVigilanceAlarm(value); };
        }
        bool InvertResetButton = false;
        bool ResetAtStandstill = false;
        bool ResetWhenPressed = false;
        public override void HandleEvent(TCSEvent evt, string message)
        {
            switch(evt)
            {
                case TCSEvent.AlerterPressed:
                    Pressed = !InvertResetButton;
                    break;
                case TCSEvent.AlerterReleased:
                    Pressed = InvertResetButton;
                    break;
            }
        }
        public override void Initialize()
        {
            InvertResetButton = tcs.GetBoolParameter("HM","InvertirBoton",true);
            HMReleasedAlertDelayS = tcs.GetFloatParameter("HM","AvisoLevantado",2.5f);
            HMReleasedEmergencyDelayS = tcs.GetFloatParameter("HM","UrgenciaLevantado", 5);
            HMPressedAlertDelayS = tcs.GetFloatParameter("HM","AvisoPisado", 32.5f);
            HMPressedEmergencyDelayS = tcs.GetFloatParameter("HM","UrgenciaPisado", 35);
            ResetWhenPressed = tcs.GetBoolParameter("HM","RearmarAlPulsar", false);
            ResetAtStandstill = tcs.GetBoolParameter("HM","RearmarEnParado", false);
            HMPressedAlertTimer = new Timer(tcs);
            HMPressedAlertTimer.Setup(HMPressedAlertDelayS);
            HMPressedEmergencyTimer = new Timer(tcs);
            HMPressedEmergencyTimer.Setup(HMPressedEmergencyDelayS);
            HMReleasedAlertTimer = new Timer(tcs);
            HMReleasedAlertTimer.Setup(HMReleasedAlertDelayS);
            HMReleasedEmergencyTimer = new Timer(tcs);
            HMReleasedEmergencyTimer.Setup(HMReleasedEmergencyDelayS);
        }
        public override void Update()
        {
            if (!Activated || !tcs.IsAlerterEnabled() || tcs.IsDirectionNeutral())
            {
                HMReleasedAlertTimer.Stop();
                HMReleasedEmergencyTimer.Stop();
                HMPressedAlertTimer.Stop();
                HMPressedEmergencyTimer.Stop();
                if (Emergency)
                {
                    Emergency = false;
                    SetVigilanceEmergencyDisplay(false);
                }
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
                SetVigilanceAlarmDisplay(false);
                tcs.SetCabDisplayControl(31, 0);
                return;
            }
            tcs.SetCabDisplayControl(31, 1);
            if (Pressed && (!HMPressedAlertTimer.Started || !HMPressedEmergencyTimer.Started))
            {
                HMReleasedAlertTimer.Stop();
                HMReleasedEmergencyTimer.Stop();
                HMPressedAlertTimer.Start();
                HMPressedEmergencyTimer.Start();
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
                SetVigilanceAlarmDisplay(false);
                if (Emergency && ResetWhenPressed)
                {
                    Emergency = false;
                    SetVigilanceEmergencyDisplay(false);
                }
            }
            if (Pressed && HMPressedAlertTimer.RemainingValue < 2.5f)
            {
                SetVigilanceAlarmDisplay(true);
            }
            if (!Pressed && (!HMReleasedAlertTimer.Started || !HMReleasedEmergencyTimer.Started))
            {
                HMReleasedAlertTimer.Start();
                HMReleasedEmergencyTimer.Start();
                HMPressedAlertTimer.Stop();
                HMPressedEmergencyTimer.Stop();
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
                SetVigilanceAlarmDisplay(true);
                if (Emergency && ResetWhenPressed)
                {
                    Emergency = false;
                    SetVigilanceEmergencyDisplay(false);
                }
            }
            if (HMReleasedAlertTimer.Triggered || HMPressedAlertTimer.Triggered)
            {
                if (!tcs.AlerterSound()) SetVigilanceAlarm(true);
                SetVigilanceAlarmDisplay(true);
            }
            else
            {
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
            }
            if (!Emergency && (HMPressedEmergencyTimer.Triggered || HMReleasedEmergencyTimer.Triggered))
            {
                Emergency = true;
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
                SetVigilanceAlarmDisplay(false);
                SetVigilanceEmergencyDisplay(true);
            }
            if (Emergency && tcs.SpeedMpS() < 1.5f && ResetAtStandstill)
            {
                Emergency = false;
                SetVigilanceEmergencyDisplay(false);
            }
        }
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = new List<Parameter>();
            
            Parameter p;
            
            p = new Parameter("hm::pressed");
            p.SetValue = (string val) => {Pressed = val=="1" || val=="true";};
            l.Add(p);
            
            return l;
        }
    }
    public class ETCS : InteractiveTCS
    {
        public enum Aspecto
        {
            Apagada,
            Parada,
            ParadaLZB,
            ParadaSelectiva,
            ParadaSelectivaDestellos,
            ParadaPermisiva,
            RebaseAutorizado,
            RebaseAutorizadoCortaDistancia,
            RebaseAutorizadoDestellos,
            MovimientoAutorizado,
            ParadaDiferida,
            AnuncioParadaInmediata,
            AnuncioParada,
            AnuncioPrecaucion,
            PreanuncioParada,
            ViaLibreCondicional,
            ViaLibre
        }
		Dictionary<string, Aspecto> textoAAspecto;
        Aspecto ConvertirAspecto(Aspect aspect, string text)
        {
            if (textoAAspecto.ContainsKey(text))
            {
                return textoAAspecto[text];
            }
            else
            {
                switch (aspect)
                {
                    case Aspect.Stop:
                        return Aspecto.Parada;

                    case Aspect.StopAndProceed:
                        return Aspecto.RebaseAutorizado;

                    case Aspect.Restricted:
                        return Aspecto.RebaseAutorizadoDestellos;

                    case Aspect.Approach_1:
                        return Aspecto.AnuncioParada;

                    case Aspect.Approach_2:
                        return Aspecto.AnuncioPrecaucion;

                    case Aspect.Approach_3:
                        return Aspecto.PreanuncioParada;

                    case Aspect.Clear_1:
                        return Aspecto.ViaLibreCondicional;

                    case Aspect.Clear_2:
                        return Aspecto.ViaLibre;
                }
            }
            return Aspecto.Parada;
        }
        double StartNeutralSectionDistanceM=double.MaxValue;
        double EndNeutralSectionDistanceM=double.MinValue;
        Timer OpenCircuitBreakerTimer;
        Timer CloseCircuitBreakerTimer;
        Timer ResetThrottleTimer;
        Timer ZeroThrottleTimer;
        double StartLowPantographSection=double.MaxValue;
        double EndLowPantographSection=double.MinValue;
        bool[] PantoRaised = new bool[4];
        public ETCS(ServerTCS tcs) : base(tcs)
        {
			textoAAspecto = Enum.GetNames(typeof(Aspecto)).ToDictionary(x => x, x => (Aspecto)Enum.Parse(typeof(Aspecto), x), StringComparer.OrdinalIgnoreCase);
        }
        public override void HandleEvent(TCSEvent evt, string message)
        {
        }
        /*[DllImport("kernel32", SetLastError = true, CharSet = CharSet.Ansi)]
        internal static extern IntPtr LoadLibrary([MarshalAs(UnmanagedType.LPStr)]string lpFileName);
        [DllImport("kernel32.dll")]
        public static extern IntPtr GetProcAddress(IntPtr hModule, string procedureName);
        [DllImport("kernel32.dll")]
        static extern uint GetLastError();

        [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
        private delegate void Sta();
        [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
        private delegate void Upd();
        Sta start;
        Upd update;*/
        public override void Initialize()
        {
            OpenCircuitBreakerTimer = new Timer(tcs);
            CloseCircuitBreakerTimer = new Timer(tcs);
            ResetThrottleTimer = new Timer(tcs);
            ZeroThrottleTimer = new Timer(tcs);
            OpenCircuitBreakerTimer.Setup(1.0f);
            CloseCircuitBreakerTimer.Setup(1.0f);
            ResetThrottleTimer.Setup(3.0f);
            ZeroThrottleTimer.Setup(3.0f);
            /*IntPtr pDll = LoadLibrary("evc.dll");
            Console.Write("Error: ");
            Console.WriteLine(GetLastError());
            IntPtr ps = GetProcAddress(pDll, "start");
            IntPtr pu = GetProcAddress(pDll, "update");
            start = (Sta)Marshal.GetDelegateForFunctionPointer(ps, typeof(Sta));
            update = (Upd)Marshal.GetDelegateForFunctionPointer(pu, typeof(Upd));
            //start();*/
        }
        float PrevPostDist=0;
        float PrevPostSpeed=0;
        float CurrPostSpeed=0;
        bool started=false;
        void UpdateTrackConditions()
        {
            float PantoToFront=0;
            float PantoToRear=0;
            {
                bool start = StartNeutralSectionDistanceM + PantoToFront < tcs.SpeedMpS() * 1;
                bool end = EndNeutralSectionDistanceM < -tcs.TrainLengthM() + PantoToRear;
                tcs.SetPowerAuthorization(end || !start);
                if (end || !start)
                {
                    if (CloseCircuitBreakerTimer.Started) tcs.SetCircuitBreakerClosingOrder(true);
                    if (CloseCircuitBreakerTimer.Triggered)
                    {
                        tcs.SetCircuitBreakerClosingOrder(false);
                        CloseCircuitBreakerTimer.Stop();
                    }
                    OpenCircuitBreakerTimer.Start();
                }
                else
                {
                    if (OpenCircuitBreakerTimer.Started) tcs.SetCircuitBreakerOpeningOrder(true);
                    if (OpenCircuitBreakerTimer.Triggered)
                    {
                        tcs.SetCircuitBreakerOpeningOrder(false);
                        OpenCircuitBreakerTimer.Stop();
                    }
                    CloseCircuitBreakerTimer.Start();
                }
                if (StartNeutralSectionDistanceM + PantoToFront > tcs.SpeedMpS() * 7 || end) ZeroThrottleTimer.Stop();
                else if (!ZeroThrottleTimer.Started) ZeroThrottleTimer.Start();
                if (start && !end) ResetThrottleTimer.Stop();
                else if (!ResetThrottleTimer.Started && !CloseCircuitBreakerTimer.Started) ResetThrottleTimer.Start();
                double percent = 100;
                if (!ResetThrottleTimer.Started) percent = 0;
                else if (ZeroThrottleTimer.Started) percent = ZeroThrottleTimer.RemainingValue*100/ResetThrottleTimer.AlarmValue;
                else percent = 100*(1 - ResetThrottleTimer.RemainingValue/ResetThrottleTimer.AlarmValue);
                if (percent > 100) percent = 100;
                if (percent < 0) percent = 0;
                //tcs.SetMaxThrottlePercent((float)percent);
            }
            {
                bool lower = StartLowPantographSection + PantoToFront < tcs.SpeedMpS() * 15;
                bool raise = EndLowPantographSection < -tcs.TrainLengthM() + PantoToRear;
                if (lower && !raise && !tcs.ArePantographsDown())
                {
                    for (int i=1; i<5; i++)
                    {
                        PantoRaised[i-1] = tcs.GetPantographState(i) == PantographState.Up;
                    }
                    tcs.SetPantographsDown();
                }
                if (raise || !lower)
                {
                    for (int i=1; i<5; i++)
                    {
                        if (PantoRaised[i-1]) tcs.SetPantographUp(i);
                        PantoRaised[i-1] = false;
                    }
                }
            }
        }
        public override void Update()
        {
            /*if (!started)
            {
                start();
                started = true;
            }
            update();*/
            tcs.ETCSStatus.PlanningAreaShown = tcs.ETCSStatus.ShowTextMessageArea = true;
            for (int i=0; i<tcs.ETCSStatus.TextMessages.Count; i++)
            {
                TextMessage t = tcs.ETCSStatus.TextMessages[i];
                if (t.Acknowledged)
                {
                    t.Acknowledged = false;
                    tcs.ETCSStatus.TextMessages[i] = t;
                    foreach(KeyValuePair<int, TextMessage> entry in MessageList)
                    {
                        if (entry.Value.Equals(t))
                        {
                            tcs.SendParameter("noretain(etcs::dmi::feedback","messageAcked("+entry.Key+"))");
                            break;
                        }
                    }
                }
            }
            UpdateTrackConditions();
            //if (atf >= 0 && atf < tcs.Locomotive().CruiseControl.SelectedSpeedMpS) tcs.Locomotive().CruiseControl.SetSpeed(MpS.ToKpH(atf));
            UpdateSignalPassed();
            UpdateInfillPassed();
            UpdateEurobalise();
            float PostDist = tcs.NextPostDistanceM(0);
            float PostSpeed = tcs.NextPostSpeedLimitMpS(0);
            if (PrevPostDist + 5 < PostDist || PrevPostSpeed != PostSpeed)
            {
                if (PrevPostSpeed < 300) CurrPostSpeed = PrevPostSpeed;
            }
            PrevPostDist = PostDist;
            PrevPostSpeed = PostSpeed;
            /*if (TunnelPassed && TunnelLength > 199)
            {
                string tel1 = "1"+"0100001"+"0"+"000"+"001"+"00"+"11111111"+"0000000000"+"00000000000010"+"0";
                string tel2 = "1"+"0100001"+"0"+"001"+"001"+"00"+"11111111"+"0000000000"+"00000000000010"+"0";
                bool fwd = true;
                float pos = get_pk(PreviousTunnelDist, ref fwd);
                if (fwd) pos += TunnelLength/2000;
                else pos -= TunnelLength/2000;
                if (pos<0) pos = 0;
                tel1 += get_tunnel((int)PreviousTunnelDist, TunnelLength, pos) + "11111111";
                tel2 += "11111111";
                tcs.SendParameter("etcs::telegram",tel1);
                tcs.SendParameter("etcs::telegram",tel2);
            }*/
            if (BalisePassed == null) return;
            if (BalisePassed.TextAspect != "")
            {
                tcs.SendParameter("noretain(etcs::telegram", fill_telegram(BalisePassed.TextAspect)+")");
                return;
            }
            bool NeutralSectionPassed = BalisePassed.type.StartsWith("etcs_neutralsection");
            bool SeccionadorPassed = BalisePassed.type.StartsWith("etcs_seccionamiento");
            bool DefaultPassed = BalisePassed.type.StartsWith("etcs_default");
            bool LevelTransitionAnnouncementPassed = BalisePassed.type.StartsWith("etcs_leveltr_announcement");
            bool LevelTransitionOrderPassed = BalisePassed.type.StartsWith("etcs_leveltr_order");
            bool MAInfillPassed = BalisePassed.type.StartsWith("etcs_infill_ma");
            bool FixedInfillPassed = BalisePassed.type.StartsWith("etcs_infill_fixed");
            bool MAMainPassed = BalisePassed.type.StartsWith("etcs_main_ma");
            bool FixedMainPassed = BalisePassed.type.StartsWith("etcs_main_fixed");
            /*if (MAMainPassed)
            {
                Aspect nextAspect = tcs.NextSignalAspect(0);
                string nextTextAspect = tcs.NextGenericSignalFeatures("NORMAL", 0, float.MaxValue).TextAspect;
                float maend=0;
                float off = tcs.DistanceM()-group_position;
                string ma = get_ma(off, false, out maend);
                maend += 700;
                string ssp=get_ssp(maend, off);
                string grad=get_gradient(maend, BalisePassed);
                string packs = grad + ssp + ma;
                packs += create_packet(137, (nextAspect == Aspect.Stop || (nextAspect == Aspect.StopAndProceed && nextTextAspect != "RebaseAutorizado")) ? "0" : "1", 1);
                if (tcs.NextGenericSignalDistanceM("ETCS_LEVEL") < 500 && tcs.NextGenericSignalDistanceM("ETCS_LEVEL") >= 0)
                {
                    string lev = "000";
                    if (tcs.NextGenericSignalAspect("ETCS_LEVEL") == Aspect.StopAndProceed) lev = "010";
                    packs += create_packet(41, "01" + "000000000000000" + lev + "000000000000000" + "00000", 1);
                }
                packs += get_linking(tcs.DistanceM()-group_position, BalisePassed.reverse_passed);
                packs += create_packet(132, nextTextAspect == "RebaseAutorizado" ? "1" : "0", 1);
                if (nextTextAspect == "RebaseAutorizado")
                {
                    string prof = "01" + format_etcs_distance(0) + "01" + "1111111" + format_etcs_distance(tcs.NextSignalDistanceM(1)) + format_etcs_distance(0) + "0" + "00000";
                    packs += create_packet(80, prof, 1);
                }
                else if (nextAspect == Aspect.Restricted)
                {
                    string prof = "01" + format_etcs_distance(0) + "00" + "1111111" + format_etcs_distance(tcs.NextSignalDistanceM(1)) + format_etcs_distance(0) + "0" + "00000";
                    packs += create_packet(80, prof, 1);
                }
                send_telegram(BalisePassed,packs);
            }
            else if (FixedMainPassed)
            {
                string packs = "";
                float tpos=-1;
                float tlength=-1;
                get_tunnel_dist(ref tpos, ref tlength, tcs.NextSignalDistanceM(5));
                if (tpos >= 0 && tlength >= 0)
                {
                    fwd = true;
                    pos = get_pk(tpos, ref fwd);
                    if (fwd) pos += tlength/2000;
                    else pos -= tlength/2000;
                    if (pos<0) pos = 0;
                    packs += get_tunnel((int)tpos, tlength, pos);
                }
                packs += get_conditions(tcs.DistanceM()-group_position, tcs.NextSignalDistanceM(5));
                send_telegram(BalisePassed,packs);
            }
            else if (MAInfillPassed)
            {
                List<BaliseDataType> balises = GetNextBalise(true, tcs.NextSignalDistanceM(0)-60, tcs.NextSignalDistanceM(0), BalisePassed.reverse_passed, 3);
                BaliseDataType locref = balises.Count == 0 ? null : balises[balises.Count-1];
                string packs = get_linking(tcs.DistanceM()-group_position, BalisePassed.reverse_passed);
                if (locref != null)
                {
                    float maend=0;
                    float off = tcs.DistanceM()-group_position;
                    float infoff = locref.distance;
                    string ma = get_ma(infoff, true, out maend);
                    maend += 700;
                    string ssp = get_ssp(maend, off);
                    string grad = get_gradient(maend, BalisePassed);
                    packs += grad + ssp + create_packet(136, "0"+ format_binary(locref.nid_bg, 14), 1) + ma;
                    if (tcs.NextSignalAspect(0) == Aspect.Restricted)
                    {
                        string prof = "01" + format_etcs_distance(tcs.NextSignalDistanceM(0)-infoff) + "00" + "1111111" + format_etcs_distance(tcs.NextSignalDistanceM(1)-tcs.NextSignalDistanceM(0)) + format_etcs_distance(300) + "1" + "00000";
                        packs += create_packet(80, prof, 1);
                    }
                }
                send_telegram(BalisePassed,packs);
            }
            else if (FixedInfillPassed)
            {
                string packs = "";
                packs += get_conditions(tcs.DistanceM()-group_position, tcs.NextSignalDistanceM(5));
                send_telegram(BalisePassed,packs);
            }
            else if (LevelTransitionAnnouncementPassed)
            {
                string packs = "";
                if (BalisePassed.aspect == Aspect.Stop) packs += create_packet(41, "01" + format_etcs_distance(500) + "000" + format_etcs_distance(300) + "00000", 1);
                else if (BalisePassed.aspect == Aspect.StopAndProceed) packs += create_packet(41, "01" + format_etcs_distance((tcs.NextSignalDistanceM(0)+50)*1.05f) + "010" + "000000000000000" + "00000", 1);
                send_telegram(BalisePassed, packs+get_linking(tcs.DistanceM()-group_position, BalisePassed.reverse_passed));
            }
            else if (LevelTransitionOrderPassed)
            {
                string packs = "";
                if (BalisePassed.aspect != Aspect.Clear_2 && BalisePassed.aspect != Aspect.StopAndProceed)
                {
                    string lev = "000";
                    if (BalisePassed.aspect == Aspect.StopAndProceed) lev = "010";
                    packs += create_packet(41, "01" + "000000000000000" + lev + "000000000000000" + "00000", 1);
                }
                send_telegram(BalisePassed, packs+get_linking(tcs.DistanceM()-group_position, BalisePassed.reverse_passed));
            }
            else
            {
                send_telegram(BalisePassed,"");
            }*/
        }
        
        string fill_telegram(string tel)
        {
            Console.WriteLine("Ref: "+group_position+" Dist: "+tcs.DistanceM()); 
            Console.WriteLine("Before: " + tel);
            float end=32700;
            float bgref=group_position-tcs.DistanceM();
            float ilref=-1;
            float prevdist=-1;
            for (int i=0; ; i++)
            {
                float dist = tcs.NextGenericSignalFeatures("ETCS", i, 32000).DistanceM;
                if (dist < 0 || dist > 32000) break;
                if (prevdist >= 0 && dist-prevdist < 12)
                {
                    prevdist = dist;
                    continue;
                }
                prevdist = dist;
                if (dist < tcs.NextSignalDistanceM(0)) ilref = dist;
            }
            tel = Regex.Replace(tel, @"NextSignalDistanceM\(([0-9]+)\)", match => {
                return Math.Min(tcs.NextSignalDistanceM(int.Parse(match.Groups[1].Value)),32000).ToString().Replace(',','.');
            });
            tel = Regex.Replace(tel, @"NextSignalDistanceM\(([A-Z_]+),([0-9])+\)", match => {
                return Math.Min(tcs.NextGenericSignalFeatures(match.Groups[1].Value, int.Parse(match.Groups[2].Value), 32000).DistanceM,32000).ToString().Replace(',','.');
            });
            tel = Regex.Replace(tel, @"NextEurobaliseDistanceM\(([0-9]+)\)", match => {
                return Math.Min(tcs.NextGenericSignalFeatures("ETCS", int.Parse(match.Groups[1].Value), 32000).DistanceM,32000).ToString().Replace(',','.');
            });
            tel = Regex.Replace(tel, @"bgref", match => {
                return bgref.ToString().Replace(',','.');
            });
            tel = Regex.Replace(tel, @"ilref", match => {
                return ilref.ToString().Replace(',','.');
            });
            /*tel = Regex.Replace(tel, @"EOADistanceM(\([0-9])+\)", match => {
                return tcs.EOADistanceM(tcs.CurrentTrainMUDirection() == Direction.Reverse ? 1 : 0);
            });*/
            tel = Regex.Replace(tel, @"{ma_infill}", match => {
                float maend;
                return get_ma(ilref, true, out maend);
            });
            tel = Regex.Replace(tel, @"{ma}", match => {
                float maend;
                return get_ma(bgref, false, out maend);
            ;
            });
            tel = Regex.Replace(tel, @"{ssp}", match => {
                return get_ssp(end, bgref);
            });
            tel = Regex.Replace(tel, @"{ssp_infill}", match => {
                return get_ssp(end, ilref);
            });
            tel = Regex.Replace(tel, @"{gradient}", match => {
                return get_gradient(end);
            });
            tel = Regex.Replace(tel, @"{linking}", match => {
                return get_linking(bgref, BalisePassed.reverse_passed);
            });
            tel = Regex.Replace(tel, @"{trackcond}", match => {
                return get_conditions(bgref, tcs.NextSignalDistanceM(5));
            });
            tel = Regex.Replace(tel, @"{tunnel_msg\(([0-9]+)\)}", match => {
                return get_tunnel_msg(bgref, int.Parse(match.Groups[1].Value));
            });
            tel = Regex.Replace(tel, @"{pk}", match => {
                bool fwd;
                float pos = get_pk(0, out fwd);
                if (pos >= 0)
                {
                    string position="01"+"0"+format_binary(BalisePassed.nid_bg, 14)+format_etcs_distance(0)+((fwd ^ BalisePassed.reverse_passed) ? "1" : "0")+format_binary((int)(pos*1000), 24)+"00000";
                    return create_packet(79, position, 2);
                }
                return "";
            });
            /*tel = Regex.Replace(tel, @"{os_profile}", match => {
                string prof = "01" + format_etcs_distance(0) + "00" + "1111111" + format_etcs_distance(tcs.NextSignalDistanceM(1)-bgref) + format_etcs_distance(0) + "0" + "00000";
                return create_packet(80, prof, 1);
            });
            tel = Regex.Replace(tel, @"{os_profile_infill}", match => {
                string prof = "01" + format_etcs_distance(tcs.NextSignalDistanceM(0)-ilref) + "00" + "1111111" + format_etcs_distance(tcs.NextSignalDistanceM(1)-tcs.NextSignalDistanceM(0)) + format_etcs_distance(300) + "1" + "00000";
                return create_packet(80, prof, 1);
            });*/
            /*tel = Regex.Replace(tel, @"{pk\+([0-9]+(\.[0-9]+)?)}", match => {
                
            });*/
            tel = Regex.Replace(tel, @"{([^}]*)}", match => {
                //Console.WriteLine("mid: "+match.Groups[1].Value);
                return format_etcs_distance(eval(match.Groups[1].Value));
            });
            Console.WriteLine("After: " + tel);
            return tel;
        }
        public double eval(string exp)
        {
            int bracketCounter = 0;
            int operatorIndex = -1;

            for(int i=0; i<exp.Length; i++){
                char c = exp[i];
                if(c == '(') bracketCounter++;
                else if(c == ')') bracketCounter--;
                else if((c == '+' || c == '-') && bracketCounter == 0){
                    operatorIndex = i;
                    break;
                }
                else if((c == '*' || c == '/') && bracketCounter == 0 && operatorIndex < 0){
                    operatorIndex = i;
                }
            }
            if(operatorIndex <= 0){
                exp = exp.Trim();
                if(exp[0] == '(' && exp[exp.Length-1] == ')')
                    return eval(exp.Substring(1, exp.Length-2));
                else
                    return double.Parse(exp, CultureInfo.InvariantCulture.NumberFormat);
            }
            else{
                switch(exp[operatorIndex]){
                    case '+':
                        return eval(exp.Substring(0, operatorIndex)) + eval(exp.Substring(operatorIndex+1));
                    case '-':
                        return eval(exp.Substring(0, operatorIndex)) - eval(exp.Substring(operatorIndex+1));
                    case '*':
                        return eval(exp.Substring(0, operatorIndex)) * eval(exp.Substring(operatorIndex+1));
                    case '/':
                        return eval(exp.Substring(0, operatorIndex)) / eval(exp.Substring(operatorIndex+1));
                }
            }
            return 0;
        }
        string get_ma(float bgref, bool infill, out float maend)
        {
            string ma="01";
            maend = 0;
            var linkedSignal = tcs.NextGenericSignalFeatures("NORMAL", 0, float.MaxValue);
            Aspecto aspecto = ConvertirAspecto(linkedSignal.Aspect, linkedSignal.TextAspect);
            int vrelease = 15;
            if (aspecto==Aspecto.Parada || aspecto==Aspecto.ParadaPermisiva || aspecto==Aspecto.ParadaSelectiva || (aspecto == Aspecto.RebaseAutorizado && infill) || aspecto == Aspecto.RebaseAutorizadoCortaDistancia)
            {
                ma += format_etcs_speedKpH(0)+"0000000"+"0000000000"+"00000";
                ma += format_etcs_distance(tcs.NextSignalDistanceM(0)-bgref)+"0"+"0"+"1"+format_etcs_distance(15)+format_etcs_speedKpH(vrelease)+"0";
            }
            else
            {
                float EoAdist = tcs.EOADistanceM(tcs.CurrentTrainMUDirection() == Direction.Reverse ? 1 : 0);
                bool EoAvalid = false;
                if (tcs.NextSignalDistanceM(0) < 0 || tcs.NextSignalDistanceM(0) > 32000) EoAvalid = true;
                ma += format_etcs_speedKpH(300)+format_etcs_speed(0)+format_binary(0, 10);
                List<SignalFeatures> features = new List<SignalFeatures>();
                features.Add(tcs.NextGenericSignalFeatures("NORMAL", 0, float.MaxValue));
                int maxToClear = 0;
                if (aspecto == Aspecto.RebaseAutorizado || aspecto == Aspecto.RebaseAutorizadoDestellos) maxToClear = 1;
                else if (aspecto == Aspecto.AnuncioParada) maxToClear = 2;
                else if (aspecto == Aspecto.AnuncioPrecaucion) maxToClear = 3;
                else if (aspecto == Aspecto.ViaLibreCondicional || aspecto == Aspecto.PreanuncioParada) maxToClear = 3;
                else if (aspecto == Aspecto.ViaLibre || aspecto == Aspecto.ParadaSelectivaDestellos) maxToClear = 4;
                
                List<SignalFeatures> stops = new List<SignalFeatures>();
                for(int i=1; i<=maxToClear; i++) 
                {
                    SignalFeatures feat = tcs.NextGenericSignalFeatures("NORMAL", i, float.MaxValue);
                    if (feat.MainHeadSignalTypeName.Equals("pantalla_ertms") || feat.MainHeadSignalTypeName == "sp4md" || feat.MainHeadSignalTypeName == "sp4md_izq")
                    {
                        maxToClear++;
                        continue;
                    }
                    if (EoAvalid && feat.DistanceM > EoAdist + 10)
                    {
                        maend = Math.Min(EoAdist, 32000);
                        vrelease = 10;
                        break;
                    }
                    if (feat.MainHeadSignalTypeName == "sp2mb") vrelease = 10;
                    maend = Math.Min(feat.DistanceM, 32000);
                    aspecto = ConvertirAspecto(feat.Aspect, feat.TextAspect);
                    if (feat.DistanceM > 32000 || aspecto==Aspecto.Parada || aspecto==Aspecto.ParadaPermisiva || aspecto==Aspecto.ParadaSelectiva || aspecto == Aspecto.RebaseAutorizadoCortaDistancia || aspecto==Aspecto.RebaseAutorizado || i==maxToClear) break;
                    features.Add(feat);
                    bool salida = feat.MainHeadSignalTypeName.StartsWith("sp3s") || feat.MainHeadSignalTypeName.StartsWith("sp4s");
                    bool entrada = feat.MainHeadSignalTypeName.StartsWith("sp3e") || feat.MainHeadSignalTypeName.StartsWith("sp4e");
                    if ((salida || entrada) && stops.Count<2) stops.Add(feat);
                }
                for(int i=0; i<10; i++) 
                {
                    SignalFeatures feat = tcs.NextGenericSignalFeatures("OLPN_T", i, float.MaxValue);
                    if (feat.DistanceM > maend) break;
                    stops.Add(feat);
                }
                stops.Sort((x,y) => x.DistanceM.CompareTo(y.DistanceM));
                List<string> sects = new List<string>();
                float start = bgref;
                for (int i=0; i<stops.Count; i++)
                {
                    var feat = stops[i];
                    sects.Add(construirSeccion(feat.DistanceM-start, sects.Count, features, feat, (i+1<stops.Count) ? (SignalFeatures?)stops[i+1] : null, infill));
                    start = feat.DistanceM;
                }
                ma += format_binary(sects.Count, 5);
                foreach (var sec in sects) ma += sec;
                ma += construirSeccion(maend-start, sects.Count, features, stops.Count > 0 ? (SignalFeatures?)stops[stops.Count-1] : null, null, infill);
                /*for(int i=1; i<=maxToClear; i++) 
                {
                    SignalFeatures feat = tcs.NextGenericSignalFeatures("NORMAL", i, float.MaxValue);
                    if (feat.MainHeadSignalTypeName.Equals("pantalla_ertms"))
                    {
                        maxToClear++;
                        continue;
                    }
                    if (feat.DistanceM > EoAdist + 10)
                    {
                        maend = Math.Min(EoAdist, 32000);
                        vrelease = 10;
                        break;
                    }
                    maend = Math.Min(feat.DistanceM, 32000);
                    if (feat.DistanceM > 32000 || feat.Aspect == Aspect.Stop || feat.Aspect == Aspect.StopAndProceed || feat.Aspect == Aspect.Restricted || i==maxToClear) break;
                    features.Add(feat);
                }
                int sectioncount = 0;
                int sectionsignalcount = 0;
                float sectionStartDistance = bgref;
                string sections = "";
                int lastsectionsignal = -1;
                int maxsections = 2;
                for (int i=0; i<features.Count && sectioncount < maxsections; i++)
                {
                    var feat = features[i];
                    bool salida = feat.MainHeadSignalTypeName.StartsWith("sp3s") || feat.MainHeadSignalTypeName.StartsWith("sp4s");
                    bool entrada = feat.MainHeadSignalTypeName.StartsWith("sp3e") || feat.MainHeadSignalTypeName.StartsWith("sp4e");
                    if (salida || entrada)
                    {
                        float sectionlength = feat.DistanceM - sectionStartDistance;
                        if (sectioncount == 0)
                        {
                            sections += format_etcs_distance(sectionlength);
                            if (infill || sectionsignalcount > 0) sections += "0";
                            else sections += "1" + format_binary(entrada ? 150 : 30, 10) + format_etcs_distance(sectionlength);
                            
                        }
                        else if (sectioncount == 1)
                        {                  
                            var feat2 = features[lastsectionsignal];
                            bool salida2 = feat2.MainHeadSignalTypeName.StartsWith("sp3s") || feat2.MainHeadSignalTypeName.StartsWith("sp4s");
                            bool entrada2 = feat2.MainHeadSignalTypeName.StartsWith("sp3e") || feat2.MainHeadSignalTypeName.StartsWith("sp4e");
                            sections += format_etcs_distance(sectionlength) + "1";
                            if (lastsectionsignal > 0) sections += format_binary(150, 10) + format_etcs_distance(0);
                            else
                            {
                                if (entrada2) sections += format_binary(infill ? 150 : 180, 10);
                                else sections += format_binary(infill ? 30 : 180, 10);
                                sections += format_etcs_distance(Math.Min(sectionlength, 200)); //D_SECTIONTIMERSTOPLOC(k)
                            }
                        }
                        lastsectionsignal = i;
                        sectionsignalcount = 0;
                        sectioncount++;
                        sectionStartDistance = feat.DistanceM;
                    }
                    sectionsignalcount++;
                }
                ma += format_binary(sectioncount, 5) + sections; // N_ITER + SECTION(k)
                ma += format_etcs_distance(maend - sectionStartDistance); // L_ENDSECTION
                if (lastsectionsignal == -1)
                {
                    ma += "0"; // Q_SECTIONTIMER
                }
                else
                {
                    var feat = features[lastsectionsignal];
                    bool salida = feat.MainHeadSignalTypeName.StartsWith("SP3S") || feat.MainHeadSignalTypeName.StartsWith("SP4S");
                    bool entrada = feat.MainHeadSignalTypeName.StartsWith("SP3E") || feat.MainHeadSignalTypeName.StartsWith("SP4E");
                    ma += "1";
                    if (sectioncount == 2) ma += format_binary(150, 10) + format_etcs_distance(0);
                    else
                    {
                        if (lastsectionsignal > 0) ma += format_binary(150, 10) + format_etcs_distance(0);
                        else
                        {
                            if (entrada) ma += format_binary(infill ? 150 : 180, 10);
                            else ma += format_binary(infill ? 150 : 180, 10);
                            ma += format_etcs_distance(Math.Min(maend - sectionStartDistance, 200)); //D_SECTIONTIMERSTOPLOC(k)
                        }
                    }
                }*/
                ma += "0"+"1"+format_etcs_distance(15)+format_etcs_speedKpH(vrelease)+"0";
            }
            return create_packet(12, ma, 1);
        }
        string construirSeccion(double longitud, int sectionNumber, List<SignalFeatures> feat, SignalFeatures? senalInicioSeccion, SignalFeatures? senalFinSeccion, bool infill)
        {
            int idx = senalInicioSeccion.HasValue ? feat.IndexOf(senalInicioSeccion.Value) : -1;
            int idx1 = senalFinSeccion.HasValue ? feat.IndexOf(senalFinSeccion.Value) : -1;
            bool esSalida = false;
            bool Convencional = true;
            string sect = format_etcs_distance(longitud);
            if (senalInicioSeccion != null && idx < 0)
            {
                sect += "1"+format_binary(160, 10)+format_etcs_distance(0);
            }
            else if (sectionNumber > 0)
            {
                int T = 30;
                if (idx == 0 && !infill) T = Convencional ? 180 : 360; // DEI
                else
                {
                    if (Convencional) T = (idx == 0 && esSalida) ? 30 : 150; // DAI
                    else if (idx == 1) T = 240; // DAI zona 2
                    else T = 360; // DAI zona 1
                }
                sect += "1"+format_binary(T, 10)+format_etcs_distance(200);
            }
            else if (idx1 == 0 && !infill)
            {
                int T = Convencional ? 150 : 240; // DAI
                sect += "1"+format_binary(T, 10)+format_etcs_distance(0);
            }
            else sect += "0"; // Sin temporizar
            return sect;
        }
        string get_directional_linking(float bgref, bool reverse, bool include_reverse)
        {
            List<BaliseDataType> balises = GetNextBalise(true, bgref + 10, 15000, reverse, 3, include_reverse);
            if (balises.Count == 0) return "";
            float cumref = bgref;
            List<string> links = new List<string>();
            for (int i=0; i<balises.Count; i++)
            {
                float d_link = balises[i].distance - cumref;
                string l = format_etcs_distance(d_link) + "0" + format_binary(balises[i].nid_bg, 14) + (balises[i].reverse_passed ? "0" : "1") + "01" + format_binary(3, 6);
                links.Add(l);
                cumref = balises[i].distance;
            }
            string link = "01" + links[0] + format_binary(links.Count-1, 5);
            for (int i=1; i<links.Count; i++)
            {
                link += links[i];
            }
            return link;
        }
        string get_linking(float bgref, bool reverse_passed)
        {
            if (reverse_passed) return "";
            string l2 = get_directional_linking(bgref, reverse_passed, false);
            if (l2 != "") return create_packet(5, l2, 1);
            return "";
            /*string l1 = get_directional_linking(bgref, !reverse_passed);
            string l2 = get_directional_linking(bgref, reverse_passed);
            string packs = "";
            if (l1 != "") packs += create_packet(5, l1, 0);
            if (l2 != "") packs += create_packet(5, l2, 1);
            return packs;;*/
        }
        void send_telegram(BaliseDataType balise, string telegrams, bool linked = true)
        {
            string tel = "1"+"0100001"+"0"+format_binary(balise.n_pig,3)+format_binary(balise.n_total, 3)+"00"+"11111111"+"0000000000"+format_binary(balise.nid_bg, 14)+(linked ? "1" : "0")+telegrams+"11111111";
            tcs.SendParameter("noretain(etcs::telegram", tel+")");
        }
        struct SpeedElement
        {
            public float distance;
            public float speed;
        }
        string get_ssp(float maend, float off)
        {
            string ssp="01";
            List<string> elements = new List<string>();
            float currspd = CurrPostSpeed > 1 ? CurrPostSpeed : Math.Min(tcs.CurrentPostSpeedLimitMpS(), tcs.LineSpeedMpS());
            for (int i=0; i<5; i++)
            {
                if (tcs.NextPostDistanceM(i) > off) break;
                float lim = tcs.NextPostSpeedLimitMpS(i);
                if (lim > 300) continue;
                currspd = Math.Min(lim, tcs.LineSpeedMpS());
            }
            elements.Add("000000000000000"+format_etcs_speed(currspd)+"0"+"00000");
            List<SpeedElement> speeds = new List<SpeedElement>();
            float sspend = maend;
            for (int i=0; i<25; i++)
            {
                float dist = tcs.NextPostDistanceM(i)-off;
                if (dist > sspend)
                    break;
                if (dist < 0 || tcs.NextPostSpeedLimitMpS(i) > 300) continue;
                SpeedElement e;
                e.speed = Math.Min(tcs.NextPostSpeedLimitMpS(i), tcs.LineSpeedMpS());
                e.distance = dist;
                /*string el = format_etcs_distance(dist-prevdist);
                if (tcs.NextPostDistanceM(i+2)-dist < 10)
                {
                    el += format_etcs_speed(tcs.NextPostSpeedLimitMpS(i+2)) + "0" + "00010";
                    el += "00" + format_binary(2, 4) + format_etcs_speed(tcs.NextPostSpeedLimitMpS(i+1));
                    el += "00" + format_binary(4, 4) + format_etcs_speed(tcs.NextPostSpeedLimitMpS(i));
                    i += 2;
                }
                else if (tcs.NextPostDistanceM(i+1)-dist < 5)
                {
                    el += format_etcs_speed(tcs.NextPostSpeedLimitMpS(i+1)) + "0" + "00001";
                    el += "00" + format_binary(2, 4) + format_etcs_speed(tcs.NextPostSpeedLimitMpS(i));
                    i += 1;
                }
                else
                {
                    el += format_etcs_speed(Math.Min(tcs.NextPostSpeedLimitMpS(i), tcs.LineSpeedMpS())) + "0" + "00000";
                }*/
                speeds.Add(e);
            }
            for (int i=0; i<20; i++)
            {
                var feat = tcs.NextGenericSignalFeatures("VELOCIDAD", i, sspend);
                float dist = feat.DistanceM-off;
                if (dist > sspend || dist < 0)
                    break;
                if (feat.TextAspect == "")
                    continue;
                SpeedElement e;
                e.speed = Math.Min(int.Parse(feat.TextAspect)/3.6f, tcs.LineSpeedMpS());
                e.distance = dist;
                speeds.Add(e);
            }
            speeds.Sort((x,y) => x.distance.CompareTo(y.distance));
            float prevdist=0;
            for (int i=0; i<speeds.Count; i++)
            {
                string el = format_etcs_distance(speeds[i].distance-prevdist);
                el += format_etcs_speed(speeds[i].speed) + "0" + "00000";
                elements.Add(el);
                prevdist = speeds[i].distance;
            }
            elements.Add(format_etcs_distance(sspend-prevdist)+"1111111"+"0"+"00000");
            ssp += elements[0];
            ssp += format_binary(elements.Count-1, 5);
            for (int i=1; i<elements.Count; i++)
            {
                ssp += elements[i];
            }
            return create_packet(27, ssp, 1);
        }
        string get_gradient(float maxdist)
        {
            float altM = tcs.AltitudeM();//SignalObject.trItems[Locomotive().Train.signalRef.SignalObjects[bg.nid_bg].trItem].Y;
            float distM = group_position-tcs.DistanceM();
            float prevDistRef = 0;
            float distRef = 0;
            List<string> grads = new List<string>();
            for (int i=0; distM < maxdist; i++)
            {
                SignalFeatures sig = tcs.NextGenericSignalFeatures("NORMAL", i, maxdist);
                if (sig.DistanceM == float.MaxValue)
                {
                    break;
                }
                else
                {
                    float objDist = sig.DistanceM;
                    float objAlt = sig.AltitudeM;
                    float g = (objAlt-altM)/(objDist-distM)*1000;
                    if (g > 200) g = 200;
                    if (g < -200) g = -200;
                    string gr = format_etcs_distance((distRef-prevDistRef)/10);
                    if (g <= 0)
                    {
                        gr+="0"+format_binary(-(int)g, 8);
                    }
                    else
                    {
                        gr+="1"+format_binary((int)g, 8);
                    }
                    grads.Add(gr);
                    prevDistRef = distRef;
                    distRef = objDist;
                    altM = objAlt;
                    distM = objDist;
                }
            }
            if (grads.Count == 0)
                return create_packet(21,"10" + "000000000000000"+"0"+"00000000" + format_binary(1, 5) + format_etcs_distance(maxdist/10)+"0"+"11111111", 1);
            string grad = "10" + grads[0] + format_binary(grads.Count, 5);
            for(int i=1; i<grads.Count; i++)
            {
                grad += grads[i];
            }
            return create_packet(21, grad + format_etcs_distance((maxdist-prevDistRef)/10)+"0"+"11111111", 1);
        }
        struct TrackCondition
        {
            public float dist;
            public float length;
            public int type;
        }
        string get_conditions(float offset, float max)
        {
            if (max > 30000) max = 30000;
            List<TrackCondition> conds = new List<TrackCondition>();
            // Tunnels
            for (int i=0; ; i++)
            {
                TunnelInfo info = tcs.NextTunnel(i);
                if (info.DistanceM > max) break;
                if (info.LengthM>200)
                {
                    TrackCondition nostop = new TrackCondition();
                    nostop.type = 0;
                    nostop.dist = Math.Max(info.DistanceM, 0) - offset;
                    nostop.length = info.LengthM;
                    conds.Add(nostop);
                }
                TrackCondition airtight = new TrackCondition();
                airtight.type = 5;
                airtight.dist = Math.Max(info.DistanceM, 0) - offset;
                airtight.length = info.LengthM;
                conds.Add(airtight);  
            }
            // Neutral sections
            for (int i=0; ; i++)
            {
                var feat = tcs.NextGenericSignalFeatures("INFO", i, max);
                if (feat.DistanceM < 0 || feat.DistanceM > max) break;
                TrackCondition cond = new TrackCondition();
                cond.type = 15;
                string endname = "";
                if (feat.MainHeadSignalTypeName == "iniciozonaneutra")
                {
                    cond.type = 9;
                    endname = "finzonaneutra";
                }
                else if (feat.MainHeadSignalTypeName == "startneutro")
                {
                    cond.type = 9;
                    endname = "endneutro";
                }
                else if (feat.MainHeadSignalTypeName == "bajarpantografos")
                {
                    cond.type = 3;
                    endname = "subirpantografos";
                }
                else continue;
                cond.dist = feat.DistanceM-offset;
                cond.length = 200;
                for (int j=0; j<4; j++)
                {
                    var feat2 = tcs.NextGenericSignalFeatures("INFO", i+j, max); 
                    if (feat2.DistanceM < feat.DistanceM || feat2.DistanceM > max) break;
                    if (feat2.MainHeadSignalTypeName == endname)
                    {
                        cond.length = feat2.DistanceM-feat.DistanceM;
                        break;
                    }
                }
                conds.Add(cond);  
            }
            
            if (conds.Count == 0) return "";
            conds.Sort((x, y) => x.dist.CompareTo(y.dist));
            float cumdist=0;
            List<string> elements = new List<string>();
            for (int i=0; i<conds.Count; i++)
            {
                TrackCondition tc = conds[i];
                if (tc.dist < 0)
                {
                    tc.length += tc.dist;
                    tc.dist = 0;
                }
                if (tc.length <= 0) continue;
                string el = format_etcs_distance(tc.dist-cumdist) + format_etcs_distance(tc.length) + format_binary(tc.type, 4);
                elements.Add(el);
                cumdist = tc.dist;
            }
            if (elements.Count == 0) return "";
            string pack = "01"+"0";
            pack += elements[0];
            pack += format_binary(elements.Count-1, 5);
            for (int i=1; i<elements.Count; i++)
            {
                pack += elements[i];
            }
            return create_packet(68, pack, 1);
        }
        float get_pk(float mindist, out bool fwd)
        {
            float pk = 0;
            float pkdist = 0;
            fwd = true;
            for (int i=0; ; i++)
            {
                MilepostInfo info = tcs.NextMilepost(i);
                if (info.DistanceM < mindist)
                {
                    continue;
                }
                if (info.DistanceM > 4000 + mindist)
                {
                    return pk;
                }
                
                if (pk != 0)
                {
                    float pk2 = info.Value;
                    fwd = pk2 >= pk;
                    if (fwd) return pk-pkdist/1000;
                    else return pk + pkdist/1000;
                }
                pk = info.Value;
                pkdist = info.DistanceM - mindist;
            }
        }
        string get_tunnel_msg(float bgref, int ahead)
        {
            
            TunnelInfo info = tcs.NextTunnel(ahead);
            if (info.DistanceM > 32000 || info.DistanceM < 0) return "";
            float dist = info.DistanceM - bgref;
            float length = info.LengthM;
            bool fwd;
            float pk = get_pk(dist, out fwd);
            if (fwd) pk += length/2000;
            else pk -= length/2000;
            if (pk<0) pk = 0;
            double start = Math.Max(dist-1000, 0);
            double end = dist+length-start;
            string txt;
            if (length < 1000)
            {
                txt = "Túnel PK " + pk.ToString("0.0") + " L " + length.ToString("0.0") + "m";
            }
            else
            {
                txt = "Túnel PK " + pk.ToString("0.0") + " L " + (length/1000).ToString("0.0") + "km";
            }
            byte[] ascii = System.Text.Encoding.GetEncoding(28591).GetBytes(txt);
            string msg = "10" + format_binary(0,2) + "0" + format_etcs_distance(start/10) + format_binary(15,4) + format_binary(5,3) + format_etcs_distance(end/10) + format_binary(1023,10) + format_binary(15,4) + format_binary(5,3) + format_binary(0,2) + format_binary(ascii.Length, 8);
            for (int i=0; i<ascii.Length; i++)
            {
                msg += format_binary((int)ascii[i],8);
            }
            return create_packet(72, msg, 1);
        }
        int nid_lrbg;
        float pos_lrbg;
        bool orient;
        bool ma_rq;
        float current_ma_end;
        float reported_pos;
        /*void l2_test()
        {
            if (BalisePassed != null && !BalisePassed.reverse_passed)
            {
                if ((BalisePassed.reverse_passed && BalisePassed.n_pig == 0) || (!BalisePassed.reverse_passed && BalisePassed.n_pig == BalisePassed.n_total))
                {
                    nid_lrbg = BalisePassed.nid_bg;
                    pos_lrbg = group_position;
                    orient = BalisePassed.reverse_passed;
                }
            }
            if ((ma_rq || Math.Abs(current_ma_end-eoa_distance()) > 10) && Math.Max(current_ma_end, reported_pos)-tcs.DistanceM() > tcs.NextSignalDistanceM(0)-50)
            {
                l2_ma();
                ma_rq = false;
            }
        }
        void handle_msg(string msg)
        {
            byte[] data = Convert.FromBase64String(msg);
            bool pos = false;
            if (data[0] == 132)
            {
                ma_rq = true;
                pos = true;
            }
            if (data[0] == 136) pos = true;
            if (pos)
            {
                reported_pos = tcs.DistanceM();//pos_lrbg + d_lrbg;
            }
        }
        float eoa_distance()
        {
            float dist=0;
            for (int i=0; i<5; i++)
            {
                var feat = tcs.NextGenericSignalFeatures("NORMAL", i, float.MaxValue);
                dist = feat.DistanceM;
                var asp = ConvertirAspecto(feat.Aspect, feat.TextAspect);
                if (asp == Aspecto.Parada || asp == Aspecto.ParadaPermisiva) break;
                if (dist > 32000) break;
            }
            return dist;
        }
        void l2_ma()
        {
            /*float dist = Math.Min(eoa_distance()+tcs.DistanceM()-pos_lrbg, 32000);
            string ma="01"+format_etcs_speedKpH(0)+format_binary(0,10)+format_binary(0,5)+format_etcs_distance(dist)+"0"+"0"+"0"+"0";
            string msg=create_message(3, false, 0, nid_lrbg, create_packet(15,ma,orient?0:1)+get_ssp(32000,pos_lrbg-tcs.DistanceM())+get_gradient(32000)+create_packet(5, get_directional_linking(pos_lrbg-tcs.DistanceM(), orient, true), orient ? 0 : 1)+get_conditions(pos_lrbg-tcs.DistanceM(), 32000));
            tcs.SendParameter("noretain(etcs::message", msg+")");
        }*/
        string format_binary(int value, int size)
        {
            if (value < 0) value = 0;
            string tmp = Convert.ToString(value,2);
            string bin="";
            for (int i=0; i<size-tmp.Length; i++)
            {
                bin += "0";
            }
            bin += tmp;
            return bin;
        }
        string format_etcs_speed(double speedmps)
        {
            int val = Math.Min((int)Math.Round(speedmps*3.6)/5, 120);
            return format_binary(val, 7);
        }
        string format_etcs_speedKpH(double speedkph)
        {
            int val = Math.Min((int)Math.Round(speedkph)/5, 120);
            return format_binary(val, 7);
        }
        string format_etcs_distance(double distm)
        {
            int val = Math.Max(Math.Min((int)Math.Round(distm), 32767),0);
            return format_binary(val, 15);
        }
        string create_packet(int nid_packet, string info, int dir)
        {
            return format_binary(nid_packet, 8)+format_binary(dir, 2)+format_binary(info.Length+23,13)+info;
        }
        string create_message(int nid_message, bool ack, int nid_c, int nid_bg, string extra)
        {
            int size = (extra.Length + 75 + 7)/8;
            string pack = format_binary(nid_message, 8)+format_binary(size, 10)+format_binary(0, 32)+format_binary(ack ? 0 : 1, 1)+format_binary(nid_c,10)+format_binary(nid_bg,14)+extra;
            if (size * 8 > pack.Length) pack += format_binary(0, size * 8 - pack.Length);
            byte[] data = new byte[size];
            for (int i=0; i<size; i++)
            {
                for (int j=0; j<8; j++)
                {
                    data[i] += (byte)((pack[8*i+j]=='1' ? 1 : 0)<<(7-j));
                }
            }
            return Convert.ToBase64String(data);
        }
        bool SignalPassed = false;
        float PreviousSignalDistanceM = 0;
        Aspect PreviousSignalAspect;
		protected void UpdateSignalPassed()
        {
            SignalPassed = (tcs.NextSignalDistanceM(0) > PreviousSignalDistanceM+20)&&(tcs.SpeedMpS()>0.1f);
            PreviousSignalDistanceM = tcs.NextSignalDistanceM(0);
            if (SignalPassed && tcs.NextSignalAspect(0) == Aspect.None) SignalPassed = false;
            if (!SignalPassed) PreviousSignalAspect = tcs.NextSignalAspect(0);
        }
        bool InfillPassed=false;
        bool InfillReset=false;
        protected void UpdateInfillPassed()
        {
            InfillPassed = false;
            if (tcs.NextSignalDistanceM(0) < 300)
            {
                if (!InfillReset)
                {
                    InfillReset = true;
                    InfillPassed = true;
                }
            }
            if (SignalPassed) InfillReset = false;
        }
        class BaliseDataType
        {
            public float distance;
            public string type;
            public Aspect aspect;
            public string TextAspect;
            public int nid_bg;
            public int n_pig;
            public int n_total;
            public bool reverse_passed;
        }
        bool emularEurobalizas = false;
        BaliseDataType BuildBalise(string name, float distance, string aspect)
        {
            BaliseDataType b = new BaliseDataType();
            b.distance = distance;
            b.type = name;
            b.TextAspect = aspect;
            if (b.TextAspect.Length >= 50)
            {
                b.nid_bg = Convert.ToInt32(b.TextAspect.Substring(35, 14), 2);
                b.n_pig = Convert.ToInt32(b.TextAspect.Substring(9, 3), 2);
                b.n_total = Convert.ToInt32(b.TextAspect.Substring(12, 3), 2);
            }
            else
            {
                b.n_pig = int.Parse(b.type[b.type.Length-3].ToString())-1;
                b.n_total = int.Parse(b.type[b.type.Length-1].ToString())-1;
                b.nid_bg = 1;
            }
            return b;
        }
        List<BaliseDataType> GetNextBalise(bool find_first, float min_distance, float max_distance, bool reverse_search = false, int num = 1, bool include_reverse=true)
        {
            List<BaliseDataType> balises = new List<BaliseDataType>();
            //float distance = 0;
            emularEurobalizas = tcs.NextGenericSignalDistanceM("ETCS") < 0;
            if (emularEurobalizas)
            {
                /*for (int i=0; balises.Count < num; i++)
                {
                    float sigdist = tcs.NextSignalDistanceM(i);
                    if (sigdist < 0) break;
                    // MA
                    {
                        float dist = sigdist - 10;
                        if (dist > max_distance) break;
                        if (dist >= min_distance)
                        {  
                            BaliseDataType b = BuildBalise("etcs_main_ma_1_2", dist, "");
                            if (!find_first || b.nid_bg != -1) balises.Add(b);
                        }
                    }
                    // Fija
                    {
                        float dist = sigdist - 5;
                        if (dist > max_distance) break;
                        if (dist >= min_distance)
                        {  
                            BaliseDataType b = BuildBalise("etcs_main_fixed_2_2", dist, "");
                            if (!find_first || b.nid_bg != -1) balises.Add(b);
                        }
                    }
                }*/
            }
            else/* if (!include_reverse)*/
            {
                for (int i=0; balises.Count < num; i++)
                {
                    SignalFeatures sig = tcs.NextGenericSignalFeatures("ETCS", i, max_distance);
                    if (sig.DistanceM > max_distance || sig.DistanceM < 0) break;
                    if (sig.DistanceM < min_distance) continue;
                    BaliseDataType b = BuildBalise(sig.MainHeadSignalTypeName, sig.DistanceM, sig.TextAspect);
                    if (find_first && b.n_pig != 0) continue;
                    balises.Add(b);
                }
            }
            /*else
            {
                Locomotive = tcs.Locomotive;
                int dir = ((tcs.CurrentTrainMUDirection() == Direction.Reverse) ^ reverse_search) ? 1 : 0;
                int fn_type = Locomotive().Train.signalRef.ORTSSignalTypes.IndexOf("ETCS");
                if (fn_type < 0)
                    return balises;
                
                if (Locomotive().Train.ValidRoute[dir] == null || Locomotive().Train.PresentPosition[0].TCSectionIndex < 0 || Locomotive().Train.PresentPosition[1].TCSectionIndex < 0)
                    return balises;
                    
                int index = dir == 0 ? Locomotive().Train.PresentPosition[0].RouteListIndex : 
                    Locomotive().Train.ValidRoute[1].GetRouteIndex(Locomotive().Train.PresentPosition[1].TCSectionIndex, 0);
                if (index < 0)
                    return balises;
                
                float lengthOffset = (dir == 1) ? (-Locomotive().Train.PresentPosition[1].TCOffset +
                        Locomotive().Train.signalRef.TrackCircuitList[Locomotive().Train.PresentPosition[1].TCSectionIndex].Length) : Locomotive().Train.PresentPosition[0].TCOffset;
                float totalLength = 0;//-tcs.TrainLengthM()+3;
                //if ((tcs.IsFlipped() || tcs.IsRearCab())^(dir == 1)) totalLength = -3;
                var routePath = Locomotive().Train.ValidRoute[dir];
                int fwd_candidates = 0;
                int rev_candidates = 0;
                while (index < routePath.Count && totalLength < max_distance && balises.Count < num)
                {
                    var thisElement = routePath[index];
                    var thisSection = Locomotive().Train.signalRef.TrackCircuitList[thisElement.TCSectionIndex];
                    var thisSignalList = thisSection.CircuitItems.TrackCircuitSignals[thisElement.Direction][fn_type];
                    foreach (var thisSignal in thisSignalList.TrackCircuitItem)
                    {
                        if (thisSignal.SignalLocation > lengthOffset)
                        {
                            BaliseDataType b = BuildBalise(thisSignal.SignalRef.SignalHeads[0].SignalTypeName, thisSignal.SignalLocation - lengthOffset + totalLength, thisSignal.SignalRef.SignalHeads[0].TextSignalAspect);
                            if (find_first && b.n_pig != 0) continue;
                            if (b.distance < min_distance) continue;
                            balises.Add(b);
                            fwd_candidates++;
                            if (fwd_candidates >= num) break;
                        }
                    }
                    thisSignalList = thisSection.CircuitItems.TrackCircuitSignals[1-thisElement.Direction][fn_type];
                    
                    List<TrackCircuitSignalItem> list = new List<TrackCircuitSignalItem>();
                    list.AddRange(thisSignalList.TrackCircuitItem);
                    list.Reverse();
                    foreach (var thisSignal in list)
                    {
                        if ((thisSection.Length - thisSignal.SignalLocation) > lengthOffset)
                        {
                            BaliseDataType b = BuildBalise(thisSignal.SignalRef.SignalHeads[0].SignalTypeName, (thisSection.Length - thisSignal.SignalLocation) - lengthOffset + totalLength, thisSignal.SignalRef.SignalHeads[0].TextSignalAspect);
                            if (find_first && b.n_pig != 0) continue;
                            if (b.distance < min_distance) continue;
                            b.reverse_passed = true;
                            balises.Add(b);
                            rev_candidates++;
                            if (rev_candidates >= num) break;
                        }
                    }
                    totalLength += (thisSection.Length - lengthOffset);
                    lengthOffset = 0;

                    index++;
                }
            }*/
            return balises.OrderBy(balise => balise.distance).ToList();
        }
        BaliseDataType BaliseProximity;
        BaliseDataType BalisePassed;
        float group_position = 0;
        float last_passed = 0;
        int nid_bg = -1;
        protected void UpdateEurobalise()
        {
            BalisePassed = null;
            List<BaliseDataType> balises = GetNextBalise(false, 0, 20);
            BaliseDataType t = balises.Count == 0 ? null : balises[0];
            if (last_passed != 0 && tcs.DistanceM() - last_passed > 20)
            {
                group_position = 0;
                last_passed = 0;
                nid_bg = -1;
            }
            if (BaliseProximity != null && (t == null || t.distance > 20 || t.type != BaliseProximity.type || t.nid_bg != BaliseProximity.nid_bg || t.n_pig != BaliseProximity.n_pig))
            {
                //last_passed = tcs.DistanceM();
                BalisePassed = BaliseProximity;
                if (nid_bg != BalisePassed.nid_bg) group_position = 0;
                nid_bg = BalisePassed.nid_bg;
                if (BalisePassed.n_pig == 0) group_position = last_passed;
                else if (group_position == 0 && BalisePassed.reverse_passed)
                {
                    List<BaliseDataType> bgrefs = GetNextBalise(true, 0, 120);
                    BaliseDataType bgref = bgrefs.Count == 0 ? null : bgrefs[0];
                    if (bgref != null && bgref.nid_bg == nid_bg)
                    {
                        group_position = tcs.DistanceM()+bgref.distance;
                    }
                }
                if (group_position == 0) group_position = last_passed;
                BaliseProximity = null;
            }
            if (t != null && t.distance < 15) BaliseProximity = t;
            if (BaliseProximity != null) last_passed = tcs.DistanceM()+t.distance;
        }
        float atf;
        float parseFloat(string s)
        {
            if (s.Length == 0) return 0;
            double val = 0;
            double.TryParse(s.Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out val);
            return (float)val;
        }
        public class SimpleJSON
        {
            string json;
            int index;
            bool readingContent;
            public SimpleJSON(string str)
            {
                index = 0;
                readingContent = false;
                int start = str.IndexOf('{');
                int end = str.LastIndexOf('}');
                if (start < 0 || end < 0 || start>end) json = "";
                else json = str.Substring(start+1, end-start-1);
            }
            public string GetNextField()
            {
                if (readingContent) GetContent();
                bool escape = false;
                int start = -1;
                int end = -1;
                for (int i=index; i<json.Length; i++)
                {
                    if (start >= 0 && json[i] == '\\') escape = !escape; 
                    else escape = false;
                    if (json[i] == '"' && !escape)
                    {
                        if (start < 0) start = i;
                        else
                        {
                            end = i;
                            break;
                        }
                    }
                }
                if (start < 0 || end < 0)
                {
                    index = json.Length;
                    return null;
                }
                index = end + 1;
                readingContent = true;
                return json.Substring(start+1, end-start-1);
            }
            public string GetContent()
            {
                if (!readingContent) return null;
                int start = -1;
                int end = -1;
                int currentdepth = 0;
                bool inString = false;
                bool escape = false;
                for (int i=index; i<json.Length && end < 0 && currentdepth >= 0; i++)
                {
                    if (json[i] == ':' && start < 0) start = i+1;
                    if (start < 0) continue;
                    switch(json[i])
                    {
                        case '\\':
                            escape = !escape && inString;
                            break;
                        case '"':
                            if (!escape) inString = !inString;
                            break;
                        case '{':
                        case '[':
                            if (!inString) currentdepth++;
                            break;
                        case '}':
                        case ']':
                            if (!inString) currentdepth--;
                            break;
                        case ',':
                            if (currentdepth == 0 && !inString) end = i;
                            break;
                    }
                    if (!inString || json[i] != '\\') escape = false;
                }
                if (end < 0) end = json.Length;
                string val = json.Substring(start, end-start).Trim(new char[]{' ','\n','\r'});
                index = end+1;
                readingContent = false;
                return val;
            }
            public float? GetFloat()
            {
                double num;
                if (!double.TryParse(GetContent(), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out num)) return null;
                return (float)num;
            }
            public float? GetSpeedMpS()
            {
                float? f = GetFloat();
                if (f == null) return null;
                return MpS.FromKpH((float)Math.Round(MpS.ToKpH(f.Value)));
            }
            public int? GetInt()
            {
                int num;
                if (!int.TryParse(GetContent(), out num)) return null;
                return num;
            }
            public string GetString()
            {
                string c = GetContent();
                return c.Substring(1, c.Length-2);
            }
            public List<string> GetArrayContent()
            {
                var list = new List<string>();
                string cont = GetContent();
                int start = 1;
                int currentdepth = 0;
                bool inString = false;
                bool escape = false;
                for (int i=1; i<cont.Length; i++)
                {
                    switch(cont[i])
                    {
                        case '\\':
                            escape = !escape && inString;
                            break;
                        case '"':
                            if (!escape) inString = !inString;
                            break;
                        case '{':
                        case '[':
                            if (!inString) currentdepth++;
                            break;
                        case '}':
                        case ']':
                            if (!inString) currentdepth--;
                            break;
                        case ',':
                            if (currentdepth == 0 && !inString)
                            {
                                string s = cont.Substring(start, i-start).Trim(new char[]{' ','\n','\r'});
                                if (s.Length > 0) list.Add(s);
                                start = i+1;
                            }
                            break;
                    }
                    if (!inString || cont[i] != '\\') escape = false;
                }
                if (start < cont.Length)
                {
                    string s = cont.Substring(start, cont.Length-1-start).Trim(new char[]{' ','\n','\r'});
                    if (s.Length > 0) list.Add(s);
                }
                return list;
            }
        }
        Dictionary<int, TextMessage> MessageList = new Dictionary<int, TextMessage>();
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = new List<Parameter>();
            
            Parameter p;
            
            p = new Parameter("etcs::emergency");
            p.SetValue = (string val) => {Emergency = val!="0" && val!="false";};
            l.Add(p);
            
            
            p = new Parameter("etcs::atf");
            p.SetValue = (string val) => {
                atf = (float)parseFloat(val);
                //if (atf >= 0) tcs.Locomotive().CruiseControl.SetSpeed(MpS.ToKpH(atf));
            };
            l.Add(p);
            
            p = new Parameter("etcs::fullbrake");
            p.SetValue = (string val) => {FullBrake = val=="1" || val=="true";};
            l.Add(p);
            
            p = new Parameter("etcs::tractioncutoff");
            p.SetValue = (string val) => {TCO = val=="1" || val=="true";};
            l.Add(p);
            
            p = new Parameter("etcs::lower_pantographs");
            p.SetValue = (string val) => {
                string[] dists = val.Split(';');
                EndLowPantographSection = double.MinValue;
                StartLowPantographSection = double.MaxValue;
                if (dists.Length > 1 && dists[1].Length > 0)
                {
                    StartLowPantographSection = float.MinValue;
                    double.TryParse(dists[1].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out EndLowPantographSection);
                }
                if (dists.Length > 0 && dists[0].Length > 0) double.TryParse(dists[0].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out StartLowPantographSection);
            };
            l.Add(p);
            
            p = new Parameter("etcs::neutral_section");
            p.SetValue = (string val) => {
                string[] dists = val.Split(';');
                EndNeutralSectionDistanceM = double.MinValue;
                StartNeutralSectionDistanceM = double.MaxValue;
                if (dists.Length > 1 && dists[1].Length > 0)
                {
                    StartNeutralSectionDistanceM = float.MinValue;
                    double.TryParse(dists[1].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out EndNeutralSectionDistanceM);
                }
                if (dists.Length > 0 && dists[0].Length > 0) double.TryParse(dists[0].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out StartNeutralSectionDistanceM);
            };
            l.Add(p);

            p = new Parameter("etcs::dmi::command");
            p.SetValue = (string recvdata) =>
            {
                int spl1 = recvdata.IndexOf('(');
                int spl2 = recvdata.LastIndexOf(')');
                if (spl1 < 0 || spl2 < 0) return;
                string command = recvdata.Substring(0, spl1);
                string value = recvdata.Substring(spl1 + 1, spl2 - spl1 - 1);
                if (command == "json")
                {
                    tcs.ETCSStatus.IndicationMarkerDistanceM = null;
                    tcs.ETCSStatus.IndicationMarkerTarget = null;
                    var j = new SimpleJSON(value);
                    string field = j.GetNextField();
                    while (field != null)
                    {
                        switch (field)
                        {
                            case "AllowedSpeedMpS": tcs.ETCSStatus.AllowedSpeedMpS = j.GetSpeedMpS() ?? 0; break;
                            case "TargetSpeedMpS": tcs.ETCSStatus.TargetSpeedMpS = j.GetSpeedMpS(); break;
                            case "InterventionSpeedMpS": tcs.ETCSStatus.InterventionSpeedMpS = j.GetSpeedMpS() ?? 0; break;
                            case "ReleaseSpeedMpS":
                                if (tcs.ETCSStatus.TargetSpeedMpS == 0) tcs.ETCSStatus.ReleaseSpeedMpS = j.GetSpeedMpS();
                                else tcs.ETCSStatus.ReleaseSpeedMpS = null;
                                break;
                            case "CurrentMonitoringStatus": tcs.ETCSStatus.CurrentMonitor = (Monitor)j.GetInt().Value; break;
                            case "CurrentSupervisionStatus": tcs.ETCSStatus.CurrentSupervisionStatus = (SupervisionStatus)j.GetInt().Value; break;
                            case "CurrentMode": tcs.ETCSStatus.CurrentMode = (Mode)j.GetInt().Value; break;
                            case "TargetDistanceM":
                            {
                                float? f = j.GetFloat();
                                if (tcs.ETCSStatus.TargetSpeedMpS < tcs.ETCSStatus.AllowedSpeedMpS && f > 0) tcs.ETCSStatus.TargetDistanceM = f;
                                else tcs.ETCSStatus.TargetDistanceM = null;
                                break;
                            }
                            case "TimeToPermittedS":
                            {
                                float? f = j.GetFloat();
                                if (f == null || f.Value >= 20 || tcs.ETCSStatus.CurrentMonitor == Monitor.CeilingSpeed || tcs.ETCSStatus.CurrentMode != Mode.FS) tcs.ETCSStatus.TimeToPermittedS = null;
                                else tcs.ETCSStatus.TimeToPermittedS = f.Value;
                                break;
                            }
                            case "GradientProfile":
                            {
                                var list = j.GetArrayContent();
                                tcs.ETCSStatus.GradientProfile.Clear();
                                foreach (string s in list)
                                {
                                    var j2 = new SimpleJSON(s);
                                    int grad=0;
                                    float dist=0;
                                    field = j2.GetNextField();
                                    while (field != null)
                                    {
                                        if (field == "DistanceToTrainM") dist = j2.GetFloat().Value;
                                        else if (field == "GradientPerMille") grad = j2.GetInt().Value;
                                        field = j2.GetNextField();
                                    }
                                    tcs.ETCSStatus.GradientProfile.Add(new GradientProfileElement(dist, grad));
                                }
                                break;
                            }
                            case "PlanningTrackConditions":
                            {
                                var list = j.GetArrayContent();
                                tcs.ETCSStatus.PlanningTrackConditions.Clear();
                                foreach (string s in list)
                                {
                                    var j2 = new SimpleJSON(s);
                                    int type=0;
                                    float dist=0;
                                    bool yellow=false;
                                    field = j2.GetNextField();
                                    while (field != null)
                                    {
                                        if (field == "DistanceToTrainM") dist = j2.GetFloat().Value;
                                        else if (field == "Type") type = j2.GetInt().Value;
                                        else if (field == "YellowColour") yellow = j2.GetContent()=="true";
                                        field = j2.GetNextField();
                                    }
                                    tcs.ETCSStatus.PlanningTrackConditions.Add(new PlanningTrackCondition((TrackConditionType)type, yellow, dist));
                                }
                                break;
                            }
                            case "SpeedTargets":
                            {
                                var list = j.GetArrayContent();
                                tcs.ETCSStatus.SpeedTargets.Clear();
                                foreach (string s in list)
                                {
                                    var j2 = new SimpleJSON(s);
                                    float speed=0;
                                    float dist=0;
                                    field = j2.GetNextField();
                                    while (field != null)
                                    {
                                        if (field == "DistanceToTrainM") dist = j2.GetFloat().Value;
                                        else if (field == "TargetSpeedMpS") speed = j2.GetSpeedMpS().Value;
                                        field = j2.GetNextField();
                                    }
                                    tcs.ETCSStatus.SpeedTargets.Add(new PlanningTarget(dist, speed));
                                }
                                break;
                            }
                            case "IndicationMarkerDistanceM": tcs.ETCSStatus.IndicationMarkerDistanceM = j.GetFloat(); break;
                            case "IndicationMarkerTarget":
                            {
                                tcs.ETCSStatus.IndicationMarkerTarget = null;
                                string s = j.GetContent();
                                if (s != "null")
                                {
                                    var j2 = new SimpleJSON(s);
                                    float speed=-1;
                                    float dist=0;
                                    field = j2.GetNextField();
                                    while (field != null)
                                    {
                                        if (field == "DistanceToTrainM") dist = j2.GetFloat().Value;
                                        else if (field == "TargetSpeedMpS") speed = j2.GetFloat().Value;
                                        field = j2.GetNextField();
                                    }
                                    if (speed >= 0) tcs.ETCSStatus.IndicationMarkerTarget = new PlanningTarget(dist, speed);
                                }
                                break;
                            }
                        }
                        field = j.GetNextField();
                    }
                }
                else if (command == "setMessage")
                {
                    string[] split1 = value.Split(',');
                    int id = int.Parse(split1[0]);
                    int size = int.Parse(split1[1]);
                    value = value.Substring(split1[0].Length+split1[1].Length+2);
                    size = System.Text.Encoding.UTF8.GetString(System.Text.Encoding.UTF8.GetBytes(value), 0, size).Length;
                    string text = value.Substring(0, size);
                    string[] split2 = value.Substring(size+1).Split(',');
                    int hour = int.Parse(split2[0]);
                    int min = int.Parse(split2[1]);
                    bool fg = split2[2] == "true";
                    bool ack = split2[3] == "true";
                    TextMessage msg = new TextMessage(text, hour*3600+min*60, fg, ack);
                    MessageList[id] = msg;
                    if (tcs.ETCSStatus.TextMessages.Contains(msg)) tcs.ETCSStatus.TextMessages.Remove(msg);
                    tcs.ETCSStatus.TextMessages.Insert(0, msg);
                }
                else if (command == "setRevokeMessage")
                {
                    int num = int.Parse(value);
                    TextMessage msg;
                    if (MessageList.TryGetValue(num, out msg))
                    {
                        tcs.ETCSStatus.TextMessages.Remove(msg);
                        MessageList.Remove(num);
                    }
                }
            };
            l.Add(p);

            return l;
        }
    }
    public abstract class ASFA : InteractiveTCS
    {
        public enum Freq
        {
            FP,
            L1,
            L2,
            L3,
            L4,
            L5,
            L6,
            L7,
            L8,
            L9,
            L10,
            L11,
            AL
        }
        float LVIstart = 0;
        Freq lvi1 = Freq.L11;
        Freq lvi2 = Freq.L11;
        bool LineaEquipadaComprobado = false;
        bool LineaEquipada = false;
        public ASFA(ServerTCS tcs) : base(tcs)
        {
        }
        public override void Update()
        {
            if(!LineaEquipadaComprobado)
            {
                LineaEquipada = tcs.NextGenericSignalDistanceM("ASFA") >= 0;
                LineaEquipadaComprobado = true;
            }
            UpdateSignalPassed();
            UpdateDistanciaPrevia();
        }
        Random rnd = new Random();
        
        Freq GetBalizaAspect()
        {
            if (!LineaEquipada)
            {
                for(int i=0; i<4; i++)
                {
                    if(tcs.NextPostDistanceM(i)<=1500 && tcs.NextPostDistanceM(i)>=1495 && tcs.CurrentPostSpeedLimitMpS() - tcs.NextPostSpeedLimitMpS(i)>=MpS.FromKpH(40))
                    {
                        return Freq.L1;
                    }
                }
                float dprevia = tcs.NextSignalDistanceM(0)-PreviaDistance+10;
                switch (tcs.NextSignalAspect(0))
                {
                    case Aspect.Stop:
                    case Aspect.StopAndProceed:
                    case Aspect.Restricted:
                    case Aspect.Permission:
                        return (dprevia>0 && PreviaDistance > 0) ? Freq.L7 : Freq.L8;
                    case Aspect.Approach_1:
                    case Aspect.Approach_2:
                    case Aspect.Approach_3:
                        return Freq.L1;
                    case Aspect.Clear_1:
                        return Freq.L2;
                    case Aspect.Clear_2:
                        return Freq.L3;
                    default:
                        return Freq.FP;
                }
            }
            else
            {
                string name = tcs.NextGenericSignalMainHeadSignalType("ASFA");
                switch(tcs.NextGenericSignalFeatures("ASFA", 0, 10).TextAspect)
                {
                    case "FP":
                        return Freq.FP;
                    case "L1":
                        return Freq.L1;
                    case "L2":
                        return Freq.L2;
                    case "L3":
                        return Freq.L3;
                    case "L4":
                        return Freq.L4;
                    case "L5":
                        return Freq.L5;
                    case "L6":
                        return Freq.L6;
                    case "L7":
                        return Freq.L7;
                    case "L8":
                        return Freq.L8;
                    case "L9":
                        return Freq.L9;
                    case "L10":
                        return Freq.L10;
                    case "L11":
                        return Freq.L11;
                    case "":
                        switch(tcs.NextGenericSignalAspect("ASFA"))
                        {
                            case Aspect.Permission:
                            case Aspect.Stop:
                                return Freq.L8;
                            case Aspect.StopAndProceed:
                                return Freq.L7;
                            case Aspect.Restricted:
                                return Freq.L4;
                            case Aspect.Approach_1:
                                return Freq.L1;
                            case Aspect.Approach_2:
                                return Freq.L5;
                            case Aspect.Approach_3:
                                return Freq.L6;
                            case Aspect.Clear_1:
                                return Freq.L2;
                            case Aspect.Clear_2:
                                return Freq.L3;
                            default:
                                return Freq.FP;
                        }
                    default:
                        return Freq.AL;
                }
                return Freq.FP;
            }
        }
        float GetBalizaDistance()
        {
            if (!LineaEquipada)
            {
                for(int i=0; i<4; i++)
                {
                    if(tcs.NextPostDistanceM(i)<=1500 && tcs.NextPostDistanceM(i)>=1495 && tcs.CurrentPostSpeedLimitMpS() - tcs.NextPostSpeedLimitMpS(i)>=MpS.FromKpH(40))
                    {
                        return tcs.NextPostDistanceM(i)-1495;
                    }
                }
                float dprevia = tcs.NextSignalDistanceM(0)-PreviaDistance+10;
                if (dprevia>0 && PreviaDistance > 0)
                    return dprevia;
                
                return tcs.NextSignalDistanceM(0);
                /*if(LVIstart==0)
                {
                    for(int i=0; i<4; i++)
                    {
                        if(tcs.NextPostDistanceM(i)>1500 || tcs.NextPostDistanceM(i)<1495) continue;
                        if(tcs.CurrentPostSpeedLimitMpS()-tcs.NextPostSpeedLimitMpS(i)>=MpS.FromKpH(40))
                        {
                            LVIstart = tcs.DistanceM();
                            float speed = MpS.ToKpH(tcs.NextPostSpeedLimitMpS(i));
                            if (speed < 50) lvi1 = lvi2 = Freq.L11;
                            else if (speed < 80)
                            {
                                lvi1 = Freq.L11;
                                lvi2 = Freq.L10;
                            }
                            else if (speed < 120)
                            {
                                lvi1 = Freq.L10;
                                lvi2 = Freq.L11;
                            }
                            else lvi1 = lvi2 = Freq.L10;
                        }
                    }
                }*/
            }
            else
            {
                return tcs.NextGenericSignalDistanceM("ASFA");
            }
        }
        
        float fail;
        float fail_odometer;
        
        Freq prevBalizaAspect = Freq.FP;
        float prevBalizaDistance = -1;
        public Freq Baliza()
        {
            int random = 1;
            int random_max = 1000;
            if (random == 2) random_max = 500;
            else if (random == 3) random_max = 100;
                
            if (random > 0 && tcs.DistanceM()-fail_odometer > 1000) {
                if (rnd.Next(1,random_max) == 5)
                    fail = tcs.ClockTime();
                fail_odometer = tcs.DistanceM();
            }
            if (tcs.ClockTime()-fail<0.5f)
                return Freq.AL;
            
            float dist = GetBalizaDistance();
            if (prevBalizaDistance >= 0 && prevBalizaAspect != Freq.FP && prevBalizaDistance + 3 < dist)
            {
                Freq f = prevBalizaAspect;
                prevBalizaAspect = Freq.FP;
                return f;
            }
            if (dist<5 && dist>0)
            {
                prevBalizaDistance = dist;
                prevBalizaAspect = GetBalizaAspect();
            }
            else
            {
                prevBalizaAspect = Freq.FP;
            }
            if (dist<0.3 && dist>0)
            {
                return prevBalizaAspect;
            }
            return Freq.FP;
        }
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = new List<Parameter>();
            
            Parameter p;
            
            p = new Parameter("asfa::emergency");
            p.SetValue = (string val) => {Emergency = val!="0" && val!="false";};
            l.Add(p);
            
            p = new Parameter("asfa::frecuencia");
            p.GetValue = () => Baliza().ToString();
            l.Add(p);
            
            return l;
        }
        bool SignalPassed = false;
        float PreviousSignalDistanceM = 0;
        bool PreviaPassed = false;
        bool LineaConvencional = true;
        float PreviaDistance = 300;
        float AnuncioDistance = 1500f;
        protected void UpdateSignalPassed()
        {
            SignalPassed = (tcs.NextSignalDistanceM(0) > PreviousSignalDistanceM+20)&&(tcs.SpeedMpS()>0.1f);
            PreviousSignalDistanceM = tcs.NextSignalDistanceM(0);
            if (SignalPassed && tcs.NextSignalAspect(0) == Aspect.None) SignalPassed = false;
        }
        protected void UpdateDistanciaPrevia()
        {
            if (SignalPassed)
            {
                if ((tcs.NextSignalAspect(0) == Aspect.Clear_2 && tcs.NextSignalSpeedLimitMpS(0) < MpS.FromKpH(165f) && tcs.NextSignalSpeedLimitMpS(0) > MpS.FromKpH(155f)) || (tcs.NextSignalAspect(0) == Aspect.Approach_1 && tcs.NextSignalSpeedLimitMpS(0) < MpS.FromKpH(35f) && tcs.NextSignalSpeedLimitMpS(0) > MpS.FromKpH(25f)))
                {
                    PreviaDistance = 0;
                }
                else
                {
                    if (LineaConvencional)
                    {
                        if (tcs.NextSignalDistanceM(0) < 100f)
                        {
                            PreviaDistance = 0f;
                        }
                        else if (tcs.NextSignalDistanceM(0) < 400f)
                        {
                            PreviaDistance = 50f;
                        }
                        else if (tcs.NextSignalDistanceM(0) < 700f)
                        {
                            PreviaDistance = 100f;
                        }
                        else
                        {
                            PreviaDistance = 300f;
                        }
                    }
                    else
                    {
                        if (tcs.NextSignalDistanceM(0) < 100f)
                        {
                            PreviaDistance = 0f;
                        }
                        else if (tcs.NextSignalDistanceM(0) < 700f)
                        {
                            PreviaDistance = 100f;
                        }
                        else if (tcs.NextSignalDistanceM(0) < 1000f)
                        {
                            PreviaDistance = 300f;
                        }
                        else
                        {
                            PreviaDistance = 500f;
                        }
                    }
                }
            }
        }
    }
    class ASFAclasico : ASFA
    {
        bool Encendido = false;
        bool Urgencia = false;
        bool RebaseAuto = false;
        bool Eficacia = false;
        bool ASFA200 = true;
        bool RecL2;
        bool Connected = false;
        int TipoTren;
        ulong RECStarted = 0;
        ulong RojoStarted = 0;
        ulong AlarmaStarted = 0;
        ulong RebaseStarted = 0;
        ulong CondStarted = 0;
        int Velocidad = 0;
        ulong Previous;
        ulong LastPConex;
        ulong BuzzEnd = 0;
        ulong poweroff = 0;
        
        const int PConex = 2;
        const int PREC = 3;
        const int PAlarma = 4;
        const int PRearme = 5;
        const int PRebase = 6;
        const int LuzFrenar = 12;
        const int LuzL2 = 13;
        const int LuzRojo = 14;
        const int LuzVL = 15;
        const int LuzCV = 16;
        const int LuzEficacia = 17;
        const int LuzREC = 18;
        const int LuzAlarma = 19;
        const int LuzRearme = 20;
        const int LuzRebase = 21;
        
        Freq prev_freq;
        Freq freq;
        
        void buzz(ulong time)
        {
            if (time == 500) tcs.TriggerSoundInfo1();
            else tcs.TriggerSoundPenalty1();
            BuzzEnd = millis() + time;
        }
        void nobuzz()
        {
            tcs.TriggerSoundPenalty2();
        }
        ulong millis()
        {
            return (ulong)(tcs.ClockTime()*1000);
        }
        int HIGH = 1;
        int LOW = 0;
        int[] estados_luces = new int[12];
        int[] estados_botones = new int[12];
        void digitalWrite(int pin, int value)
        {
            estados_luces[pin-12] = value;
            tcs.SetCabDisplayControl(pin, value);
            if(estados_luces[LuzRojo-12]==1) tcs.SetNextSignalAspect(Aspect.Stop);
            else if(estados_luces[LuzFrenar-12]==1) tcs.SetNextSignalAspect(Aspect.Approach_1);
            else if(estados_luces[LuzVL-12]==1) tcs.SetNextSignalAspect(Aspect.Clear_1);
            else tcs.SetNextSignalAspect(Aspect.Clear_2);
            tcs.SetCabDisplayControl(PREC, estados_luces[LuzREC-12]);
            tcs.SetCabDisplayControl(PAlarma, estados_luces[LuzAlarma-12]);
            tcs.SetCabDisplayControl(PRearme, estados_luces[LuzRearme-12]);
            tcs.SetCabDisplayControl(PRebase, estados_luces[LuzRebase-12]);
        }
        int digitalRead(int pin)
        {
            return 1-estados_botones[pin];
        }
        public ASFAclasico(ServerTCS tcs) : base(tcs)
        {
        }
        public override void Initialize()
        {
            estados_botones[PConex] = 0;
            tcs.SetCustomizedCabviewControlName(0, "Genérico ASFA 1");
            tcs.SetCustomizedCabviewControlName(1, "Genérico ASFA 2");
            tcs.SetCustomizedCabviewControlName(2, "Conexión ASFA");
            tcs.SetCustomizedCabviewControlName(3, "REC ASFA");
            tcs.SetCustomizedCabviewControlName(4, "Alarma ASFA");
            tcs.SetCustomizedCabviewControlName(5, "Rearme ASFA");
            tcs.SetCustomizedCabviewControlName(6, "Rebase ASFA");
            ASFA200 = tcs.GetIntParameter("ASFA", "TipoTren", 200) > 160;
        }
        public override void Update()
        {
            base.Update();
            tcs.SetCabDisplayControl(PConex, Encendido ? 1 : 0);
            Velocidad = (int)MpS.ToKpH(tcs.SpeedMpS());
            freq = Baliza();
            if(digitalRead(PConex)==LOW && !Encendido) start();
            if(digitalRead(PConex)==HIGH&&digitalRead(PRebase)==HIGH)
            {
                if(Encendido && poweroff == 0) poweroff = millis();
            }
            else poweroff = 0;
            if(poweroff != 0 && poweroff<millis()) shutdown();
            if(Encendido)
            {
                if(RebaseStarted==0&&digitalRead(PRebase)==LOW)
                {
                    RebaseStarted = millis();
                    RebaseAuto = true;
                    digitalWrite(LuzRebase, HIGH);
                }
                if(digitalRead(PRebase)==HIGH)
                {
                    RebaseStarted = 0;
                    digitalWrite(LuzRebase, LOW);
                }
                if(RebaseStarted+10000<millis())
                {
                    RebaseAuto = false;
                    digitalWrite(LuzRebase, LOW);
                }
                if(BuzzEnd!=0 && BuzzEnd<millis())
                {
                    BuzzEnd = 0;
                    nobuzz();
                }
                if(prev_freq!=freq)
                {
                    if(ASFA200 && freq != Freq.FP)
                    {
                        CondStarted = 0;
                        RecL2 = false;
                    }
                    switch(freq)
                    {
                        case Freq.L1:
                            buzz(3000);
                            RECStarted = millis();
                            break;
                        case Freq.L2:
                            if(ASFA200)
                            {
                                buzz(3000);
                                CondStarted = millis();
                                digitalWrite(LuzREC, HIGH);
                            }
                            else buzz(500);
                            break;
                        case Freq.L3:
                            buzz(500);
                            break;
                        case Freq.L7:
                        {
                            int Vmax = 60;
                            if(TipoTren == 110) Vmax = 60;
                            if(TipoTren == 90) Vmax = 50;
                            if(TipoTren == 70) Vmax = 35;
                            if(Velocidad>Vmax)
                            {
                            Urgencia = true;
                            buzz(5000);
                            digitalWrite(LuzRojo, HIGH);
                            }
                            else
                            {
                            buzz(3000);
                            RojoStarted = millis();
                            }
                        }
                        break;
                        case Freq.L8:
                            if(!RebaseAuto)
                            {
                                Urgencia = true;
                                buzz(5000);
                                digitalWrite(LuzRojo, HIGH);
                            }
                            else
                            {
                                buzz(3000);
                                RojoStarted = millis();
                            }
                            break;
                        case Freq.FP:
                            break;
                        default:
                            Eficacia = false;
                            if(AlarmaStarted==0)
                            {
                                buzz(3000);
                                AlarmaStarted = millis();
                                digitalWrite(LuzAlarma, HIGH);
                            }
                            break;
                    }
                    prev_freq = freq;
                }
                Eficacia = freq==Freq.FP;  
                digitalWrite(LuzEficacia, Eficacia ? 1 : 0);
                if(AlarmaStarted!=0)
                {
                    if(digitalRead(PAlarma)==LOW&&Eficacia)
                    {
                        nobuzz();
                        AlarmaStarted = 0;
                        digitalWrite(LuzAlarma, LOW);
                    }
                    else if(AlarmaStarted+3000<millis()) Urgencia = true;
                }
                if(RECStarted != 0)
                {
                    digitalWrite(LuzREC, HIGH);
                    digitalWrite(LuzFrenar, HIGH);
                    if(Velocidad>160 && ASFA200) Urgencia = true;
                    if(digitalRead(PREC)==LOW)
                    {
                        nobuzz();
                        digitalWrite(LuzREC, LOW);
                        digitalWrite(LuzFrenar, LOW);
                        RECStarted = 0;
                    }
                    else if(RECStarted+3000<millis())
                    {
                        Urgencia = true;
                        digitalWrite(LuzREC, LOW);
                        digitalWrite(LuzFrenar, LOW);
                        RECStarted = 0;
                    }
                }
                if(RojoStarted!=0)
                {
                    digitalWrite(LuzRojo, HIGH);
                    if(RojoStarted+10000<millis())
                    {
                        digitalWrite(LuzRojo, LOW);
                        RojoStarted = 0;
                    }
                }
                if(CondStarted!=0)
                {
                    if(digitalRead(PREC)==LOW && !RecL2)
                    {
                        nobuzz();
                        RecL2 = true;
                        digitalWrite(LuzREC, LOW);
                    }
                    if(!RecL2 && CondStarted + 3000 < millis())
                    {
                        Urgencia = true;
                        digitalWrite(LuzREC, LOW);
                    }
                    if(Velocidad>180 && CondStarted + 18000 < millis()) Urgencia = true;
                    if(Velocidad>160 && CondStarted + 30000 < millis()) Urgencia = true;
                    digitalWrite(LuzL2, (int)((millis() - CondStarted) / 500 % 2));
                }
                else digitalWrite(LuzL2, LOW);
                if(Urgencia&&Velocidad<5)
                { 
                    digitalWrite(LuzRojo, LOW);
                    if(AlarmaStarted==0)
                    {
                        digitalWrite(LuzRearme, HIGH);
                        if(digitalRead(PRearme)==LOW) Urgencia = false;
                    }
                }
                else digitalWrite(LuzRearme, LOW);
            }
            Emergency = Urgencia;
            Previous = millis();
        }
        void start()
        {   
            //Urgencia = false;
            Encendido = true;
            buzz(500);
            LastPConex = millis();
        }
        void shutdown()
        {
            freq = Freq.FP;
            RECStarted = RojoStarted = AlarmaStarted = RebaseStarted = CondStarted = 0;
            //Urgencia = false;
            Eficacia = false;
            nobuzz();
            digitalWrite(LuzREC, LOW);
            digitalWrite(LuzFrenar, LOW);
            digitalWrite(LuzRojo, LOW);
            digitalWrite(LuzAlarma, LOW);
            digitalWrite(LuzEficacia, LOW);
            digitalWrite(LuzL2, LOW);
            digitalWrite(LuzRebase, LOW);
            digitalWrite(LuzRearme, LOW);
            digitalWrite(LuzVL, LOW);
            digitalWrite(LuzCV, LOW);
            Encendido = false;
            poweroff = 0;
        }
        double LastPressed;
        int count=0;
        public override void HandleEvent(TCSEvent ev, string message)
        {
            if(ev == TCSEvent.GenericTCSButtonPressed || ev == TCSEvent.GenericTCSButtonReleased)
            {
                int num = int.Parse(message);
                bool pressed = ev == TCSEvent.GenericTCSButtonPressed;
                if (num == 0)
                {
                    estados_botones[PREC] = pressed ? 1 : 0;
                    estados_botones[PRearme] = pressed ? 1 : 0;
                    if (pressed)
                    {
                        if(LastPressed + 1 > tcs.ClockTime()) count++;
                        else count = 1;
                        if (count == 4) estados_botones[PConex] = 1-estados_botones[PConex];
                        LastPressed = tcs.ClockTime();
                    }
                }
                else if (num == 1)
                {
                    estados_botones[PAlarma] = pressed ? 1 : 0;
                    estados_botones[PRebase] = pressed ? 1 : 0;
                }
                else if ((num == PConex || num == PRebase))
                {
                    if (pressed) estados_botones[num] = 1-estados_botones[num];
                }
                else
                {
                    estados_botones[num] = pressed ? 1 : 0;
                }
            }
        }
        public override List<Parameter> GetParameters()
        {
            return new List<Parameter>();
        }
    }
    class ASFAclasicoExterno : ASFA
    {
        public ASFAclasicoExterno(ServerTCS tcs) : base(tcs)
        {
        }
        public override void Initialize()
        {
        }
        public override void Update()
        {
            base.Update();
        }
        public override void HandleEvent(TCSEvent ev, string message)
        {

        }
        public override List<Parameter> GetParameters()
        {
            return base.GetParameters();
        }
    }
    class ASFADigital : ASFA
    {
        //Combinador general
        public bool Connected;
        bool FE;
        //Transición a LZB/ERTMS
        public bool AKT = false; //Inhibir freno de urgencia
        public bool CON = true; //Conexión de ASFA
        int UltimaInfo=1;
        Aspect FallbackAspect;
        bool controldesv=false;
        bool secAA=false;
        int TargetState=0;
        int IndicadorLVI=0;
        int IndicadorPNdesp=0;
        int IndicadorPNprot=0;
        int IndicadorFrenado=0;
        bool Anun = false;
        bool Prec = false;
        bool Prean = false;
        bool Modo = false;
        bool Rearme = false;
        bool Rebase = false;
        bool Aumento = false;
        bool Alarma = false;
        bool Ocultacion = false;
        bool LTV = false;
        bool PN = false;
        bool PConex = true;
        bool Basico = false;
        bool IlumConex=false;
        bool IlumAnpar=false;
        bool IlumAnpre=false;
        bool IlumPrepar=false;
        bool IlumVLcond=false;
        bool IlumModo=false;
        bool IlumRearme=false;
        bool IlumRebase=false;
        bool IlumAumento=false;
        bool IlumAlarma=false;
        bool IlumOcult=false;
        bool IlumLVI=false;
        bool IlumPN=false;
        bool Velo=false;
        bool Eficacia=false;
        int EficaciaB=0;
        int FrenarB=0;
        int Led3B=0;
        int ModoDisplay=-1;
        int Tipo;
        int Velocidad;
        bool PantallaActiva = false;
        Timer InicioPantalla;
        public ASFADigital(ServerTCS tcs) : base(tcs)
        {
            InicioPantalla = new Timer(tcs);
            InicioPantalla.Setup(10);
        }
        public void start()
        {
            InicioPantalla.Stop();
            tcs.Register("asfa::indicador::*");
            PantallaActiva = true;
            /*Anun = false;
            Prec = false;
            Prean = false;
            Modo = false;
            Rearme = false;
            Rebase = false;
            Aumento = false;
            Alarma = false;
            Ocultacion = false;
            LTV = false;
            PN = false;
            Basico = false;
            IlumAnpar=false;
            IlumAnpre=false;
            IlumPrepar=false;
            IlumVLcond=false;
            IlumModo=false;
            IlumRearme=false;
            IlumRebase=false;
            IlumAumento=false;
            IlumAlarma=false;
            IlumOcult=false;
            IlumLVI=false;
            IlumPN=false;
            EficaciaB=0;
            FrenarB=0;
            Led3B=0;
            Connected = true;
            tcs.SetCabDisplayControl(11, 1);
            
            tcs.SendParameter("asfa::pulsador::conex", "1");*/
        }
        string div;
        string getDIV()
        {
            if (div != null) return div;
            string DIV = tcs.GetStringParameter("ASFA", "DIV", "020001162E47558A26023132333402300000C8780000957102690295000288039803E8643C328C00000000000000000000000000000000000000000000000000");
            string hex = "0123456789ABCDEF";
            System.Text.StringBuilder b = new System.Text.StringBuilder(DIV);
            int Vmax = Math.Min(tcs.GetIntParameter("ASFA","VmaxVehiculo",0),200);
            if (Vmax == 0) Vmax = Math.Min(tcs.GetIntParameter("General","TrainMaxSpeed",0),200);
            if (Vmax == 0) Vmax = Math.Min(tcs.GetIntParameter("General","MaxSpeed",0),200);
            if (Vmax > 0)
            {
                b[36] = hex[Vmax/16];
                b[37] = hex[Vmax%16];
            }
            int div15 = Convert.ToInt32(DIV.Substring(30,2),16);
            int div17 = Convert.ToInt32(DIV.Substring(34,2),16);
            int modoCONV = tcs.GetIntParameter("ASFA","ModoCONV",-1);
            int modoAV = tcs.GetIntParameter("ASFA","ModoAV",-1);
            int modoRAM = tcs.GetIntParameter("ASFA","ModoRAM",-1);
            int modoBTS = tcs.GetIntParameter("ASFA","ModoBTS",-1);
            int fase = tcs.GetIntParameter("ASFA","Fase",-1);
            if (fase != -1) div15 = (div15&(255-1))|(fase == 2 ? 1 : 0);
            if (modoCONV != -1) div15 = (div15&(255-16))|(modoCONV*16);
            if (modoAV != -1) div15 = (div15&(255-32))|(modoAV*32);
            if (modoRAM != -1) div17 = (div17&(255-4))|(modoRAM*4);
            if (modoBTS != -1) div17 = (div17&(255-8))|(modoBTS*8);
            b[30] = hex[div15/16];
            b[31] = hex[div15%16];
            b[34] = hex[div17/16];
            b[35] = hex[div17%16];
            DIV = b.ToString();
            div = DIV;
            return DIV;
        }
        void stop()
        {
            InicioPantalla.Stop();
            tcs.RemoveParameter("asfa::indicador::*");
            UltimaInfo=1;
            FallbackAspect = Aspect.Clear_2;
            controldesv=false;
            secAA=false;
            TargetState=0;
            IndicadorLVI=0;
            IndicadorPNdesp=0;
            IndicadorPNprot=0;
            IndicadorFrenado=0;
            FE = false;
            Velo = false;
            Eficacia=false;
            PantallaActiva = false;
            ModoDisplay = -1;
            Tipo = 0;
            Velocidad = 0;
            /*Connected = false;
            Emergency = false;
            
            tcs.RemoveParameter("asfa::pulsador::ilum::*");
            tcs.RemoveParameter("asfa::leds::*");
            tcs.RemoveParameter("asfa::pulsador::basico");
            
            tcs.SendParameter("asfa::pulsador::conex", "0");*/
        }
        public override void Initialize()
        {
            tcs.SetCustomizedCabviewControlName(0, "Rec. anuncio parada");
            tcs.SetCustomizedCabviewControlName(1, "Rec. anuncio precaucion");
            tcs.SetCustomizedCabviewControlName(2, "Rec. preanuncio o condicional");
            tcs.SetCustomizedCabviewControlName(3, "Modo ASFA");
            tcs.SetCustomizedCabviewControlName(4, "Rearme freno");
            tcs.SetCustomizedCabviewControlName(5, "Rebase autorizado");
            tcs.SetCustomizedCabviewControlName(6, "Aumento vel. ASFA");
            tcs.SetCustomizedCabviewControlName(7, "Rec. alarma ASFA");
            tcs.SetCustomizedCabviewControlName(8, "Ocultacion info ASFA");
            tcs.SetCustomizedCabviewControlName(9, "Rec. limitacion velocidad");
            tcs.SetCustomizedCabviewControlName(10, "Rec. paso a nivel");
            tcs.SetCustomizedCabviewControlName(11, "Conexión ASFA");
            tcs.SetCustomizedCabviewControlName(12, "Conmutador ASFA básico");
        }
        public override void Update()
        {
            base.Update();
            if (InicioPantalla.Triggered) start();
            tcs.SetCabDisplayControl(0, IlumAnpar ? 1 : 0);
            tcs.SetCabDisplayControl(1, IlumAnpre ? 1 : 0);
            tcs.SetCabDisplayControl(2, IlumVLcond ? (IlumPrepar ? 3 : 2) : (IlumPrepar ? 1 : 0));
            tcs.SetCabDisplayControl(3, IlumModo ? 1 : 0);
            tcs.SetCabDisplayControl(4, IlumRearme ? 1 : 0);
            tcs.SetCabDisplayControl(5, IlumRebase ? 1 : 0);
            tcs.SetCabDisplayControl(6, IlumAumento ? 1 : 0);
            tcs.SetCabDisplayControl(7, IlumAlarma ? 1 : 0);
            tcs.SetCabDisplayControl(8, IlumOcult ? 1 : 0);
            tcs.SetCabDisplayControl(9, IlumLVI ? 1 : 0);
            tcs.SetCabDisplayControl(10, IlumPN ? 1 : 0);
            tcs.SetCabDisplayControl(11, PConex ? 1 : (IlumConex ? 0 : 2));
            tcs.SetCabDisplayControl(12, Basico ? 1 : 0);
            if (UltimaInfo == 8 && ((int)(tcs.ClockTime()*2))%2 == 1) tcs.SetCabDisplayControl(15, 0);
            else tcs.SetCabDisplayControl(15, UltimaInfo);
            tcs.SetCabDisplayControl(16, IndicadorPNdesp != 0 ? 2 : (IndicadorPNprot != 0 ? 1 : 0));
            tcs.SetCabDisplayControl(17, controldesv ? 2 : (secAA ? 5 : 0));
            tcs.SetCabDisplayControl(18, IndicadorLVI);
            tcs.SetCabDisplayControl(20, TargetState == 0 ? 2 : (TargetState == 1 ? 0 : 1));
            tcs.SetCabDisplayControl(21, FE ? 3 : IndicadorFrenado);
            tcs.SetCabDisplayControl(22, EficaciaB);
            tcs.SetCabDisplayControl(23, FrenarB);
            tcs.SetCabDisplayControl(24, Led3B);
            tcs.SetCabDisplayControl(25, PantallaActiva ? (ModoDisplay == 5 ? 3 : (Velo ? 2 : 1)) : 0);
            tcs.SetCabDisplayControl(26, Eficacia ? (((int)(tcs.ClockTime()*2))%8 + 1) : 0);
            tcs.SetCabDisplayControl(27, ModoDisplay + 1);
            tcs.SetCabDisplayControl(28, Tipo);
            tcs.SetCabDisplayControl(29, Velocidad);
            tcs.SetNextSignalAspect(FallbackAspect);
            //tcs.SetOverspeedWarningDisplay(IndicadorFrenado != 0 ? true : false);
            //tcs.SetPenaltyApplicationDisplay(Emergency);
        }
        public override void HandleEvent(TCSEvent ev, string message)
        {
            if(ev == TCSEvent.GenericTCSButtonPressed || ev == TCSEvent.GenericTCSButtonReleased)
            {
                int num = int.Parse(message);
                bool pressed = ev == TCSEvent.GenericTCSButtonPressed;
                if (num == 11 && pressed) PConex = !PConex;
                else if (num == 12 && pressed) Basico = !Basico;
                else if(num==0) Anun = pressed;
                else if(num==1) Prec = pressed;
                else if(num==2) Prean = pressed;
                else if(num==3) Modo = pressed;
                else if(num==4) Rearme = pressed;
                else if(num==5) Rebase = pressed;
                else if(num==6) Aumento = pressed;
                else if(num==7) Alarma = pressed;
                else if(num==8) Ocultacion = pressed;
                else if(num==9) LTV = pressed;
                else if(num==10) PN = pressed;
            }
        }
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = base.GetParameters();
            /*if(p.name=="asfa_sound_trigger")
            {
                p.SetValue = (string val) => 
                {
                    int num = int.Parse(val);
                    if(num == 0) tcs.TriggerSoundInfo1();
                    if(num == 1) tcs.TriggerSoundPenalty1();
                    if(num == 2) tcs.TriggerSoundAlert1();
                    if(num == 3) tcs.TriggerSoundAlert2();
                    if(num == 9) tcs.TriggerSoundSystemDeactivate();
                };
                return true;
            }
            else */
            Parameter p = null;
            
            p = new Parameter("asfa::div");
            p.GetValue = () => getDIV();
            l.Add(p);
            
            p = new Parameter("asfa::indicador::v_control");
            p.SetValue = (string val) => tcs.SetNextSpeedLimitMpS(MpS.FromKpH(float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat)));
            l.Add(p);
            
            p = new Parameter("asfa::indicador::velocidad");
            p.SetValue = (string val) => tcs.SetCabDisplayControl(30, int.Parse(val));
            l.Add(p);
            
            p = new Parameter("asfa::indicador::estado_vcontrol");
            p.SetValue = (string val) => TargetState = int.Parse(val);
            l.Add(p);
            
            
            p = new Parameter("asfa::indicador::ultima_info");
            p.SetValue = (string val) => {
                int num = int.Parse(val)/2;
                UltimaInfo = num;
                switch(num)
                {
                    case 2:
                        FallbackAspect = Aspect.Stop;
                        break;
                    case 3:
                        FallbackAspect = Aspect.StopAndProceed;
                        break;
                    case 4:
                        FallbackAspect = Aspect.Approach_1;
                        break;
                    case 5:
                        FallbackAspect = Aspect.Approach_2;
                        break;
                    case 6:
                        FallbackAspect = Aspect.Approach_3;
                        break;
                    case 7:
                        FallbackAspect = Aspect.Approach_3;
                        break;
                    case 8:
                        FallbackAspect = Aspect.Clear_1;
                        break;
                    default:
                        FallbackAspect = Aspect.Clear_2;
                        break;
                }
            };
            l.Add(p);
            
            p = new Parameter("asfa::indicador::control_desvio");
            p.SetValue = (string val) => controldesv = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::indicador::secuencia_aa");
            p.SetValue = (string val) => secAA = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::indicador::lvi");
            p.SetValue = (string val) => IndicadorLVI = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfa::indicador::pndesp");
            p.SetValue = (string val) => IndicadorPNdesp = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfa::indicador::pnprot");
            p.SetValue = (string val) => IndicadorPNprot = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfa::indicador::frenado");
            p.SetValue = (string val) => IndicadorFrenado = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfa::indicador::urgencia");
            p.SetValue = (string val) => FE = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::indicador::eficacia");
            p.SetValue = (string val) => Eficacia = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::indicador::velo");
            p.SetValue = (string val) => Velo = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::indicador::modo");
            p.SetValue = (string val) => ModoDisplay = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfa::indicador::tipo_tren");
            p.SetValue = (string val) => {
                int T=0;
                if (int.TryParse(val, out T))
                {
                    if (T > 0 && T<130) T = T/10-4;
                    else if (T>130) T = T/20+2;
                }
                else if (val == "CONV") T = 13;
                else if (val == "AV") T = 14;
                else if (val == "RAM") T = 15;
                Tipo = T;
            };
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::anpar");
            p.GetValue = () => Anun ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::anpre");
            p.GetValue = () => Prec ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::prepar");
            p.GetValue = () => Prean ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::modo");
            p.GetValue = () => Modo ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::rearme");
            p.GetValue = () => Rearme ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::rebase");
            p.GetValue = () => Rebase ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::aumento");
            p.GetValue = () => Aumento ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::alarma");
            p.GetValue = () => Alarma ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ocultacion");
            p.GetValue = () => Ocultacion ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::lvi");
            p.GetValue = () => LTV ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::pn");
            p.GetValue = () => PN ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::basico");
            p.GetValue = () => Basico ? "1" : "0";
            p.SetValue = (string val) => Basico = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::conex");
            p.SetValue = (string val) => PConex = val=="1";
            p.GetValue = () => PConex ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::alimentado");
            p.GetValue = () => tcs.IsCabPowerSupplyOn() ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::conex");
            p.SetValue = (string val) => IlumConex = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::anpar");
            p.SetValue = (string val) => IlumAnpar = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::anpre");
            p.SetValue = (string val) => IlumAnpre = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::prepar");
            p.SetValue = (string val) => IlumPrepar = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::vlcond");
            p.SetValue = (string val) => IlumVLcond = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::modo");
            p.SetValue = (string val) => IlumModo = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::rearme");
            p.SetValue = (string val) => IlumRearme = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::rebase");
            p.SetValue = (string val) => IlumRebase = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::aumento");
            p.SetValue = (string val) => IlumAumento = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::alarma");
            p.SetValue = (string val) => IlumAlarma = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::ocultacion");
            p.SetValue = (string val) => IlumOcult = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::lvi");
            p.SetValue = (string val) => IlumLVI = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::pulsador::ilum::pn");
            p.SetValue = (string val) => IlumPN = val== "1";
            l.Add(p);
            
            p = new Parameter("asfa::leds::0");
            p.SetValue = (string val) => EficaciaB = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfa::leds::1");
            p.SetValue = (string val) => FrenarB = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfa::leds::2");
            p.SetValue = (string val) => Led3B = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfa::pantalla::activa");
            p.SetValue = (string val) => {if (val== "1") start();};
            l.Add(p);
            
            p = new Parameter("asfa::pantalla::habilitada");
            p.SetValue = (string val) => {if (val== "1") InicioPantalla.Start(); else stop();};
            l.Add(p);
            
            return l;
        }
    }
}
