//#define USE_ATO
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Globalization;
using System.IO;
using System.IO.Ports;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using Orts.Common;
using Event = Orts.Common.Event;
using Orts.Simulation.Signalling;
using Orts.Simulation;
using Orts.Simulation.RollingStocks;
using Orts.Simulation.RollingStocks.SubSystems;
using ORTS.Common;
using ORTS.Scripting.Api;
using ORTS.Scripting.Api.ETCS;
namespace ORTS.Scripting.Script
{
    public class ServerTCS : TrainControlSystem
    {
        public Client c=null;
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        List<InteractiveTCS> tcs = new List<InteractiveTCS>();
        ControlVehiculo Control;
        public ATO ATO;
        public static Random Random = new Random();
        public ServerTCS()
        {
            Control = new ControlVehiculo(this);
        }
        public void RequestModule(string module)
        {
            if (c != null) c.WriteLine("request_module("+module+")");
        }
        public void Register(string parameter)
        {
            if (c != null) c.WriteLine("register("+parameter+")");
        }
        public void RemoveParameter(string parameter)
        {
            if (c != null) c.WriteLine("unregister("+parameter+")");
        }
        public void SendParameter(string parameter, string value)
        {
            if (c != null) c.WriteLine(parameter+"="+value);
        }
        Parameter GetParameter(string parameter)
        {
            Parameter compared = new Parameter(parameter);
            Parameter p = null;
            parameters.TryGetValue(compared, out p);
            return p;
        }
        public override void Initialize()
        {
            Activated = false;
            tcs.Add(new HM(this));
            if(GetBoolParameter("ASFA","Digital",false)) tcs.Add(new ASFADigital(this));
            else if (GetBoolParameter("General", "ASFA", true)) tcs.Add(new ASFAclasico(this));
            tcs.Add(new ETCS(this));
            if (GetBoolParameter("DASS", "Instalado", false)) tcs.Add(new DASS(this));
            if (GetBoolParameter("General","LZB",false)) tcs.Add(new LZB(this));
            if (GetBoolParameter("General","Ebicab",false)) tcs.Add(new EBICAB900(this));

            Serie = GetIntParameter("General", "Serie", 0);
            Subserie = GetStringParameter("General", "Subserie", "").Trim('\0');


            bool ato = Serie == 102 || Serie == 103 || Serie == 106 || Serie == 107 || Serie == 112 || Serie == 130 || Serie == 252 || Serie == 446 || Serie == 730;
            ato = GetBoolParameter("General", "ATO", ato);
            if (ato) ATO = new ATO(this);

            CloseCircuitBreakerTimer = new Timer(this);
            CloseCircuitBreakerTimer.Setup(6.0f);
            OpenCircuitBreakerTimer = new Timer(this);
            OpenCircuitBreakerTimer.Setup(6.0f);
            
            Control.Initialize();

            foreach(InteractiveTCS i in tcs)
            {
                i.Activated = true;
                i.Initialize();
            }
            ATO?.Initialize();
        }
        void InitializeValues()
        {
            foreach(InteractiveTCS i in tcs)
            {
                foreach (var param in i.GetParameters())
                {
                    if (parameters.TryGetValue(param, out var p2))
                    {
                        p2.SetValue += param.SetValue;
                        if (p2.GetValue == null) p2.GetValue = param.GetValue;
                    }
                    else parameters.Add(param);
                }
            }
            
            Parameter p = null;
            p = new Parameter("speed");
            p.GetValue = () => MpS.ToKpH(SpeedMpS()).ToString().Replace(',','.');
            parameters.Add(p);

            /*p = new Parameter("cruise_speed");
            p.GetValue = () => MpS.ToKpH(SetSpeedMpS ?? 0).ToString().Replace(',','.');
            parameters.Add(p);*/
            
            p = new Parameter("distance");
            p.GetValue = () => SignedDistanceM().ToString().Replace(',','.');
            //p.GetValue = () => Locomotive().Train.DistanceTravelledM.ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("train_orientation");
            p.GetValue = () => (IsFlipped() || IsRearCab() ? "-1" : "1").ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("acceleration");
            p.GetValue = () => AccelerationMpSS().ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("train_length");
            p.GetValue = () => ((int)TrainLengthM()).ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("master_key");
            p.GetValue = () => IsCabPowerSupplyOn() && IsLowVoltagePowerSupplyOn() ? "1" : "0";
            parameters.Add(p);
            
            p = new Parameter("controller::direction");
            p.GetValue = () => CurrentDirection() == Direction.Forward ? "1" : (CurrentDirection() == Direction.Reverse ? "-1" : "0");
            parameters.Add(p);
            
            p = new Parameter("current_cab");
            p.GetValue = () => (IsRearCab() && ((Serie >= 200 && Serie < 400) || (Serie >= 600 && Serie < 700))) ? "1" : "0";
            parameters.Add(p);
            
            p = new Parameter("simulator_time");
            p.GetValue = () => ClockTime().ToString().Replace(',','.');
            parameters.Add(p);
            
            p = new Parameter("serie");
            p.GetValue = () => Serie.ToString()+Subserie;
            parameters.Add(p);
        }
        bool ServerAvailable = true;
        int UpdateCount=0;
        public override void Update()
        {
            if(!IsTrainControlEnabled())
            {
                if (c!=null)
                {
                    foreach(Parameter p in parameters)
                    {
                        p.RemoveClient(c);
                    }
                    c.Stop();
                    c = null;
                }
                return;
            }
            if (UpdateCount<4)
            {
                UpdateCount++;
                return;
            }
            if (UpdateCount == 4)
            {
                InitializeValues();
                UpdateCount++;
            }
            if(c==null && ServerAvailable)
            {
                try{
                    TcpClient cl = new TcpClient();
                    cl.Connect("127.0.0.1", 5090);
                    c = new TCPClient(cl);
                } catch(Exception e)
                {
                    ServerAvailable = false;
                    c = null;
                    return;
                }
                c.WriteLine("register(hm::pressed)");
                c.WriteLine("register(+::emergency)");
                c.WriteLine("register(+::fullbrake)");
                c.WriteLine("register(+::tractioncutoff)");
                c.WriteLine("register(etcs::obu_tr)");
                c.WriteLine("register(etcs::dmi::command)");
                c.WriteLine("register(etcs::asc)");
                c.WriteLine("register(etcs::button::ack::light)");
                c.WriteLine("register(stm::command_etcs)");
                
                Register("asfad::pulsador::ilum::*");
                Register("asfad::pulsador::basico");
                Register("asfad::pulsador::conex");
                Register("asfad::leds::*");
                Register("asfad::pantalla::habilitada");
                Register("asfad::pantalla::activa");
                
                Register("asfa::akt::*");
                Register("asfa::con::*");

                Register("asfa::pulsador::*");
                Register("asfa::llave");
            }
            if (c != null)
            {
                string s = c.ReadLine();
                while(s!=null)
                {
                    if(s.StartsWith("register(") || s.StartsWith("get("))
                    {
                        int div = s.IndexOf('(');
                        int fin = s.LastIndexOf(')');
                        if(div<=0 || fin<=0)
                        {
                            s = c.ReadLine();
                            continue;
                        }
                        string fun = s.Substring(0, div);
                        string param = s.Substring(div+1, fin-div-1);
                        foreach (Parameter p in parameters)
                        {
                            if(p!=null && p.GetValue!=null && p.Matches(param))
                            {
                                if(fun == "register")
                                {
                                    Register r;
                                    if (p.name == "speed" || p.name == "simulator_time" || p.name == "cruise_speed") r = new NumericRegister(0.2f);
                                    //else if (p.name == "lzb::zielentfernung") r = new NumericRegister(5.0f);
                                    else if (p.name == "acceleration") r = new NumericRegister(0.05f);
                                    else if (p.name == "distance") r = new NumericRegister(0.5f);
                                    else r = new DiscreteRegister(false);
                                    p.registers[r] = c;
                                }
                                else c.WriteLine(p.name + '=' + p.GetValue());
                            }
                        }
                    }
                    else if(s.Contains('='))
                    {
                        int pos = s.IndexOf('=');
                        string param = s.Substring(0, pos);
                        string val = s.Substring(pos+1);
                        if(param != "connected") 
                        {
                            Parameter ps = GetParameter(param);
                            if(ps != null && ps.SetValue!=null) ps.SetValue(val);
                        }
                    }
                    s = c.ReadLine();
                }
                foreach(Parameter p in parameters)
                {
                    p.Send();
                }
            }
            if (GetControlMode() == TRAIN_CONTROL.OUT_OF_CONTROL) ResetOutOfControlMode();
            foreach(InteractiveTCS i in tcs)
            {
                i.Update();
            }
            ATO?.Update();
            bool emergency = false;
            bool fullBrake = false;
            bool tco = false;
            bool power = true;
            foreach(InteractiveTCS i in tcs)
            {
                if(i.Emergency) emergency = true;
                if(i.FullBrake) fullBrake = true;
                if(i.TCO) tco = true;
                if(!i.PowerAuthorization) power = false;
            }
            bool seta = TrainBrakeControllerState() == ControllerState.EBPB;
            if (TrainBrakeControllerState() != ControllerState.Emergency && TrainBrakeControllerState() != ControllerState.TCSEmergency && IsBrakeEmergency() && !emergency) seta = true;
            Control.Update(emergency, fullBrake, tco, power, seta);
            UpdateZonaNeutra();
        }
        public int Serie;
        public string Subserie;
        Timer CloseCircuitBreakerTimer;
        Timer OpenCircuitBreakerTimer;
        public bool Disyuntor;
        public bool NeutralSectionHandledByPowerSupply;
        public float NeutralSectionDelayM()
        {
            if (NeutralSectionHandledByPowerSupply) return 0;
            if (Serie >= 200 && Serie <= 300) return Math.Min(20, Math.Max(TrainLengthM() - 5, 0));
            return Math.Max(TrainLengthM() - 5, 0);

        }
        void UpdateZonaNeutra()
        {
            if (ArePantographsDown())
            {
                if (OpenCircuitBreakerTimer.Started || CloseCircuitBreakerTimer.Started)
                {
                    if (NeutralSectionHandledByPowerSupply)
                    {
                        SignalEventToPowerSupply(PowerSupplyEvent.OpenCircuitBreaker, 10000);
                        SignalEventToPowerSupply(PowerSupplyEvent.CloseCircuitBreaker, 10000);
                    }
                    else
                    {
                        SetCircuitBreakerOpeningOrder(false);
                        SetCircuitBreakerClosingOrder(false);
                    }
                    CloseCircuitBreakerTimer.Stop();
                    OpenCircuitBreakerTimer.Stop();
                }
                return;
            }
            List<(double?,double?)> dists = new List<(double?,double?)>();
            foreach (var t in tcs)
            {
                if (t.NeutralSection == null) continue;
                if (t.NeutralSection.Active) dists.Add((-10000,10000));
                dists.AddRange(t.NeutralSection.DistancesM);
            }

            double? StartNeutralSectionDistanceM=double.MaxValue;
            double? EndNeutralSectionDistanceM=double.MaxValue;
            foreach (var dist in dists)
            {
                if (dist.Item1 == null && dist.Item2 == null) continue;
                if (dist.Item1 == null)
                {
                    StartNeutralSectionDistanceM = double.MinValue;
                }
                else if (dist.Item1 < StartNeutralSectionDistanceM)
                {
                    if (StartNeutralSectionDistanceM > dist.Item2) EndNeutralSectionDistanceM = dist.Item2.Value;
                    StartNeutralSectionDistanceM = dist.Item1.Value;
                }
                else if (dist.Item1 < EndNeutralSectionDistanceM && dist.Item2 > EndNeutralSectionDistanceM)
                {
                    EndNeutralSectionDistanceM = dist.Item2.Value;
                }
            }

            if (NeutralSectionHandledByPowerSupply) SignalEventToPowerSupply(PowerSupplyEvent.OpenCircuitBreaker, Math.Max((int)StartNeutralSectionDistanceM, 10000));
            if (NeutralSectionHandledByPowerSupply) SignalEventToPowerSupply(PowerSupplyEvent.CloseCircuitBreaker, Math.Max((int)EndNeutralSectionDistanceM, -10000));

            bool cierreAutomatico = Serie != 100 && Serie != 101;
            if (StartNeutralSectionDistanceM < SpeedMpS() * 11 && EndNeutralSectionDistanceM > -NeutralSectionDelayM())
            {
                if (!OpenCircuitBreakerTimer.Started)
                {
                    OpenCircuitBreakerTimer.Start();
                    if (NeutralSectionHandledByPowerSupply) SignalEventToPowerSupply(PowerSupplyEvent.OpenCircuitBreaker);
                }
            }
            else
            {
                if (OpenCircuitBreakerTimer.Started && !CloseCircuitBreakerTimer.Started && cierreAutomatico)
                {
                    OpenCircuitBreakerTimer.Stop();
                    CloseCircuitBreakerTimer.Start();
                    if (NeutralSectionHandledByPowerSupply) SignalEventToPowerSupply(PowerSupplyEvent.CloseCircuitBreaker);
                }
                else
                {
                    if (CloseCircuitBreakerTimer.Triggered) CloseCircuitBreakerTimer.Stop();
                    if (OpenCircuitBreakerTimer.Started) OpenCircuitBreakerTimer.Stop();
                }
            }

            if (!NeutralSectionHandledByPowerSupply)
            {
                SetCircuitBreakerOpeningOrder(OpenCircuitBreakerTimer.Started && !OpenCircuitBreakerTimer.Triggered);
                if (cierreAutomatico) SetCircuitBreakerClosingOrder(CloseCircuitBreakerTimer.Started && !CloseCircuitBreakerTimer.Triggered);
            }
        }
        bool pantosDown;
        bool PantographDownHandledByPowerSupply;
        void UpdatePantographDownSection()
        {
            List<(double?,double?)> dists = new List<(double?,double?)>();
            foreach (var t in tcs)
            {
                if (t.LowerPantographSection == null) continue;
                if (t.LowerPantographSection.Active) dists.Add((-10000,10000));
                else dists.Add((-10000, 10000));
                dists.AddRange(t.LowerPantographSection.DistancesM);
            }

            double StartNeutralSectionDistanceM=double.MaxValue;
            double EndNeutralSectionDistanceM=double.MinValue;
            foreach (var dist in dists)
            {
                if (dist.Item1 < StartNeutralSectionDistanceM)
                {
                    if (StartNeutralSectionDistanceM > dist.Item2) EndNeutralSectionDistanceM = dist.Item2.Value;
                    StartNeutralSectionDistanceM = dist.Item1.Value;
                }
                else if (dist.Item1 < EndNeutralSectionDistanceM)
                {
                    EndNeutralSectionDistanceM = dist.Item2.Value;
                }
            }

            if (PantographDownHandledByPowerSupply) SignalEventToPowerSupply(PowerSupplyEvent.LowerPantograph, Math.Max((int)StartNeutralSectionDistanceM, 10000));
            if (PantographDownHandledByPowerSupply) SignalEventToPowerSupply(PowerSupplyEvent.RaisePantograph, Math.Max((int)EndNeutralSectionDistanceM, -10000));

            bool start = StartNeutralSectionDistanceM < SpeedMpS() * 20;
            bool end = EndNeutralSectionDistanceM < -TrainLengthM() && EndNeutralSectionDistanceM > -50000;

            if (start && !end && !pantosDown)
            {
                pantosDown = true;
                if (PantographDownHandledByPowerSupply) SignalEventToPowerSupply(PowerSupplyEvent.LowerPantograph);
                else SetPantographsDown();
            }
            bool cierreAutomatico = true;
            if (end && pantosDown && cierreAutomatico)
            {
                pantosDown = false;
                if (PantographDownHandledByPowerSupply) SignalEventToPowerSupply(PowerSupplyEvent.RaisePantograph);
            }
            else
            {
                if (!start || end) pantosDown = false;
            }
        }
        public override void HandleEvent(TCSEvent evt, string message) 
        {
            switch (evt)
            {
                case TCSEvent.CircuitBreakerOpen:
                    Disyuntor = false;
                    break;
                case TCSEvent.CircuitBreakerClosed:
                    Disyuntor = true;
                    break;
            }
            foreach(InteractiveTCS e in tcs)
            {
                e.HandleEvent(evt, message);
            }
            Control.HandleEvent(evt, message);
        }
        public override void HandleEvent(PowerSupplyEvent evt, string message)
        {
            switch (evt)
            {
                case PowerSupplyEvent.OpenCircuitBreakerButtonPressed:
                    OpenCircuitBreakerTimer.Stop();
                    CloseCircuitBreakerTimer.Stop();
                    break;
                case PowerSupplyEvent.OpenCircuitBreaker:
                    if (message == "AUTOMATIC_NEUTRAL_SECTION") NeutralSectionHandledByPowerSupply = true;
                    break;
                case PowerSupplyEvent.LowerPantograph:
                    if (message == "AUTOMATIC_LOWER_PANTOGRAPH") PantographDownHandledByPowerSupply = true;
                    break;
            }
        }
    }

    public class ControlVehiculo
    {
        ServerTCS tcs;
        protected int Serie => tcs.Serie;
        protected string Subserie => tcs.Subserie;

        protected float AvisoSobreVelocidadMpS=float.MaxValue;
        protected float CorteTraccionSobreVelocidadMpS=float.MaxValue;
        protected float UrgenciaSobreVelocidadMpS=float.MaxValue;
        protected bool LazoPuertas;
        protected bool EmergencyNeutral = false;
        protected bool SetaAbreDisyuntor;
        protected bool EmergenciaAbreDisyuntor;
        protected bool SetaBajaPantografos;
        protected bool EmergenciaCortaFrenoElectrico;

        protected Timer ByPassLazoFreno;
        protected int ControlBypassFreno;
        protected Timer ByPassLazoPuertas;
        protected int ControlBypassPuertas;
        protected Timer AnulacionAlarmas;
        protected int ControlAnulacionAlarmas;

        bool AlarmaViajeros = false;

        private bool prevNeutral = false;
        private bool prevTCO=false;
        public ControlVehiculo(ServerTCS tcs)
        {
            this.tcs = tcs;
        }
        public virtual void Initialize()
        {
            if (Serie == 446)
            {
                AvisoSobreVelocidadMpS = CorteTraccionSobreVelocidadMpS = MpS.FromKpH(107);
                UrgenciaSobreVelocidadMpS = MpS.FromKpH(113);
            }
            else if (Serie == 447)
            {
                AvisoSobreVelocidadMpS = CorteTraccionSobreVelocidadMpS = MpS.FromKpH(125);
                UrgenciaSobreVelocidadMpS = MpS.FromKpH(130);
            }
            {
                int tmp = tcs.GetIntParameter("General", "Sobrevelocidad", -1);
                if (tmp > 0) AvisoSobreVelocidadMpS = MpS.FromKpH(tmp);
                tmp = tcs.GetIntParameter("General", "SobrevelocidadCorteTraccion", -1);
                if (tmp > 0) CorteTraccionSobreVelocidadMpS = MpS.FromKpH(tmp);
                tmp = tcs.GetIntParameter("General", "SobrevelocidadUrgencia", -1);
                if (tmp > 0) UrgenciaSobreVelocidadMpS = MpS.FromKpH(tmp);
            }
            LazoPuertas = tcs.GetBoolParameter("General", "LazoPuertas", false);

            EmergencyNeutral = (Serie >= 446 && Serie <= 451) || Serie == 440 || Serie == 470 || Serie == 104 ||Serie == 114 || Serie == 120 || Serie == 599 || Serie == 598 || Serie == 594 || Serie == 444 || Serie == 448 || Serie == 432 || Serie == 445 || Serie == 269 || Serie == 121 || Serie == 120 || Serie == 105  || Serie == 601 || (Serie >= 462 && Serie <= 465);
            EmergencyNeutral = tcs.GetBoolParameter("General", "EmergencyNeutral", EmergencyNeutral);

            EmergenciaAbreDisyuntor = Serie == 100 || Serie == 101 || Serie == 108 || Serie == 256 || Serie == 006;
            SetaAbreDisyuntor = Serie == 100 || Serie == 101 || Serie == 108 || Serie == 102 || Serie == 103 || Serie == 112 || Serie == 130 || Serie == 730 || Serie == 256 || Serie == 006;
            SetaBajaPantografos = Serie == 102 || Serie == 112 || Serie == 103 || Serie == 130 || Serie == 730 || Serie == 109;
            EmergenciaCortaFrenoElectrico = Serie != 130;

            ByPassLazoFreno = new Timer(tcs);
            ByPassLazoFreno.Setup(float.MaxValue);
            ByPassLazoPuertas = new Timer(tcs);
            ByPassLazoPuertas.Setup(float.MaxValue);
            AnulacionAlarmas = new Timer(tcs);
            AnulacionAlarmas.Setup(30);
        }
        public virtual void Update(bool emergency, bool fullBrake, bool tco, bool power, bool seta)
        {
            if (ByPassLazoFreno.Triggered) ByPassLazoFreno.Stop();
            if (ByPassLazoPuertas.Triggered) ByPassLazoPuertas.Stop();
            if (AnulacionAlarmas.Triggered) AnulacionAlarmas.Stop();

            if (Serie == 445 || Serie == 446 || Serie == 447 || Serie == 450 || Serie == 451 || Serie == 463 || Serie == 464 || Serie == 465)
            {
                if (AlarmaViajeros && tcs.SpeedMpS() < 1) AlarmaViajeros = false;
                if (ServerTCS.Random.Next(1000000) == 1)
                {
                    AlarmaViajeros = true;
                    tcs.Message(ConfirmLevel.Warning, "Tirador de alarma sala de viajeros");
                }
            }

            UpdateLazoTraccion(tco);
            UpdateLazoFreno(emergency);
            //tcs.SetDynamicBrakeAuthorization(!EmergenciaCortaFrenoElectrico || !tcs.IsBrakeEmergency());
            tcs.SetPowerAuthorization(power && !((seta && SetaAbreDisyuntor) || (emergency && EmergenciaAbreDisyuntor)));
            if (seta && SetaBajaPantografos) tcs.SetPantographsDown();
            tcs.SetHorn(seta && ((( Serie == 449 || Serie == 599 || Serie == 598 ) && (tcs.SpeedMpS() > MpS.FromKpH(20)) || (( Serie == 106 || Serie == 107 || Serie == 162 ) && (tcs.SpeedMpS() > MpS.FromKpH(5))))));
            tcs.SetFullBrake(fullBrake);
            tcs.SetOverspeedWarningDisplay(tcs.SpeedMpS()>AvisoSobreVelocidadMpS);
        }
        protected virtual void UpdateLazoTraccion(bool tcsDemand)
        {
            bool tco = false;
            tco |= tcsDemand;
            tco |= LazoPuertas && tcs.CurrentDoorState(DoorSide.Both) != DoorState.Closed && !ByPassLazoPuertas.Started;
            tco |= (Serie == 102 || Serie == 130 || Serie == 730 || Serie == 112 || Serie == 109 || Serie == 106 || Serie == 107 || Serie == 162 ) && tcs.TrainBrakeControllerState() != ControllerState.Release;
            if (!tco && prevTCO && tcs.ThrottlePercent() > 0) tco = true;
            tco |= tcs.SpeedMpS() > CorteTraccionSobreVelocidadMpS;
            prevTCO = tco;
            tco |= tcs.DoesBrakeCutPower() && (tcs.IsBrakeFullService() || tcs.IsBrakeEmergency() || tcs.BrakeCutsPowerAtBrakeCylinderPressureBar() < tcs.LocomotiveBrakeCylinderPressureBar());
            tcs.SetTractionAuthorization(!tco);
        }
        protected virtual void UpdateLazoFreno(bool tcsDemand)
        {
            bool emergency = false;
            if (EmergencyNeutral) emergency |= tcs.IsDirectionNeutral();
            if (!ByPassLazoFreno.Started)
            {
                //emergency |= MainResPressureBar() < 6;
                emergency |= tcs.SpeedMpS() > UrgenciaSobreVelocidadMpS;
                emergency |= AlarmaViajeros && !AnulacionAlarmas.Started;
            }
            emergency |= tcsDemand;
            bool apply = false;
            bool release = false;
            if (emergency)
            {
                apply = true;
            }
            else if ((Serie >= 462 && Serie <= 465) || Serie == 269)
            {
                if (prevNeutral) release = true;
            }
            else if ((Serie == 100 || Serie == 101 || Serie == 108))
            {
                if (tcs.Disyuntor) release = true;
            }
            else
            {
                release = true;
            }
            if (apply)
            {
                tcs.SetEmergencyBrake(true);
                tcs.SetPenaltyApplicationDisplay(true);
            }
            else if (release)
            {
                tcs.SetEmergencyBrake(false);
                tcs.SetPenaltyApplicationDisplay(false);
            }
            prevNeutral = tcs.IsDirectionNeutral();
        }
        public virtual void HandleEvent(TCSEvent evt, string message)
        {
            switch (evt)
            {
                case TCSEvent.GenericTCSSwitchOn:
                case TCSEvent.GenericTCSSwitchOff:
                {
                    bool on = evt == TCSEvent.GenericTCSSwitchOn;
                    if (int.TryParse(message, out int id))
                    {
                        if (id == ControlBypassFreno)
                        {
                            if (on) ByPassLazoFreno.Start();
                            else ByPassLazoFreno.Stop();
                            tcs.SetCabDisplayControl(ControlBypassFreno, on ? 1 : 0);
                        }
                        else if (id == ControlBypassPuertas)
                        {
                            if (on) ByPassLazoPuertas.Start();
                            else ByPassLazoPuertas.Stop();
                            tcs.SetCabDisplayControl(ControlBypassPuertas, on ? 1 : 0);
                        }
                    }
                    break;
                }
                case TCSEvent.GenericTCSButtonPressed:
                {
                    if (int.TryParse(message, out int id))
                    {
                        if (id == ControlAnulacionAlarmas) AnulacionAlarmas.Start();
                    }
                    break;
                }
            }
        }
    }
    public class ATO
    {
        float PermittedSpeedMpS;
        float PermittedSpeedAccelerationMpSS;
        float ReleaseSpeedMpS;
        private float prevPermittedSpeedMpS;
        private float prevTimeS;
        IIRFilter AccelerationFilter = new IIRFilter(IIRFilter.FilterTypes.Butterworth, 1, 1.0f, 0.1f);
        string ActiveSystem;
        public struct Target
        {
            public float TargetSpeedMpS;
            public float TargetDistanceM;
            public float DecelerationMpSS;
            public float CurveDelayS;
        }
        public Target TCSTarget;
        public List<Target> Targets = new List<Target>();
        public ServerTCS tcs;
        public ATO(ServerTCS tcs)
        {
            this.tcs = tcs;
        }
        public void Initialize()
        {

        }
        public void SetSpeed(string system, float vPerm, float vTarg=float.MaxValue, float dTarg=float.MaxValue, float delay=0, float dec=0)
        {
            if (ActiveSystem == null) ActiveSystem = system;
            if (ActiveSystem != system) return;

            PermittedSpeedMpS = vPerm;

            Targets.Clear();
            Targets.Add(new Target()
            {
                TargetSpeedMpS = vTarg,
                TargetDistanceM = dTarg,
                CurveDelayS = delay,
                DecelerationMpSS = dec,
            });
        }
        public void SetSpeed(string system, float vPerm, List<Target> targets, float vRelease=0)
        {
            if (ActiveSystem == null) ActiveSystem = system;
            if (ActiveSystem != system) return;

            PermittedSpeedMpS = vPerm;
            ReleaseSpeedMpS = vRelease;
            Targets.Clear();
            if (targets != null)
            {
                foreach (var targ in targets)
                {
                    Targets.Add(targ);
                }
            }
        }
        public void Disable(string system)
        {
            if (ActiveSystem == system)
            {
                ActiveSystem = null;
                Targets.Clear();
                ReleaseAccepted = false;
            }
        }
        void CalculateSetPoint(Target target, out float atospd, out float atoaccel)
        {
            float targetSpeedMpS = target.TargetSpeedMpS;
            float targetDistanceM = target.TargetDistanceM;
            float decelerationMpSS = target.DecelerationMpSS;
            float curveDelayS = target.CurveDelayS;
            bool precisionStop = tcs.Serie == 446 && targetSpeedMpS == 0;
            float speedCurveMpS;
            if (precisionStop) speedCurveMpS = Math.Max(tcs.SpeedCurve(targetDistanceM - 10, MpS.FromKpH(5), 0, 1 + curveDelayS, decelerationMpSS), MpS.FromKpH(5));
            else speedCurveMpS = tcs.SpeedCurve(targetDistanceM, targetSpeedMpS, 0, curveDelayS, decelerationMpSS);
            if (precisionStop && (speedCurveMpS < MpS.FromKpH(15) || targetDistanceM <= 10))
            {
                if (targetDistanceM <= 0.05f || (targetDistanceM < 0.2f && tcs.SpeedMpS() < 0.25f))
                {
                    atospd = 0;
                    atoaccel = -0.3f;
                }
                else if (targetDistanceM <= 10)
                {
                    float curve = Math.Max(Math.Min(tcs.SpeedCurve(targetDistanceM, 0, 0, 0, 0.3f), MpS.FromKpH(5)), 0);
                    float dec = Math.Min(tcs.Deceleration(tcs.SpeedMpS(), 0, targetDistanceM), 0.45f);
                    atospd = Math.Min(tcs.SpeedMpS(), curve);
                    atoaccel = dec > 0.3f ? -dec : (dec > 0.2f ? -(dec-0.2f)/0.1f*0.3f : 0);
                }
                else
                {
                    float dec1 = tcs.Deceleration(speedCurveMpS, 0, targetDistanceM);
                    float dec2 = (MpS.ToKpH(speedCurveMpS)-5)/10*tcs.SpeedMpS()/speedCurveMpS*decelerationMpSS;
                    atospd = speedCurveMpS;
                    if (dec2 > Math.Max(dec1, 0.2f)) atoaccel = -dec2;
                    else atoaccel = dec1 > 0.2f ? -dec1 : 0;
                }
            }
            else if (targetSpeedMpS == 0 && (targetDistanceM < 1 || (targetDistanceM < 5 && Math.Min(speedCurveMpS, tcs.SpeedMpS()) < MpS.FromKpH(3))))
            {
                atospd = 0;
                atoaccel = -0.3f;
            }
            else if (targetDistanceM <= 0 || speedCurveMpS <= targetSpeedMpS)
            {
                atospd = targetSpeedMpS;
                atoaccel = 0;
            }
            else
            {
                atospd = speedCurveMpS;
                float targetDec = decelerationMpSS / (1 + decelerationMpSS * curveDelayS / speedCurveMpS);
                if (ActiveSystem == "LZB")
                {
                    if (speedCurveMpS > MpS.FromKpH(30)) targetDec *= 1.5f;
                    else if (speedCurveMpS > MpS.FromKpH(25)) targetDec *= 1 + 0.5f * (MpS.ToKpH(speedCurveMpS)-25)/5;
                }
                atoaccel = -targetDec;
            }
        }
        public void UpdateSetPoint(ref float? atospd, ref float atoaccel, ref float atotarget, float newspd, float newaccel, float newtarget)
        {
            if (atospd == null || atospd > newspd + MpS.FromKpH(5))
            {
                atospd = newspd;
                atoaccel = newaccel;
                atotarget = newtarget;
            }
            else if (atospd > newspd - MpS.FromKpH(5))
            {
                if (atospd >= newspd)
                {
                    atoaccel = Math.Min(newaccel, atoaccel * (1 - (atospd.Value - newspd) / MpS.FromKpH(5)));
                    atospd = newspd;
                }
                else
                {
                    atoaccel = Math.Min(atoaccel, newaccel * (1 - (newspd - atospd.Value) / MpS.FromKpH(5)));
                }
                atotarget = Math.Min(atotarget, newtarget);
            }
        }
        public void UpdateSetPoint(ref float? atospd, ref float atoaccel, ref float atotarget, Target target)
        {
            CalculateSetPoint(target, out float spd, out float accel);
            UpdateSetPoint(ref atospd, ref atoaccel, ref atotarget, spd, accel, target.TargetSpeedMpS);
        }
        float? PrevATOspd;
        float? PrevPrefijada;
        float EndATOTime;
        bool resetReq = false;
        bool ReleaseAccepted;
        public void Update()
        {
            float? atospd = null;
            float atoaccel = 0;

            float atotarget = float.MaxValue;
            foreach (var target in Targets)
            {
                if (target.TargetDistanceM < 1.0e6f)
                {
                    UpdateSetPoint(ref atospd, ref atoaccel, ref atotarget, target);
                }
            }
            if (ActiveSystem != null)
            {
                float elapsedS = tcs.GameTime() - prevTimeS;
                if (elapsedS > 0)
                {
                    float acc = AccelerationFilter.Filter((PermittedSpeedMpS - prevPermittedSpeedMpS) / elapsedS);
                    if (acc > PermittedSpeedAccelerationMpSS)
                    {
                        PermittedSpeedAccelerationMpSS = Math.Min(acc, PermittedSpeedAccelerationMpSS + elapsedS * 0.25f);
                    }
                    else
                    {
                        PermittedSpeedAccelerationMpSS = Math.Max(acc, PermittedSpeedAccelerationMpSS - elapsedS * 0.25f);
                    }
                    if (PermittedSpeedAccelerationMpSS > 1) PermittedSpeedAccelerationMpSS = 1;
                    else if (PermittedSpeedAccelerationMpSS < -1) PermittedSpeedAccelerationMpSS = -1;
                }
                prevPermittedSpeedMpS = PermittedSpeedMpS;
                prevTimeS = tcs.GameTime();

                if (ReleaseAccepted && (ReleaseSpeedMpS > PermittedSpeedMpS || ReleaseSpeedMpS > atospd) && ReleaseSpeedMpS > MpS.FromKpH(5))
                {
                    atospd = ReleaseSpeedMpS - MpS.FromKpH(5);
                    atoaccel = 0;
                    atotarget = 0;
                }
                else if (atotarget == 0 && atospd < MpS.FromKpH(15) && tcs.Serie == 446)
                {

                }
                else if (PermittedSpeedMpS < MpS.FromKpH(3))
                {
                    UpdateSetPoint(ref atospd, ref atoaccel, ref atotarget, 0, -0.3f, 0);
                }
                else if (!atospd.HasValue || atospd > PermittedSpeedMpS + 0.01f)
                {
                    UpdateSetPoint(ref atospd, ref atoaccel, ref atotarget, PermittedSpeedMpS, PermittedSpeedAccelerationMpSS, 0);
                }

                if (ReleaseSpeedMpS < atospd) ReleaseAccepted = false;
                else if (!ReleaseAccepted && tcs.SpeedMpS() == 0 && tcs.ThrottlePercent() == 0) ReleaseAccepted = true;
            }

            if (atospd > tcs.SpeedMpS())
            {
                // TODO: energy savings
            }
#if USE_ATO
            if (false)
            {
                /*if (atospd == 0) ATOStopped = true;
                if (atospd == null) ATOStopped = tcs.SpeedMpS() < MpS.FromKpH(3);
                if (tcs.ATOArranque1 && tcs.ATOArranque2 && ATOStopped && atospd > 0 && tcs.SpeedMpS() > MpS.FromKpH(3)) ATOStopped = false;
                if (ATOStopped && (!tcs.ATOArranque1 || !tcs.ATOArranque2) && atospd != null)
                {
                    atospd = 0;
                    atoaccel = -0.75f;
                }
                tcs.SetSpeedMpS = atospd;
                if (atospd == null) tcs.SetSpeedAccelerationMpSS = 0;
                else tcs.SetSpeedAccelerationMpSS = atoaccel;*/
            }
            else if (tcs.Serie == 446)
            {
                if (atospd == 0 && PrevATOspd > 0)
                {
                    resetReq = true;
                }
                if (tcs.ThrottlePercent() == 0) resetReq = false;
                if (resetReq || (atospd > 0 && tcs.ThrottlePercent() == 0))
                {
                    atospd = 0;
                    atoaccel = -0.3f;
                }
                tcs.SetSpeedMpS = atospd;
                if (atospd == null) tcs.SetSpeedAccelerationMpSS = 0;
                else tcs.SetSpeedAccelerationMpSS = atoaccel;
                PrevATOspd = atospd;
            }
            else
            {
                if (atospd == null && PrevATOspd != null)
                {
                    tcs.SetSpeedMpS = null;
                    if (EndATOTime < 0) EndATOTime = tcs.ClockTime();
                    if (PrevPrefijada != null && (tcs.SetSpeedMpS == null || tcs.SetSpeedMpS != PrevPrefijada))
                    {
                        PrevATOspd = null;
                    }
                    PrevPrefijada = tcs.SetSpeedMpS;
                    tcs.SetSpeedAccelerationMpSS = 0;
                    if (EndATOTime + 10 < tcs.ClockTime())
                    {
                        tcs.SetSpeedMpS = 0;
                    }
                    else
                    {
                        tcs.SetSpeedMpS = PrevATOspd;
                    }
                }
                else
                {
                    if (atospd == null)
                    {
                        tcs.SetSpeedMpS = MpS.FromKpH(200);
                        tcs.SetSpeedAccelerationMpSS = 0;
                    }
                    else
                    {
                        tcs.SetSpeedMpS = atospd;
                        tcs.SetSpeedAccelerationMpSS = atoaccel;
                    }
                    EndATOTime = -1;
                    PrevATOspd = atospd;
                }
            }
#endif
        }
    }
    public abstract class Client
    {
        public virtual void Start()
        {
            WriteLine("connected=true");
        }
        public abstract void WriteLine(string s);
        public abstract string ReadLine();
        public abstract void Stop();
    }
    public class TCPClient : Client
    {
        TcpClient client;
        NetworkStream stream;
        StreamReader reader;
        Task<string> t;
        public TCPClient(TcpClient c)
        {
            client = c;
            stream = client.GetStream();
            reader = new StreamReader(stream, System.Text.Encoding.UTF8);
        }
        public override void Start()
        {
            base.Start();
        }
        public override void Stop()
        {
            client.Close();
        }
        public override void WriteLine(string s)
        {
            byte[] b = System.Text.Encoding.UTF8.GetBytes(s + "\r\n");
            stream.WriteAsync(b, 0, b.Length);
        }
        public override string ReadLine()
        {
            /*while (stream.DataAvailable)
            {
                buff += (char)stream.ReadByte();
            }
            int ind = buff.IndexOf('\n');
            if (ind >= 0)
            {
                string res = buff.Substring(0, ind);
                buff = buff.Substring(ind + 1);
                if (res.Length>0 && res[res.Length-1] == '\r') return res.Substring(0,res.Length-1);
                return res;
            }*/
            string res = null;
            if (t == null) t = reader.ReadLineAsync();
            if (t.IsCompleted)
            {
                res = t.Result;
                t = null;
            }
            return res;
        }
    }
    public abstract class Register
    {
        public bool FirstSent = false;
        public Func<string, bool> HasToSend;
        public Action<string> Sent;
    }
    public class DiscreteRegister : Register
    {
        string prev = "";
        public DiscreteRegister(bool repeat)
        {
            HasToSend = (string val) => repeat || val != prev;
            Sent = (string val) => prev = val;
        }
    }
    public class NumericRegister : Register
    {
        float prev = 0;
        public NumericRegister(float margin)
        {
            HasToSend = (string val) => {
                float curr = float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat);
                return Math.Abs(curr - prev) > margin || (prev != 0 && curr == 0);
            };
            Sent = (string val) => prev = float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat);
        }
    }
    public class Parameter
    {
        public Dictionary<Register, Client> registers;
        public readonly string name;
        public Parameter(string name)
        {
            registers = new Dictionary<Register, Client>();
            this.name = name;
        }
        public Func<string> GetValue;
        public Action<string> SetValue;
        public void Send()
        {
            if(GetValue == null) return;
            string val = GetValue();
            if (val == null) return;
            foreach (Register r in registers.Keys)
            {
                if (r.HasToSend(val) || !r.FirstSent)
                {
                    r.FirstSent = true;
                    registers[r].WriteLine(name + '=' + val);
                    if(r.Sent!=null) r.Sent(val);
                }
            }
        }
        public bool Matches(string topic)
        {
            string[] t1 = topic.Split(new string[]{"::"}, StringSplitOptions.None);
            string[] t2 = name.Split(new string[]{"::"}, StringSplitOptions.None);
            for (int i=0; i<t1.Length && i<t2.Length; i++)
            {
                if (t1[i] == "*")
                    return true;
                if (t1[i] != "+" && t1[i] != t2[i])
                    return false;
            }
            return t1.Length == t2.Length;
        }
        public void RemoveClient(Client c)
        {
            foreach(var item in registers.Where(kvp => kvp.Value == c).ToList())
            {
                registers.Remove(item.Key);
            }
        }
        public override bool Equals(object obj)
        {
            if (obj is Parameter) return name.Equals((obj as Parameter).name);
            return name.Equals(obj);
        }
        public override int GetHashCode()
        {
            return name.GetHashCode();
        }
    }
    public abstract class InteractiveTCS
    {
        public ServerTCS tcs;
        public bool Activated = false;
        public bool Emergency = false;
        public bool FullBrake = false;
        public bool TCO = false;
        public bool PowerAuthorization = true;
        public class TrackConditionProfile
        {
            public bool Active;
            public List<(double?,double?)> DistancesM = new List<(double?,double?)>();
        }
        public TrackConditionProfile NeutralSection;
        public TrackConditionProfile LowerPantographSection;
        public abstract List<Parameter> GetParameters();
        public InteractiveTCS(ServerTCS tcs)
        {
            this.tcs = tcs;
        }
        public abstract void Initialize();
        public abstract void Update();
        public abstract void HandleEvent(TCSEvent evt, string message);
    }
    public class HM : InteractiveTCS
    {
        float HMReleasedAlertDelayS;
        float HMReleasedEmergencyDelayS;
        float HMPressedAlertDelayS;
        float HMPressedEmergencyDelayS;

        float ActivationSpeedMpS;
        
        public bool Pressed = false;
        Timer HMPressedAlertTimer;
        Timer HMPressedEmergencyTimer;
        Timer HMReleasedAlertTimer;
        Timer HMReleasedEmergencyTimer;

        Action<bool> SetVigilanceAlarm;
        Action<bool> SetVigilanceAlarmDisplay; 
        Action<bool> SetVigilanceEmergencyDisplay; 
        
        int AnulacionHM;
        
        bool Anulado = false;
        
        bool HMEmergency;

        public HM(ServerTCS tcs) : base(tcs)
        {
            SetVigilanceAlarm = (value) => { if (Activated) tcs.SetVigilanceAlarm(value); };
            SetVigilanceAlarmDisplay = (value) => { if (Activated) tcs.SetVigilanceAlarmDisplay(value); };
            SetVigilanceEmergencyDisplay = (value) => { if (Activated) tcs.SetVigilanceEmergencyDisplay(value); };
        }
        bool InvertResetButton = true;
        bool ResetAtStandstill = false;
        bool ResetWhenPressed = false;
        bool ResetWhenPressedTwice = false;
        bool ResetNeutral = true;
        int PressedTimes;
        float LastPressedTime;
        bool ResetOnTCO = false;
        public override void HandleEvent(TCSEvent evt, string message)
        {
            switch(evt)
            {
                case TCSEvent.AlerterPressed:
                    SetPressed(!InvertResetButton);
                    break;
                case TCSEvent.AlerterReleased:
                    SetPressed(Pressed = InvertResetButton);
                    break;
                case TCSEvent.GenericTCSSwitchOn:
                case TCSEvent.GenericTCSSwitchOff:
                    int num = int.Parse(message);
                    if (num == AnulacionHM)
                    {
                        Anulado = evt == TCSEvent.GenericTCSSwitchOn;
                        tcs.SetCabDisplayControl(AnulacionHM, Anulado ? 1 : 0);
                    }
                    break;
            }
        }
        public override void Initialize()
        {
            InvertResetButton = tcs.GetBoolParameter("HM","InvertirBoton",true);
            HMReleasedAlertDelayS = tcs.GetFloatParameter("HM","AvisoLevantado",2.5f);
            HMReleasedEmergencyDelayS = tcs.GetFloatParameter("HM","UrgenciaLevantado", 5);
            HMPressedAlertDelayS = tcs.GetFloatParameter("HM","AvisoPisado", 32.5f);
            HMPressedEmergencyDelayS = tcs.GetFloatParameter("HM","UrgenciaPisado", 35);
            ResetWhenPressed = tcs.GetBoolParameter("HM","RearmarAlPulsar", false);
            ResetWhenPressedTwice = tcs.GetBoolParameter("HM","RearmarAlPulsarDoble", false);
            ResetAtStandstill = tcs.GetBoolParameter("HM","RearmarEnParado", false);
            ResetNeutral = tcs.GetBoolParameter("HM","RearmarInversorNeutro", true);
            AnulacionHM = tcs.GetIntParameter("HM", "Anulacion", 0)-1;
            ActivationSpeedMpS = MpS.FromKpH(tcs.GetFloatParameter("HM", "VelocidadUmbral", 0));
            if (AnulacionHM > 0)
            {
                Anulado = !tcs.IsAlerterEnabled();
                tcs.SetCustomizedCabviewControlName(AnulacionHM, "Anulación Hombre Muerto");
                tcs.SetCabDisplayControl(AnulacionHM, Anulado ? 1 : 0);
            }
            
            HMPressedAlertTimer = new Timer(tcs);
            HMPressedAlertTimer.Setup(HMPressedAlertDelayS);
            HMPressedEmergencyTimer = new Timer(tcs);
            HMPressedEmergencyTimer.Setup(HMPressedEmergencyDelayS);
            HMReleasedAlertTimer = new Timer(tcs);
            HMReleasedAlertTimer.Setup(HMReleasedAlertDelayS);
            HMReleasedEmergencyTimer = new Timer(tcs);
            HMReleasedEmergencyTimer.Setup(HMReleasedEmergencyDelayS);
        }
        public override void Update()
        {
            if (!Activated || tcs.IsDirectionNeutral() || Anulado || !tcs.IsAlerterEnabled() || tcs.SpeedMpS() < ActivationSpeedMpS || (ResetOnTCO && !tcs.PowerAuthorization()))
            {
                HMReleasedAlertTimer.Stop();
                HMReleasedEmergencyTimer.Stop();
                HMPressedAlertTimer.Stop();
                HMPressedEmergencyTimer.Stop();
                if (tcs.IsDirectionNeutral() && ResetNeutral) HMEmergency = false;
                if (Emergency)
                {
                    Emergency = false;
                    SetVigilanceEmergencyDisplay(false);
                }
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
                SetVigilanceAlarmDisplay(false);
                return;
            }
            if (Pressed && (!HMPressedAlertTimer.Started || !HMPressedEmergencyTimer.Started))
            {
                HMReleasedAlertTimer.Stop();
                HMReleasedEmergencyTimer.Stop();
                HMPressedAlertTimer.Start();
                HMPressedEmergencyTimer.Start();
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
                SetVigilanceAlarmDisplay(false);
            }
            if (Pressed && HMPressedAlertTimer.RemainingValue < 2.5f)
            {
                SetVigilanceAlarmDisplay(true);
            }
            if (!Pressed && (!HMReleasedAlertTimer.Started || !HMReleasedEmergencyTimer.Started))
            {
                HMReleasedAlertTimer.Start();
                HMReleasedEmergencyTimer.Start();
                HMPressedAlertTimer.Stop();
                HMPressedEmergencyTimer.Stop();
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
                SetVigilanceAlarmDisplay(true);
            }
            if (HMReleasedAlertTimer.Triggered || HMPressedAlertTimer.Triggered)
            {
                if (!tcs.AlerterSound()) SetVigilanceAlarm(true);
                SetVigilanceAlarmDisplay(true);
            }
            else
            {
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
            }
            if (!HMEmergency && (HMPressedEmergencyTimer.Triggered || HMReleasedEmergencyTimer.Triggered))
            {
                HMEmergency = true;
                if (tcs.AlerterSound()) SetVigilanceAlarm(false);
                SetVigilanceAlarmDisplay(false);
                SetVigilanceEmergencyDisplay(true);
            }
            if (HMEmergency && tcs.SpeedMpS() < 1.5f && ResetAtStandstill)
            {
                HMEmergency = false;
                SetVigilanceEmergencyDisplay(false);
            }
            Emergency = HMEmergency;
        }
        public void SetPressed(bool pressed)
        {
            if (pressed == Pressed) return;
            Pressed = pressed;
            if (Pressed)
            {
                if (tcs.ClockTime() - LastPressedTime < 3) ++PressedTimes;
                else PressedTimes = 1;
                LastPressedTime = tcs.ClockTime();
            }
            if (HMEmergency && Pressed && ResetWhenPressed)
            {
                HMEmergency = false;
                SetVigilanceEmergencyDisplay(false);
            }
            if (Pressed && Anulado && PressedTimes > 2)
            {
                PressedTimes = 0;
                Anulado = false;
            }
            if (HMEmergency && Pressed && PressedTimes > 1 && ResetWhenPressedTwice)
            {
                PressedTimes = 0;
                HMEmergency = false;
                SetVigilanceEmergencyDisplay(false);
            }
        }
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = new List<Parameter>();
            
            Parameter p;
            
            p = new Parameter("hm::pressed");
            p.SetValue = (string val) => {SetPressed(val=="1" || val=="true");};
            l.Add(p);
            
            return l;
        }
    }
    public class DASS : InteractiveTCS
    {
        bool Anulado;
        enum EstadoDASS
        {
            Inactivo,
            Armado,
            Activo
        }
        EstadoDASS Estado;
        bool LazoPuertas;
        int InterruptorBypass;
        int PulsadorVerde;
        int PulsadorBlanco;
        int PulsadorBicolor1;
        int PulsadorBicolor2;
        bool LastRandom;

        public DASS(ServerTCS tcs) : base(tcs)
        {
        }
        public override void HandleEvent(TCSEvent ev, string message)
        {
            switch (ev)
            {
                case TCSEvent.GenericTCSSwitchOff:
                case TCSEvent.GenericTCSSwitchOn:{
                    int num = int.Parse(message);
                    if (num == InterruptorBypass)
                    {
                        Anulado = ev == TCSEvent.GenericTCSSwitchOn;
                        tcs.SetCabDisplayControl(InterruptorBypass, Anulado ? 1 : 0);
                    }}
                    break;
                case TCSEvent.GenericTCSButtonPressed:{
                    int num = int.Parse(message);
                    if (num >= PulsadorVerde && num <= PulsadorBicolor2 && Estado == EstadoDASS.Activo)
                    {
                        Estado = EstadoDASS.Inactivo;
                        if (num == PulsadorVerde) tcs.Message(ConfirmLevel.Information, "DASS - Vía libre");
                        else if (num == PulsadorBlanco) tcs.Message(ConfirmLevel.Information, "DASS - Señal inexistente");
                        else if ((num == PulsadorBicolor1) ^ LastRandom) tcs.Message(ConfirmLevel.Information, "DASS - Anuncio de parada");
                        else tcs.Message(ConfirmLevel.Warning, "DASS - Señal en rojo");
                    }}
                    break;
            }
                
        }
        public override void Initialize()
        {
            int puls = tcs.GetIntParameter("DASS", "CabControl", 1);
            InterruptorBypass = puls-1;
            PulsadorVerde = puls;
            PulsadorBlanco = puls+1;
            PulsadorBicolor1 = puls+2;
            PulsadorBicolor2 = puls+3;
            tcs.SetCustomizedCabviewControlName(InterruptorBypass, "Anulación DASS");
        }
        public override void Update()
        {
            if (Estado != EstadoDASS.Activo)
            {
                tcs.SetCabDisplayControl(PulsadorVerde, 0);
                tcs.SetCabDisplayControl(PulsadorBlanco, 0);
                tcs.SetCabDisplayControl(PulsadorBicolor1, 0);
                tcs.SetCabDisplayControl(PulsadorBicolor2, 0);
                tcs.SetCustomizedCabviewControlName(PulsadorVerde, "DASS");
                tcs.SetCustomizedCabviewControlName(PulsadorBlanco, "DASS");
                tcs.SetCustomizedCabviewControlName(PulsadorBicolor1, "DASS");
                tcs.SetCustomizedCabviewControlName(PulsadorBicolor2, "DASS");
            }
            if (Anulado)
            {
                TCO = false;
                Estado = EstadoDASS.Inactivo;
                return;
            }
            LazoPuertas = tcs.CurrentDoorState(DoorSide.Left) == DoorState.Closed && tcs.CurrentDoorState(DoorSide.Right) == DoorState.Closed;
            if (!LazoPuertas) Estado = EstadoDASS.Armado;
            if (LazoPuertas && Estado == EstadoDASS.Armado)
            {
                Estado = EstadoDASS.Activo;
                LastRandom = ServerTCS.Random.Next(2) == 1;
                tcs.SetCabDisplayControl(PulsadorVerde, 1);
                tcs.SetCabDisplayControl(PulsadorBlanco, 1);
                tcs.SetCabDisplayControl(PulsadorBicolor1, LastRandom ? 2 : 1);
                tcs.SetCabDisplayControl(PulsadorBicolor2, LastRandom ? 1 : 2);
                tcs.SetCustomizedCabviewControlName(PulsadorVerde, "DASS: vía libre");
                tcs.SetCustomizedCabviewControlName(PulsadorBlanco, "DASS: señal inexistente");
                tcs.SetCustomizedCabviewControlName(LastRandom ? PulsadorBicolor2 : PulsadorBicolor1, "DASS: anuncio de parada");
                tcs.SetCustomizedCabviewControlName(LastRandom ? PulsadorBicolor1 : PulsadorBicolor2, "DASS: señal en parada");
            }
            TCO = Estado == EstadoDASS.Activo;
        }
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = new List<Parameter>();
            return l;
        }
    }
    public class ETCS : InteractiveTCS
    {
        public enum Aspecto
        {
            Apagada,
            Parada,
            ParadaLZB,
            ParadaSelectiva,
            ParadaSelectivaDestellos,
            ParadaPermisiva,
            RebaseAutorizado,
            RebaseAutorizadoCortaDistancia,
            RebaseAutorizadoDestellos,
            MovimientoAutorizado,
            ParadaDiferida,
            AnuncioParadaInmediata,
            AnuncioParada,
            AnuncioPrecaucion,
            PreanuncioParada,
            ViaLibreCondicional,
            ViaLibre
        }
		Dictionary<string, Aspecto> textoAAspecto;
        Aspecto ConvertirAspecto(Aspect aspect, string text)
        {
            if (textoAAspecto.ContainsKey(text))
            {
                return textoAAspecto[text];
            }
            else
            {
                switch (aspect)
                {
                    case Aspect.Stop:
                        return Aspecto.Parada;

                    case Aspect.StopAndProceed:
                        return Aspecto.RebaseAutorizado;

                    case Aspect.Restricted:
                        return Aspecto.RebaseAutorizadoDestellos;

                    case Aspect.Approach_1:
                        return Aspecto.AnuncioParada;

                    case Aspect.Approach_2:
                        return Aspecto.AnuncioPrecaucion;

                    case Aspect.Approach_3:
                        return Aspecto.PreanuncioParada;

                    case Aspect.Clear_1:
                        return Aspecto.ViaLibreCondicional;

                    case Aspect.Clear_2:
                        return Aspecto.ViaLibre;
                }
            }
            return Aspecto.Parada;
        }
        double StartLowPantographSection=double.MaxValue;
        double EndLowPantographSection=double.MinValue;
        bool[] PantoRaised = new bool[4];
        Mode CurrentMode;
        int IsolationButton = -1;
        int GSMRSwitch = -1;
        int AckButton = -1;
        bool Isolated;
        bool ATO;
        public ETCS(ServerTCS tcs) : base(tcs)
        {
			textoAAspecto = Enum.GetNames(typeof(Aspecto)).ToDictionary(x => x, x => (Aspecto)Enum.Parse(typeof(Aspecto), x), StringComparer.OrdinalIgnoreCase);
        }
        public override void HandleEvent(TCSEvent ev, string message)
        {
            switch (ev)
            {
                case TCSEvent.GenericTCSSwitchOn:
                case TCSEvent.GenericTCSSwitchOff:
                {
                    int num = int.Parse(message);
                    bool act = ev == TCSEvent.GenericTCSSwitchOn;
                    if (num == IsolationButton)
                    {
                        Isolated = act;
                        tcs.SetCabDisplayControl(num, Isolated ? 1 : 0);
                    }
                    else if (num == GSMRSwitch)
                    {
                        tcs.SendParameter("gsmr::active", act ? "1" : "0");
                        tcs.SetCabDisplayControl(num, act ? 1 : 0);
                    }
                    break;
                }
                case TCSEvent.GenericTCSButtonPressed:
                case TCSEvent.GenericTCSButtonReleased:
                {
                    int num = int.Parse(message);
                    bool pressed = ev == TCSEvent.GenericTCSButtonPressed;
                    if (num == AckButton)
                    {
                        tcs.SendParameter("etcs::button::ack", pressed ? "1" : "0");
                        //tcs.SetCabDisplayControl(num, pressed ? 1 : 0);
                    }
                    break;
                }
            }
        }
        /*[DllImport("kernel32", SetLastError = true, CharSet = CharSet.Ansi)]
        internal static extern IntPtr LoadLibrary([MarshalAs(UnmanagedType.LPStr)]string lpFileName);
        [DllImport("kernel32.dll")]
        public static extern IntPtr GetProcAddress(IntPtr hModule, string procedureName);
        [DllImport("kernel32.dll")]
        static extern uint GetLastError();

        [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
        private delegate void Sta();
        [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
        private delegate void Upd();
        Sta start;
        Upd update;*/
        public override void Initialize()
        {
            IsolationButton = tcs.GetIntParameter("ETCS", "IsolationButton", 0)-1;
            if (IsolationButton >= 0) tcs.SetCustomizedCabviewControlName(IsolationButton, "ETCS Isolation");
            GSMRSwitch = tcs.GetIntParameter("ETCS", "GSMRSwitch", 0)-1;
            if (GSMRSwitch >= 0)
            {
                tcs.SetCustomizedCabviewControlName(GSMRSwitch, "GSM-R switch");
                tcs.SetCabDisplayControl(GSMRSwitch, 1);
            }
            AckButton = tcs.GetIntParameter("ETCS", "AckButton", 0)-1;
            if (AckButton >= 0) tcs.SetCustomizedCabviewControlName(AckButton, "ETCS ACK");
            ATO = tcs.GetBoolParameter("ETCS", "ATO", true);
            /*IntPtr pDll = LoadLibrary("evc.dll");
            Console.Write("Error: ");
            Console.WriteLine(GetLastError());
            IntPtr ps = GetProcAddress(pDll, "start");
            IntPtr pu = GetProcAddress(pDll, "update");
            start = (Sta)Marshal.GetDelegateForFunctionPointer(ps, typeof(Sta));
            update = (Upd)Marshal.GetDelegateForFunctionPointer(pu, typeof(Upd));
            //start();*/
        }
        SpeedInfo? PreviousSpeedPost = null;
        SpeedInfo? CurrentSpeedPost = null;
        float skipPostDistance = 0;
        bool started=false;
        void UpdateTrackConditions()
        {
            /*float PantoToFront=0;
            float PantoToRear=0;
            {
                bool start = StartNeutralSectionDistanceM + PantoToFront < tcs.SpeedMpS() * 1;
                bool end = EndNeutralSectionDistanceM < -tcs.TrainLengthM() + PantoToRear;
                if (end || !start)
                {
                    if (CloseCircuitBreakerTimer.Started) tcs.SetCircuitBreakerClosingOrder(true);
                    if (CloseCircuitBreakerTimer.Triggered)
                    {
                        tcs.SetCircuitBreakerClosingOrder(false);
                        CloseCircuitBreakerTimer.Stop();
                    }
                    OpenCircuitBreakerTimer.Start();
                }
                else
                {
                    if (OpenCircuitBreakerTimer.Started) tcs.SetCircuitBreakerOpeningOrder(true);
                    if (OpenCircuitBreakerTimer.Triggered)
                    {
                        tcs.SetCircuitBreakerOpeningOrder(false);
                        OpenCircuitBreakerTimer.Stop();
                    }
                    CloseCircuitBreakerTimer.Start();
                }
                if (StartNeutralSectionDistanceM + PantoToFront > tcs.SpeedMpS() * 7 || end) ZeroThrottleTimer.Stop();
                else if (!ZeroThrottleTimer.Started) ZeroThrottleTimer.Start();
                if (start && !end) ResetThrottleTimer.Stop();
                else if (!ResetThrottleTimer.Started && !CloseCircuitBreakerTimer.Started) ResetThrottleTimer.Start();
                double percent = 100;
                if (!ResetThrottleTimer.Started) percent = 0;
                else if (ZeroThrottleTimer.Started) percent = ZeroThrottleTimer.RemainingValue*100/ResetThrottleTimer.AlarmValue;
                else percent = 100*(1 - ResetThrottleTimer.RemainingValue/ResetThrottleTimer.AlarmValue);
                if (percent > 100) percent = 100;
                if (percent < 0) percent = 0;
                MaxThrottlePercent = (float)percent;
            }
            {
                bool lower = StartLowPantographSection + PantoToFront < tcs.SpeedMpS() * 15;
                bool raise = EndLowPantographSection < -tcs.TrainLengthM() + PantoToRear;
                if (lower && !raise && !tcs.ArePantographsDown())
                {
                    for (int i=1; i<5; i++)
                    {
                        PantoRaised[i-1] = tcs.GetPantographState(i) == PantographState.Up;
                    }
                    tcs.SetPantographsDown();
                }
                if (raise || !lower)
                {
                    for (int i=1; i<5; i++)
                    {
                        if (PantoRaised[i-1]) tcs.SetPantographUp(i);
                        PantoRaised[i-1] = false;
                    }
                }
            }*/
        }
        protected float? ATOVperm;
        protected float ATOVrelease;
        /*protected float? ATOVtarget;
        protected float? ATODtarget;*/
        protected Dictionary<float, float> ATOTargets = new Dictionary<float, float>();
        protected List<ATO.Target> ATOTargets2 = new List<ATO.Target>();
        public override void Update()
        {
            /*if (!started)
            {
                start();
                started = true;
            }
            update();*/
            if (Isolated)
            {
                Emergency = FullBrake = TCO = false;
                return;
            }
            tcs.ETCSStatus.ShowTextMessageArea = true;
            tcs.ETCSStatus.PlanningAreaShown = CurrentMode == Mode.FS;
            for (int i=0; i<tcs.ETCSStatus.TextMessages.Count; i++)
            {
                TextMessage t = tcs.ETCSStatus.TextMessages[i];
                if (t.Acknowledged)
                {
                    t.Acknowledged = false;
                    tcs.ETCSStatus.TextMessages[i] = t;
                    foreach(KeyValuePair<int, TextMessage> entry in MessageList)
                    {
                        if (entry.Value.Equals(t))
                        {
                            tcs.SendParameter("noretain(etcs::dmi::feedback","messageAcked("+entry.Key+"))");
                            break;
                        }
                    }
                }
            }
            UpdateTrackConditions();
            UpdateSignalPassed();
            UpdateInfillPassed();
            UpdateEurobalise();
            var postFeat = GetSpeedLimit(0, float.MaxValue);
            if (PreviousSpeedPost.HasValue && (PreviousSpeedPost.Value.distance + 5 < postFeat.distance || PreviousSpeedPost.Value.speed != postFeat.speed) && tcs.DistanceM() > skipPostDistance)
            {
                CurrentSpeedPost = PreviousSpeedPost;
                skipPostDistance = tcs.DistanceM() + 15;
            }
            if (postFeat.speed < 0) PreviousSpeedPost = null;
            else PreviousSpeedPost = postFeat;
            foreach (var balise in BalisesPassed)
            {
                tcs.SendParameter("noretain(etcs::telegram", fill_telegram(balise)+")");
            }
            if (ATO && tcs.ATO != null)
            {
                if (ATOVperm.HasValue)
                {
                    ATOTargets2.Clear();
                    foreach (var kvp in ATOTargets)
                    {
                        float dist = kvp.Key - tcs.SignedDistanceM() * (tcs.IsFlipped() || tcs.IsRearCab() ? -1 : 1);
                        if (kvp.Value == 0)
                        {
                            ATOTargets2.Add(new ATO.Target()
                            {
                                TargetSpeedMpS = 0,
                                TargetDistanceM = dist - 10,
                                DecelerationMpSS = 0.5f,
                                CurveDelayS = 5,
                            });
                        }
                        else
                        {
                            ATOTargets2.Add(new ATO.Target()
                            {
                                TargetSpeedMpS = kvp.Value,
                                TargetDistanceM = dist,
                                DecelerationMpSS = 0.5f,
                                CurveDelayS = 2,
                            });
                        }
                    }
                    tcs.ATO.SetSpeed("ETCS", ATOVperm.Value, ATOTargets2, ATOVrelease);
                }
                else
                {
                    tcs.ATO.Disable("ETCS");
                }
            }
        }
        
        string fill_telegram(BaliseDataType BalisePassed)
        {
            string tel = BalisePassed.TextAspect;
            Console.WriteLine("Ref: "+group_position+" Dist: "+tcs.DistanceM()); 
            Console.WriteLine("Before: " + tel);
            float end=32700;
            float bgref=group_position-tcs.DistanceM();
            float ilref=-1;
            float prevdist=-1;
            int linkedSignalIndex = 0;
            for (int i=0; i<10; i++)
            {
                SignalFeatures feat = tcs.NextGenericSignalFeatures("NORMAL", i, float.MaxValue);
                if (feat.MainHeadSignalTypeName.Equals("pantalla_ertms") || feat.MainHeadSignalTypeName == "sp4md" || feat.MainHeadSignalTypeName == "sp4md_izq" || feat.MainHeadSignalTypeName == "selu4monombra" || feat.MainHeadSignalTypeName == "selu4monombraizq") continue;
                linkedSignalIndex = i;
                break;
            }
            for (int i=0; ; i++)
            {
                float dist = tcs.NextGenericSignalFeatures("ETCS", i, 32000).DistanceM;
                if (dist < 0 || dist > 32000) break;
                if (prevdist >= 0 && dist-prevdist < 12)
                {
                    prevdist = dist;
                    continue;
                }
                prevdist = dist;
                if (dist < tcs.NextSignalDistanceM(linkedSignalIndex)) ilref = dist;
            }
            tel = Regex.Replace(tel, @"NextSignalDistanceM\(([0-9]+)\)", match => {
                if (BalisePassed.reverse_passed) return "0";
                return Math.Min(tcs.NextSignalDistanceM(int.Parse(match.Groups[1].Value)),32000).ToString().Replace(',','.');
            });
            tel = Regex.Replace(tel, @"NextSignalDistanceM\(([A-Z_]+),([0-9])+\)", match => {
                if (BalisePassed.reverse_passed) return "0";
                return Math.Min(tcs.NextGenericSignalFeatures(match.Groups[1].Value, int.Parse(match.Groups[2].Value), 32000).DistanceM,32000).ToString().Replace(',','.');
            });
            tel = Regex.Replace(tel, @"NextEurobaliseDistanceM\(([0-9]+)\)", match => {
                if (BalisePassed.reverse_passed) return "0";
                return Math.Min(tcs.NextGenericSignalFeatures(BalisePassed.reverse_passed ? "ETCS_BACKFACING" : "ETCS", int.Parse(match.Groups[1].Value), 32000).DistanceM,32000).ToString().Replace(',','.');
            });
            tel = Regex.Replace(tel, @"bg_reference\(([0-9]+)\)", match => {
                if (BalisePassed.reverse_passed) return "0";
                for (int i=0; ; i++)
                {
                    var feat = tcs.NextGenericSignalFeatures("ETCS", i, 32000);
                    if (feat.DistanceM < 0 || feat.DistanceM > 32000) break;
                    var bal = BuildBalise(feat.MainHeadSignalTypeName, feat.DistanceM, feat.TextAspect);
                    if (bal.nid_bg == int.Parse(match.Groups[1].Value)) return (feat.DistanceM - bgref).ToString().Replace(',','.');
                }
                return "32000";
            });
            tel = Regex.Replace(tel, @"bg_reference_back\(([0-9]+)\)", match => {
                if (BalisePassed.reverse_passed) return "0";
                for (int i=0; ; i++)
                {
                    var feat = tcs.NextGenericSignalFeatures("ETCS_BACKFACING", i, 32000);
                    if (feat.DistanceM < 0 || feat.DistanceM > 32000) break;
                    var bal = BuildBalise(feat.MainHeadSignalTypeName, feat.DistanceM, feat.TextAspect);
                    if (bal.nid_bg == int.Parse(match.Groups[1].Value)) return (feat.DistanceM - bgref).ToString().Replace(',','.');
                }
                return "32000";
            });
            tel = Regex.Replace(tel, @"bgref", match => {
                return bgref.ToString().Replace(',','.');
            });
            tel = Regex.Replace(tel, @"ilref", match => {
                return ilref.ToString().Replace(',','.');
            });
            /*tel = Regex.Replace(tel, @"EoADistanceM(\([0-9])+\)", match => {
                return tcs.EOADistanceM(tcs.CurrentTrainMUDirection() == Direction.Reverse ? 1 : 0);
            });*/
            tel = Regex.Replace(tel, @"{ma_infill}", match => {
                if (BalisePassed.reverse_passed) return "";
                float maend;
                return get_ma(ilref, true, out maend, linkedSignalIndex);
            });
            tel = Regex.Replace(tel, @"{ma}", match => {
                if (BalisePassed.reverse_passed) return "";
                float maend;
                return get_ma(bgref, false, out maend, 0);
            ;
            });
            tel = Regex.Replace(tel, @"{ssp}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_ssp(end, bgref, BalisePassed.m_version);
            });
            tel = Regex.Replace(tel, @"{ssp_infill}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_ssp(end, ilref, BalisePassed.m_version);
            });
            tel = Regex.Replace(tel, @"{gradient}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_gradient(end);
            });
            tel = Regex.Replace(tel, @"{ltv}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_ltv(end, bgref);
            });
            tel = Regex.Replace(tel, @"{linking}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_linking(bgref, BalisePassed.reverse_passed);
            });
            tel = Regex.Replace(tel, @"{trackcond}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_conditions(bgref, tcs.NextSignalDistanceM(5), BalisePassed.m_version);
            });
            tel = Regex.Replace(tel, @"{tunnel_msg\(([0-9]+)\)}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_tunnel_msg(bgref, int.Parse(match.Groups[1].Value));
            });
            tel = Regex.Replace(tel, @"{viaducto_msg\(([0-9]+)\)}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_viaducto_msg(bgref, int.Parse(match.Groups[1].Value));
            });
            tel = Regex.Replace(tel, @"{puente_msg\(([0-9]+)\)}", match => {
                if (BalisePassed.reverse_passed) return "";
                return get_puente_msg(bgref, int.Parse(match.Groups[1].Value));
            });
            tel = Regex.Replace(tel, @"{pk}", match => {
                if (BalisePassed.reverse_passed) return "";
                bool fwd;
                float pos = get_pk(0, out fwd);
                if (pos >= 0)
                {
                    string position="01"+"0"+format_binary(BalisePassed.nid_bg, 14)+format_etcs_distance(0)+((fwd ^ BalisePassed.reverse_passed) ? "1" : "0")+format_binary((int)(pos*1000), BalisePassed.m_version < 32 ? 20 : 24)+"00000";
                    return create_packet(79, position, 2);
                }
                return "";
            });
            tel = Regex.Replace(tel, @"{([^}]*)}", match => {
                //Console.WriteLine("mid: "+match.Groups[1].Value);
                return format_etcs_distance(eval(match.Groups[1].Value));
            });
            Console.WriteLine("After: " + tel);
            return tel;
        }
        public double eval(string exp)
        {
            int bracketCounter = 0;
            int operatorIndex = -1;

            for(int i=0; i<exp.Length; i++){
                char c = exp[i];
                if(c == '(') bracketCounter++;
                else if(c == ')') bracketCounter--;
                else if((c == '+' || c == '-') && bracketCounter == 0){
                    operatorIndex = i;
                    break;
                }
                else if((c == '*' || c == '/') && bracketCounter == 0 && operatorIndex < 0){
                    operatorIndex = i;
                }
            }
            if(operatorIndex <= 0){
                exp = exp.Trim();
                if(exp[0] == '(' && exp[exp.Length-1] == ')')
                    return eval(exp.Substring(1, exp.Length-2));
                else
                    return double.Parse(exp, CultureInfo.InvariantCulture.NumberFormat);
            }
            else{
                switch(exp[operatorIndex]){
                    case '+':
                        return eval(exp.Substring(0, operatorIndex)) + eval(exp.Substring(operatorIndex+1));
                    case '-':
                        return eval(exp.Substring(0, operatorIndex)) - eval(exp.Substring(operatorIndex+1));
                    case '*':
                        return eval(exp.Substring(0, operatorIndex)) * eval(exp.Substring(operatorIndex+1));
                    case '/':
                        return eval(exp.Substring(0, operatorIndex)) / eval(exp.Substring(operatorIndex+1));
                }
            }
            return 0;
        }
        string get_ma(float bgref, bool infill, out float maend, int linkedSignalIndex)
        {
            string ma="01";
            maend = 0;
            var linkedSignal = tcs.NextGenericSignalFeatures("NORMAL", linkedSignalIndex, float.MaxValue);
            Aspecto aspecto = ConvertirAspecto(linkedSignal.Aspect, linkedSignal.TextAspect);
            int vrelease = 15;
            if (aspecto==Aspecto.Parada || aspecto==Aspecto.ParadaPermisiva || aspecto==Aspecto.ParadaSelectiva || (aspecto == Aspecto.RebaseAutorizado && infill) || aspecto == Aspecto.RebaseAutorizadoCortaDistancia)
            {
                ma += format_etcs_speedKpH(0)+"0000000"+"0000000000"+"00000";
                ma += format_etcs_distance(tcs.NextSignalDistanceM(linkedSignalIndex)-bgref)+"0"+"0"+"1"+format_etcs_distance(15)+format_etcs_speedKpH(vrelease)+"0";
            }
            else
            {
                float EoAdist = tcs.EOADistanceM(tcs.CurrentTrainMUDirection() == Direction.Reverse ? 1 : 0);
                bool EoAvalid = false;
                if (tcs.NextSignalDistanceM(linkedSignalIndex) < 0 || tcs.NextSignalDistanceM(linkedSignalIndex) > 32000) EoAvalid = true;
                ma += format_etcs_speedKpH(300)+format_etcs_speed(0)+format_binary(0, 10);
                List<SignalFeatures> features = new List<SignalFeatures>();
                features.Add(tcs.NextGenericSignalFeatures("NORMAL", linkedSignalIndex, float.MaxValue));
                int maxToClear = 0;
                if (aspecto == Aspecto.RebaseAutorizado || aspecto == Aspecto.RebaseAutorizadoDestellos) maxToClear = 1;
                else if (aspecto == Aspecto.AnuncioParada) maxToClear = 4;
                else if (aspecto == Aspecto.AnuncioPrecaucion) maxToClear = 4;
                else if (aspecto == Aspecto.ViaLibreCondicional || aspecto == Aspecto.PreanuncioParada) maxToClear = 4;
                else if (aspecto == Aspecto.ViaLibre || aspecto == Aspecto.ParadaSelectivaDestellos) maxToClear = 4;
                
                List<SignalFeatures> stops = new List<SignalFeatures>();
                for(int i=linkedSignalIndex+1; i<=linkedSignalIndex+maxToClear; i++) 
                {
                    SignalFeatures feat = tcs.NextGenericSignalFeatures("NORMAL", i, float.MaxValue);
                    if (feat.MainHeadSignalTypeName.Equals("pantalla_ertms") || feat.MainHeadSignalTypeName == "sp4md" || feat.MainHeadSignalTypeName == "sp4md_izq" || feat.MainHeadSignalTypeName == "selu4monombra" || feat.MainHeadSignalTypeName == "selu4monombraizq")
                    {
                        maxToClear++;
                        continue;
                    }
                    if (EoAvalid && feat.DistanceM > EoAdist + 10)
                    {
                        maend = Math.Min(EoAdist-10, 32000);
                        vrelease = 10;
                        break;
                    }
                    if (feat.MainHeadSignalTypeName == "sp2mb")
                    {
                        vrelease = 10;
                        maend = Math.Min(feat.DistanceM-10, 32000);
                    }
                    else
                    {
                        maend = Math.Min(feat.DistanceM, 32000);
                    }
                    aspecto = ConvertirAspecto(feat.Aspect, feat.TextAspect);
                    if (feat.DistanceM > 32000 || aspecto==Aspecto.Parada || aspecto==Aspecto.ParadaPermisiva || aspecto==Aspecto.ParadaSelectiva || aspecto == Aspecto.RebaseAutorizadoCortaDistancia || aspecto==Aspecto.RebaseAutorizado || aspecto==Aspecto.RebaseAutorizadoDestellos || i==linkedSignalIndex+maxToClear) break;
                    features.Add(feat);
                    bool salida = feat.MainHeadSignalTypeName.StartsWith("sp3s") || feat.MainHeadSignalTypeName.StartsWith("sp4s");
                    bool entrada = feat.MainHeadSignalTypeName.StartsWith("sp3e") || feat.MainHeadSignalTypeName.StartsWith("sp4e");
                    if ((salida || entrada) && stops.Count<2) stops.Add(feat);
                }
                for(int i=0; i<10; i++) 
                {
                    SignalFeatures feat = tcs.NextGenericSignalFeatures("OLPN_T", i, float.MaxValue);
                    if (feat.DistanceM > maend) break;
                    stops.Add(feat);
                }
                stops.Sort((x,y) => x.DistanceM.CompareTo(y.DistanceM));
                List<string> sects = new List<string>();
                float start = bgref;
                for (int i=0; i<stops.Count; i++)
                {
                    var feat = stops[i];
                    sects.Add(construirSeccion(feat.DistanceM-start, sects.Count, features, feat, (i+1<stops.Count) ? (SignalFeatures?)stops[i+1] : null, infill));
                    start = feat.DistanceM;
                }
                ma += format_binary(sects.Count, 5);
                foreach (var sec in sects) ma += sec;
                ma += construirSeccion(maend-start, sects.Count, features, stops.Count > 0 ? (SignalFeatures?)stops[stops.Count-1] : null, null, infill);
                ma += "0"+"1"+format_etcs_distance(vrelease == 10 ? 10 : 15)+format_etcs_speedKpH(vrelease)+"0";
            }
            return create_packet(12, ma, 1);
        }
        string construirSeccion(double longitud, int sectionNumber, List<SignalFeatures> feat, SignalFeatures? senalInicioSeccion, SignalFeatures? senalFinSeccion, bool infill)
        {
            int idx = senalInicioSeccion.HasValue ? feat.IndexOf(senalInicioSeccion.Value) : -1;
            int idx1 = senalFinSeccion.HasValue ? feat.IndexOf(senalFinSeccion.Value) : -1;
            bool esSalida = false;
            bool Convencional = true;
            string sect = format_etcs_distance(longitud);
            if (senalInicioSeccion != null && idx < 0)
            {
                sect += "1"+format_binary(160, 10)+format_etcs_distance(0);
            }
            else if (sectionNumber > 0)
            {
                int T = 30;
                if (idx == 0 && !infill) T = Convencional ? 180 : 360; // DEI
                else
                {
                    if (Convencional) T = (idx == 0 && esSalida) ? 30 : 150; // DAI
                    else if (idx == 1) T = 240; // DAI zona 2
                    else T = 360; // DAI zona 1
                }
                sect += "1"+format_binary(T, 10)+format_etcs_distance(Math.Min(200, longitud));
            }
            else if (idx1 == 0 && !infill)
            {
                int T = Convencional ? 150 : 240; // DAI
                sect += "1"+format_binary(T, 10)+format_etcs_distance(longitud);
            }
            else sect += "0"; // Sin temporizar
            return sect;
        }
        string get_directional_linking(float bgref, bool reverse, bool include_reverse)
        {
            List<BaliseDataType> balises = GetNextBalise(true, bgref + 10, 15000, reverse, 3, include_reverse);
            if (balises.Count == 0) return "";
            float cumref = bgref;
            List<string> links = new List<string>();
            for (int i=0; i<balises.Count; i++)
            {
                float d_link = balises[i].distance - cumref;
                string l = format_etcs_distance(d_link) + "0" + format_binary(balises[i].nid_bg, 14) + (balises[i].reverse_passed ? "0" : "1") + "01" + format_binary(3, 6);
                links.Add(l);
                cumref = balises[i].distance;
            }
            string link = "01" + links[0] + format_binary(links.Count-1, 5);
            for (int i=1; i<links.Count; i++)
            {
                link += links[i];
            }
            return link;
        }
        string get_linking(float bgref, bool reverse_passed)
        {
            if (reverse_passed) return "";
            string l2 = get_directional_linking(bgref, reverse_passed, false);
            if (l2 != "") return create_packet(5, l2, 1);
            return "";
            /*string l1 = get_directional_linking(bgref, !reverse_passed);
            string l2 = get_directional_linking(bgref, reverse_passed);
            string packs = "";
            if (l1 != "") packs += create_packet(5, l1, 0);
            if (l2 != "") packs += create_packet(5, l2, 1);
            return packs;;*/
        }
        void send_telegram(BaliseDataType balise, string telegrams, bool linked = true)
        {
            string tel = "1"+"0100001"+"0"+format_binary(balise.n_pig,3)+format_binary(balise.n_total, 3)+"00"+"11111111"+"0000000000"+format_binary(balise.nid_bg, 14)+(linked ? "1" : "0")+telegrams+"11111111";
            tcs.SendParameter("noretain(etcs::telegram", tel+")");
        }
        struct SpeedInfo
        {
            public float distance;
            public float speed;
            public float speedA;
            public float speedB;
            public string ToBinary(float prevdist=0, int m_version=33)
            {
                string el = format_etcs_distance(distance-prevdist) + format_etcs_speed(speed) + "0";
                var extra_speeds = new List<string>();
                if (m_version < 32)
                {
                    if (speedA > speed) extra_speeds.Add(format_binary(4, 4)+format_etcs_speed(speedA));
                    if (speedB > speedA) extra_speeds.Add(format_binary(6, 4)+format_etcs_speed(speedB));
                }
                else
                {
                    if (speedA > speed) extra_speeds.Add("00"+format_binary(3, 4)+format_etcs_speed(speedA));
                    if (speedB > speedA) extra_speeds.Add("00"+format_binary(5, 4)+format_etcs_speed(speedB));
                }
                el += format_binary(extra_speeds.Count, 5);
                for (int j=0; j<extra_speeds.Count; j++)
                {
                    el += extra_speeds[j];
                }
                return el;
            }
        }
        SpeedInfo GetSpeedLimit(int ahead, float maxDist)
        {
            float dist=float.MaxValue;
            float speed=-1;
            float speedA=-1;
            float speedB=-1;
            int currentNo = 0;
            float lastDist = 0;
            for (int i=0; i<40; i++)
            {
                var feat = tcs.NextSpeedPostFeatures(i, maxDist);
                if (feat.SpeedLimitMpS < 0) break;
                if (feat.DistanceM > maxDist) break;
                string name = feat.SpeedPostTypeName?.ToLowerInvariant();
                if (feat.IsWarning || name == "placa_2dig" || name == "placa_3dig" || name == "placa_4dig" || name == "renfecomlimperspltv" || name == "renfefinlimperspltv" || name == "lav_rasante1" || name == "lav_rasante2" || name == "lav_rasante3" || name == "lav_rasante4") continue;
                if (currentNo != ahead)
                {
                    if (feat.DistanceM - lastDist > 10) ++currentNo;
                }
                else
                {
                    if (feat.DistanceM - lastDist > 10 && speed >= 0) break;
                    float spd = Math.Min(feat.SpeedLimitMpS, tcs.LineSpeedMpS());
                    if (speed < 0)
                    {
                        speed = spd;
                        dist = feat.DistanceM;
                    }
                    else if (speedA < 0) speedA = spd;
                    else if (speedB < 0) speedB = spd;
                    else break;
                }
                lastDist = feat.DistanceM;
            }
            if (speedA < speed) speedA = speed;
            if (speedB < speedA) speedB = speedA;
            return new SpeedInfo {
                distance = dist,
                speed = speed,
                speedA = speedA,
                speedB = speedB,
            };
        }
        string get_ssp(float maend, float off, int m_version=33)
        {
            string ssp="01";
            List<string> elements = new List<string>();
            SpeedInfo currspd;
            if (CurrentSpeedPost == null)
            {
                float spd = Math.Min(tcs.CurrentPostSpeedLimitMpS(), tcs.LineSpeedMpS());
                currspd = new SpeedInfo{
                    distance = 0,
                    speed = spd,
                    speedA = spd,
                    speedB = spd,
                };
            }
            else
            {
                currspd = CurrentSpeedPost.Value;
                currspd.distance = 0;
            }
            for (int i=0; i<5; i++)
            {
                var feat = GetSpeedLimit(i, off);
                if (feat.speed < 0) break;
                currspd = feat;
                currspd.distance = 0;
            }
            elements.Add(currspd.ToBinary());
            List<SpeedInfo> speeds = new List<SpeedInfo>();
            float sspend = maend;
            for (int i=0; i<40 && speeds.Count < 25; i++)
            {
                var feat = GetSpeedLimit(i, sspend+off);
                if (feat.speed < 0) break;
                feat.distance -= off;
                if (feat.distance < 0) continue;
                speeds.Add(feat);
            }
            speeds.Sort((x,y) => x.distance.CompareTo(y.distance));
            float prevdist=0;
            for (int i=0; i<speeds.Count; i++)
            {
                elements.Add(speeds[i].ToBinary(prevdist, m_version));
                prevdist = speeds[i].distance;
            }
            elements.Add(format_etcs_distance(sspend-prevdist)+"1111111"+"0"+"00000");
            ssp += elements[0];
            ssp += format_binary(elements.Count-1, 5);
            for (int i=1; i<elements.Count; i++)
            {
                ssp += elements[i];
            }
            return create_packet(27, ssp, 1);
        }
        string get_gradient(float maxdist)
        {
            float altM = tcs.AltitudeM();//SignalObject.trItems[Locomotive().Train.signalRef.SignalObjects[bg.nid_bg].trItem].Y;
            float distM = group_position-tcs.DistanceM();
            float prevDistRef = 0;
            float distRef = 0;
            List<string> grads = new List<string>();
            for (int i=0; distM < maxdist; i++)
            {
                SignalFeatures sig = tcs.NextGenericSignalFeatures("NORMAL", i, maxdist);
                if (sig.DistanceM == float.MaxValue)
                {
                    break;
                }
                else
                {
                    float objDist = sig.DistanceM;
                    float objAlt = sig.AltitudeM;
                    float g = (objAlt-altM)/(objDist-distM)*1000;
                    if (g > 200) g = 200;
                    if (g < -200) g = -200;
                    string gr = format_etcs_distance((distRef-prevDistRef)/10);
                    if (g <= 0)
                    {
                        gr+="0"+format_binary(-(int)g, 8);
                    }
                    else
                    {
                        gr+="1"+format_binary((int)g, 8);
                    }
                    grads.Add(gr);
                    prevDistRef = distRef;
                    distRef = objDist;
                    altM = objAlt;
                    distM = objDist;
                }
            }
            if (grads.Count == 0)
                return create_packet(21,"10" + "000000000000000"+"0"+"00000000" + format_binary(1, 5) + format_etcs_distance(maxdist/10)+"0"+"11111111", 1);
            string grad = "10" + grads[0] + format_binary(grads.Count, 5);
            for(int i=1; i<grads.Count; i++)
            {
                grad += grads[i];
            }
            return create_packet(21, grad + format_etcs_distance((maxdist-prevDistRef)/10)+"0"+"11111111", 1);
        }
        string get_ltv(float end, float off)
        {
            int ltvCount = 1;
            StringBuilder tsrs = new StringBuilder();
            for (int i=0; i<25; i++)
            {
                var feat = tcs.NextSpeedPostFeatures(i, end+off);
                if (feat.SpeedLimitMpS < 0) break;
                string name = feat.SpeedPostTypeName?.ToLowerInvariant();
                if (name != "renfecomlimperspltv") continue;
                for (int j = i+1; j < i+10; j++)
                {
                    var feat2 = tcs.NextSpeedPostFeatures(j, float.MaxValue);
                    if (feat2.SpeedLimitMpS < 0) break;
                    name = feat2.SpeedPostTypeName?.ToLowerInvariant();
                    if (name != "renfefinlimperspltv") continue;
                    tsrs.Append(create_packet(65, "01"+format_binary(ltvCount++, 8)+format_etcs_distance(feat.DistanceM-off)+format_etcs_distance(feat2.DistanceM-feat.DistanceM)+"0"+format_etcs_speed(feat.SpeedLimitMpS), 1));
                    break;
                }
            }
            return tsrs.ToString();
        }
        struct TrackCondition
        {
            public float dist;
            public float length;
            public int type;
        }
        string get_conditions(float offset, float max, int m_version=33)
        {
            if (max > 30000) max = 30000;
            List<TrackCondition> conds = new List<TrackCondition>();
            float speed = tcs.CurrentPostSpeedLimitMpS();
            float brakingDist= Math.Min(Math.Max((speed*speed)/2/0.8f, 400), 4000);
            // Tunnels
            for (int i=0; ; i++)
            {
                TunnelInfo info = tcs.NextTunnel(i);
                if (info.DistanceM > max) break;
                if (info.LengthM<200) continue;
                TrackCondition nostop = new TrackCondition();
                nostop.type = 0;
                nostop.dist = info.DistanceM - offset/* - brakingDist*/;
                nostop.length = info.LengthM/* + brakingDist*/;
                conds.Add(nostop);
                TrackCondition airtight = new TrackCondition();
                airtight.type = 5;
                airtight.dist = info.DistanceM-200 - offset;
                airtight.length = info.LengthM+500;
                bool add = true;
                for (int j=0; j<conds.Count; j++)
                {
                    var other = conds[j];
                    if (other.type != 5) continue;
                    float diff = airtight.dist - other.dist - other.length;
                    if (diff < 1200)
                    {
                        other.length = airtight.dist + airtight.length - other.dist;
                        add = false;
                        conds[j] = other;
                        break;
                    }
                }
                if (add) conds.Add(airtight);
            }
            // Other conditions as indicated by info signals
            for (int i=0; ; i++)
            {
                var feat = tcs.NextGenericSignalFeatures("INFO", i, max);
                if (feat.DistanceM < 0 || feat.DistanceM > max) break;
                TrackCondition cond = new TrackCondition();
                cond.type = 15;
                string endname = "";
                if (feat.MainHeadSignalTypeName == "iniciozonaneutra")
                {
                    cond.type = 9;
                    endname = "finzonaneutra";
                }
                else if (feat.MainHeadSignalTypeName == "startneutro")
                {
                    cond.type = 9;
                    endname = "endneutro";
                }
                else if (feat.MainHeadSignalTypeName == "bajarpantografos")
                {
                    cond.type = 3;
                    endname = "subirpantografos";
                }
                else if (feat.MainHeadSignalTypeName == "inicioviaducto")
                {
                    cond.type = m_version < 32 ? 1 : 0;
                    endname = "finviaducto";
                }
                else if (feat.MainHeadSignalTypeName == "iniciopuente")
                {
                    cond.type = m_version < 32 ? 1 : 0;
                    endname = "finpuente";
                }
                else continue;
                cond.dist = feat.DistanceM-offset;
                cond.length = 200;
                for (int j=0; j<4; j++)
                {
                    var feat2 = tcs.NextGenericSignalFeatures("INFO", i+j, max); 
                    if (feat2.DistanceM < feat.DistanceM || feat2.DistanceM > max) break;
                    if (feat2.MainHeadSignalTypeName == endname)
                    {
                        cond.length = feat2.DistanceM-feat.DistanceM;
                        break;
                    }
                }
                if (m_version < 32 && (cond.type == 0 || cond.type == 1 || cond.type == 2 || cond.type == 3 || cond.type == 9))
                {
                    cond.dist -= brakingDist;
                    cond.length += brakingDist;
                }
                conds.Add(cond);
                if (m_version >= 32 && (cond.type == 3 || cond.type == 9))
                {
                    TrackCondition cond2 = new TrackCondition();
                    cond2.type = 0;
                    cond2.length = cond.length;
                    cond2.dist = cond.dist;
                    conds.Add(cond2);
                }
            }
            for (int i=0; i<conds.Count; i++)
            {
                var cond = conds[i];
                if (cond.dist < 0)
                {
                    cond.length += cond.dist;
                    cond.dist = 0;
                    conds[i] = cond;
                }
            }
            if (conds.Count == 0) return "";
            conds.Sort((x, y) => x.dist.CompareTo(y.dist));
            float cumdist=0;
            List<string> elements = new List<string>();
            for (int i=0; i<conds.Count; i++)
            {
                TrackCondition tc = conds[i];
                if (tc.dist < 0)
                {
                    tc.length += tc.dist;
                    tc.dist = 0;
                }
                if (tc.length <= 0) continue;
                string el = format_etcs_distance(tc.dist-cumdist) + format_etcs_distance(tc.length) + format_binary(tc.type, 4);
                elements.Add(el);
                cumdist = tc.dist;
            }
            if (elements.Count == 0) return "";
            string pack = "01"+"0";
            pack += elements[0];
            pack += format_binary(elements.Count-1, 5);
            for (int i=1; i<elements.Count; i++)
            {
                pack += elements[i];
            }
            return create_packet(68, pack, 1);
        }
        float get_pk(float mindist, out bool fwd)
        {
            float pk = 0;
            float pkdist = 0;
            fwd = true;
            for (int i=0; ; i++)
            {
                MilepostInfo info = tcs.NextMilepost(i);
                if (info.DistanceM < mindist)
                {
                    continue;
                }
                if (info.DistanceM > 4000 + mindist)
                {
                    return pk;
                }
                
                if (pk != 0)
                {
                    float pk2 = info.Value;
                    fwd = pk2 >= pk;
                    if (fwd) return pk-pkdist/1000;
                    else return pk + pkdist/1000;
                }
                pk = info.Value;
                pkdist = info.DistanceM - mindist;
            }
        }
        string get_tunnel_msg(float bgref, int ahead)
        {
            TunnelInfo info = tcs.NextTunnel(ahead);
            if (info.DistanceM > 32000 || info.DistanceM < 0) return "";
            float dist = info.DistanceM - bgref;
            float length = info.LengthM;
            return get_hito("Túnel ", dist, length);
        }
        string get_viaducto_msg(float bgref, int ahead)
        {
            for (int i=0; ; i++)
            {
                var feat = tcs.NextGenericSignalFeatures("INFO", i, 5000);
                if (feat.DistanceM < 0 || feat.DistanceM > 5000) break;
                if (feat.MainHeadSignalTypeName != "inicioviaducto") continue;
                if (ahead-- > 0) continue;
                for (int j=1; j<6; j++)
                {
                    var feat2 = tcs.NextGenericSignalFeatures("INFO", i+j, 32000); 
                    if (feat2.DistanceM < feat.DistanceM || feat2.DistanceM > 32000) break;
                    if (feat2.MainHeadSignalTypeName == "finviaducto")
                    {
                        return get_hito("Viaducto ", feat.DistanceM - bgref, feat2.DistanceM - feat.DistanceM);
                    }
                }
            }
            return "";
        }
        string get_puente_msg(float bgref, int ahead)
        {
            for (int i=0; ; i++)
            {
                var feat = tcs.NextGenericSignalFeatures("INFO", i, 5000);
                if (feat.DistanceM < 0 || feat.DistanceM > 5000) break;
                if (feat.MainHeadSignalTypeName != "iniciopuente") continue;
                if (ahead-- > 0) continue;
                for (int j=1; j<6; j++)
                {
                    var feat2 = tcs.NextGenericSignalFeatures("INFO", i+j, 32000); 
                    if (feat2.DistanceM < feat.DistanceM || feat2.DistanceM > 32000) break;
                    if (feat2.MainHeadSignalTypeName == "finpuente")
                    {
                        return get_hito("Puente ", feat.DistanceM - bgref, feat2.DistanceM - feat.DistanceM);
                    }
                }
            }
            return "";
        }
        string get_hito(string txt, float dist, float length)
        {
            bool fwd;
            float pk = get_pk(dist, out fwd);
            if (fwd) pk += length/2000;
            else pk -= length/2000;
            if (pk<0) pk = 0;
            double start = Math.Max(dist-1000, 0);
            double end = dist+length-start;
            if (length < 1000)
            {
                txt += "PK " + pk.ToString("0.0") + " L " + length.ToString("0.0") + "m";
            }
            else
            {
                txt += "PK " + pk.ToString("0.0") + " L " + (length/1000).ToString("0.0") + "km";
            }
            byte[] ascii = System.Text.Encoding.GetEncoding(28591).GetBytes(txt);
            string msg = "10" + format_binary(0,2) + "0" + format_etcs_distance(start/10) + format_binary(15,4) + format_binary(5,3) + format_etcs_distance(end/10) + format_binary(1023,10) + format_binary(15,4) + format_binary(5,3) + format_binary(0,2) + format_binary(ascii.Length, 8);
            for (int i=0; i<ascii.Length; i++)
            {
                msg += format_binary((int)ascii[i],8);
            }
            return create_packet(72, msg, 1);
        }
        public static string format_binary(int value, int size)
        {
            if (value < 0) value = 0;
            string tmp = Convert.ToString(value,2);
            string bin="";
            for (int i=0; i<size-tmp.Length; i++)
            {
                bin += "0";
            }
            bin += tmp;
            return bin;
        }
        public static string format_etcs_speed(double speedmps)
        {
            int val = Math.Min((int)Math.Round(speedmps*3.6)/5, 120);
            return format_binary(val, 7);
        }
        public static string format_etcs_speedKpH(double speedkph)
        {
            int val = Math.Min((int)Math.Round(speedkph)/5, 120);
            return format_binary(val, 7);
        }
        public static string format_etcs_distance(double distm)
        {
            int val = Math.Max(Math.Min((int)Math.Round(distm), 32767),0);
            return format_binary(val, 15);
        }
        public static string create_packet(int nid_packet, string info, int dir)
        {
            return format_binary(nid_packet, 8)+format_binary(dir, 2)+format_binary(info.Length+23,13)+info;
        }
        string create_message(int nid_message, bool ack, int nid_c, int nid_bg, string extra)
        {
            int size = (extra.Length + 75 + 7)/8;
            string pack = format_binary(nid_message, 8)+format_binary(size, 10)+format_binary(0, 32)+format_binary(ack ? 0 : 1, 1)+format_binary(nid_c,10)+format_binary(nid_bg,14)+extra;
            if (size * 8 > pack.Length) pack += format_binary(0, size * 8 - pack.Length);
            byte[] data = new byte[size];
            for (int i=0; i<size; i++)
            {
                for (int j=0; j<8; j++)
                {
                    data[i] += (byte)((pack[8*i+j]=='1' ? 1 : 0)<<(7-j));
                }
            }
            return Convert.ToBase64String(data);
        }
        bool SignalPassed = false;
        float PreviousSignalDistanceM = 0;
        Aspect PreviousSignalAspect;
		protected void UpdateSignalPassed()
        {
            SignalPassed = (tcs.NextSignalDistanceM(0) > PreviousSignalDistanceM+20)&&(tcs.SpeedMpS()>0.1f);
            PreviousSignalDistanceM = tcs.NextSignalDistanceM(0);
            if (SignalPassed && tcs.NextSignalAspect(0) == Aspect.None) SignalPassed = false;
            if (!SignalPassed) PreviousSignalAspect = tcs.NextSignalAspect(0);
        }
        bool InfillPassed=false;
        bool InfillReset=false;
        protected void UpdateInfillPassed()
        {
            InfillPassed = false;
            if (tcs.NextSignalDistanceM(0) < 300)
            {
                if (!InfillReset)
                {
                    InfillReset = true;
                    InfillPassed = true;
                }
            }
            if (SignalPassed) InfillReset = false;
        }
        class BaliseDataType
        {
            public float distance;
            public string type;
            public Aspect aspect;
            public string TextAspect;
            public int nid_bg;
            public int n_pig;
            public int n_total;
            public int m_version;
            public bool reverse_passed;
        }
        bool emularEurobalizas = false;
        BaliseDataType BuildBalise(string name, float distance, string aspect)
        {
            BaliseDataType b = new BaliseDataType();
            b.distance = distance;
            b.type = name;
            b.TextAspect = aspect;
            if (b.TextAspect.Length >= 50)
            {
                b.m_version = Convert.ToInt32(b.TextAspect.Substring(1, 7), 2);
                b.nid_bg = Convert.ToInt32(b.TextAspect.Substring(35, 14), 2);
                b.n_pig = Convert.ToInt32(b.TextAspect.Substring(9, 3), 2);
                b.n_total = Convert.ToInt32(b.TextAspect.Substring(12, 3), 2);
            }
            return b;
        }
        List<BaliseDataType> GetNextBalise(bool find_first, float min_distance, float max_distance, bool reverse_search = false, int num = 1, bool include_reverse=true, List<BaliseDataType> balises=null)
        {
            if (balises == null) balises = new List<BaliseDataType>();
            //float distance = 0;
            emularEurobalizas = tcs.NextGenericSignalDistanceM("ETCS") < 0;
            if (emularEurobalizas)
            {
                /*for (int i=0; balises.Count < num; i++)
                {
                    float sigdist = tcs.NextSignalDistanceM(i);
                    if (sigdist < 0) break;
                    // MA
                    {
                        float dist = sigdist - 10;
                        if (dist > max_distance) break;
                        if (dist >= min_distance)
                        {  
                            BaliseDataType b = BuildBalise("etcs_main_ma_1_2", dist, "");
                            if (!find_first || b.nid_bg != -1) balises.Add(b);
                        }
                    }
                    // Fija
                    {
                        float dist = sigdist - 5;
                        if (dist > max_distance) break;
                        if (dist >= min_distance)
                        {  
                            BaliseDataType b = BuildBalise("etcs_main_fixed_2_2", dist, "");
                            if (!find_first || b.nid_bg != -1) balises.Add(b);
                        }
                    }
                }*/
            }
            else
            {
                for (int i=0; balises.Count < num; i++)
                {
                    SignalFeatures sig = tcs.NextGenericSignalFeatures("ETCS", i, max_distance);
                    if (sig.DistanceM > max_distance || sig.DistanceM < 0) break;
                    if (sig.DistanceM < min_distance) continue;
                    BaliseDataType b = BuildBalise(sig.MainHeadSignalTypeName, sig.DistanceM, sig.TextAspect);
                    if (find_first && b.n_pig != 0) continue;
                    balises.Add(b);
                }
                if (include_reverse)
                {
                    for (int i=0; balises.Count <  2 * num; i++)
                    {
                        SignalFeatures sig = tcs.NextGenericSignalFeatures("ETCS_BACKFACING", i, max_distance);
                        if (sig.DistanceM > max_distance || sig.DistanceM < 0) break;
                        if (sig.DistanceM < min_distance) continue;
                        BaliseDataType b = BuildBalise(sig.MainHeadSignalTypeName, sig.DistanceM, sig.TextAspect);
                        if (find_first && b.n_pig != 0) continue;
                        b.reverse_passed = true;
                        balises.Add(b);
                    }
                }
            }
            /*else
            {
                Locomotive = tcs.Locomotive;
                int dir = ((tcs.CurrentTrainMUDirection() == Direction.Reverse) ^ reverse_search) ? 1 : 0;
                int fn_type = Locomotive().Train.signalRef.ORTSSignalTypes.IndexOf("ETCS");
                if (fn_type < 0)
                    return balises;
                
                if (Locomotive().Train.ValidRoute[dir] == null || Locomotive().Train.PresentPosition[0].TCSectionIndex < 0 || Locomotive().Train.PresentPosition[1].TCSectionIndex < 0)
                    return balises;
                    
                int index = dir == 0 ? Locomotive().Train.PresentPosition[0].RouteListIndex : 
                    Locomotive().Train.ValidRoute[1].GetRouteIndex(Locomotive().Train.PresentPosition[1].TCSectionIndex, 0);
                if (index < 0)
                    return balises;
                
                float lengthOffset = (dir == 1) ? (-Locomotive().Train.PresentPosition[1].TCOffset +
                        Locomotive().Train.signalRef.TrackCircuitList[Locomotive().Train.PresentPosition[1].TCSectionIndex].Length) : Locomotive().Train.PresentPosition[0].TCOffset;
                float totalLength = 0;//-tcs.TrainLengthM()+3;
                //if ((tcs.IsFlipped() || tcs.IsRearCab())^(dir == 1)) totalLength = -3;
                var routePath = Locomotive().Train.ValidRoute[dir];
                int fwd_candidates = 0;
                int rev_candidates = 0;
                while (index < routePath.Count && totalLength < max_distance && balises.Count < num)
                {
                    var thisElement = routePath[index];
                    var thisSection = Locomotive().Train.signalRef.TrackCircuitList[thisElement.TCSectionIndex];
                    var thisSignalList = thisSection.CircuitItems.TrackCircuitSignals[thisElement.Direction][fn_type];
                    foreach (var thisSignal in thisSignalList.TrackCircuitItem)
                    {
                        if (thisSignal.SignalLocation > lengthOffset)
                        {
                            BaliseDataType b = BuildBalise(thisSignal.SignalRef.SignalHeads[0].SignalTypeName, thisSignal.SignalLocation - lengthOffset + totalLength, thisSignal.SignalRef.SignalHeads[0].TextSignalAspect);
                            if (find_first && b.n_pig != 0) continue;
                            if (b.distance < min_distance) continue;
                            balises.Add(b);
                            fwd_candidates++;
                            if (fwd_candidates >= num) break;
                        }
                    }
                    thisSignalList = thisSection.CircuitItems.TrackCircuitSignals[1-thisElement.Direction][fn_type];
                    
                    List<TrackCircuitSignalItem> list = new List<TrackCircuitSignalItem>();
                    list.AddRange(thisSignalList.TrackCircuitItem);
                    list.Reverse();
                    foreach (var thisSignal in list)
                    {
                        if ((thisSection.Length - thisSignal.SignalLocation) > lengthOffset)
                        {
                            BaliseDataType b = BuildBalise(thisSignal.SignalRef.SignalHeads[0].SignalTypeName, (thisSection.Length - thisSignal.SignalLocation) - lengthOffset + totalLength, thisSignal.SignalRef.SignalHeads[0].TextSignalAspect);
                            if (find_first && b.n_pig != 0) continue;
                            if (b.distance < min_distance) continue;
                            b.reverse_passed = true;
                            balises.Add(b);
                            rev_candidates++;
                            if (rev_candidates >= num) break;
                        }
                    }
                    totalLength += (thisSection.Length - lengthOffset);
                    lengthOffset = 0;

                    index++;
                }
            }*/
            balises.Sort((x,y) => x.distance.CompareTo(y.distance));
            return balises;
        }
        List<BaliseDataType> BaliseProximity = new List<BaliseDataType>();
        List<BaliseDataType> BalisesPassed = new List<BaliseDataType>();
        float group_position = 0;
        float last_passed = 0;
        int nid_bg = -1;
        protected void UpdateEurobalise()
        {
            BalisesPassed.Clear();
            if (BaliseProximity.Count > 0)
            {
                var balisesAhead = GetNextBalise(false, 0, 15, false, 8, true);
                foreach (var balise in BaliseProximity)
                {
                    bool ahead = false;
                    foreach (var bal in balisesAhead)
                    {
                        if (bal.nid_bg == balise.nid_bg && bal.n_pig == balise.n_pig)
                        {
                            ahead = true;
                            break;
                        }
                    }
                    if (ahead) break;
                    BalisesPassed.Add(balise);
                }
                BaliseProximity = balisesAhead;
            }
            else
            {
                GetNextBalise(false, 0, 15, false, 8, true, BaliseProximity);
            }
            if (BalisesPassed.Count > 0)
            {
                var BalisePassed = BalisesPassed[0];
                if (nid_bg != BalisePassed.nid_bg) group_position = 0;
                nid_bg = BalisePassed.nid_bg;
                if (BalisePassed.n_pig == 0) group_position = last_passed;
                else if (group_position == 0 && BalisePassed.reverse_passed)
                {
                    List<BaliseDataType> bgrefs = GetNextBalise(true, 0, 24);
                    BaliseDataType bgref = bgrefs.Count == 0 ? null : bgrefs[0];
                    if (bgref != null && bgref.nid_bg == nid_bg)
                    {
                        group_position = tcs.DistanceM()+bgref.distance;
                    }
                }
                if (group_position == 0) group_position = last_passed;
            }
            if (BaliseProximity.Count > 0) last_passed = tcs.DistanceM()+BaliseProximity[0].distance;
        }
        float parseFloat(string s)
        {
            if (s.Length == 0) return 0;
            double val = 0;
            double.TryParse(s.Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out val);
            return (float)val;
        }
        public struct SimpleJSON
        {
            string json;
            int index;
            bool readingContent;
            static char[] trim = new char[]{' ', '\n', '\r'};
            public SimpleJSON(string str)
            {
                index = 0;
                readingContent = false;
                int start = str.IndexOf('{');
                int end = str.LastIndexOf('}');
                if (start < 0 || end < 0 || start>end) json = "";
                else json = str.Substring(start+1, end-start-1);
            }
            public string GetNextField()
            {
                if (readingContent) GetContent();
                bool escape = false;
                int start = -1;
                int end = -1;
                for (int i=index; i<json.Length; i++)
                {
                    if (start >= 0 && json[i] == '\\') escape = !escape; 
                    else escape = false;
                    if (json[i] == '"' && !escape)
                    {
                        if (start < 0) start = i;
                        else
                        {
                            end = i;
                            break;
                        }
                    }
                }
                if (start < 0 || end < 0)
                {
                    index = json.Length;
                    return null;
                }
                index = end + 1;
                readingContent = true;
                return json.Substring(start+1, end-start-1);
            }
            public string GetContent()
            {
                if (!readingContent) return null;
                int start = -1;
                int end = -1;
                int currentdepth = 0;
                bool inString = false;
                bool escape = false;
                for (int i=index; i<json.Length && end < 0 && currentdepth >= 0; i++)
                {
                    if (json[i] == ':' && start < 0) start = i+1;
                    if (start < 0) continue;
                    switch(json[i])
                    {
                        case '\\':
                            escape = !escape && inString;
                            break;
                        case '"':
                            if (!escape) inString = !inString;
                            break;
                        case '{':
                        case '[':
                            if (!inString) currentdepth++;
                            break;
                        case '}':
                        case ']':
                            if (!inString) currentdepth--;
                            break;
                        case ',':
                            if (currentdepth == 0 && !inString) end = i;
                            break;
                    }
                    if (!inString || json[i] != '\\') escape = false;
                }
                if (end < 0) end = json.Length;
                string val = json.Substring(start, end-start).Trim(trim);
                index = end+1;
                readingContent = false;
                return val;
            }
            public float? GetFloat()
            {
                double num;
                if (!double.TryParse(GetContent(), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out num)) return null;
                return (float)num;
            }
            public float? GetSpeedMpS()
            {
                float? f = GetFloat();
                if (f == null) return null;
                return MpS.FromKpH((float)Math.Round(MpS.ToKpH(f.Value)));
            }
            public int? GetInt()
            {
                int num;
                if (!int.TryParse(GetContent(), out num)) return null;
                return num;
            }
            public string GetString()
            {
                string c = GetContent();
                return c.Substring(1, c.Length-2);
            }
            public IEnumerable<string> GetArrayContent()
            {
                string cont = GetContent();
                int start = 1;
                int currentdepth = 0;
                bool inString = false;
                bool escape = false;
                for (int i=1; i<cont.Length; i++)
                {
                    switch(cont[i])
                    {
                        case '\\':
                            escape = !escape && inString;
                            break;
                        case '"':
                            if (!escape) inString = !inString;
                            break;
                        case '{':
                        case '[':
                            if (!inString) currentdepth++;
                            break;
                        case '}':
                        case ']':
                            if (!inString) currentdepth--;
                            break;
                        case ',':
                            if (currentdepth == 0 && !inString)
                            {
                                string s = cont.Substring(start, i-start).Trim(trim);
                                if (s.Length > 0) yield return s;
                                start = i+1;
                            }
                            break;
                    }
                    if (!inString || cont[i] != '\\') escape = false;
                }
                if (start < cont.Length)
                {
                    string s = cont.Substring(start, cont.Length-1-start).Trim(trim);
                    if (s.Length > 0) yield return s;
                }
            }
        }
        Dictionary<int, TextMessage> MessageList = new Dictionary<int, TextMessage>();
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = new List<Parameter>();
            
            Parameter p;
            
            p = new Parameter("etcs::emergency");
            p.SetValue = (string val) => {Emergency = val!="0" && val!="false";};
            l.Add(p);
            
            
            p = new Parameter("etcs::asc");
            p.SetValue = (string val) => {
                ATOVperm = null;
                ATOTargets.Clear();
                ATOVrelease = 0;
                var j = new SimpleJSON(val);
                string f = j.GetNextField();
                while (f != null)
                {
                    if (f == "AllowedSpeedMpS") ATOVperm = j.GetFloat();
                    else if (f == "ReleaseSpeedMpS") ATOVrelease = j.GetFloat() ?? 0;
                    else if (f == "Targets")
                    {
                        foreach (string s in j.GetArrayContent())
                        {
                            float dist=0;
                            float speed=0;
                            var j2 = new SimpleJSON(s);
                            f = j2.GetNextField();
                            while (f != null)
                            {
                                if (f == "TargetSpeedMpS") speed = j2.GetFloat() ?? 0;
                                else if (f == "TargetLocationM") dist = j2.GetFloat() ?? 0;
                                f = j2.GetNextField();
                            }
                            ATOTargets[dist] = speed;
                        }
                    }
                    f = j.GetNextField();
                }
                /*string[] spds = val.Split(';');
                ATOTargets.Clear();
                if (spds.Length > 0 && double.TryParse(spds[0].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out double spd))
                {
                    ATOVperm = (float)spd;
                    for (int i=1; i<spds.Length-1; i+=2)
                    {
                        if (double.TryParse(spds[i].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out double dist) && double.TryParse(spds[i+1].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out spd))
                        {
                            ATOTargets[(float)dist] = (float)spd;
                        }
                    }
                }
                else
                {
                    ATOVperm = null;
                }*/
            };
            l.Add(p);
            
            p = new Parameter("etcs::fullbrake");
            p.SetValue = (string val) => {FullBrake = val=="1" || val=="true";};
            l.Add(p);
            
            p = new Parameter("etcs::tractioncutoff");
            p.SetValue = (string val) => {TCO = val=="1" || val=="true";};
            l.Add(p);

            p = new Parameter("etcs::isolated");
            p.SetValue = (string val) => {
                Isolated = val=="1" || val=="true";
                tcs.SetCabDisplayControl(IsolationButton, Isolated ? 1 : 0);
            };
            p.GetValue = () => Isolated ? "1" : "0";
            l.Add(p);

            p = new Parameter("etcs::button::ack::light");
            p.SetValue = (string val) => {
                tcs.SetCabDisplayControl(AckButton, int.Parse(val));
            };
            
            /*p = new Parameter("etcs::lower_pantographs");
            p.SetValue = (string val) => {
                string[] dists = val.Split(';');
                EndLowPantographSection = double.MinValue;
                StartLowPantographSection = double.MaxValue;
                if (dists.Length > 1 && dists[1].Length > 0)
                {
                    StartLowPantographSection = float.MinValue;
                    double.TryParse(dists[1].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out EndLowPantographSection);
                }
                if (dists.Length > 0 && dists[0].Length > 0) double.TryParse(dists[0].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out StartLowPantographSection);
            };
            l.Add(p);*/
            
            p = new Parameter("etcs::data_entry_type");
            p.GetValue = () => {
                if (tcs.Serie == 252 || tcs.Serie == 109) return "2";
                return "-1";
            };
            l.Add(p);

            p = new Parameter("etcs::set_speed_display");
            p.GetValue = () => (tcs.Serie == 253 ? "1" : "0");
            l.Add(p);
            
            /*p = new Parameter("etcs::neutral_section");
            p.SetValue = (string val) => {
                string[] dists = val.Split(';');
                EndNeutralSectionDistanceM = double.MinValue;
                StartNeutralSectionDistanceM = double.MaxValue;
                if (dists.Length > 1 && dists[1].Length > 0)
                {
                    StartNeutralSectionDistanceM = float.MinValue;
                    double.TryParse(dists[1].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out EndNeutralSectionDistanceM);
                }
                if (dists.Length > 0 && dists[0].Length > 0) double.TryParse(dists[0].Replace(',','.'), NumberStyles.Number, CultureInfo.InvariantCulture.NumberFormat, out StartNeutralSectionDistanceM);
            };
            l.Add(p);*/

            p = new Parameter("etcs::obu_tr");
            p.SetValue = (string val) => {
                if (val == "")
                {
                    NeutralSection = null;
                    LowerPantographSection = null;
                    return;
                }
                SimpleJSON j = new SimpleJSON(val);
                string field;
                while ((field = j.GetNextField()) != null)
                {
                    switch (field)
                    {
                        case "OBU_TR_MPS_Cmd":
                            if (NeutralSection == null) NeutralSection = new TrackConditionProfile();
                            NeutralSection.Active = j.GetContent() == "false";
                            break;
                        case "OBU_TR_PG_Cmd":
                            if (LowerPantographSection == null) LowerPantographSection = new TrackConditionProfile();
                            LowerPantographSection.Active = j.GetContent() == "true";
                            break;
                        case "TrackConditions":
                            if (NeutralSection == null) NeutralSection = new TrackConditionProfile();
                            if (LowerPantographSection == null) LowerPantographSection = new TrackConditionProfile();
                            NeutralSection.DistancesM.Clear();
                            LowerPantographSection.DistancesM.Clear();
                            foreach (var cond in j.GetArrayContent())
                            {
                                SimpleJSON j2 = new SimpleJSON(cond);
                                int type=32;
                                double? start=null;
                                double? end=null;
                                while ((field = j2.GetNextField()) != null)
                                {
                                    switch (field)
                                    {
                                        case "StartDistanceToTrainM":
                                            start = j2.GetFloat();
                                            break;
                                        case "EndDistanceToTrainM":
                                            end = j2.GetFloat();
                                            break;
                                        case "Type":
                                            type = j2.GetInt() ?? 32;
                                            break;
                                    }
                                }
                                if (type == 6) NeutralSection.DistancesM.Add((start, end));
                                else if (type == 5) LowerPantographSection.DistancesM.Add((start, end));
                            }
                            break;
                        case "TractionSystemChange":
                            {
                                SimpleJSON j2 = new SimpleJSON(j.GetContent());
                                while ((field = j2.GetNextField()) != null)
                                {
                                    switch (field)
                                    {
                                        case "DistanceToTrainM":
                                            break;
                                        case "M_VOLTAGE":
                                            break;
                                        case "NID_CTRACTION":
                                            break;
                                    }
                                }
                            }
                            break;
                    }
                }
            };
            l.Add(p);

            p = new Parameter("etcs::dmi::command");
            p.SetValue = (string recvdata) =>
            {
                int spl1 = recvdata.IndexOf('(');
                int spl2 = recvdata.LastIndexOf(')');
                if (spl1 < 0 || spl2 < 0) return;
                string command = recvdata.Substring(0, spl1);
                string value = recvdata.Substring(spl1 + 1, spl2 - spl1 - 1);
                if (command == "json")
                {
                    tcs.ETCSStatus.IndicationMarkerDistanceM = null;
                    tcs.ETCSStatus.IndicationMarkerTarget = null;
                    string status = null;
                    var j = new SimpleJSON(value);
                    while(true)
                    {
                        string f = j.GetNextField();
                        if (f == null) break;
                        if (f == "Status")
                        {
                            status = j.GetContent();
                            break;
                        }
                    }
                    if (status == null) return;
                    j = new SimpleJSON(status);
                    string field = j.GetNextField();
                    while (field != null)
                    {
                        switch (field)
                        {
                            case "AllowedSpeedMpS": if (CurrentMode != Mode.SN) tcs.ETCSStatus.AllowedSpeedMpS = j.GetSpeedMpS() ?? 0; break;
                            case "TargetSpeedMpS": if (CurrentMode != Mode.SN) tcs.ETCSStatus.TargetSpeedMpS = j.GetSpeedMpS(); break;
                            case "InterventionSpeedMpS": if (CurrentMode != Mode.SN) tcs.ETCSStatus.InterventionSpeedMpS = j.GetSpeedMpS() ?? 0; break;
                            case "ReleaseSpeedMpS":
                                if (CurrentMode == Mode.SN) break;
                                if (tcs.ETCSStatus.TargetSpeedMpS == 0) tcs.ETCSStatus.ReleaseSpeedMpS = j.GetSpeedMpS();
                                else tcs.ETCSStatus.ReleaseSpeedMpS = null;
                                break;
                            case "CurrentMonitoringStatus": if (CurrentMode != Mode.SN) tcs.ETCSStatus.CurrentMonitor = (Monitor)j.GetInt().Value; break;
                            case "CurrentSupervisionStatus": if (CurrentMode != Mode.SN) tcs.ETCSStatus.CurrentSupervisionStatus = (SupervisionStatus)j.GetInt().Value; break;
                            case "CurrentMode":
                            {
                                CurrentMode = (Mode)j.GetInt().Value;
                                tcs.ETCSStatus.CurrentMode = CurrentMode;
                                break;
                            }
                            case "CurrentNTC":
                                if (tcs.ETCSStatus.CurrentMode == Mode.SN && j.GetInt().Value != 0) tcs.ETCSStatus.CurrentMode = Mode.FS;
                                break;
                            case "TargetDistanceM":
                            {
                                if (CurrentMode == Mode.SN) return;
                                float? f = j.GetFloat();
                                if (tcs.ETCSStatus.TargetSpeedMpS < tcs.ETCSStatus.AllowedSpeedMpS && f > 0) tcs.ETCSStatus.TargetDistanceM = f;
                                else tcs.ETCSStatus.TargetDistanceM = null;
                                break;
                            }
                            case "TimeToPermittedS":
                            {
                                float? f = j.GetFloat();
                                if (f == null || f.Value >= 20 || tcs.ETCSStatus.CurrentMonitor == Monitor.CeilingSpeed || tcs.ETCSStatus.CurrentMode != Mode.FS) tcs.ETCSStatus.TimeToPermittedS = null;
                                else tcs.ETCSStatus.TimeToPermittedS = f.Value;
                                break;
                            }
                            case "GradientProfile":
                            {
                                tcs.ETCSStatus.GradientProfile.Clear();
                                foreach (string s in j.GetArrayContent())
                                {
                                    var j2 = new SimpleJSON(s);
                                    int grad=0;
                                    float dist=0;
                                    field = j2.GetNextField();
                                    while (field != null)
                                    {
                                        if (field == "DistanceToTrainM") dist = j2.GetFloat() ?? 0;
                                        else if (field == "GradientPerMille") grad = j2.GetInt().Value;
                                        field = j2.GetNextField();
                                    }
                                    tcs.ETCSStatus.GradientProfile.Add(new GradientProfileElement(dist, grad));
                                }
                                break;
                            }
                            case "PlanningTrackConditions":
                            {
                                tcs.ETCSStatus.PlanningTrackConditions.Clear();
                                foreach (string s in j.GetArrayContent())
                                {
                                    var j2 = new SimpleJSON(s);
                                    int type=0;
                                    float dist=0;
                                    bool yellow=false;
                                    field = j2.GetNextField();
                                    while (field != null)
                                    {
                                        if (field == "DistanceToTrainM") dist = j2.GetFloat() ?? 0;
                                        else if (field == "Type") type = j2.GetInt().Value;
                                        else if (field == "YellowColour") yellow = j2.GetContent()=="true";
                                        field = j2.GetNextField();
                                    }
                                    tcs.ETCSStatus.PlanningTrackConditions.Add(new PlanningTrackCondition((TrackConditionType)type, yellow, dist));
                                }
                                break;
                            }
                            case "SpeedTargets":
                            {
                                tcs.ETCSStatus.SpeedTargets.Clear();
                                foreach (string s in j.GetArrayContent())
                                {
                                    var j2 = new SimpleJSON(s);
                                    float speed=0;
                                    float dist=0;
                                    field = j2.GetNextField();
                                    while (field != null)
                                    {
                                        if (field == "DistanceToTrainM") dist = j2.GetFloat() ?? 0;
                                        else if (field == "TargetSpeedMpS") speed = j2.GetSpeedMpS().Value;
                                        field = j2.GetNextField();
                                    }
                                    tcs.ETCSStatus.SpeedTargets.Add(new PlanningTarget(dist, speed));
                                }
                                break;
                            }
                            case "IndicationMarkerDistanceM": tcs.ETCSStatus.IndicationMarkerDistanceM = j.GetFloat(); break;
                            case "IndicationMarkerTarget":
                            {
                                tcs.ETCSStatus.IndicationMarkerTarget = null;
                                string s = j.GetContent();
                                if (s != "null")
                                {
                                    var j2 = new SimpleJSON(s);
                                    float speed=-1;
                                    float dist=0;
                                    field = j2.GetNextField();
                                    while (field != null)
                                    {
                                        if (field == "DistanceToTrainM") dist = j2.GetFloat() ?? 0;
                                        else if (field == "TargetSpeedMpS") speed = j2.GetFloat().Value;
                                        field = j2.GetNextField();
                                    }
                                    if (speed >= 0) tcs.ETCSStatus.IndicationMarkerTarget = new PlanningTarget(dist, speed);
                                }
                                break;
                            }
                        }
                        field = j.GetNextField();
                    }
                }
                else if (command == "setMessage")
                {
                    string[] split1 = value.Split(',');
                    int id = int.Parse(split1[0]);
                    int size = int.Parse(split1[1]);
                    value = value.Substring(split1[0].Length+split1[1].Length+2);
                    size = System.Text.Encoding.UTF8.GetString(System.Text.Encoding.UTF8.GetBytes(value), 0, size).Length;
                    string text = value.Substring(0, size);
                    string[] split2 = value.Substring(size+1).Split(',');
                    int hour = int.Parse(split2[0]);
                    int min = int.Parse(split2[1]);
                    bool fg = split2[2] == "true";
                    bool ack = split2[3] == "true";
                    TextMessage msg = new TextMessage(text, hour*3600+min*60, fg, ack);
                    MessageList[id] = msg;
                    if (tcs.ETCSStatus.TextMessages.Contains(msg)) tcs.ETCSStatus.TextMessages.Remove(msg);
                    tcs.ETCSStatus.TextMessages.Insert(0, msg);
                }
                else if (command == "setRevokeMessage")
                {
                    int num = int.Parse(value);
                    TextMessage msg;
                    if (MessageList.TryGetValue(num, out msg))
                    {
                        tcs.ETCSStatus.TextMessages.Remove(msg);
                        MessageList.Remove(num);
                    }
                }
            };
            l.Add(p);

            return l;
        }
    }
    public abstract class ASFA : InteractiveTCS
    {
        public enum Freq
        {
            FP,
            L1,
            L2,
            L3,
            L4,
            L5,
            L6,
            L7,
            L8,
            L9,
            L10,
            L11,
            AL
        }
        float LVIstart = 0;
        Freq lvi1 = Freq.L11;
        Freq lvi2 = Freq.L11;
        bool LineaEquipadaComprobado = false;
        bool LineaEquipada = false;
        public ASFA(ServerTCS tcs) : base(tcs)
        {
        }
        public override void Update()
        {
            if(!LineaEquipadaComprobado)
            {
                LineaEquipada = tcs.NextGenericSignalDistanceM("ASFA") >= 0;
                LineaEquipadaComprobado = true;
            }
            UpdateSignalPassed();
            UpdateDistanciaPrevia();
        }
        
        Freq GetBalizaAspect()
        {
            if (!LineaEquipada)
            {
                for(int i=0; i<4; i++)
                {
                    if(tcs.NextPostDistanceM(i)<=1500 && tcs.NextPostDistanceM(i)>=1495 && tcs.CurrentPostSpeedLimitMpS() - tcs.NextPostSpeedLimitMpS(i)>=MpS.FromKpH(40))
                    {
                        return Freq.L1;
                    }
                }
                float dprevia = tcs.NextSignalDistanceM(0)-PreviaDistance+10;
                switch (tcs.NextSignalAspect(0))
                {
                    case Aspect.Stop:
                    case Aspect.StopAndProceed:
                    case Aspect.Restricted:
                    case Aspect.Permission:
                        return (dprevia>0 && PreviaDistance > 0) ? Freq.L7 : Freq.L8;
                    case Aspect.Approach_1:
                    case Aspect.Approach_2:
                    case Aspect.Approach_3:
                        return Freq.L1;
                    case Aspect.Clear_1:
                        return Freq.L2;
                    case Aspect.Clear_2:
                        return Freq.L3;
                    default:
                        return Freq.FP;
                }
            }
            else
            {
                string name = tcs.NextGenericSignalMainHeadSignalType("ASFA");
                switch(tcs.NextGenericSignalFeatures("ASFA", 0, 10).TextAspect)
                {
                    case "FP":
                        return Freq.FP;
                    case "L1":
                        return Freq.L1;
                    case "L2":
                        return Freq.L2;
                    case "L3":
                        return Freq.L3;
                    case "L4":
                        return Freq.L4;
                    case "L5":
                        return Freq.L5;
                    case "L6":
                        return Freq.L6;
                    case "L7":
                        return Freq.L7;
                    case "L8":
                        return Freq.L8;
                    case "L9":
                        return Freq.L9;
                    case "L10":
                        return Freq.L10;
                    case "L11":
                        return Freq.L11;
                    case "":
                        switch(tcs.NextGenericSignalAspect("ASFA"))
                        {
                            case Aspect.Permission:
                            case Aspect.Stop:
                                return Freq.L8;
                            case Aspect.StopAndProceed:
                                return Freq.L7;
                            case Aspect.Restricted:
                                return Freq.L4;
                            case Aspect.Approach_1:
                                return Freq.L1;
                            case Aspect.Approach_2:
                                return Freq.L5;
                            case Aspect.Approach_3:
                                return Freq.L6;
                            case Aspect.Clear_1:
                                return Freq.L2;
                            case Aspect.Clear_2:
                                return Freq.L3;
                            default:
                                return Freq.FP;
                        }
                    default:
                        return Freq.AL;
                }
                return Freq.FP;
            }
        }
        float GetBalizaDistance()
        {
            if (!LineaEquipada)
            {
                for(int i=0; i<4; i++)
                {
                    if(tcs.NextPostDistanceM(i)<=1500 && tcs.NextPostDistanceM(i)>=1495 && tcs.CurrentPostSpeedLimitMpS() - tcs.NextPostSpeedLimitMpS(i)>=MpS.FromKpH(40))
                    {
                        return tcs.NextPostDistanceM(i)-1495;
                    }
                }
                float dprevia = tcs.NextSignalDistanceM(0)-PreviaDistance+10;
                if (dprevia>0 && PreviaDistance > 0)
                    return dprevia;
                
                return tcs.NextSignalDistanceM(0);
                /*if(LVIstart==0)
                {
                    for(int i=0; i<4; i++)
                    {
                        if(tcs.NextPostDistanceM(i)>1500 || tcs.NextPostDistanceM(i)<1495) continue;
                        if(tcs.CurrentPostSpeedLimitMpS()-tcs.NextPostSpeedLimitMpS(i)>=MpS.FromKpH(40))
                        {
                            LVIstart = tcs.DistanceM();
                            float speed = MpS.ToKpH(tcs.NextPostSpeedLimitMpS(i));
                            if (speed < 50) lvi1 = lvi2 = Freq.L11;
                            else if (speed < 80)
                            {
                                lvi1 = Freq.L11;
                                lvi2 = Freq.L10;
                            }
                            else if (speed < 120)
                            {
                                lvi1 = Freq.L10;
                                lvi2 = Freq.L11;
                            }
                            else lvi1 = lvi2 = Freq.L10;
                        }
                    }
                }*/
            }
            else
            {
                return tcs.NextGenericSignalDistanceM("ASFA");
            }
        }
        
        float fail;
        float fail_odometer;
        
        Freq prevBalizaAspect = Freq.FP;
        float prevBalizaDistance = -1;
        public Freq Baliza()
        {
            int random_level = 1;
            int random_max = 1000;
            if (random_level == 2) random_max = 500;
            else if (random_level == 3) random_max = 100;
                
            if (random_level > 0 && tcs.DistanceM()-fail_odometer > 1000) {
                if (ServerTCS.Random.Next(1,random_max) == 5)
                    fail = tcs.ClockTime();
                fail_odometer = tcs.DistanceM();
            }
            if (tcs.ClockTime()-fail<0.5f)
                return Freq.AL;
            
            float dist = GetBalizaDistance();
            if (prevBalizaDistance >= 0 && prevBalizaAspect != Freq.FP && prevBalizaDistance + 3 < dist)
            {
                Freq f = prevBalizaAspect;
                prevBalizaAspect = Freq.FP;
                return f;
            }
            if (dist<5 && dist>0)
            {
                prevBalizaDistance = dist;
                prevBalizaAspect = GetBalizaAspect();
            }
            else
            {
                prevBalizaAspect = Freq.FP;
            }
            if (dist<0.3 && dist>0)
            {
                return prevBalizaAspect;
            }
            return Freq.FP;
        }
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = new List<Parameter>();
            
            Parameter p;
            
            p = new Parameter("asfa::emergency");
            p.SetValue = (string val) => {Emergency = val!="0" && val!="false";};
            l.Add(p);
            
            p = new Parameter("asfa::frecuencia");
            p.GetValue = () => Baliza().ToString();
            l.Add(p);
            
            return l;
        }
        bool SignalPassed = false;
        float PreviousSignalDistanceM = 0;
        bool PreviaPassed = false;
        bool LineaConvencional = true;
        float PreviaDistance = 300;
        float AnuncioDistance = 1500f;
        protected void UpdateSignalPassed()
        {
            SignalPassed = (tcs.NextSignalDistanceM(0) > PreviousSignalDistanceM+20)&&(tcs.SpeedMpS()>0.1f);
            PreviousSignalDistanceM = tcs.NextSignalDistanceM(0);
            if (SignalPassed && tcs.NextSignalAspect(0) == Aspect.None) SignalPassed = false;
        }
        protected void UpdateDistanciaPrevia()
        {
            if (SignalPassed)
            {
                if ((tcs.NextSignalAspect(0) == Aspect.Clear_2 && tcs.NextSignalSpeedLimitMpS(0) < MpS.FromKpH(165f) && tcs.NextSignalSpeedLimitMpS(0) > MpS.FromKpH(155f)) || (tcs.NextSignalAspect(0) == Aspect.Approach_1 && tcs.NextSignalSpeedLimitMpS(0) < MpS.FromKpH(35f) && tcs.NextSignalSpeedLimitMpS(0) > MpS.FromKpH(25f)))
                {
                    PreviaDistance = 0;
                }
                else
                {
                    if (LineaConvencional)
                    {
                        if (tcs.NextSignalDistanceM(0) < 100f)
                        {
                            PreviaDistance = 0f;
                        }
                        else if (tcs.NextSignalDistanceM(0) < 400f)
                        {
                            PreviaDistance = 50f;
                        }
                        else if (tcs.NextSignalDistanceM(0) < 700f)
                        {
                            PreviaDistance = 100f;
                        }
                        else
                        {
                            PreviaDistance = 300f;
                        }
                    }
                    else
                    {
                        if (tcs.NextSignalDistanceM(0) < 100f)
                        {
                            PreviaDistance = 0f;
                        }
                        else if (tcs.NextSignalDistanceM(0) < 700f)
                        {
                            PreviaDistance = 100f;
                        }
                        else if (tcs.NextSignalDistanceM(0) < 1000f)
                        {
                            PreviaDistance = 300f;
                        }
                        else
                        {
                            PreviaDistance = 500f;
                        }
                    }
                }
            }
        }
    }
    public class ASFAclasico : ASFA
    {
        bool Anulado = false;
        public bool Encendido = false;
        bool Urgencia = false;
        bool RebaseAuto = false;
        bool Eficacia = false;
        protected bool ASFADual = false;
        public bool ASFA200 = true;
        public bool ASFAAVE = false;
        bool RecL2;
        bool AKT = false;
        bool CON = true;
        bool AKT_ETCS = false;
        bool CON_ETCS = true;
        bool AKT_LZB = false;
        bool CON_LZB = true;
        float LastCON;
        public int TipoTren;
        ulong RECStarted = 0;
        ulong RojoStarted = 0;
        ulong AlarmaStarted = 0;
        ulong RebaseStarted = 0;
        ulong CondStarted = 0;
        ulong FrenarStarted = 0;
        int Velocidad = 0;
        ulong Previous;
        ulong LastPConex;
        protected ulong BuzzEnd = 0;

        bool ZumbadorOn;

        public int PConex = 2;
        public int PREC = 3;
        public int PAlarma = 4;
        public int PRearme = 5;
        public int PRebase = 6;
        public int PModo = 7;
        public int LuzFrenar = 12;
        public int LuzL2 = 13;
        public int LuzRojo = 14;
        public int LuzVL = 15;
        public int LuzCV = 16;
        public int LuzEficacia = 17;
        public int LuzRenfe = 18;
        public int LuzConex = 2;
        public int LuzREC = 3;
        public int LuzAlarma = 4;
        public int LuzRearme = 5;
        public int LuzRebase = 6;
        public int LuzAVE = 7;
        
        int PulsadoresCG;
        
        Freq prev_freq;
        Freq freq;
        
        protected EBICAB_STM stm;
        
        protected virtual void buzz(ulong time)
        {
            if (time == 500) tcs.TriggerSoundInfo1();
            else tcs.TriggerSoundPenalty1();
            BuzzEnd = millis() + time;
            ZumbadorOn = true;
        }
        protected virtual void nobuzz()
        {
            tcs.TriggerSoundPenalty2();
            ZumbadorOn = false;
        }
        public ulong millis()
        {
            return (ulong)(tcs.ClockTime()*1000);
        }
        int HIGH = 1;
        int LOW = 0;
        protected bool[] estados_luces = new bool[17];
        public int[] estados_botones = new int[8];
        protected virtual void digitalWrite(int pin, int value)
        {
            bool on = value != 0;
            if (estados_luces[pin-2] == on) return;
            estados_luces[pin-2] = on;
            if (pin == LuzFrenar || pin == LuzRojo || pin == LuzL2)
            {
                if(estados_luces[LuzRojo-2]) tcs.SetNextSignalAspect(Aspect.Stop);
                else if(estados_luces[LuzFrenar-2]) tcs.SetNextSignalAspect(Aspect.Approach_1);
                else if(estados_luces[LuzL2-2]) tcs.SetNextSignalAspect(Aspect.Clear_1);
                else tcs.SetNextSignalAspect(Aspect.Clear_2);
            }
            tcs.SetCabDisplayControl(pin, value);
        }
        int digitalRead(int pin)
        {
            return 1-estados_botones[pin];
        }
        public ASFAclasico(ServerTCS tcs) : base(tcs)
        {
        }
        public override void Initialize()
        {
            if (!((tcs.Serie >= 200 && tcs.Serie < 400 && tcs.Serie != 355) || (tcs.Serie >= 600 && tcs.Serie < 700))) estados_botones[PConex] = 1;
            tcs.SetCustomizedCabviewControlName(0, "Genérico ASFA 1");
            tcs.SetCustomizedCabviewControlName(1, "Genérico ASFA 2");
            tcs.SetCustomizedCabviewControlName(2, "Conexión ASFA");
            tcs.SetCustomizedCabviewControlName(3, "REC ASFA");
            tcs.SetCustomizedCabviewControlName(4, "Alarma ASFA");
            tcs.SetCustomizedCabviewControlName(5, "Rearme ASFA");
            tcs.SetCustomizedCabviewControlName(6, "Rebase ASFA");
            TipoTren = tcs.GetIntParameter("ASFA", "TipoTren", 200);
            ASFA200 = TipoTren > 160;
            ASFAAVE = tcs.GetBoolParameter("ASFA", "AVE", false);
            ASFADual = tcs.GetBoolParameter("ASFA", "Dual", false);
            if (ASFADual) tcs.SetCustomizedCabviewControlName(7, "Modo ASFA");
            
            PulsadoresCG = tcs.GetIntParameter("ASFA", "PulsadoresCG", 0);
            if (PulsadoresCG > 0)
            {
                tcs.SetCustomizedCabviewControlName(PulsadoresCG-1, "Anulación ASFA");
            }
        }
        public override void Update()
        {
            if(stm == null)
            {
                AKT = AKT_ETCS || AKT_LZB;
                CON = CON_ETCS && CON_LZB;
            }
            else
            {
                stm.Update();
                CON = stm.State == STMState.DA;
                AKT = stm.State != STMState.DA;
            }
            if (CON) LastCON = tcs.GameTime();
            base.Update();
            bool Alimentado = tcs.IsCabPowerSupplyOn() && tcs.IsLowVoltagePowerSupplyOn();
            digitalWrite(LuzConex, (Encendido || Anulado || !Alimentado) ? 1 : 0);
            Velocidad = (int)MpS.ToKpH(tcs.SpeedMpS());
            freq = Baliza();
            Activated = digitalRead(PConex)==LOW;
            if(digitalRead(PConex)==LOW && (CON || tcs.GameTime() - LastCON < 0.2f) && !Anulado && Alimentado)
            {
                if (!Encendido) start();
            }
            else if (Encendido) shutdown();
            if(Encendido)
            {
                if (ASFADual)
                {
                    bool av = digitalRead(PModo)==LOW;
                    ASFA200 = !av;
                    ASFAAVE = av;
                    digitalWrite(LuzRenfe, av ? LOW : HIGH);
                    digitalWrite(LuzAVE, av ? HIGH : LOW);
                }
                if(RebaseStarted==0&&digitalRead(PRebase)==LOW)
                {
                    RebaseStarted = millis();
                    RebaseAuto = true;
                    digitalWrite(LuzRebase, HIGH);
                }
                if(digitalRead(PRebase)==HIGH)
                {
                    RebaseStarted = 0;
                    digitalWrite(LuzRebase, LOW);
                }
                if(RebaseStarted+10000<millis())
                {
                    RebaseAuto = false;
                    digitalWrite(LuzRebase, LOW);
                }
                if(BuzzEnd!=0 && BuzzEnd<millis())
                {
                    BuzzEnd = 0;
                    nobuzz();
                }
                if(prev_freq!=freq)
                {
                    if(freq != Freq.FP)
                    {
                        FrenarStarted = 0;
                        CondStarted = 0;
                        RecL2 = false;
                    }
                    switch(freq)
                    {
                        case Freq.L1:
                            buzz(3000);
                            RECStarted = millis();
                            if (ASFAAVE || ASFA200) FrenarStarted = millis();
                            break;
                        case Freq.L2:
                            if(ASFA200 || ASFAAVE)
                            {
                                buzz(3000);
                                CondStarted = millis();
                                digitalWrite(LuzREC, HIGH);
                            }
                            else buzz(500);
                            break;
                        case Freq.L3:
                            buzz(500);
                            break;
                        case Freq.L7:
                            {
                                int Vmax = 60;
                                if(TipoTren == 110) Vmax = 60;
                                if(TipoTren == 90) Vmax = 50;
                                if(TipoTren == 70) Vmax = 35;
                                if(Velocidad>Vmax)
                                {
                                    Urgencia = true;
                                    buzz(5000);
                                    digitalWrite(LuzRojo, HIGH);
                                }
                                else
                                {
                                    buzz(3000);
                                    RojoStarted = millis();
                                }
                            }
                            break;
                        case Freq.L8:
                            if(!RebaseAuto)
                            {
                                Urgencia = true;
                                buzz(5000);
                                digitalWrite(LuzRojo, HIGH);
                            }
                            else
                            {
                                buzz(3000);
                                RojoStarted = millis();
                            }
                            break;
                        case Freq.FP:
                            break;
                        default:
                            Eficacia = false;
                            if(AlarmaStarted==0)
                            {
                                buzz(3000);
                                AlarmaStarted = millis();
                                digitalWrite(LuzAlarma, HIGH);
                            }
                            break;
                    }
                    prev_freq = freq;
                }
                Eficacia = true;  
                digitalWrite(LuzEficacia, Eficacia ? 1 : 0);
                if(AlarmaStarted!=0)
                {
                    if(digitalRead(PAlarma)==LOW&&Eficacia)
                    {
                        nobuzz();
                        AlarmaStarted = 0;
                        digitalWrite(LuzAlarma, LOW);
                    }
                    else if(AlarmaStarted+3000<millis()) Urgencia = true;
                }
                if(RECStarted != 0)
                {
                    digitalWrite(LuzREC, HIGH);
                    digitalWrite(LuzFrenar, HIGH);
                    if(digitalRead(PREC)==LOW)
                    {
                        nobuzz();
                        digitalWrite(LuzREC, LOW);
                        if (!ASFAAVE && !ASFA200) digitalWrite(LuzFrenar, LOW);
                        RECStarted = 0;
                    }
                    else if(RECStarted+3000<millis())
                    {
                        Urgencia = true;
                        digitalWrite(LuzREC, LOW);
                        if (!ASFAAVE && !ASFA200) digitalWrite(LuzFrenar, LOW);
                        RECStarted = 0;
                    }
                }
                if(RojoStarted!=0)
                {
                    digitalWrite(LuzRojo, HIGH);
                    if(RojoStarted+10000<millis())
                    {
                        digitalWrite(LuzRojo, LOW);
                        RojoStarted = 0;
                    }
                }
                if (FrenarStarted!=0)
                {
                    if (ASFAAVE)
                    {
                        if(Velocidad>180 && FrenarStarted + 18000 < millis()) Urgencia = true;
                        if(Velocidad>160 && FrenarStarted + 30000 < millis()) Urgencia = true;
                    }
                    else
                    {
                        if(Velocidad>160) Urgencia = true;
                    }
                }
                else if(ASFAAVE || ASFA200) digitalWrite(LuzFrenar, LOW);
                if(CondStarted!=0)
                {
                    if(digitalRead(PREC)==LOW && !RecL2)
                    {
                        nobuzz();
                        RecL2 = true;
                        digitalWrite(LuzREC, LOW);
                    }
                    if(!RecL2 && CondStarted + 3000 < millis())
                    {
                        Urgencia = true;
                        digitalWrite(LuzREC, LOW);
                    }
                    if(Velocidad>180 && CondStarted + 18000 < millis()) Urgencia = true;
                    if(Velocidad>160 && CondStarted + 30000 < millis()) Urgencia = true;
                    digitalWrite(LuzL2, (int)((millis() - CondStarted) / 500 % 2));
                }
                else digitalWrite(LuzL2, LOW);
                if(Urgencia&&Velocidad<5)
                { 
                    digitalWrite(LuzRojo, LOW);
                    if(AlarmaStarted==0)
                    {
                        digitalWrite(LuzRearme, HIGH);
                        if(digitalRead(PRearme)==LOW) Urgencia = false;
                    }
                }
                else digitalWrite(LuzRearme, LOW);
            }
            Emergency = (Urgencia || !Encendido) && !Anulado && !AKT;
            Previous = millis();
        }
        void start()
        {
            Encendido = true;
            buzz(500);
            LastPConex = millis();
        }
        void shutdown()
        {
            freq = Freq.FP;
            RECStarted = RojoStarted = AlarmaStarted = RebaseStarted = CondStarted = 0;
            Eficacia = false;
            nobuzz();
            digitalWrite(LuzREC, LOW);
            digitalWrite(LuzFrenar, LOW);
            digitalWrite(LuzRojo, LOW);
            digitalWrite(LuzAlarma, LOW);
            digitalWrite(LuzEficacia, LOW);
            digitalWrite(LuzL2, LOW);
            digitalWrite(LuzRebase, LOW);
            digitalWrite(LuzRearme, LOW);
            digitalWrite(LuzVL, LOW);
            digitalWrite(LuzCV, LOW);
            if (ASFADual)
            {
                digitalWrite(LuzRenfe, LOW);
                digitalWrite(LuzAVE, LOW);
            }
            Encendido = false;
        }
        double LastPressed;
        int count=0;
        public override void HandleEvent(TCSEvent ev, string message)
        {
            if(ev == TCSEvent.GenericTCSButtonPressed || ev == TCSEvent.GenericTCSButtonReleased)
            {
                int num = int.Parse(message);
                bool pressed = ev == TCSEvent.GenericTCSButtonPressed;
                if (num == 0)
                {
                    estados_botones[PREC] = pressed ? 1 : 0;
                    estados_botones[PRearme] = pressed ? 1 : 0;
                    if (pressed)
                    {
                        if(LastPressed + 1 > tcs.ClockTime()) count++;
                        else count = 1;
                        if (count == 4)
                        {
                            estados_botones[PConex] = 1-estados_botones[PConex];
                            tcs.Message(ConfirmLevel.Information, "ASFA: panel repetidor "+(estados_botones[PConex]==1 ? "conectado" : "desconectado"));
                        }
                        LastPressed = tcs.ClockTime();
                    }
                }
                else if (num == 1)
                {
                    estados_botones[PAlarma] = pressed ? 1 : 0;
                    estados_botones[PRebase] = pressed ? 1 : 0;
                }
                else if (num == PConex || num == PRebase || num == PModo)
                {
                    if (pressed)
                    {
                        estados_botones[num] = 1-estados_botones[num];
                        if (num == PConex) tcs.Message(ConfirmLevel.Information, "ASFA: panel repetidor "+(estados_botones[PConex]==1 ? "conectado" : "desconectado"));
                    }
                }
                else if (num < 8)
                {
                    estados_botones[num] = pressed ? 1 : 0;
                }
            }
            if (ev == TCSEvent.GenericTCSSwitchOn || ev == TCSEvent.GenericTCSSwitchOff)
            {
                int num = int.Parse(message);
                bool pressed = ev == TCSEvent.GenericTCSSwitchOn;
                if (num == PulsadoresCG - 1)
                {
                    Anulado = pressed;
                    tcs.Message(ConfirmLevel.Information, "ASFA: "+(Anulado ? "anulado" : "conectado"));
                    tcs.SetCabDisplayControl(PulsadoresCG - 1, Anulado ? 1 : 0);
                }
            }
        }
        public override List<Parameter> GetParameters()
        {
            var l = new List<Parameter>();
            
            var p = new Parameter("asfa::akt::lzb");
            p.SetValue = (string val) => AKT_LZB = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::con::lzb");
            p.SetValue = (string val) => CON_LZB = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::akt::etcs");
            p.SetValue = (string val) => AKT_ETCS = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::con::etcs");
            p.SetValue = (string val) => CON_ETCS = val=="1";
            l.Add(p);
            
            p = new Parameter("asfa::conectado");
            p.GetValue = () => tcs.IsCabPowerSupplyOn() && tcs.IsLowVoltagePowerSupplyOn() && !Anulado ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("stm::command_etcs");
            p.SetValue = (string val) => {
                byte[] data = Convert.FromBase64String(val);
                stm?.HandleMessage(new ETCSVariables(data));
            };
            l.Add(p);

            p = new Parameter("asfa::luz::frenar");
            p.GetValue = () => estados_luces[LuzFrenar-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::l2");
            p.GetValue = () => estados_luces[LuzL2-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::rojo");
            p.GetValue = () => estados_luces[LuzRojo-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::cv");
            p.GetValue = () => estados_luces[LuzCV-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::vl");
            p.GetValue = () => estados_luces[LuzVL-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::eficacia");
            p.GetValue = () => estados_luces[LuzEficacia-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::rec");
            p.GetValue = () => estados_luces[LuzREC-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::rearme");
            p.GetValue = () => estados_luces[LuzRearme-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::rebase");
            p.GetValue = () => estados_luces[LuzRebase-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::alarma");
            p.GetValue = () => estados_luces[LuzAlarma-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::conex");
            p.GetValue = () => estados_luces[LuzConex-2] ? "0" : "1";
            l.Add(p);

            p = new Parameter("asfa::luz::renfe");
            p.GetValue = () => estados_luces[LuzRenfe-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::luz::ave");
            p.GetValue = () => estados_luces[LuzAVE-2] ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::zumbador");
            p.GetValue = () => ZumbadorOn ? "1" : "0";
            l.Add(p);

            p = new Parameter("asfa::pulsador::rec");
            p.SetValue = (string val) => estados_botones[PREC] = val=="1" ? 1 : 0;
            l.Add(p);

            p = new Parameter("asfa::pulsador::rearme");
            p.SetValue = (string val) => estados_botones[PRearme] = val=="1" ? 1 : 0;
            l.Add(p);

            p = new Parameter("asfa::pulsador::rebase");
            p.SetValue = (string val) => estados_botones[PRebase] = val=="1" ? 1 : 0;
            l.Add(p);

            p = new Parameter("asfa::pulsador::alarma");
            p.SetValue = (string val) => estados_botones[PAlarma] = val=="1" ? 1 : 0;
            l.Add(p);

            p = new Parameter("asfa::pulsador::conex");
            p.SetValue = (string val) => estados_botones[PConex] = val=="1" ? 1 : 0;
            l.Add(p);

            p = new Parameter("asfa::llave");
            p.SetValue = (string val) => {
                estados_botones[PConex] = (val == "1" || val == "2") ? 1 : 0;
                estados_botones[PRebase] = val == "2" ? 1 : 0;
            };
            l.Add(p);
            
            return l;
        }
    }
    class ASFADigital : ASFA
    {
        //Combinador general
        public bool Connected;
        bool FE;
        //Transición a LZB/ERTMS
        public bool AKT = false; //Inhibir freno de urgencia
        public bool CON = true; //Conexión de ASFA
        int UltimaInfo=1;
        Aspect FallbackAspect;
        bool controldesv=false;
        bool secAA=false;
        int TargetState=0;
        int IndicadorLVI=0;
        int IndicadorPNdesp=0;
        int IndicadorPNprot=0;
        int IndicadorFrenado=0;
        bool Anun = false;
        bool Prec = false;
        bool Prean = false;
        bool Modo = false;
        bool Rearme = false;
        bool Rebase = false;
        bool Aumento = false;
        bool Alarma = false;
        bool Ocultacion = false;
        bool LTV = false;
        bool PN = false;
        bool PConex = false;
        bool Basico = false;
        bool IlumConex=false;
        bool IlumAnpar=false;
        bool IlumAnpre=false;
        bool IlumPrepar=false;
        bool IlumVLcond=false;
        bool IlumModo=false;
        bool IlumRearme=false;
        bool IlumRebase=false;
        bool IlumAumento=false;
        bool IlumAlarma=false;
        bool IlumOcult=false;
        bool IlumLVI=false;
        bool IlumPN=false;
        bool Velo=false;
        bool Eficacia=false;
        int EficaciaB=0;
        int FrenarB=0;
        int Led3B=0;
        int ModoDisplay=-1;
        int Tipo;
        int Velocidad;
        bool PantallaActiva = false;
        Timer InicioPantalla;
        int PulsadoresCG;
        int SelectorT = 8;
        public ASFADigital(ServerTCS tcs) : base(tcs)
        {
            InicioPantalla = new Timer(tcs);
            InicioPantalla.Setup(10);
        }
        public void start()
        {
            InicioPantalla.Stop();
            tcs.Register("asfad::indicador::*");
            PantallaActiva = true;
            /*Anun = false;
            Prec = false;
            Prean = false;
            Modo = false;
            Rearme = false;
            Rebase = false;
            Aumento = false;
            Alarma = false;
            Ocultacion = false;
            LTV = false;
            PN = false;
            Basico = false;
            IlumAnpar=false;
            IlumAnpre=false;
            IlumPrepar=false;
            IlumVLcond=false;
            IlumModo=false;
            IlumRearme=false;
            IlumRebase=false;
            IlumAumento=false;
            IlumAlarma=false;
            IlumOcult=false;
            IlumLVI=false;
            IlumPN=false;
            EficaciaB=0;
            FrenarB=0;
            Led3B=0;
            Connected = true;
            tcs.SetCabDisplayControl(11, 1);
            
            tcs.SendParameter("asfa::pulsador::conex", "1");*/
        }
        string div;
        string getDIV()
        {
            if (div != null) return div;
            string DIV = tcs.GetStringParameter("ASFA", "DIV", "020001162E47558A26023132333402300000C8780000957102690295000288039803E8643C328C00000000000000000000000000000000000000000000000000");
            string hex = "0123456789ABCDEF";
            System.Text.StringBuilder b = new System.Text.StringBuilder(DIV);
            int Vmax = Math.Min(tcs.GetIntParameter("ASFA","VmaxVehiculo",0),200);
            if (Vmax == 0) Vmax = Math.Min(tcs.GetIntParameter("General","TrainMaxSpeed",0),200);
            if (Vmax == 0) Vmax = Math.Min(tcs.GetIntParameter("General","MaxSpeed",0),200);
            if (Vmax > 0)
            {
                b[36] = hex[Vmax/16];
                b[37] = hex[Vmax%16];
            }
            int div15 = Convert.ToInt32(DIV.Substring(30,2),16);
            int div17 = Convert.ToInt32(DIV.Substring(34,2),16);
            int modoCONV = tcs.GetIntParameter("ASFA","ModoCONV",-1);
            int modoAV = tcs.GetIntParameter("ASFA","ModoAV",-1);
            int modoRAM = tcs.GetIntParameter("ASFA","ModoRAM",-1);
            int modoBTS = tcs.GetIntParameter("ASFA","ModoBTS",-1);
            int fase = tcs.GetIntParameter("ASFA","Fase",-1);
            if (fase != -1) div15 = (div15&(255-1))|(fase == 2 ? 1 : 0);
            if (modoCONV != -1) div15 = (div15&(255-16))|(modoCONV*16);
            if (modoAV != -1) div15 = (div15&(255-32))|(modoAV*32);
            if (modoRAM != -1) div17 = (div17&(255-4))|(modoRAM*4);
            if (modoBTS != -1) div17 = (div17&(255-8))|(modoBTS*8);
            b[30] = hex[div15/16];
            b[31] = hex[div15%16];
            b[34] = hex[div17/16];
            b[35] = hex[div17%16];
            DIV = b.ToString();
            div = DIV;
            return DIV;
        }
        void stop()
        {
            InicioPantalla.Stop();
            tcs.RemoveParameter("asfad::indicador::*");
            UltimaInfo=1;
            FallbackAspect = Aspect.Clear_2;
            controldesv=false;
            secAA=false;
            TargetState=0;
            IndicadorLVI=0;
            IndicadorPNdesp=0;
            IndicadorPNprot=0;
            IndicadorFrenado=0;
            FE = false;
            Velo = false;
            Eficacia=false;
            PantallaActiva = false;
            ModoDisplay = -1;
            Tipo = 0;
            Velocidad = 0;
            /*Connected = false;
            Emergency = false;
            
            tcs.RemoveParameter("asfa::pulsador::ilum::*");
            tcs.RemoveParameter("asfa::leds::*");
            tcs.RemoveParameter("asfa::pulsador::basico");
            
            tcs.SendParameter("asfa::pulsador::conex", "0");*/
        }
        public override void Initialize()
        {
            tcs.SetCustomizedCabviewControlName(0, "Rec. anuncio parada");
            tcs.SetCustomizedCabviewControlName(1, "Rec. anuncio precaucion");
            tcs.SetCustomizedCabviewControlName(2, "Rec. preanuncio o condicional");
            tcs.SetCustomizedCabviewControlName(3, "Modo ASFA");
            tcs.SetCustomizedCabviewControlName(4, "Rearme freno");
            tcs.SetCustomizedCabviewControlName(5, "Rebase autorizado");
            tcs.SetCustomizedCabviewControlName(6, "Aumento vel. ASFA");
            tcs.SetCustomizedCabviewControlName(7, "Rec. alarma ASFA");
            tcs.SetCustomizedCabviewControlName(8, "Ocultacion info ASFA");
            tcs.SetCustomizedCabviewControlName(9, "Rec. limitacion velocidad");
            tcs.SetCustomizedCabviewControlName(10, "Rec. paso a nivel");
            tcs.SetCustomizedCabviewControlName(11, "Conexión ASFA");
            tcs.SetCustomizedCabviewControlName(12, "Conmutador ASFA básico");
            
            PulsadoresCG = tcs.GetIntParameter("ASFA", "PulsadoresCG", 0);
            int speed = tcs.GetIntParameter("ASFA", "TipoTren", -1);
            if (speed > 0)
            {
                if (speed > 180) SelectorT = 8;
                else if (speed > 160) SelectorT = 7;
                else if (speed > 140) SelectorT = 6;
                else if (speed > 120) SelectorT = 5;
                else if (speed > 100) SelectorT = 4;
                else if (speed > 90) SelectorT = 3;
                else if (speed > 80) SelectorT = 2;
                else if (speed > 10) SelectorT = 1;
                else if (speed > 0) SelectorT = speed;
            }
            if (PulsadoresCG != 0)
            {
                tcs.SetCustomizedCabviewControlName(PulsadoresCG-1, "Alimentación ASFA");
                tcs.SetCustomizedCabviewControlName(PulsadoresCG, "Anulación ASFA");
                tcs.SetCustomizedCabviewControlName(PulsadoresCG+1, "Tipo tren ASFA");
                tcs.SetCabDisplayControl(PulsadoresCG-1, 1);
                tcs.SetCabDisplayControl(PulsadoresCG, 1);
                tcs.SetCabDisplayControl(PulsadoresCG+1, SelectorT - 1);
            }
            
            if (!((tcs.Serie >= 200 && tcs.Serie < 400) || (tcs.Serie >= 600 && tcs.Serie < 700))) PConex = true;
        }
        public override void Update()
        {
            base.Update();
            if (InicioPantalla.Triggered) start();
            tcs.SetCabDisplayControl(0, IlumAnpar ? 1 : 0);
            tcs.SetCabDisplayControl(1, IlumAnpre ? 1 : 0);
            tcs.SetCabDisplayControl(2, IlumVLcond ? (IlumPrepar ? 3 : 2) : (IlumPrepar ? 1 : 0));
            tcs.SetCabDisplayControl(3, IlumModo ? 1 : 0);
            tcs.SetCabDisplayControl(4, IlumRearme ? 1 : 0);
            tcs.SetCabDisplayControl(5, IlumRebase ? 1 : 0);
            tcs.SetCabDisplayControl(6, IlumAumento ? 1 : 0);
            tcs.SetCabDisplayControl(7, IlumAlarma ? 1 : 0);
            tcs.SetCabDisplayControl(8, IlumOcult ? 1 : 0);
            tcs.SetCabDisplayControl(9, IlumLVI ? 1 : 0);
            tcs.SetCabDisplayControl(10, IlumPN ? 1 : 0);
            tcs.SetCabDisplayControl(11, PConex ? 1 : (IlumConex ? 0 : 2));
            tcs.SetCabDisplayControl(12, Basico ? 1 : 0);
            if (UltimaInfo == 8 && ((int)(tcs.ClockTime()*2))%2 == 1) tcs.SetCabDisplayControl(15, 0);
            else tcs.SetCabDisplayControl(15, UltimaInfo);
            tcs.SetCabDisplayControl(16, IndicadorPNdesp != 0 ? 2 : (IndicadorPNprot != 0 ? 1 : 0));
            tcs.SetCabDisplayControl(17, controldesv ? 2 : (secAA ? 5 : 0));
            tcs.SetCabDisplayControl(18, IndicadorLVI);
            tcs.SetCabDisplayControl(20, TargetState == 0 ? 2 : (TargetState == 1 ? 0 : 1));
            tcs.SetCabDisplayControl(21, FE ? 3 : IndicadorFrenado);
            tcs.SetCabDisplayControl(22, EficaciaB);
            tcs.SetCabDisplayControl(23, FrenarB);
            tcs.SetCabDisplayControl(24, Led3B);
            tcs.SetCabDisplayControl(25, PantallaActiva ? (ModoDisplay == 5 ? 3 : (Velo ? 2 : 1)) : 0);
            tcs.SetCabDisplayControl(26, Eficacia ? (((int)(tcs.ClockTime()*2))%8 + 1) : 0);
            tcs.SetCabDisplayControl(27, ModoDisplay + 1);
            tcs.SetCabDisplayControl(28, Tipo);
            tcs.SetCabDisplayControl(29, Velocidad);
            tcs.SetNextSignalAspect(FallbackAspect);
            //tcs.SetOverspeedWarningDisplay(IndicadorFrenado != 0 ? true : false);
            //tcs.SetPenaltyApplicationDisplay(Emergency);
        }
        public override void HandleEvent(TCSEvent ev, string message)
        {
            if(ev == TCSEvent.GenericTCSButtonPressed || ev == TCSEvent.GenericTCSButtonReleased)
            {
                int num = int.Parse(message);
                bool pressed = ev == TCSEvent.GenericTCSButtonPressed;
                if (num == 11 && pressed) PConex = !PConex;
                else if (num == 12 && pressed) Basico = !Basico;
                else if(num==0) Anun = pressed;
                else if(num==1) Prec = pressed;
                else if(num==2) Prean = pressed;
                else if(num==3) Modo = pressed;
                else if(num==4) Rearme = pressed;
                else if(num==5) Rebase = pressed;
                else if(num==6) Aumento = pressed;
                else if(num==7) Alarma = pressed;
                else if(num==8) Ocultacion = pressed;
                else if(num==9) LTV = pressed;
                else if(num==10) PN = pressed;
                else if(num==PulsadoresCG+1)
                {
                    if (pressed)
                    {
                        SelectorT = SelectorT%8 + 1;
                        tcs.SetCabDisplayControl(PulsadoresCG+1, SelectorT-1);
                    }
                }
            }
            if(ev == TCSEvent.GenericTCSSwitchOff || ev == TCSEvent.GenericTCSSwitchOn)
            {
                int num = int.Parse(message);
                bool pressed = ev == TCSEvent.GenericTCSSwitchOn;
                if(PulsadoresCG != 0 && num==PulsadoresCG-1)
                {
                    tcs.SendParameter("asfad::cg::conectado", pressed ? "1" : "0");
                    tcs.SetCabDisplayControl(PulsadoresCG-1, pressed ? 1 : 0);
                }
                else if(PulsadoresCG != 0 && num==PulsadoresCG)
                {
                    tcs.SendParameter("asfad::cg::anulado", pressed ? "0" : "1");
                    tcs.SetCabDisplayControl(PulsadoresCG, pressed ? 1 : 0);
                }
            }
        }
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = base.GetParameters();
            /*if(p.name=="asfa_sound_trigger")
            {
                p.SetValue = (string val) => 
                {
                    int num = int.Parse(val);
                    if(num == 0) tcs.TriggerSoundInfo1();
                    if(num == 1) tcs.TriggerSoundPenalty1();
                    if(num == 2) tcs.TriggerSoundAlert1();
                    if(num == 3) tcs.TriggerSoundAlert2();
                    if(num == 9) tcs.TriggerSoundSystemDeactivate();
                };
                return true;
            }
            else */
            Parameter p = null;
            
            p = new Parameter("asfad::div");
            p.GetValue = () => getDIV();
            l.Add(p);
            
            p = new Parameter("asfad::indicador::v_control");
            p.SetValue = (string val) => tcs.SetNextSpeedLimitMpS(MpS.FromKpH(float.Parse(val.Replace(',','.'), CultureInfo.InvariantCulture.NumberFormat)));
            l.Add(p);
            
            p = new Parameter("asfad::indicador::velocidad");
            p.SetValue = (string val) => Velocidad = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::indicador::estado_vcontrol");
            p.SetValue = (string val) => TargetState = int.Parse(val);
            l.Add(p);
            
            
            p = new Parameter("asfad::indicador::ultima_info");
            p.SetValue = (string val) => {
                int num = int.Parse(val)/2;
                UltimaInfo = num;
                switch(num)
                {
                    case 2:
                        FallbackAspect = Aspect.Stop;
                        break;
                    case 3:
                        FallbackAspect = Aspect.StopAndProceed;
                        break;
                    case 4:
                        FallbackAspect = Aspect.Approach_1;
                        break;
                    case 5:
                        FallbackAspect = Aspect.Approach_2;
                        break;
                    case 6:
                        FallbackAspect = Aspect.Approach_3;
                        break;
                    case 7:
                        FallbackAspect = Aspect.Approach_3;
                        break;
                    case 8:
                        FallbackAspect = Aspect.Clear_1;
                        break;
                    default:
                        FallbackAspect = Aspect.Clear_2;
                        break;
                }
            };
            l.Add(p);
            
            p = new Parameter("asfad::indicador::control_desvio");
            p.SetValue = (string val) => controldesv = val=="1";
            l.Add(p);
            
            p = new Parameter("asfad::indicador::secuencia_aa");
            p.SetValue = (string val) => secAA = val=="1";
            l.Add(p);
            
            p = new Parameter("asfad::indicador::lvi");
            p.SetValue = (string val) => IndicadorLVI = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::indicador::pndesp");
            p.SetValue = (string val) => IndicadorPNdesp = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::indicador::pnprot");
            p.SetValue = (string val) => IndicadorPNprot = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::indicador::frenado");
            p.SetValue = (string val) => IndicadorFrenado = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::indicador::urgencia");
            p.SetValue = (string val) => FE = val=="1";
            l.Add(p);
            
            p = new Parameter("asfad::indicador::eficacia");
            p.SetValue = (string val) => Eficacia = val=="1";
            l.Add(p);
            
            p = new Parameter("asfad::indicador::velo");
            p.SetValue = (string val) => Velo = val=="1";
            l.Add(p);
            
            p = new Parameter("asfad::indicador::modo");
            p.SetValue = (string val) => ModoDisplay = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::indicador::tipo_tren");
            p.SetValue = (string val) => {
                int T=0;
                if (int.TryParse(val, out T))
                {
                    if (T > 0 && T<130) T = T/10-4;
                    else if (T>130) T = T/20+2;
                }
                else if (val == "CONV") T = 13;
                else if (val == "AV") T = 14;
                else if (val == "RAM") T = 15;
                Tipo = T;
            };
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::anpar");
            p.GetValue = () => Anun ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::anpre");
            p.GetValue = () => Prec ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::prepar");
            p.GetValue = () => Prean ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::modo");
            p.GetValue = () => Modo ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::rearme");
            p.GetValue = () => Rearme ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::rebase");
            p.GetValue = () => Rebase ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::aumento");
            p.GetValue = () => Aumento ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::alarma");
            p.GetValue = () => Alarma ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ocultacion");
            p.GetValue = () => Ocultacion ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::lvi");
            p.GetValue = () => LTV ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::pn");
            p.GetValue = () => PN ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::basico");
            p.GetValue = () => Basico ? "1" : "0";
            p.SetValue = (string val) => Basico = val=="1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::conex");
            p.SetValue = (string val) => PConex = val=="1";
            p.GetValue = () => PConex ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::alimentado");
            p.GetValue = () => tcs.IsCabPowerSupplyOn() ? "1" : "0";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::conex");
            p.SetValue = (string val) => IlumConex = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::anpar");
            p.SetValue = (string val) => IlumAnpar = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::anpre");
            p.SetValue = (string val) => IlumAnpre = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::prepar");
            p.SetValue = (string val) => IlumPrepar = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::vlcond");
            p.SetValue = (string val) => IlumVLcond = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::modo");
            p.SetValue = (string val) => IlumModo = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::rearme");
            p.SetValue = (string val) => IlumRearme = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::rebase");
            p.SetValue = (string val) => IlumRebase = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::aumento");
            p.SetValue = (string val) => IlumAumento = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::alarma");
            p.SetValue = (string val) => IlumAlarma = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::ocultacion");
            p.SetValue = (string val) => IlumOcult = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::lvi");
            p.SetValue = (string val) => IlumLVI = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::pulsador::ilum::pn");
            p.SetValue = (string val) => IlumPN = val== "1";
            l.Add(p);
            
            p = new Parameter("asfad::leds::0");
            p.SetValue = (string val) => EficaciaB = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::leds::1");
            p.SetValue = (string val) => FrenarB = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::leds::2");
            p.SetValue = (string val) => Led3B = int.Parse(val);
            l.Add(p);
            
            p = new Parameter("asfad::pantalla::activa");
            p.SetValue = (string val) => {if (val== "1") start();};
            l.Add(p);
            
            p = new Parameter("asfad::pantalla::habilitada");
            p.SetValue = (string val) => {if (val== "1") InicioPantalla.Start(); else stop();};
            l.Add(p);
            
            p = new Parameter("asfad::selector_tipo");
            p.GetValue = () => SelectorT.ToString();
            l.Add(p);
            
            return l;
        }
    }
    public enum STMState
    {
        NP,
        PO,
        CO,
        DE,
        CS,
        CCS,
        HS,
        DA,
        FA
    }
    public class LZB_STM
    {
        ServerTCS tcs;
        LZB LZB;
        
        public STMState State;
        public STMState Requested;
        public bool Conditional;
        Timer UpdateTimer;
        public Timer MonitorTimer;

        public bool RequestData = true;
        public bool DataEntryOngoing = false;
        
        Mode CurrentETCSMode;
        
        public LZB_STM(LZB lzb)
        {
            LZB = lzb;
            tcs = lzb.tcs;
            UpdateTimer = new Timer(tcs);
            UpdateTimer.Setup(1);
            MonitorTimer = new Timer(tcs);
            MonitorTimer.Setup(0.5f);
        }
        public void Update()
        {
            bool powered = !LZB.Isolated && tcs.IsCabPowerSupplyOn() && tcs.IsLowVoltagePowerSupplyOn();
            STMState prevState = State;
            if (!powered) State = STMState.NP;
            else if (State == STMState.NP)
            {
                State = STMState.PO;
                Requested = STMState.PO;
            }
            else
            {
                if (Requested == STMState.CO)
                {
                    if (State == STMState.PO) State = STMState.CO;
                    else if (State != STMState.CO) State = STMState.FA;
                }
                else if (Requested == STMState.DE)// Data entry
                {
                    if (State == STMState.CO) State = STMState.DE;
                    else if (State != STMState.DE) State = STMState.FA;
                }
                else if (Requested == STMState.CS) // Unconditional cold standby
                {
                    if (State == STMState.CO || State == STMState.DE || State == STMState.HS || State == STMState.DA) State = STMState.CS;
                    else if (State != STMState.CS) State = STMState.FA;
                }
                else if (Requested == STMState.CCS) // Conditional cold standby
                {
                    if (State == STMState.DA)
                    {
                        if (!LZB.OE || CurrentETCSMode == Mode.TR) State = STMState.CS;
                    }
                    else if (State != STMState.CS) State = STMState.FA;
                }
                else if (Requested == STMState.HS) // Hot standby
                {
                    if (State == STMState.CS)
                        State = STMState.HS;
                    else if (State != STMState.HS)
                        State = STMState.FA;
                }
                else if (Requested == STMState.DA) // Data available
                {
                    if (State == STMState.CS || State == STMState.HS) State = STMState.DA;
                    else if (State != STMState.DA) State = STMState.FA;
                }
                else if (Requested == STMState.FA) State = STMState.FA; // Failure
            }
            if (!UpdateTimer.Started || UpdateTimer.Triggered || prevState != State)
            {
                var state = "";
                if (State == STMState.PO && prevState != State)
                {
                    state += "00000001"+ETCS.format_binary(37, 13)+ETCS.format_binary(4, 8)+ETCS.format_binary(0, 8); // Send version
                }
                else if (State == STMState.CO && RequestData)
                {
                    state += "00001101"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)STMState.DE, 4); // Request DE state
                }
                else if (State == STMState.CO && ((LZB.DataEntered && !RequestData) || CurrentETCSMode == Mode.NL || CurrentETCSMode == Mode.SL))
                {
                    state += "00001101"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)STMState.CS, 4); // Request CS state
                }
                if (State == STMState.DA && LZB.OE) state += "00010010"+ETCS.format_binary(21, 13); // Report national trip procedure
                state += "10000000"+ETCS.format_binary(25, 13)+(LZB.EmergencyBrake ? "01" : "10")+"10"; // Brake command
                if (LZB.Supervising)
                {
                    state += "10000010"+ETCS.format_binary(29, 13)+"11"+"11"+(LZB.NeutralSectionStart.Started ? "10" : "01")+"11";
                }
                SendMessage(state);
                UpdateTimer.Start();
            }
        }
        public void SendMessage(string packs)
        {
            packs = "00001111"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)State, 4)+packs;
            while (packs.Length % 8 != 0) packs += "0";
            var msg = "00001010"+ETCS.format_binary(packs.Length/8 + 2, 8)+packs;
            byte[] data = new byte[(msg.Length+7)/8];
            for (int i = 0; i < msg.Length; i++)
            {
                if (msg[i] == '1') data[i/8] |= (byte)(1<<(7-i%8));
            }
            tcs.SendParameter("noretain(stm::command",Convert.ToBase64String(data)+")");
        }
        string GetDataEntryField(string name, int value)
        {
            byte[] ascii1 = System.Text.Encoding.GetEncoding(28591).GetBytes(name);
            byte[] ascii2 = System.Text.Encoding.GetEncoding(28591).GetBytes(value.ToString());
            string f = ETCS.format_binary(ascii1.Length, 6);
            for (int i=0; i<ascii1.Length; i++)
            {
                f += ETCS.format_binary(ascii1[i], 8);
            }
            f += ETCS.format_binary(ascii2.Length, 5);
            for (int i=0; i<ascii2.Length; i++)
            {
                f += ETCS.format_binary(ascii2[i], 8);
            }
            f += ETCS.format_binary(0, 5);
            return f;
        }
        public void HandleMessage(ETCSVariables var)
        {
            int nid_stm = (int)var.Read(8);
            if (nid_stm != 10 && nid_stm != 255) return;
            var.Offset += 8;
            while (var.Length - var.Offset > 8)
            {
                int nid_packet = (int)var.Read(8);
                int l_packet = (int)var.Read(13);
                if (l_packet < 21) break;
                int offset = var.Offset + l_packet - 21;
                Console.WriteLine(nid_packet);
                switch(nid_packet)
                {
                    case 1:
                        break;
                    case 5:
                        if (var.Read(3) == 1) var.Read(8);
                        //CurrentETCSMode = (Mode)var.Read(4);
                        if (State == STMState.PO)
                        {
                            string msg = "10110101"+ETCS.format_binary(22, 13)+(RequestData ? "1" : "0"); // Specific data need
                            msg += "00001101"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)STMState.CO, 4); // Request CO state
                            SendMessage(msg); 
                        }
                        break;
                    case 14:
                        Requested = (STMState)var.Read(4);
                        break;
                    case 30:
                        LZB.Language = ((char)var.Read(8)).ToString() + ((char)var.Read(8));
                        if (LZB.Language != "es" && LZB.Language != "de") LZB.Language = "es";
                        break;
                    case 175:
                        var.Offset += 19;
                        LZB.LT = (int)var.Read(12);
                        LZB.VMZ = (int)var.Read(7)*5;
                        if (DataEntryOngoing)
                        {
                            if (RequestData)
                            {
                                string pack="0"+ETCS.format_binary(4, 5);
                                pack += ETCS.format_binary(1, 8)+GetDataEntryField("VMZ", LZB.VMZ);
                                pack += ETCS.format_binary(2, 8)+GetDataEntryField("PFT", LZB.PFT);
                                pack += ETCS.format_binary(3, 8)+GetDataEntryField("BP", LZB.BP);
                                pack += ETCS.format_binary(4, 8)+GetDataEntryField("LT", LZB.LT);
                                SendMessage("10110011"+ETCS.format_binary(pack.Length + 21, 13)+pack); // Specific data need
                            }
                            else
                            {
                                SendMessage("10110011"+ETCS.format_binary(27, 13)+"0"+"00000"); // No specific data need
                                LZB.DataEntered = true;
                            }
                        }
                        break;
                    case 180: {
                        int nfields = (int)var.Read(5);
                        int success = 0;
                        for (int i=0; i<nfields; i++)
                        {
                            int id = (int)var.Read(8);
                            int length = (int)var.Read(5);
                            string result = "";
                            for (int j=0; j<length; j++)
                            {
                                result += (char)var.Read(8);
                            }
                            if (int.TryParse(result, out int val))
                            {
                                switch(id)
                                {
                                    case 1:
                                        LZB.VMZ = val;
                                        break;
                                    case 2:
                                        LZB.PFT = val;
                                        break;
                                    case 3:
                                        LZB.BP = val;
                                        break;
                                    case 4:
                                        LZB.LT = val;
                                        break;
                                }
                                success++;
                            }
                        }
                        if (success >= 4)
                        {
                            LZB.DataEntered = true;
                            SendMessage("10110011"+ETCS.format_binary(27, 13)+"0"+"00000"); // End of specific data need
                        }
                        else
                        {
                            string pack="0"+ETCS.format_binary(4, 5);
                            pack += ETCS.format_binary(1, 8)+GetDataEntryField("VMZ", LZB.VMZ);
                            pack += ETCS.format_binary(2, 8)+GetDataEntryField("PFT", LZB.PFT);
                            pack += ETCS.format_binary(3, 8)+GetDataEntryField("BP", LZB.BP);
                            pack += ETCS.format_binary(4, 8)+GetDataEntryField("LT", LZB.LT);
                            SendMessage("10110011"+ETCS.format_binary(pack.Length + 21, 13)+pack); // Specific data need
                        }
                        break;
                    }
                    case 184:
                        bool start = var.Read(1)==1;
                        DataEntryOngoing = start;
                        if (start) LZB.DataEntered = false;
                        else if (State == STMState.DE) SendMessage("00001101"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)STMState.CS, 4)); // Request CS state
                        break;
                    case 176:
                        break;
                }
                var.Offset = offset;
            }
        }
    }
    public class LZB : InteractiveTCS
    {
        int ControlInicioPulsadores;
        enum Button
        {
            Frei,
            Command,
            Alertar,
        }
        Dictionary<Button, bool> Buttons = new Dictionary<Button, bool>();
        int ControlInicioIndicadores;
        int ExternalTransmissionIndicator;
        int ControlAnulacion;
        enum Indicator
        {
            None,
            L30,
            L55,
            L60,
            L70,
            L80,
            L85,
            H, // OE
            E40, // A
            ENDE, // FIN
            B, // S
            Ü, // T
            Befehl40, // R
            M,
            Hz500,
            Hz1000, // P
            Hz2000,
            G, // V
            EL,
            V40, // OP 40
            S, // E
            Stör // CI
        }
        Dictionary<Indicator, int> IndicatorMap = new Dictionary<Indicator, int>();
        enum IndicatorStatus
        {
            Off,
            On,
            Flash,
            CounterFlash
        }
        enum LZBVariant
        {
            LZB80,
            SpanishHS,
            SpanishConv,
        }
        LZBVariant Variant = LZBVariant.LZB80;
        int ControlDistanciaObjetivo = 29;
        int ControlVelocidadObjetivo;
        int ControlVelocidadPermitida;
        bool PrefijadaVsoll = true;
        struct SpeedData
        {
            public float CurrentSpeedMpS;
            public float TargetDistanceM;
            public float TargetSpeedMpS;
            public float XGDistanceM;
            public int DecelCurve;
            public int Location;
            public bool Down;
            public bool PartialBlock;
            public bool End;
        }
        SpeedData? CurrentSpeed;
        Dictionary<Indicator, IndicatorStatus> Indicators = new Dictionary<Indicator, IndicatorStatus>();
        Dictionary<Indicator, IndicatorStatus> STMIndicatorStatus = new Dictionary<Indicator, IndicatorStatus>();
        Indicator[] STMIndicators = new Indicator[6];
        Blinker Blink;
        Dictionary<int, (float, float)> SpeedCurves = new Dictionary<int, (float, float)>();
        Timer FreiTimer;
        bool FreiPressed;
        LZB_STM stm;
        bool LZBHandlesASFA = true;
        public enum SoundType
        {
            Normal,
            StartCurve,
            TransmissionFailure,
            Overspeed,
            NeutralSection,
            Emergency,
            Command,
            EmergencyVoice,
            NeutralSectionVoice,
            CommandVoice,
            V40Voice,
            E40Voice,
            HVoice,
            AlertVoice,
            FreiVoice,
            TransmissionFailureVoice,
        }
        Dictionary<SoundType,float> ActiveSounds = new Dictionary<SoundType,float>();
        
        public bool Isolated;
        public bool DataEntered = false;
        public int VMZ = 200;
        public int PFT = 100;
        public int BP = 0;
        public int LT = 0;
        /*enum PZBTrainType
        {
            O,
            M,
            U
        }
        PZBTrainType PZBTrainType;
        bool HasPZB;
        enum PZBSupervisionState
        {
            Normal,
            Starting,
            Warning,
            RestrictedWarning,
            Approach,
            RestrictedApproach,
        }
        PZBSupervisionState PZBState;
        float PZBDistanceChange;
        float PZBTimeChange;*/
        public bool EmergencyBrake {get; protected set;}
        public bool OE {get; protected set;}
        bool Rebasar = false;
        bool Supervision40 = false;
        float InicioRebasar;
        float MaxDistance = 4000;
        float MaxDistanceBar = 2000;
        float DistanceScale = 1;
        OdoMeter TrainLengthDelayOdometer;
        float TrainLengthDelaySpeed;
        
        Dictionary<string, Dictionary<MensajeTexto, (string, int, int)>> STMMessages = new Dictionary<string,Dictionary<MensajeTexto, (string, int, int)>>();
        Dictionary<MensajeTexto, float> ActiveSTMMessages = new Dictionary<MensajeTexto, float>();
        public string Language = "es";
        enum MensajeTexto
        {
            RebaseVelocidad,
            FrenoEmergencia,
            CambioVelocidad,
            ComienzoCurva,
            Supervision40,
            RebasePuntoParada,
            InformarJefeCirculacion,
            PararInmediatamente,
            ParadaEmergenciaActivada,
            RebaseParadaEmergencia,
            Fin,
            PulsarLiberar,
            RespetarSeñales,
            OrdenPrecaucion,
            Averia,
            FalloTransmision,
            Frenar85,
            FrenarServicio,
            BajarPantografo,
            AbrirDisyuntor,
            SubirPantografo,
            CerrarDisyuntor,
            RespetarPantografos,
        }
        
        public LZB(ServerTCS tcs) : base(tcs)
        {
            Blink = new Blinker(tcs);
            Blink.Setup(1);
            FreiTimer = new Timer(tcs);
            FreiTimer.Setup(8);
            TrainLengthDelayOdometer = new OdoMeter(tcs);
            NeutralSectionStart = new OdoMeter(tcs);
            NeutralSectionEnd = new OdoMeter(tcs);
            
            //SpeedCurves[0] = new Dictionary<float, (float, float)>();
            SpeedCurves[-1] = (0.08f, 0.12f);
            SpeedCurves[0] = (0.14f, 0.21f);
            SpeedCurves[1] = (0.20f, 0.30f);
            SpeedCurves[2] = (0.26f, 0.39f);
            SpeedCurves[3] = (0.32f, 0.48f);
            SpeedCurves[4] = (0.38f, 0.57f);
            SpeedCurves[5] = (0.44f, 0.66f);
            SpeedCurves[6] = (0.50f, 0.75f);
            SpeedCurves[7] = (0.56f, 0.84f);
            SpeedCurves[8] = (0.63f, 0.95f);
            SpeedCurves[9] = (0.70f, 1.05f);
            SpeedCurves[10] = (0.77f, 1.16f);
            
            for (int i=0; i<=(int)Indicator.Stör; i++)
            {
                Indicators[(Indicator)i] = IndicatorStatus.Off;
                STMIndicatorStatus[(Indicator)i] = IndicatorStatus.Off;
                IndicatorMap[(Indicator)i] = 0;
            }
            for (int i=0; i<3; i++)
            {
                Buttons[(Button)i] = false;
            }
            
            STMMessages["de"] = new Dictionary<MensajeTexto, (string, int, int)>();
            STMMessages["de"][MensajeTexto.FrenoEmergencia] = ("Zwangsbremsung", 2, 1);
            STMMessages["de"][MensajeTexto.CambioVelocidad] = ("Geschwindigkeitswechsel", 1, 0);
            STMMessages["de"][MensajeTexto.ComienzoCurva] = ("Bremseinsatzpunkt erwarten", 1, 0);
            STMMessages["de"][MensajeTexto.Supervision40] = ("v-Überwachung 40km/h", 5, 0);
            STMMessages["de"][MensajeTexto.RebasePuntoParada] = ("LZB-Halt überfahren", 2, 1);
            STMMessages["de"][MensajeTexto.InformarJefeCirculacion] = ("Fdl beteiligen", 7, 0);
            STMMessages["de"][MensajeTexto.ParadaEmergenciaActivada] = ("LZB-Nothalt", 2, 1);
            STMMessages["de"][MensajeTexto.RebaseParadaEmergencia] = ("LZB-Nothalt überfahren", 2, 1);
            STMMessages["de"][MensajeTexto.Fin] = ("LZB-ENDE", 5, 0);
            STMMessages["de"][MensajeTexto.PulsarLiberar] = ("Freitaste betätigen", 7, 0);
            STMMessages["de"][MensajeTexto.RespetarSeñales] = ("Signale und Fahrplan beachten", 5, 0);
            STMMessages["de"][MensajeTexto.OrdenPrecaucion] = ("LZB-Vorsichtauftrag", 5, 0);
            STMMessages["de"][MensajeTexto.Averia] = ("LZB-Störung", 5, 0);
            STMMessages["de"][MensajeTexto.FalloTransmision] = ("LZB-Übertragungsausfall", 5, 0);
            STMMessages["de"][MensajeTexto.Frenar85] = ("Abbremsenunter 85km/h", 7, 0);
            STMMessages["de"][MensajeTexto.FrenarServicio] = ("Mit Betriebsbremsung anhalten", 7, 0);
            STMMessages["de"][MensajeTexto.BajarPantografo] = ("Stromabnehmer senken", 7, 0);
            STMMessages["de"][MensajeTexto.SubirPantografo] = ("Stromabnehmer heben", 7, 0);
            STMMessages["de"][MensajeTexto.AbrirDisyuntor] = ("Hauptschalter ausschalten", 7, 0);
            STMMessages["de"][MensajeTexto.CerrarDisyuntor] = ("Hauptschalter einschalten", 7, 0);
            STMMessages["de"][MensajeTexto.RespetarPantografos] = ("Ggf. weitere Stromabnehmer beachten", 5, 0);

            STMMessages["es"] = new Dictionary<MensajeTexto, (string, int, int)>();
            STMMessages["es"][MensajeTexto.RebaseVelocidad] = ("Rebase de velocidad", 5, 0);
            STMMessages["es"][MensajeTexto.FrenoEmergencia] = ("Freno de emergencia", 2, 1);
            STMMessages["es"][MensajeTexto.CambioVelocidad] = ("Cambio de velocidad", 1, 0);
            STMMessages["es"][MensajeTexto.ComienzoCurva] = ("Esperar comienzo de la curva de frenado", 1, 0);
            STMMessages["es"][MensajeTexto.Supervision40] = ("Supervisión de velocidad a 40km/h", 5, 0);
            STMMessages["es"][MensajeTexto.RebasePuntoParada] = ("Rebase del punto de parada LZB", 2, 1);
            STMMessages["es"][MensajeTexto.InformarJefeCirculacion] = ("Informar al jefe de circulación", 7, 0);
            STMMessages["es"][MensajeTexto.PararInmediatamente] = ("Parar de inmediato", 7, 0);
            STMMessages["es"][MensajeTexto.ParadaEmergenciaActivada] = ("Parada de emergencia LZB activada", 2, 1);
            STMMessages["es"][MensajeTexto.Fin] = ("FIN-LZB", 5, 0);
            STMMessages["es"][MensajeTexto.PulsarLiberar] = ("Pulsar LZB-Liberar", 7, 0);
            STMMessages["es"][MensajeTexto.RespetarSeñales] = ("Respetar señales y horario", 5, 0);
            STMMessages["es"][MensajeTexto.OrdenPrecaucion] = ("Orden de precaución LZB", 5, 0);
            STMMessages["es"][MensajeTexto.Averia] = ("Avería LZB", 5, 0);
            STMMessages["es"][MensajeTexto.FalloTransmision] = ("Fallo de transmisión", 5, 0);
            STMMessages["es"][MensajeTexto.Frenar85] = ("Frenar por debajo de 80 km/h", 7, 0);
            STMMessages["es"][MensajeTexto.FrenarServicio] = ("Parar con freno de servicio", 7, 0);
            STMMessages["es"][MensajeTexto.BajarPantografo] = ("Bajar pantógrafo", 7, 0);
            STMMessages["es"][MensajeTexto.SubirPantografo] = ("Subir pantógrafo", 7, 0);
            STMMessages["es"][MensajeTexto.AbrirDisyuntor] = ("Abrir disyuntor principal", 7, 0);
            STMMessages["es"][MensajeTexto.CerrarDisyuntor] = ("Cerrar disyuntor principal", 7, 0);
            STMMessages["es"][MensajeTexto.RespetarPantografos] = ("Respetar otros pantógrafos", 5, 0);
        }
        public override void HandleEvent(TCSEvent ev, string message)
        {
            switch (ev)
            {
                case TCSEvent.GenericTCSButtonPressed:
                case TCSEvent.GenericTCSButtonReleased:
                {
                    int id = int.Parse(message);
                    if (ControlInicioPulsadores != 0 && id < 2)
                    {
                        Buttons[(Button)id] = ev == TCSEvent.GenericTCSButtonPressed && Supervising;
                        tcs.SetCabDisplayControl(id, ev == TCSEvent.GenericTCSButtonPressed && Supervising ? 1 : 0);
                    }
                    int num = id-ControlInicioPulsadores;
                    if (num >= 0 && num < 3)
                    {
                        Buttons[(Button)num] = ev == TCSEvent.GenericTCSButtonPressed;
                        tcs.SetCabDisplayControl(id, ev == TCSEvent.GenericTCSButtonPressed ? 1 : 0);
                    }
                    break;
                }
                case TCSEvent.GenericTCSSwitchOn:
                case TCSEvent.GenericTCSSwitchOff:
                {
                    int num = int.Parse(message);
                    if (num == ControlAnulacion)
                    {
                        Isolated = ev == TCSEvent.GenericTCSSwitchOn;
                        tcs.SetCabDisplayControl(num, Isolated ? 1 : 0);
                    }
                    break;
                }
            }
        }
        public override void Initialize()
        {
            ControlInicioIndicadores = tcs.GetIntParameter("LZB", "FirstIndicator", 31)-1;
            ExternalTransmissionIndicator = tcs.GetIntParameter("LZB", "TransmissionIndicator", 0)-1;
            ControlDistanciaObjetivo = tcs.GetIntParameter("LZB", "TargetDistanceIndicator", 29);
            ControlVelocidadObjetivo = tcs.GetIntParameter("LZB", "TargetSpeedIndicator", 0)-1;
            ControlVelocidadPermitida = tcs.GetIntParameter("LZB", "PermittedSpeedIndicator", 0)-1;
            ControlInicioPulsadores = tcs.GetIntParameter("LZB", "FirstButton", 46)-1;
            ControlAnulacion = tcs.GetIntParameter("LZB", "IsolationButton", 0)-1;
            MaxDistance = tcs.GetFloatParameter("LZB","MaxDistance",4000);
            MaxDistanceBar = tcs.GetFloatParameter("LZB", "MaxDistanceBar", 2000);
            DistanceScale = tcs.GetFloatParameter("LZB", "DistanceScale", 1);

            if (tcs.Serie == 104 || tcs.Serie == 114 || tcs.Serie == 120 || tcs.Serie == 121 || tcs.Serie == 105 || tcs.Serie == 100) PrefijadaVsoll = false;
            LZBHandlesASFA = tcs.Serie != 109 && tcs.Serie != 130 && tcs.Serie != 730;
            
            VMZ = tcs.GetIntParameter("General","MaxSpeed",VMZ);
            VMZ = tcs.GetIntParameter("General","TrainMaxSpeed",VMZ);
            LT = (int)tcs.TrainLengthM();
            Blink.Start();
            tcs.SetCustomizedCabviewControlName(ControlInicioPulsadores + (int)Button.Frei, "LZB liberar");
            tcs.SetCustomizedCabviewControlName(ControlInicioPulsadores + (int)Button.Alertar, "LZB alertar");
            tcs.SetCustomizedCabviewControlName(ControlInicioPulsadores + (int)Button.Command, "LZB rebasar");
            if (ControlAnulacion >= 0) tcs.SetCustomizedCabviewControlName(ControlAnulacion, "Anulación LZB");
            
            if (tcs.GetBoolParameter("LZB", "STM", false)) stm = new LZB_STM(this);
            
            if (tcs.Serie == 446 || (tcs.Serie >= 462 && tcs.Serie >= 465))
            {
                Variant = LZBVariant.SpanishConv;
            }
            else if ((tcs.Serie >= 100 && tcs.Serie <= 200) || tcs.Serie == 730 || tcs.Serie == 252 || tcs.Serie == 355)
            {
                Variant = LZBVariant.SpanishHS;
            }
            else
            {
                Variant = LZBVariant.LZB80;
            }
            
            IndicatorMap[Indicator.B] = 1;
            IndicatorMap[Indicator.Ü] = 2;
            IndicatorMap[Indicator.Stör] = 3;
            IndicatorMap[Indicator.ENDE] = 4;
            IndicatorMap[Indicator.EL] = 5;
            IndicatorMap[Indicator.G] = 6;
            IndicatorMap[Indicator.S] = 7;
            IndicatorMap[Indicator.Hz1000] = 8;
            IndicatorMap[Indicator.H] = 9;
            IndicatorMap[Indicator.V40] = 10;
            IndicatorMap[Indicator.E40] = 11;
            IndicatorMap[Indicator.Befehl40] = 12;
            switch (Variant)
            {
                case LZBVariant.LZB80:
                    IndicatorMap[Indicator.L55] = 13;
                    IndicatorMap[Indicator.L70] = 14;
                    IndicatorMap[Indicator.L85] = 15;
                    break;
                case LZBVariant.SpanishHS:
                    IndicatorMap[Indicator.L60] = 13;
                    IndicatorMap[Indicator.L80] = 14;
                    break;
                case LZBVariant.SpanishConv:
                    IndicatorMap[Indicator.L30] = 13;
                    IndicatorMap[Indicator.L60] = 14;
                    break;
            }
            
            UpdateIndicators();
        }
        float platformLocation;
        bool platformLock;
        bool platformSkip;
        float skippedPlatformLocation;
        float stopTime;
        float NextPlatformDistanceM(int reqNum)
        {
            int num = 0;
            for (int i=0; i<5; i++)
            {
                var feat = tcs.NextGenericSignalFeatures("ATO", i, float.MaxValue);
                var name = feat.MainHeadSignalTypeName.ToLowerInvariant();
                if (name == ((tcs.TrainLengthM() < 110) ? "parada_ato_simple" : "parada_ato"))
                {
                    if (num == reqNum) return feat.DistanceM;
                    else ++num;
                }
            }
            return float.MaxValue;
        }
        float NextPlatformDistanceM()
        {
            if (platformLock)
            {
                float d = platformLocation - tcs.DistanceM();
                if (d < -15) platformLock = false;
                if (Math.Abs(d) < 5 && tcs.SpeedMpS() < 0.1f)
                {
                    if (stopTime == 0) stopTime = tcs.ClockTime();
                    if (tcs.ClockTime() > stopTime + 4)
                    {
                        stopTime = 0;
                        platformLock = false;
                        platformSkip = true;
                        skippedPlatformLocation = platformLocation;
                    }
                }
                return d;
            }
            float dist = NextPlatformDistanceM(0);
            if (platformSkip)
            {
                if (Math.Abs(skippedPlatformLocation - tcs.DistanceM() - dist) > 30) platformSkip = false;
                else dist = NextPlatformDistanceM(1);
            }
            if (dist < 10)
            {
                platformLocation = tcs.DistanceM() + dist;
                platformLock = true;
            }
            return dist;
        }
        void UpdateTargets()
        {
            float curr = Math.Min(CurrentSpeedPost?.SpeedLimitMpS ?? tcs.CurrentPostSpeedLimitMpS(), MpS.FromKpH(Supervision40 ? 40 : VMZ));
            float xg = float.MaxValue;
            float spd = float.MaxValue;
            float dist = float.MaxValue;
            bool end = false;
            float enddist = -1;
            bool totalBlock = false;
            bool partialBlock = false;
            float firstSignal = -1;
            for (int i=0; i<10; i++)
            {
                var feat = tcs.NextGenericSignalFeatures("NORMAL", i, float.MaxValue);
                if (feat.Aspect != Aspect.Stop && (feat.Aspect != Aspect.StopAndProceed || feat.TextAspect == "ParadaLZB"  || feat.TextAspect == "ParadaSelectiva" || feat.TextAspect == "ParadaSelectivaDestellos"))
                {
                    if (firstSignal < 0) firstSignal = feat.DistanceM;
                    if (feat.MainHeadSignalTypeName.ToLowerInvariant() != "pantalla_ertms" && !partialBlock) totalBlock = true;
                    continue;
                }
                if (feat.TextAspect == "RebaseAutorizado")
                {
                    float nspd = MpS.FromKpH(30);
                    float ndist = feat.DistanceM;
                    float nxg = ndist + nspd * nspd / 2 / 0.5f;
                    if (nxg < xg)
                    {
                        xg = nxg;
                        spd = nspd;
                        dist = ndist;
                    }
                    if (i == 0 && ndist < 500)
                    {
                        end = true;
                        enddist = ndist;
                    }
                    break;
                }
                else
                {
                    float nxg = feat.DistanceM;
                    if (feat.MainHeadSignalTypeName.ToLowerInvariant() == "pantalla_ertms" && !totalBlock) partialBlock = true;
                    if (nxg < xg)
                    {
                        xg = nxg-12;
                        spd = 0;
                        dist = nxg;
                        break;
                    }
                }
            }
            if (tcs.Serie == 446)
            {
                float nxg = NextPlatformDistanceM();
                if (nxg < xg)
                {
                    xg = nxg;
                    spd = 0;
                    dist = nxg + 4;
                    end = false;
                }
            }
            for (int i=0; i<10; i++)
            {
                var post = tcs.NextSpeedPostFeatures(i, float.MaxValue);
                string name = post.SpeedPostTypeName?.ToLowerInvariant();
                if (post.IsWarning || name == "placa_2dig" || name == "placa_3dig" || name == "placa_4dig" || name == "lav_rasante1" || name == "lav_rasante2" || name == "lav_rasante3" || name == "lav_rasante4") continue;
                float nspd = Math.Min(post.SpeedLimitMpS, MpS.FromKpH(Supervision40 ? 40 : VMZ));
                if (Math.Abs(nspd - curr)<0.1f) continue;
                float ndist = post.DistanceM;
                float nxg = ndist + nspd * nspd / 2 / 0.5f;
                //if (nspd > curr) continue;
                if (nxg < xg)
                {
                    xg = nxg;
                    spd = nspd;
                    dist = ndist;
                    end = false;
                }
            }
            
            var endmarker = tcs.NextGenericSignalFeatures("LZB", 0, float.MaxValue);
            if (endmarker.MainHeadSignalTypeName == "lzbend" && endmarker.DistanceM < xg && endmarker.DistanceM >= 0)
            {
                float nspd = curr;
                float ndist = endmarker.DistanceM;
                float nxg = ndist + nspd * nspd / 2 / 0.5f;
                if (nxg < xg)
                {
                    xg = nxg;
                    spd = nspd;
                    dist = ndist;
                }
                if (endmarker.DistanceM < 1700)
                {
                    end = true;
                    enddist = ndist;
                }
            }

            if (end && enddist < 50 && FreiPressed)
            {
                Transmission = false;
                Supervising = false;
                FreiPressed = false;
            }
            if (Supervision40 && firstSignal > 0)
            {
                float ndist = firstSignal;
                float nspd = MpS.FromKpH(40);
                float nxg = ndist + MpS.FromKpH(40)*MpS.FromKpH(40) / 2 / 0.5f;
                if (nxg < xg)
                {
                    xg = nxg;
                    spd = nspd;
                    dist = ndist;
                }
            }
            
            if (spd > curr && dist < 10 && LT > 10 && (!TrainLengthDelayOdometer.Started || curr < TrainLengthDelaySpeed))
            {
                TrainLengthDelayOdometer.Setup(LT);
                TrainLengthDelayOdometer.Start();
                TrainLengthDelaySpeed = curr;
            }
            
            if (TrainLengthDelayOdometer.Triggered) TrainLengthDelayOdometer.Stop();
            if (TrainLengthDelayOdometer.Started)
            {
                curr = Math.Min(curr, TrainLengthDelaySpeed);
                float ndist = TrainLengthDelayOdometer.RemainingValue;
                float nspd = curr;
                float nxg = ndist + nspd * nspd / 2 / 0.5f;
                if (nxg < xg)
                {
                    xg = nxg;
                    spd = nspd;
                    dist = ndist;
                    end = false;
                }
            }
            
            if (dist > MaxDistance)
            {
                CurrentSpeed = new SpeedData() {
                    CurrentSpeedMpS = curr,
                    TargetDistanceM = float.MaxValue,
                    TargetSpeedMpS = curr,
                    XGDistanceM = float.MaxValue,
                    DecelCurve = tcs.Serie == 446 ? 9 : 6,
                    Location = CurrentLoop,
                    Down = false,
                    PartialBlock = partialBlock,
                    End = false,
                };
            }
            else
            {
                if (CurrentSpeed?.TargetSpeedMpS > spd && CurrentSpeed?.CurrentSpeedMpS > spd)
                {
                    SendTextMessage(MensajeTexto.CambioVelocidad, true);
                    TriggerSound(SoundType.Normal);
                }
                /*else if (CurrentSpeed?.CurrentSpeedMpS < curr)
                {
                    TriggerSound(SoundType.Normal);
                }*/
                CurrentSpeed = new SpeedData() {
                    CurrentSpeedMpS = curr,
                    TargetDistanceM = dist + LoopOffset,
                    TargetSpeedMpS = spd,
                    XGDistanceM = xg + LoopOffset,
                    DecelCurve = tcs.Serie == 446 ? 9 : 6,
                    Location = CurrentLoop,
                    Down = false,
                    PartialBlock = partialBlock,
                    End = end,
                };
            }
        }
        SignalFeatures? last;
        SignalFeatures? lastMain;
        bool Transmission;
        public bool Supervising {get; private set;}
        float lastSupervising;
        float TransmissionFailureStartTime;
        
        bool RouteFittedTested = false;
        bool RouteFitted = false;
        float failOdometer;
        
        enum TransmissionFailureStep
        {
            Inactive,
            InitialFailure,
            PendingAcknowledgement,
            WaitSpeed,
            WaitStandstill,
            PendingRelease,
            PendingCommand
        }
        TransmissionFailureStep TransmissionFailureState;
        
        void UpdateTransmission()
        {
            if(!RouteFittedTested)
            {
                RouteFitted = tcs.NextGenericSignalDistanceM("LZB") >= 0;
                RouteFittedTested = true;
            }
            bool BKW = false;
            
            if (tcs.DistanceM() - failOdometer > 500)
            {
                if (ServerTCS.Random.Next(1, 1000) == 10) Transmission = false;
                failOdometer = tcs.DistanceM();
            }
            
            bool signalPassed = false;
            {
                var feat = tcs.NextGenericSignalFeatures("NORMAL", 0, float.MaxValue);
                if (lastMain == null) lastMain = feat;
                var l = lastMain.Value;
                if ((feat.MainHeadSignalTypeName != l.MainHeadSignalTypeName || feat.DistanceM > l.DistanceM + 5) && l.DistanceM < 10 && l.DistanceM >= 0)
                {
                    signalPassed = true;
                }
                lastMain = feat;
            }
            
            if (RouteFitted) // Check specific markers
            {
                var feat = tcs.NextGenericSignalFeatures("LZB", 0, float.MaxValue);
                if (last == null) last = feat;
                var l = last.Value;
                if ((feat.MainHeadSignalTypeName != l.MainHeadSignalTypeName || feat.DistanceM > l.DistanceM + 5) && l.DistanceM < 10 && l.DistanceM >= 0)
                {
                    if (l.MainHeadSignalTypeName == "lzbstart")
                    {
                        BKW = true;
                    }
                    /*else if (l.MainHeadSignalTypeName == "lzbend")
                    {
                        Transmission = false;
                        FreiPressed = false;
                    }*/
                }
                last = feat;
            }
            else // Use signals
            {
                BKW = signalPassed;
            }
            
            if (BKW)
            {
                Supervising = true;
                Transmission = true;
                FreiPressed = false;
                CurrentLoop = 0;
                LoopOffset = 0;
                OdometerReference = tcs.DistanceM();
            }
            if (signalPassed && !Rebasar) Supervision40 = false;
            if (Transmission) UpdateTargets();
            else if (!Supervising) CurrentSpeed = null;
        }
        float OdometerReference;
        int CurrentLoop;
        float LoopOffset;
        void UpdateDistance()
        {
            LoopOffset = tcs.DistanceM() - OdometerReference;
            if (Transmission && LoopOffset > 100)
            {
                OdometerReference = tcs.DistanceM();
                CurrentLoop++;
                LoopOffset = 0;
            }
            if (CurrentLoop > 127) Transmission = false;
            if (CurrentSpeed != null && !Rebasar)
            {
                var sp = CurrentSpeed.Value;
                if (sp.TargetSpeedMpS < 1 && sp.TargetDistanceM - LoopOffset - (sp.Down ? -1 : 1) * (CurrentLoop - sp.Location)*100 <= 2)
                {
                    OE = true;
                }
            }
        }
        SpeedPostFeatures? PreviousSpeedPost;
        SpeedPostFeatures? CurrentSpeedPost;
        public OdoMeter NeutralSectionStart;
        OdoMeter NeutralSectionEnd;
        public override void Update()
        {
            if (LT == 0) LT = (int)tcs.TrainLengthM();
            var postFeat = tcs.NextSpeedPostFeatures(0, float.MaxValue);
            if (PreviousSpeedPost.HasValue && (PreviousSpeedPost.Value.DistanceM + 5 < postFeat.DistanceM || PreviousSpeedPost.Value.SpeedLimitMpS != postFeat.SpeedLimitMpS))
            {
                string name = PreviousSpeedPost.Value.SpeedPostTypeName?.ToLowerInvariant();
                if (!(PreviousSpeedPost.Value.IsWarning || name == "placa_2dig" || name == "placa_3dig" || name == "placa_4dig" || name == "lav_rasante1" || name == "lav_rasante2" || name == "lav_rasante3" || name == "lav_rasante4")) CurrentSpeedPost = PreviousSpeedPost;
            }
            if (postFeat.SpeedLimitMpS < 0) PreviousSpeedPost = null;
            else PreviousSpeedPost = postFeat;
            
            if (Supervising)
            {
                for (int i=0; i<10; i++)
                {
                    if (NeutralSectionStart.Started) break;
                    var feat = tcs.NextGenericSignalFeatures("INFO",i,float.MaxValue);
                    if (feat.DistanceM > 1000) break;
                    if (feat.MainHeadSignalTypeName == "iniciozonaneutra" || feat.MainHeadSignalTypeName == "startneutro")
                    {
                        if (feat.DistanceM < tcs.SpeedMpS() * 11)
                        {
                            for (int j=i; j<10; j++)
                            {
                                var feat2 = tcs.NextGenericSignalFeatures("INFO",j,float.MaxValue);
                                if (feat2.MainHeadSignalTypeName == "finzonaneutra" || feat2.MainHeadSignalTypeName == "endneutro")
                                {
                                    NeutralSectionStart.Setup(feat.DistanceM);
                                    NeutralSectionStart.Start();
                                    NeutralSectionEnd.Setup(feat2.DistanceM);
                                    NeutralSectionEnd.Start();
                                    break;
                                }
                            }
                            break;
                        }
                    }
                }
                if (stm == null)
                {
                    if (NeutralSection == null) NeutralSection = new TrackConditionProfile();
                    NeutralSection.Active = NeutralSectionStart.Started;
                }
                if (NeutralSectionEnd.Started && NeutralSectionEnd.RemainingValue < -tcs.NeutralSectionDelayM())
                {
                    NeutralSectionStart.Stop();
                    NeutralSectionEnd.Stop();
                }
            }
            else
            {
                NeutralSectionStart.Stop();
                NeutralSectionEnd.Stop();
                NeutralSection = null;
            }
            if (NeutralSectionStart.Started && !ActiveSounds.ContainsKey(SoundType.NeutralSectionVoice))
            {
                TriggerSound(SoundType.NeutralSectionVoice);
            }
            else if (!NeutralSectionEnd.Started && ActiveSounds.ContainsKey(SoundType.NeutralSectionVoice))
            {
                StopSound(SoundType.NeutralSectionVoice);
            }
            
            if (Isolated) DataEntered = false;
            bool prevActivated = Activated;
            Activated = !Isolated && tcs.IsCabPowerSupplyOn() && tcs.IsLowVoltagePowerSupplyOn();
            if (stm != null)
            {
                STMState state = stm.State;
                stm.Update();
                Activated &= stm.State == STMState.HS || stm.State == STMState.DA;
                if (state != stm.State && stm.State == STMState.DA) TriggerSound(SoundType.Normal);
            }
            if (Supervising && (stm == null || stm.State == STMState.DA)) lastSupervising = tcs.ClockTime();
            /*if (Supervising) tcs.CabSignallingStatus = "LZB";
            else if (tcs.CabSignallingStatus == "LZB") tcs.CabSignallingStatus = null;*/
            if (!Activated)
            {
                if (prevActivated)
                {
                    tcs.ATO?.Disable("LZB");
                    Supervising = Transmission = false;
                    CurrentSpeed = null;
                    EmergencyBrake = false;
                    for (int i=0; i<=(int)Indicator.Stör; i++)
                    {
                        Indicators[(Indicator)i] = IndicatorStatus.Off;
                        STMIndicatorStatus[(Indicator)i] = IndicatorStatus.Off;
                    }
                    ActiveSounds.Clear();
                    UpdateIndicators();
                }
#if USE_ATO
                if (ControlVelocidadPermitida >= 0) tcs.SetCabDisplayControl(ControlVelocidadPermitida, PrefijadaVsoll && tcs.SetSpeedMpS.HasValue ? MpS.ToKpH(tcs.SetSpeedMpS.Value) : 0);
#endif
                Emergency = !Isolated && stm == null;
                CurrentLoop = 0;
                LoopOffset = 0;
                OdometerReference = tcs.DistanceM();
                return;
            }
            UpdateDistance();
            UpdateTransmission();
            if (!Supervising)
            {
                Rebasar = Supervision40 = false;
            }
            if (!Supervising || (Transmission && (CurrentSpeed == null || !CurrentSpeed.Value.End)))
            {
                FreiPressed = false;
                FreiTimer.Stop();
            }
            Vist = tcs.SpeedMpS();
            Vsoll = 0;
            Vint = 0;
            Vziel = 0;
            Zielentfernung = 0;
            if (Rebasar)
            {
                Vsoll = MpS.FromKpH(40);
                Vint = MpS.FromKpH(48.75f);
                if (Vist > Vint)
                {
                    if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                        StopSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Off;
                }
                else if (Vist > Vsoll + MpS.FromKpH(5))
                {
                    if (Indicators[Indicator.G] != IndicatorStatus.Flash)
                        TriggerSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Flash;
                }
                else
                {
                    if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                        StopSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Off;
                }
            }
            else if (TransmissionFailureState > TransmissionFailureStep.InitialFailure)
            {
                if (FreiTimer.Triggered) TransmissionFailureStartTime = 0;
                if (TransmissionFailureState == TransmissionFailureStep.PendingCommand)
                {
                    Vsoll = 0;
                    Vint = MpS.FromKpH(8.75f);
                }
                else
                {
                    Vziel = CurrentSpeed.Value.PartialBlock ? 0 : MpS.FromKpH(40);
                    Vsoll = Math.Max(CurrentSpeed.Value.CurrentSpeedMpS - Math.Max(0.5f*(tcs.ClockTime() - TransmissionFailureStartTime - 10), 0), Vziel);
                    Vint = Math.Max(Vsoll + MpS.FromKpH(8.75f), MpS.FromKpH(25));
                }
                if (Vist > Vint)
                {
                    if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                        StopSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Off;
                }
                else if (Vist > Math.Max(Vsoll + MpS.FromKpH(5), MpS.FromKpH(20)))
                {
                    if (Indicators[Indicator.G] != IndicatorStatus.Flash)
                        TriggerSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Flash;
                }
                else
                {
                    if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                        StopSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Off;
                }
            }
            else if (CurrentSpeed != null)
            {
                var sp = CurrentSpeed.Value;
                float xgDistance = Math.Max(sp.XGDistanceM - LoopOffset - (sp.Down ? -1 : 1) * (CurrentLoop - sp.Location)*100, 0);
                float brakingDistance = sp.CurrentSpeedMpS*sp.CurrentSpeedMpS/2/SpeedCurves[sp.DecelCurve].Item1;
                Zielentfernung = Math.Max(Math.Min(sp.TargetDistanceM, sp.XGDistanceM) - LoopOffset - (sp.Down ? -1 : 1) * (CurrentLoop - sp.Location)*100, 0);
                Vsoll = Math.Min(sp.CurrentSpeedMpS, Math.Max((float)Math.Sqrt(2*xgDistance*SpeedCurves[sp.DecelCurve].Item1), sp.TargetSpeedMpS));
                Vint = Math.Min(sp.CurrentSpeedMpS + MpS.FromKpH(8.75f), Math.Max(tcs.SpeedCurve(Zielentfernung, sp.TargetSpeedMpS + MpS.FromKpH(8.75f), 0, 0, SpeedCurves[sp.DecelCurve].Item2), sp.TargetSpeedMpS + MpS.FromKpH(8.75f)));
                Vziel = Math.Min(sp.TargetSpeedMpS, sp.CurrentSpeedMpS);
                if (Vist > Vint)
                {
                    if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                        StopSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Off;
                }
                else if (Vist > Vsoll + MpS.FromKpH(5) && Vist < Vint)
                {
                    if (Indicators[Indicator.G] != IndicatorStatus.Flash)
                        TriggerSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Flash;
                }
                else
                {
                    if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                        StopSound(SoundType.Overspeed);
                    if (xgDistance < brakingDistance + (Variant != LZBVariant.SpanishConv ? 1000 : 350) && Vist > (Variant != LZBVariant.SpanishConv ? (Vsoll - MpS.FromKpH(30)) : Vziel) && Vsoll > Vziel)
                    {
                        if (Indicators[Indicator.G] == IndicatorStatus.Off)
                        {
                            TriggerSound(SoundType.StartCurve);
                            SendTextMessage(MensajeTexto.ComienzoCurva, true);
                        }
                        Indicators[Indicator.G] = IndicatorStatus.On;
                    }
                    else Indicators[Indicator.G] = IndicatorStatus.Off;
                }
            }
            /*else if (HasPZB)
            {
                float speed = float.MaxValue;
                switch (PZBState)
                {
                    case PZBSupervisionState.Normal:
                        switch(PZBTrainType)
                        {
                            case PZBTrainType.O:
                                speed = MpS.FromKpH(160);
                                break;
                            case PZBTrainType.M:
                                speed = MpS.FromKpH(125);
                                break;
                            case PZBTrainType.U:
                                speed = MpS.FromKpH(105);
                                break;
                        }
                        break;
                    case PZBSupervisionState.Warning:
                        if (Vist < MpS.FromKpH(10))
                        {
                            PZBState = PZBSupervisionState.RestrictedWarning;
                        }
                        switch(PZBTrainType)
                        {
                            case PZBTrainType.O:
                                speed = MpS.FromKpH(Math.Min(165, Math.Max(165 - (tcs.ClockTime() - PZBTimeChange - 2.5)*80/21.5f, 85)));
                                break;
                            case PZBTrainType.M:
                                speed = MpS.FromKpH(Math.Min(125, Math.Max(125 - (tcs.ClockTime() - PZBTimeChange - 2.5)*55/27.5f, 70)));
                                break;
                            case PZBTrainType.U:
                                speed = MpS.FromKpH(Math.Min(105, Math.Max(105 - (tcs.ClockTime() - PZBTimeChange - 2.5)*50/36.5f, 55)));
                                break;
                        }
                        break;
                    case PZBSupervisionState.RestrictedWarning:
                        speed = MpS.FromKpH(45);
                        break;
                    case PZBSupervisionState.Approach:
                        if (Vist < MpS.FromKpH(10))
                        {
                            PZBState = PZBSupervisionState.RestrictedApproach;
                        }
                        switch(PZBTrainType)
                        {
                            case PZBTrainType.O:
                                speed = MpS.FromKpH(Math.Min(65, Math.Max(65 - (tcs.DistanceM() - PZBDistanceChange)*20/153, 45)));
                                break;
                            case PZBTrainType.M:
                                speed = MpS.FromKpH(Math.Min(50, Math.Max(50 - (tcs.DistanceM() - PZBDistanceChange)*15/153, 35)));
                                break;
                            case PZBTrainType.U:
                                speed = MpS.FromKpH(Math.Min(40, Math.Max(40 - (tcs.DistanceM() - PZBDistanceChange)*15/153, 25)));
                                break;
                        }
                        break;
                    case PZBSupervisionState.RestrictedApproach:
                        switch(PZBTrainType)
                        {
                            case PZBTrainType.M:
                            case PZBTrainType.U:
                                speed = MpS.FromKpH(25);
                                break;
                            case PZBTrainType.O:
                                speed = MpS.FromKpH(Math.Min(45, Math.Max(45 - (tcs.DistanceM() - PZBDistanceChange)*20/200, 25)));
                                speed = MpS.FromKpH(Math.Min(30, Math.Max(30 - (tcs.DistanceM() - PZBDistanceChange)*20/200, 10)));
                                break;
                        }
                        break;
                }
                speed = Math.Min(MpS.FromKpH(VMZ+5), speed);
                Vint = speed + MpS.FromKpH(2.5);
                if (Vist > Vint)
                {
                    if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                        StopSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Off;
                }
                else if (Vist > speed)
                {
                    if (Indicators[Indicator.G] != IndicatorStatus.Flash)
                        TriggerSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Flash;
                }
                else
                {
                    if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                        StopSound(SoundType.Overspeed);
                    Indicators[Indicator.G] = IndicatorStatus.Off;
                }
            }*/
            else
            {
                if (Indicators[Indicator.G] == IndicatorStatus.Flash)
                    StopSound(SoundType.Overspeed);
                Indicators[Indicator.G] = IndicatorStatus.Off;
            }
            Indicators[Indicator.L30] = IndicatorStatus.Off;
            Indicators[Indicator.L55] = IndicatorStatus.Off;
            Indicators[Indicator.L60] = IndicatorStatus.Off;
            Indicators[Indicator.L70] = IndicatorStatus.Off;
            Indicators[Indicator.L80] = IndicatorStatus.Off;
            Indicators[Indicator.L85] = IndicatorStatus.Off;
            Indicators[Indicator.Befehl40] = IndicatorStatus.Off;
            if (ActiveSTMMessages.TryGetValue(MensajeTexto.CambioVelocidad, out float time) && tcs.ClockTime() - time > 20)
            {
                SendTextMessage(MensajeTexto.CambioVelocidad, false);
            }
            if (ActiveSTMMessages.TryGetValue(MensajeTexto.ComienzoCurva, out time) && tcs.ClockTime() - time > 20)
            {
                SendTextMessage(MensajeTexto.ComienzoCurva, false);
            }
            if (ActiveSTMMessages.TryGetValue(MensajeTexto.SubirPantografo, out time) && tcs.ClockTime() - time > 20)
            {
                SendTextMessage(MensajeTexto.SubirPantografo, false);
            }
            if (ActiveSTMMessages.TryGetValue(MensajeTexto.CerrarDisyuntor, out time) && tcs.ClockTime() - time > 20)
            {
                SendTextMessage(MensajeTexto.CerrarDisyuntor, false);
            }
            if (ActiveSTMMessages.TryGetValue(MensajeTexto.RespetarPantografos, out time) && tcs.ClockTime() - time > 20)
            {
                SendTextMessage(MensajeTexto.RespetarPantografos, false);
            }
            if (!Transmission && Supervising)
            {
                switch(TransmissionFailureState)
                {
                    case TransmissionFailureStep.Inactive:
                        TransmissionFailureStartTime = tcs.ClockTime();
                        TransmissionFailureState = TransmissionFailureStep.InitialFailure;
                        break;
                    case TransmissionFailureStep.InitialFailure:
                        if (tcs.ClockTime() - TransmissionFailureStartTime > 3)
                        {
                            TransmissionFailureState = TransmissionFailureStep.PendingAcknowledgement;
                            Zielentfernung = 0;
                            FreiTimer.Start();
                            TriggerSound(SoundType.TransmissionFailure);
                        }
                        break;
                    case TransmissionFailureStep.PendingAcknowledgement:
                        if (Buttons[Button.Frei])
                        {
                            FreiTimer.Stop();
                            Buttons[Button.Frei] = false;
                            TransmissionFailureState = CurrentSpeed.Value.PartialBlock ? TransmissionFailureStep.WaitStandstill : TransmissionFailureStep.WaitSpeed;
                        }
                        break;
                    case TransmissionFailureStep.WaitSpeed:
                        if (Vist < MpS.FromKpH(Variant == LZBVariant.SpanishHS ? 80 : (Variant == LZBVariant.SpanishConv ? 60 : 85))) TransmissionFailureState = TransmissionFailureStep.PendingRelease;
                        break;
                    case TransmissionFailureStep.PendingRelease:
                        switch (Variant)
                        {
                            case LZBVariant.SpanishHS:
                                Indicators[Indicator.L80] = IndicatorStatus.Flash;
                                Indicators[Indicator.L60] = IndicatorStatus.CounterFlash;
                                break;
                            case LZBVariant.SpanishConv:
                                Indicators[Indicator.L60] = IndicatorStatus.Flash;
                                break;
                            default:
                                Indicators[Indicator.L85] = IndicatorStatus.Flash;
                                break;
                        }
                        if (Buttons[Button.Frei])
                        {
                            Supervising = false;
                            Buttons[Button.Frei] = false;
                            TransmissionFailureState = TransmissionFailureStep.Inactive;
                        }
                        break;
                    case TransmissionFailureStep.WaitStandstill:
                        if (Vist < 1) TransmissionFailureState = TransmissionFailureStep.PendingCommand;
                        break;
                    case TransmissionFailureStep.PendingCommand:
                        Indicators[Indicator.Befehl40] = IndicatorStatus.Flash;
                        break;
                }
            }
            else
            {
                TransmissionFailureState = TransmissionFailureStep.Inactive;
            }
            Indicators[Indicator.Stör] = TransmissionFailureState == TransmissionFailureStep.InitialFailure ? IndicatorStatus.On : IndicatorStatus.Off;
            SendTextMessage(MensajeTexto.FalloTransmision, TransmissionFailureState > TransmissionFailureStep.InitialFailure);
            SendTextMessage(MensajeTexto.Frenar85, TransmissionFailureState == TransmissionFailureStep.WaitSpeed);
            SendTextMessage(MensajeTexto.PulsarLiberar, FreiTimer.Started);
            SendTextMessage(MensajeTexto.Supervision40, Supervision40);
            SendTextMessage(MensajeTexto.RespetarSeñales, (CurrentSpeed != null && CurrentSpeed.Value.End && FreiPressed) || TransmissionFailureState > TransmissionFailureStep.PendingAcknowledgement);
            SendTextMessage(MensajeTexto.FrenarServicio, TransmissionFailureState == TransmissionFailureStep.WaitStandstill);
            SendTextMessage(MensajeTexto.InformarJefeCirculacion, TransmissionFailureState == TransmissionFailureStep.PendingCommand || OE);
            if (!Supervising)
            {
                if (!DataEntered)
                {
                    Indicators[Indicator.Stör] = IndicatorStatus.Flash;
                    Indicators[Variant == LZBVariant.SpanishConv ? Indicator.L30 : (Variant == LZBVariant.SpanishHS ? Indicator.L80 : Indicator.L85)] = IndicatorStatus.CounterFlash;
                }
                else
                {
                    switch (Variant)
                    {
                        case LZBVariant.SpanishHS:
                            Indicators[Indicator.L80] = IndicatorStatus.On;
                            break;
                        case LZBVariant.SpanishConv:
                            Indicators[Indicator.L60] = IndicatorStatus.On;
                            break;
                        default:
                            Indicators[Indicator.L85] = IndicatorStatus.On;
                            break;
                    }
                }
            }
            if (CurrentSpeed != null && CurrentSpeed.Value.End)
            {
                if (!FreiTimer.Started && !FreiPressed)
                {
                    FreiTimer.Start();
                    TriggerSound(SoundType.Normal);
                }
                if (Buttons[Button.Frei])
                {
                    FreiPressed = true;
                    Buttons[Button.Frei] = false;
                    FreiTimer.Stop();
                }
            }
            if (Vist < 1 && Buttons[Button.Frei]) DataEntered = true;
            if (Buttons[Button.Command] && Vist < 1)
            {
                if (TransmissionFailureState == TransmissionFailureStep.PendingCommand)
                {
                    Supervising = false;
                    TriggerSound(SoundType.Command);
                }
                else if (!Rebasar)
                {
                    Rebasar = true;
                    InicioRebasar = tcs.DistanceM();
                    Supervision40 = true;
                    OE = false;
                    if (stm != null) stm.SendMessage("00010010"+ETCS.format_binary(21, 13));
                    TriggerSound(SoundType.Command);
                }
            }
            else
            {
                StopSound(SoundType.Command);
            }
            if (Rebasar && tcs.DistanceM() - InicioRebasar > 50 && (Variant != LZBVariant.SpanishConv || (Variant == LZBVariant.SpanishConv && Buttons[Button.Frei])))
            {
                Rebasar = false;
            }
            if (Indicators[Indicator.Befehl40] != IndicatorStatus.Flash) Indicators[Indicator.Befehl40] = Buttons[Button.Command] || Rebasar ? IndicatorStatus.On : IndicatorStatus.Off;
            
            if (Supervising && (Vist > Vint || FreiTimer.Triggered || OE) && !EmergencyBrake)
            {
                EmergencyBrake = true;
                TriggerSound(SoundType.Emergency);
                TriggerSound(SoundType.EmergencyVoice);
            }
            else if (EmergencyBrake && (!Supervising || Vist <= Vsoll) && !FreiTimer.Triggered && !OE)
            {
                EmergencyBrake = false;
                StopSound(SoundType.Emergency);
                StopSound(SoundType.EmergencyVoice);
            }
            Indicators[Indicator.S] = EmergencyBrake ? (FreiTimer.Triggered ? IndicatorStatus.Flash : IndicatorStatus.On) : IndicatorStatus.Off;
            if (OE)
            {
                if (Indicators[Indicator.H] != IndicatorStatus.On)
                {
                    TriggerSound(SoundType.Emergency);
                    Indicators[Indicator.H] = IndicatorStatus.On;
                }
            }
            else
            {
                if (Indicators[Indicator.H] == IndicatorStatus.On)
                {
                    StopSound(SoundType.Emergency);
                    Indicators[Indicator.H] = IndicatorStatus.Off;
                }
            }
            if (tcs.ATO != null)
            {
                if (Supervising && CurrentSpeed != null)
                {
                    var sp = CurrentSpeed.Value;
                    float dec = SpeedCurves[sp.DecelCurve].Item1;
                    tcs.ATO.SetSpeed("LZB", Vsoll, Vziel, Zielentfernung, 0, dec);
                    //tcs.Message(ConfirmLevel.None, String.Format("{0} {1}", Math.Min(sp.TargetDistanceM, sp.XGDistanceM) - LoopOffset - (sp.Down ? -1 : 1) * (CurrentLoop - sp.Location)*100, tcs.AccelerationMpSS()));
                }
                else
                {
                    tcs.ATO.Disable("LZB");
                }
            }
            Indicators[Indicator.Hz1000] = tcs.BrakePipePressureBar() < 3.5 ? IndicatorStatus.Flash : IndicatorStatus.Off;
            if (Activated && (tcs.BrakePipePressureBar() > 3.5 || stm != null))
            {
                if (Indicators[Indicator.B] == IndicatorStatus.Off) TriggerSound(SoundType.Normal);
                Indicators[Indicator.B] = IndicatorStatus.On;
            }
            else Indicators[Indicator.B] = IndicatorStatus.Off;
            if (Transmission)
            {
                if (Indicators[Indicator.Ü] == IndicatorStatus.Off) TriggerSound(SoundType.Normal);
                Indicators[Indicator.Ü] = IndicatorStatus.On;
            }
            else if (TransmissionFailureState == TransmissionFailureStep.PendingAcknowledgement)
            {
                if (Indicators[Indicator.Ü] != IndicatorStatus.Flash) TriggerSound(SoundType.TransmissionFailure);
                Indicators[Indicator.Ü] = IndicatorStatus.Flash;
            }
            else Indicators[Indicator.Ü] = IndicatorStatus.Off;
            Indicators[Indicator.ENDE] = CurrentSpeed != null && CurrentSpeed.Value.End ? (FreiPressed ? IndicatorStatus.On : IndicatorStatus.Flash) : IndicatorStatus.Off;
            if (NeutralSectionStart.Started && !NeutralSectionEnd.Triggered)
            {
                if (Indicators[Indicator.EL] == IndicatorStatus.Off) TriggerSound(SoundType.NeutralSection);
                Indicators[Indicator.EL] = IndicatorStatus.On;
            }
            else Indicators[Indicator.EL] = IndicatorStatus.Off;
            
            Emergency = EmergencyBrake && (stm == null || stm.State == STMState.DA);
            
            UpdateIndicators();
        }
        
        public float Vist;
        public float Vsoll;
        public float Vint;
        public float Vziel;
        public float Zielentfernung;
        public void UpdateIndicators()
        {
            UpdateSound();
            if (stm != null)
            {
                bool changed = false;
                if (stm.State != STMState.DA)
                {
                    for (int i=0; i<STMIndicators.Length; i++)
                    {
                        STMIndicators[i] = Indicator.None;
                    }
                }
                else for (int i=1; i<=(int)Indicator.Stör; i++)
                {
                    var ind = (Indicator)i;
                    if (Indicators[ind] != STMIndicatorStatus[ind])
                    {
                        changed = true;
                        int pos = -1;
                        if (ind == Indicator.B)
                        {
                            STMIndicators[0] = ind;
                            pos = 0;
                        }
                        else if (ind != Indicator.Ü)
                        {
                            for (int j=1; j<STMIndicators.Length; j++)
                            {
                                if (Indicators[STMIndicators[j]] == IndicatorStatus.Off)
                                {
                                    STMIndicators[j] = Indicator.None;
                                }
                                if (STMIndicators[j] == ind)
                                {
                                    pos = j;
                                    break;
                                }
                            }
                            if (pos < 0)
                            {
                                for (int j=1; j<STMIndicators.Length; j++)
                                {
                                    if (STMIndicators[j] == Indicator.None && Indicators[ind] != IndicatorStatus.Off)
                                    {
                                        STMIndicators[j] = ind;
                                        pos = j;
                                        break;
                                    }
                                }
                            }
                        }
                        {
                            if (ind == Indicator.G)
                            {
                                SendTextMessage(MensajeTexto.RebaseVelocidad, Indicators[ind] == IndicatorStatus.Flash);
                            }
                            else if (ind == Indicator.S)
                            {
                                SendTextMessage(MensajeTexto.FrenoEmergencia, Indicators[ind] == IndicatorStatus.On);
                            }
                            else if (ind == Indicator.H)
                            {
                                SendTextMessage(MensajeTexto.RebasePuntoParada, Indicators[ind] == IndicatorStatus.On);
                            }
                            else if (ind == Indicator.ENDE)
                            {
                                SendTextMessage(MensajeTexto.Fin, Indicators[ind] != IndicatorStatus.Off);
                            }
                            else if (ind == Indicator.EL)
                            {
                                SendTextMessage(MensajeTexto.BajarPantografo, Indicators[ind] == IndicatorStatus.Flash);
                                SendTextMessage(MensajeTexto.AbrirDisyuntor, Indicators[ind] == IndicatorStatus.On);
                                if (Indicators[ind] == IndicatorStatus.Off)
                                {
                                    if (STMIndicatorStatus[ind] == IndicatorStatus.Flash)
                                    {
                                        SendTextMessage(MensajeTexto.SubirPantografo, true);
                                        SendTextMessage(MensajeTexto.RespetarPantografos, true);
                                    }
                                    else if (STMIndicatorStatus[ind] == IndicatorStatus.On)
                                    {
                                        SendTextMessage(MensajeTexto.CerrarDisyuntor, true);
                                        SendTextMessage(MensajeTexto.RespetarPantografos, true);
                                    }
                                }
                            }
                        }
                        STMIndicatorStatus[ind] = Indicators[ind];
                    }
                }
                if (changed)
                {
                    List<string> changedIcons = new List<string>();
                    for (int i=0; i<6; i++)
                    {
                        string str = ETCS.format_binary(i+1, 8) + ETCS.format_binary(i+1, 5);
                        str += ETCS.format_binary(IndicatorMap[STMIndicators[i]], 8);
                        str += "1";
                        var status = STMIndicators[i] == Indicator.None ? IndicatorStatus.Off : Indicators[STMIndicators[i]];
                        str += status == IndicatorStatus.CounterFlash ? "1" : "0";
                        str += status == IndicatorStatus.On ? "00" : "01";
                        str += "000000" + "000000";
                        changedIcons.Add(str);
                    }
                    string inds = ETCS.format_binary(changedIcons.Count, 5);
                    foreach (string str in changedIcons)
                    {
                        inds += str;
                    }
                    inds = "00100011"+ETCS.format_binary(21+inds.Length, 13)+inds;
                    stm.SendMessage(inds);
                }
                if (stm.State == STMState.DA)
                {
                    tcs.ETCSStatus.CurrentMonitor = Monitor.CeilingSpeed;
                    tcs.ETCSStatus.CurrentSupervisionStatus = SupervisionStatus.Normal;
                    if (Supervising && !Rebasar)
                    {
                        tcs.ETCSStatus.TargetDistanceM = Transmission ? Zielentfernung : null;
                        tcs.ETCSStatus.AllowedSpeedMpS = Vsoll;
                        tcs.ETCSStatus.TargetSpeedMpS = Vziel;
                    }
                    else
                    {
                        tcs.ETCSStatus.TargetDistanceM = null;
                        tcs.ETCSStatus.AllowedSpeedMpS = Rebasar ? Vsoll : 0;
                        tcs.ETCSStatus.TargetSpeedMpS = null;
                    }
                }
                if ((stm.State == STMState.DA || stm.State == STMState.HS) && (!stm.MonitorTimer.Started || stm.MonitorTimer.Triggered))
                {
                    string param = "00101011"+"0000001100100"+"01";
                    param += ETCS.format_binary((int)(Vsoll*3.6f), 10)+ETCS.format_etcs_speed(Vziel);
                    param += "0000000000"+"0100000010";
                    param += ETCS.format_etcs_distance(Math.Min(Zielentfernung, MaxDistance));
                    
                    param += Emergency ? "110" : (tcs.SpeedMpS() > Vsoll && Supervising ? "101" : "000");
                    
                    if (Supervising && !Rebasar) param += "010"+"11"+"011"+"10"+"000"+"00"+"101"+"00"+(Transmission && !OE ? "11" : "00");
                    else if (Rebasar) param += "010"+"01"+"011"+"00"+"000"+"00"+"101"+"00"+"00";
                    else param +=  "010"+"00"+"011"+"00"+"000"+"00"+"101"+"00"+"00";
                    stm.SendMessage(param);
                    stm.MonitorTimer.Start();
                }
                
                for (int i=0; i<STMIndicators.Length; i++)
                {
                    var ind = STMIndicators[i];
                    if (ind == Indicator.None)
                    {
                        tcs.SetCabDisplayControl(ControlInicioIndicadores + i, 0);
                        continue;
                    }
                    IndicatorStatus status = Indicators[ind];
                    int light = 0;
                    if (status == IndicatorStatus.Off || stm.State != STMState.DA) light = 0;
                    else if (status == IndicatorStatus.On) light = 1;
                    else if ((status == IndicatorStatus.CounterFlash) ^ Blink.On) light = 1;
                    tcs.SetCabDisplayControl(ControlInicioIndicadores + i, light * IndicatorMap[ind]);
                }
                if (ExternalTransmissionIndicator >= 0)
                {
                    var status = Indicators[Indicator.Ü];
                    int light = 0;
                    if (status == IndicatorStatus.Off) light = 0;
                    else if (status == IndicatorStatus.On) light = 1;
                    else if ((status == IndicatorStatus.CounterFlash) ^ Blink.On) light = 1;
                    tcs.SetCabDisplayControl(ExternalTransmissionIndicator, light);
                }
                return;
            }
            foreach (var kvp in Indicators)
            {
                int estado = 0;
                if (kvp.Value == IndicatorStatus.Off) estado = 0;
                else if (kvp.Value == IndicatorStatus.On) estado = 1;
                else if ((kvp.Value == IndicatorStatus.CounterFlash) ^ Blink.On) estado = 1;
                tcs.SetCabDisplayControl(ControlInicioIndicadores + IndicatorMap[kvp.Key] - 1, estado);
            }
            if (!Supervising)
            {
                tcs.SetCabDisplayControl(ControlDistanciaObjetivo, 0);
                tcs.SetCabDisplayControl(ControlDistanciaObjetivo-1, 2);
                if (ControlVelocidadObjetivo >= 0) tcs.SetCabDisplayControl(ControlVelocidadObjetivo, 0);
                else tcs.SetNextSpeedLimitMpS(0);
#if USE_ATO
                if (ControlVelocidadPermitida >= 0) tcs.SetCabDisplayControl(ControlVelocidadPermitida, PrefijadaVsoll && tcs.SetSpeedMpS.HasValue ? MpS.ToKpH(tcs.SetSpeedMpS.Value) : 0);
                else tcs.SetCurrentSpeedLimitMpS(0);
#else
                tcs.SetCurrentSpeedLimitMpS(0);
#endif
            }
            else if (Rebasar || TransmissionFailureState == TransmissionFailureStep.PendingCommand)
            {
                tcs.SetCabDisplayControl(ControlDistanciaObjetivo, 0);
                tcs.SetCabDisplayControl(ControlDistanciaObjetivo-1, 2);
                if (ControlVelocidadObjetivo >= 0) tcs.SetCabDisplayControl(ControlVelocidadObjetivo, 0);
                else tcs.SetNextSpeedLimitMpS(0);
                if (ControlVelocidadPermitida >= 0) tcs.SetCabDisplayControl(ControlVelocidadPermitida, Rebasar ? MpS.ToKpH(Vsoll) : 0);
                else tcs.SetCurrentSpeedLimitMpS(Rebasar ? Vsoll : 0);
            }
            else
            {
                if (!Transmission || OE)
                {
                    tcs.SetCabDisplayControl(ControlDistanciaObjetivo, 0);
                    tcs.SetCabDisplayControl(ControlDistanciaObjetivo-1, 1);
                }
                else if (Zielentfernung > MaxDistanceBar)
                {
                    if (Zielentfernung > MaxDistance)  tcs.SetCabDisplayControl(ControlDistanciaObjetivo, MaxDistance/DistanceScale);
                    else tcs.SetCabDisplayControl(ControlDistanciaObjetivo, (int)(Zielentfernung/100)*100/DistanceScale);
                    tcs.SetCabDisplayControl(ControlDistanciaObjetivo-1, 0);
                }
                else
                {
                    float ziel = Zielentfernung;
                    float ind = 0;
                    if (MaxDistanceBar == 2000)
                    {
                        if (ziel > 1500) ind = 32+(ziel-1500)/500*5;
                        else if (ziel > 1000) ind = 27+(ziel-1000)/500*5;
                        else if (ziel > 750) ind = 22+(ziel-750)/250*5;
                        else if (ziel > 500) ind = 17+(ziel-500)/250*5;
                        else if (ziel > 250) ind = 12+(ziel-250)/250*5;
                        else if (ziel > 100) ind = 8+(ziel-100)/150*4;
                        else if (ziel > 50) ind = 4+(ziel-50)/50*4;
                        else ind = ziel/50*4;
                    }
                    else
                    {
                        if (ziel > 3000) ind = 32+(ziel-3000)/1000*5;
                        else if (ziel > 2000) ind = 27+(ziel-2000)/1000*5;
                        else if (ziel > 1000) ind = 22+(ziel-1000)/1000*5;
                        else if (ziel > 750) ind = 17+(ziel-750)/250*5;
                        else if (ziel > 500) ind = 12+(ziel-500)/250*5;
                        else if (ziel > 250) ind = 8+(ziel-250)/250*4;
                        else if (ziel > 100) ind = 4+(ziel-100)/150*4;
                        else ind = ziel/100*4;
                    }
                    tcs.SetCabDisplayControl(ControlDistanciaObjetivo, (float)Math.Floor(ind)/37.0f*MaxDistanceBar/DistanceScale);
                    tcs.SetCabDisplayControl(ControlDistanciaObjetivo-1, 1);
                }
                if (ControlVelocidadObjetivo >= 0) tcs.SetCabDisplayControl(ControlVelocidadObjetivo, MpS.ToKpH(Vziel));
                else tcs.SetNextSpeedLimitMpS(Vziel);
                if (ControlVelocidadPermitida >= 0) tcs.SetCabDisplayControl(ControlVelocidadPermitida, MpS.ToKpH(Vsoll));
                else tcs.SetCurrentSpeedLimitMpS(Vsoll);
            }
        }
        void SendTextMessage(MensajeTexto type, bool display)
        {
            if (stm == null) return;
            if (ActiveSTMMessages.ContainsKey(type))
            {
                if (display) return;
                ActiveSTMMessages.Remove(type);
            }
            else
            {
                if (!display) return;
                ActiveSTMMessages[type] = tcs.ClockTime();
            }
            if (STMMessages[Language].TryGetValue(type, out var tm))
            {
                int id = (int)type + 1;
                string txt = tm.Item1;
                int col1 = tm.Item2;
                int col2 = tm.Item3;
                string msg;
                if (display)
                {
                    msg = ETCS.format_binary(id, 8);
                    msg += "1000"+ETCS.format_binary(col1,3)+ETCS.format_binary(col2, 3);
                    msg += "0";
                    byte[] ascii = System.Text.Encoding.GetEncoding(28591).GetBytes(txt);
                    msg += ETCS.format_binary(ascii.Length, 8);
                    for (int j=0; j<ascii.Length; j++)
                    {
                        msg += ETCS.format_binary((int)ascii[j],8);
                    }
                    msg = "00100110"+ETCS.format_binary(msg.Length+21, 13)+msg;
                }
                else
                {
                    msg = "00100111"+ETCS.format_binary(29, 13)+ETCS.format_binary(id, 8);
                }
                stm.SendMessage(msg);
            }
        }
        float LastPlayedSound;
        public void TriggerSound(SoundType id)
        {
            ActiveSounds[id] = tcs.ClockTime();
        }
        public void StopSound(SoundType id)
        {
            ActiveSounds.Remove(id);
        }
        void UpdateSound()
        {
            List<SoundType> old = new List<SoundType>();
            foreach (var kvp in ActiveSounds)
            {
                float threshold = float.MaxValue;
                float delay = 4;
                SoundType id = kvp.Key;
                switch (id)
                {
                    case SoundType.Normal:
                    case SoundType.StartCurve:
                        threshold = 1;
                        delay = 2;
                        break;
                    case SoundType.Overspeed:
                        delay = 2;
                        break;
                    case SoundType.TransmissionFailure:
                        threshold = 3;
                        break;
                    case SoundType.NeutralSection:
                        threshold = 11;
                        break;
                    case SoundType.EmergencyVoice:
                    case SoundType.NeutralSectionVoice:
                    case SoundType.CommandVoice:
                    case SoundType.V40Voice:
                    case SoundType.E40Voice:
                    case SoundType.HVoice:
                    case SoundType.AlertVoice:
                    case SoundType.FreiVoice:
                    case SoundType.TransmissionFailureVoice:
                        delay = 1.5f;
                        break;
                }
                if (threshold < tcs.ClockTime() - kvp.Value)
                {
                    old.Add(id);
                }
                else if (tcs.ClockTime() - LastPlayedSound > delay)
                {
                    LastPlayedSound = tcs.ClockTime();
                    if (stm != null)
                    {
                        string snd = "00001";
                        switch (id)
                        {
                            case SoundType.EmergencyVoice:
                                snd += "00000011"+"01"+"00000";
                                break;
                            case SoundType.NeutralSectionVoice:
                            case SoundType.CommandVoice:
                            case SoundType.V40Voice:
                            case SoundType.E40Voice:
                            case SoundType.HVoice:
                            case SoundType.AlertVoice:
                            case SoundType.FreiVoice:
                            case SoundType.TransmissionFailureVoice:
                                snd += "00000010"+"01"+"00000";
                                break;
                            default:
                                snd += "00000001"+"01"+"00001"+ETCS.format_binary(450/32, 8)+ETCS.format_binary(10, 8);
                                break;
                        }
                        snd = "00101110"+ETCS.format_binary(snd.Length + 21, 13) + snd;
                        stm.SendMessage(snd);
                    }
                    else
                    {
                        switch (id)
                        {
                            case SoundType.EmergencyVoice:
                                break;
                            case SoundType.NeutralSectionVoice:
                            case SoundType.CommandVoice:
                            case SoundType.V40Voice:
                            case SoundType.E40Voice:
                            case SoundType.HVoice:
                            case SoundType.AlertVoice:
                            case SoundType.FreiVoice:
                            case SoundType.TransmissionFailureVoice:
                                break;
                            case SoundType.Overspeed:
                            case SoundType.StartCurve:
                                tcs.TriggerSoundAlert2();
                                break;
                            default:
                                tcs.TriggerSoundAlert1();
                                break;
                        }
                    }
                }
            }
            foreach (var snd in old)
            {
                ActiveSounds.Remove(snd);
            }
        }
        public override List<Parameter> GetParameters()
        {
            List<Parameter> l = new List<Parameter>();
            
            Parameter p;

            p = new Parameter("stm::command_etcs");
            p.SetValue = (string val) => {
                byte[] data = Convert.FromBase64String(val);
                stm?.HandleMessage(new ETCSVariables(data));
            };
            l.Add(p);
            
            p = new Parameter("asfa::akt::lzb");
            p.GetValue = () => {
                if (!LZBHandlesASFA) return "0";
                return (Supervising && (stm == null || stm.State == STMState.DA)) || tcs.ClockTime() - lastSupervising < 0.5f ? "1" : "0";
            };
            l.Add(p);
            
            p = new Parameter("asfa::con::lzb");
            p.GetValue = () => {
                if (!LZBHandlesASFA) return "1";
                return (Supervising && (stm == null || stm.State == STMState.DA)) ? "0" : "1";
            };
            l.Add(p);

            p = new Parameter("lzb::supervising");
            p.GetValue = () => {
                if (LZBHandlesASFA) return "-1";
                return Supervising ? "1" : "0";
            };
            l.Add(p);
            
            p = new Parameter("stm::10::isolated");
            p.GetValue = () => {
                return Isolated ? "1" : "0";
            };
            l.Add(p);
            
            p = new Parameter("lzb::vziel");
            p.GetValue = () => {
                return (!Supervising || Rebasar) ? "" : ((int)MpS.ToKpH(Vziel)).ToString();
            };
            l.Add(p);
            
            p = new Parameter("lzb::vsoll");
            p.GetValue = () => {
                return !Supervising ? "0" : ((int)MpS.ToKpH(Vsoll)).ToString();
            };
            l.Add(p);
            
            p = new Parameter("lzb::zielentfernung");
            p.GetValue = () => {
                return (!Supervising || Rebasar || !Transmission || OE) ? "" : (((int)(Zielentfernung/5))*5).ToString();
            };
            l.Add(p);
            
            return l;
        }
    }
    public class ETCSVariables
    {
        List<bool> bits;
        public int Offset;
        public int Length => bits.Count;
        public ETCSVariables()
        {
            bits = new List<bool>();
        }
        public ETCSVariables(byte[] buffer)
        {
            bits = new List<bool>(buffer.Length*8);
            for (int i=0; i<buffer.Length; i++)
            {
                for (int j=0; j<8; j++)
                {
                    bits.Add(((buffer[i] >> (7 - j)) & 1) == 1);
                }
            }
        }
        public void Push(long variable, int size)
        {
            for (int i=0; i<size; i++)
            {
                bits.Add(((variable>>(size-i-1)) & 1) == 1);
            }
        }
        public void Replace(int pos, long variable, int size)
        {
            for (int i = 0; i < size; i++)
            {
                bits[pos + i] = ((variable >> (size - i - 1)) & 1) == 1;
            }
        }
        public long Access(int pos, int size)
        {
            long v = 0;
            for (int i=0; i<size; i++)
            {
                if (bits[pos + Offset + i]) v |= 1 << (size - i - 1);
            }
            return v;
        }
        public long Read(int size)
        {
            long l = Access(0, size);
            Offset += size;
            return l;
        }
        public float ReadDistanceM(int scale)
        {
            return Read(15) * (scale == 2 ? 10.0f : (scale == 0 ? 0.1f : 1.0f));
        }
        public float ReadSpeedMpS()
        {
            return Read(7)*5/3.6f;
        }
        public byte[] ToArray()
        {
            int size = (bits.Count + 7) / 8;
            byte[] data = new byte[size];
            int div = bits.Count / 8;
            int rem = bits.Count % 8;
            for (int i = 0; i < div; i++)
            {
                byte c = 0;
                for (int j = 0; j < 8; j++)
                {
                    if (bits[8*i+j]) c |= (byte)(1 << (7 - j));
                }
                data[i] = c;
            }
            if (rem > 0)
            {
                byte c = 0;
                for (int i = 0; i < rem; i++)
                {
                    if (bits[8 * div + i]) c |= (byte)(1 << (7 - i));
                }
                data[div] = c;
            }
            data[1] = (byte)(size >> 2);
            data[2] = (byte)((size << 6) | (data[2] & 63));
            return data;
        }
    }
    public class EBICAB_STM
    {
        ServerTCS tcs;
        EBICAB900 ASFA;
        
        public STMState State;
        public STMState Requested;
        public bool Conditional;
        Timer UpdateTimer;
        public Timer MonitorTimer;

        public bool RequestData = true;
        public bool DataEntryOngoing = false;
        
        Mode CurrentETCSMode;
        
        public EBICAB_STM(EBICAB900 asfa)
        {
            ASFA = asfa;
            tcs = asfa.tcs;
            UpdateTimer = new Timer(tcs);
            UpdateTimer.Setup(1);
            MonitorTimer = new Timer(tcs);
            MonitorTimer.Setup(0.5f);
        }
        public void Update()
        {
            bool powered = ASFA.Activated && tcs.IsCabPowerSupplyOn() && tcs.IsLowVoltagePowerSupplyOn();
            STMState prevState = State;
            if (!powered) State = STMState.NP;
            else if (State == STMState.NP)
            {
                State = STMState.PO;
                Requested = STMState.PO;
            }
            else
            {
                if (Requested == STMState.CO)
                {
                    if (State == STMState.PO) State = STMState.CO;
                    else if (State != STMState.CO) State = STMState.FA;
                }
                else if (Requested == STMState.DE)// Data entry
                {
                    if (State == STMState.CO) State = STMState.DE;
                    else if (State != STMState.DE) State = STMState.FA;
                }
                else if (Requested == STMState.CS) // Unconditional cold standby
                {
                    if (State == STMState.CO || State == STMState.DE || State == STMState.HS || State == STMState.DA) State = STMState.CS;
                    else if (State != STMState.CS) State = STMState.FA;
                }
                else if (Requested == STMState.CCS) // Conditional cold standby
                {
                    if (State == STMState.DA)
                    {
                        State = STMState.CS;
                    }
                    else if (State != STMState.CS) State = STMState.FA;
                }
                else if (Requested == STMState.HS) // Hot standby
                {
                    if (State == STMState.CS){
                        State = STMState.HS;
                    }    
                    else if (State != STMState.HS)
                        State = STMState.FA;
                }
                else if (Requested == STMState.DA) // Data available
                {
                    if (State == STMState.CS || State == STMState.HS) State = STMState.DA;
                    else if (State != STMState.DA) State = STMState.FA;
                }
                else if (Requested == STMState.FA) State = STMState.FA; // Failure
            }
            if (!UpdateTimer.Started || UpdateTimer.Triggered || prevState != State)
            {
                var state = "";
                if (State == STMState.PO && prevState != State)
                {
                    state += "00000001"+ETCS.format_binary(37, 13)+ETCS.format_binary(4, 8)+ETCS.format_binary(0, 8); // Send version
                }
                else if (State == STMState.CO && RequestData)
                {
                    state += "00001101"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)STMState.DE, 4); // Request DE state
                }
                else if (State == STMState.CO && ((/*LZB.DataEntered &&*/ !RequestData) || CurrentETCSMode == Mode.NL || CurrentETCSMode == Mode.SL))
                {
                    state += "00001101"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)STMState.CS, 4); // Request CS state
                }
                //if (State == STMState.DA && ASFA.Emergency) state += "00010010"+ETCS.format_binary(21, 13); // Report national trip procedure
                state += "10000000"+ETCS.format_binary(25, 13)+(ASFA.Emergency ? "01" : "10")+"10"; // Brake command
                SendMessage(state);
                UpdateTimer.Start();
            }
        }
        public void SendMessage(string packs)
        {
            packs = "00001111"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)State, 4)+packs;
            while (packs.Length % 8 != 0) packs += "0";
            var msg = ETCS.format_binary(19, 8)+ETCS.format_binary(packs.Length/8 + 2, 8)+packs;
            byte[] data = new byte[(msg.Length+7)/8];
            for (int i = 0; i < msg.Length; i++)
            {
                if (msg[i] == '1') data[i/8] |= (byte)(1<<(7-i%8));
            }
            tcs.SendParameter("noretain(stm::command",Convert.ToBase64String(data)+")");
        }
        string GetDataEntryField(string name, string[] values, string value)
        {
            byte[] ascii1 = System.Text.Encoding.GetEncoding(28591).GetBytes(name);
            byte[] ascii2 = System.Text.Encoding.GetEncoding(28591).GetBytes(value.ToString());
            string f = ETCS.format_binary(ascii1.Length, 6);
            for (int i=0; i<ascii1.Length; i++)
            {
                f += ETCS.format_binary(ascii1[i], 8);
            }
            f += ETCS.format_binary(ascii2.Length, 5);
            for (int i=0; i<ascii2.Length; i++)
            {
                f += ETCS.format_binary(ascii2[i], 8);
            }
            f += ETCS.format_binary(values.Length, 5);
            for (int i=0; i<values.Length; i++)
            {
                byte[] ascii3 = System.Text.Encoding.GetEncoding(28591).GetBytes(values[i].ToString());
                f += ETCS.format_binary(ascii3.Length, 5);
                for (int j=0; j<ascii3.Length; j++)
                {
                    f += ETCS.format_binary(ascii3[j], 8);
                }
            }
            return f;
        }
        string GetDataEntryField(string name, int value)
        {
            byte[] ascii1 = System.Text.Encoding.GetEncoding(28591).GetBytes(name);
            byte[] ascii2 = System.Text.Encoding.GetEncoding(28591).GetBytes(value.ToString());
            string f = ETCS.format_binary(ascii1.Length, 6);
            for (int i=0; i<ascii1.Length; i++)
            {
                f += ETCS.format_binary(ascii1[i], 8);
            }
            f += ETCS.format_binary(ascii2.Length, 5);
            for (int i=0; i<ascii2.Length; i++)
            {
                f += ETCS.format_binary(ascii2[i], 8);
            }
            f += ETCS.format_binary(0, 5);
            return f;
        }
        public void HandleMessage(ETCSVariables var)
        {
            int nid_stm = (int)var.Read(8);
            if (nid_stm != 19 && nid_stm != 255) return;
            var.Offset += 8;
            while (var.Length - var.Offset > 8)
            {
                int nid_packet = (int)var.Read(8);
                int l_packet = (int)var.Read(13);
                if (l_packet < 21) break;
                int offset = var.Offset + l_packet - 21;
                Console.WriteLine(nid_packet);
                switch(nid_packet)
                {
                    case 1:
                        break;
                    case 5:
                        if (var.Read(3) == 1) var.Read(8);
                        //CurrentETCSMode = (Mode)var.Read(4);
                        if (State == STMState.PO)
                        {
                            string msg = "10110101"+ETCS.format_binary(22, 13)+(RequestData ? "1" : "0"); // Specific data need
                            msg += "00001101"+ETCS.format_binary(25, 13)+ETCS.format_binary((int)STMState.CO, 4); // Request CO state
                            SendMessage(msg); 
                        }
                        break;
                    case 14:
                        Requested = (STMState)var.Read(4);
                        break;
                    case 34:{
                        int num = (int)var.Read(5);
                        for (int i=0; i<num; i++)
                        {
                            int id = (int)var.Read(8);
                            bool pressed = var.Read(1) == 1;
                            switch (id)
                            {
                                case 1:
                                    ASFA.estados_botones[ASFA.PREC] = pressed ? 1 : 0;
                                    break;
                                case 2:
                                    ASFA.estados_botones[ASFA.PAlarma] = pressed ? 1 : 0;
                                    break;
                                case 3:
                                    ASFA.estados_botones[ASFA.PRearme] = pressed ? 1 : 0;
                                    break;
                                case 4:
                                    if (pressed) ASFA.estados_botones[ASFA.PRebase] = 1-ASFA.estados_botones[ASFA.PRebase];
                                    break;
                                case 5:
                                    if (pressed) ASFA.estados_botones[ASFA.PModo] = 1-ASFA.estados_botones[ASFA.PModo];
                                    break;
                            }
                        }
                        break;
                    }
                    case 175:
                        var.Offset += 19;
                        var.Read(12);
                        ASFA.TipoTren = (int)var.Read(7)*5;
                        if (ASFA.TipoTren <= 70) ASFA.TipoTren = 70;
                        else if (ASFA.TipoTren <= 90) ASFA.TipoTren = 90;
                        else if (ASFA.TipoTren <= 110) ASFA.TipoTren = 110;
                        else if (ASFA.TipoTren <= 160) ASFA.TipoTren = 160;
                        else ASFA.TipoTren = 200;
                        if (DataEntryOngoing)
                        {
                            if (RequestData)
                            {
                                string pack="0"+ETCS.format_binary(1, 5);
                                pack += ETCS.format_binary(1, 8)+GetDataEntryField("Modo ASFA", new string[]{"ATP SIN", "ATP AVE"}, ASFA.ASFAAVE ? "ATP AVE" : "ATP SIN");
                                SendMessage("10110011"+ETCS.format_binary(pack.Length + 21, 13)+pack); // Specific data need
                            }
                            else
                            {
                                SendMessage("10110011"+ETCS.format_binary(27, 13)+"0"+"00000"); // No specific data need
                            }
                        }
                        break;
                    case 180: {
                        int nfields = (int)var.Read(5);
                        int success = 0;
                        for (int i=0; i<nfields; i++)
                        {
                            int id = (int)var.Read(8);
                            int length = (int)var.Read(5);
                            string result = "";
                            for (int j=0; j<length; j++)
                            {
                                result += (char)var.Read(8);
                            }
                            if (id == 1)
                            {
                                switch (result)
                                {
                                    case "ATP SIN":
                                        ASFA.estados_botones[ASFA.PModo] = 0;
                                        success++;
                                        break;
                                    case "ATP AVE":
                                        ASFA.estados_botones[ASFA.PModo] = 1;
                                        success++;
                                        break;
                                }
                            }
                        }
                        if (success >= 1)
                        {
                            SendMessage("10110011"+ETCS.format_binary(27, 13)+"0"+"00000"); // End of specific data need
                        }
                        else
                        {
                            string pack="0"+ETCS.format_binary(1, 5);
                            pack += ETCS.format_binary(1, 8)+GetDataEntryField("Modo ASFA", new string[]{"ATP SIN", "ATP AVE"}, "");
                            SendMessage("10110011"+ETCS.format_binary(pack.Length + 21, 13)+pack); // Specific data need
                        }
                        break;
                    }   
                    case 184:
                        bool start = var.Read(1)==1;
                        DataEntryOngoing = start;
                        if (start) {}
                        else if (State == STMState.DE) SendMessage("00001101" + ETCS.format_binary(25, 13) + ETCS.format_binary((int)STMState.CS, 4)); // Request CS state
                        break;
                    case 176:
                        break;
                }
                var.Offset = offset;
            }
        }
    }
    public class EBICAB900 : ASFAclasico
    {
        Timer STMSendIndicatorsTimer;
        public EBICAB900(ServerTCS tcs) : base(tcs)
        {
        }
        public override void Initialize()
        {
            stm = new EBICAB_STM(this);
            STMSendIndicatorsTimer = new Timer(tcs);
            STMSendIndicatorsTimer.Setup(5);
            estados_botones[PConex] = 1;
            ASFADual = true;
            //STMSendIndicatorsTimer.Start();
        }
        void sendSTMIndicators()
        {
            //STMSendIndicatorsTimer.Start();
            if (stm == null) return;
            List<string> inds = new List<string>();
            List<string> butts = new List<string>();
            for (int i = 0; i<estados_luces.Length; i++)
            {
                bool on = estados_luces[i];
                int id = 0;
                string name = "";
                int ilumcol = 5;
                bool butt = false;
                if (i+2 == LuzFrenar)
                {
                    name = "FRENAR";
                    id = 1;
                }
                else if (i+2 == LuzL2)
                {
                    id = 2;
                    ilumcol = 4;
                }
                else if (i+2 == LuzRojo)
                {
                    id = 3;
                    ilumcol = 2;
                }
                else if (i+2 == LuzEficacia)
                {
                    name = "EFICACIA";
                    ilumcol = 4;
                    id = 6;
                }
                else if (i+2 == LuzREC)
                {
                    name = "REC";
                    id = 1;
                    butt = true;
                }
                else if (i+2 == LuzAlarma)
                {
                    name = "ALARMA\nASFA";
                    id = 2;
                    butt = true;
                    ilumcol = 2;
                }
                else if (i+2 == LuzRearme)
                {
                    name = "REARME\nFRENO";
                    id = 3;
                    butt = true;
                    ilumcol = 2;
                }
                else if (i+2 == LuzRebase)
                {
                    name = "REBASE\nAUTO";
                    id = 4;
                    butt = true;
                }
                else if (i+2 == LuzRenfe && on)
                {
                    name = "RENFE";
                    id = 5;
                    butt = true;
                }
                else if (i+2 == LuzAVE && on)
                {
                    name = "AVE";
                    id = 5;
                    butt = true;
                }
                else
                {
                    continue;
                }
                if (id > 0)
                {
                    string ind = ETCS.format_binary(id, 8) + ETCS.format_binary(id, 5);
                    ind += ETCS.format_binary(0, 8);
                    ind += "1";
                    ind += "0" + "00";
                    ind += on ? ETCS.format_binary(ilumcol, 3) : "001";
                    ind += "000";
                    byte[] ascii = System.Text.Encoding.GetEncoding(28591).GetBytes(name);
                    ind += ETCS.format_binary(ascii.Length, 6);
                    for (int j=0; j<ascii.Length; j++)
                    {
                        ind += ETCS.format_binary(ascii[j], 8);
                    }
                    if (butt) butts.Add(ind);
                    else inds.Add(ind);
                }
            }
            string msg = "";
            if (inds.Count > 0)
            {
                string pack = ETCS.format_binary(inds.Count, 5);
                foreach (string str in inds)
                {
                    pack += str;
                }
                msg += "00100011"+ETCS.format_binary(21+pack.Length, 13)+pack;
            }
            if (butts.Count > 0)
            {
                string pack = ETCS.format_binary(butts.Count, 5);
                foreach (string str in butts)
                {
                    pack += str;
                }
                msg += "00100000"+ETCS.format_binary(21+pack.Length, 13)+pack;
            }
            if (msg != "") stm.SendMessage(msg);
        }
        protected override void digitalWrite(int pin, int value)
        {
            bool on = value != 0;
            if (estados_luces[pin-2] == on) return;
            estados_luces[pin-2] = on;
            sendSTMIndicators();
        }
        protected override void buzz(ulong time)
        {
            string pack = ETCS.format_binary(2, 5);
            pack += ETCS.format_binary(time == 500 ? 1 : 2, 8)+ETCS.format_binary(time == 500 ? 1 : 2, 2)+ETCS.format_binary(0, 5);
            stm.SendMessage("00101110"+ETCS.format_binary(21+pack.Length, 13)+pack);
            BuzzEnd = millis() + time;
        }
        protected override void nobuzz()
        {
            string pack = ETCS.format_binary(2, 5);
            pack += ETCS.format_binary(1, 8)+ETCS.format_binary(0, 2)+ETCS.format_binary(0, 5);
            pack += ETCS.format_binary(2, 8)+ETCS.format_binary(0, 2)+ETCS.format_binary(0, 5);
            stm.SendMessage("00101110"+ETCS.format_binary(21+pack.Length, 13)+pack);
        }
        public override void HandleEvent(TCSEvent ev, string message)
        {
            if(ev == TCSEvent.GenericTCSButtonPressed || ev == TCSEvent.GenericTCSButtonReleased)
            {
                int num = int.Parse(message);
                bool pressed = ev == TCSEvent.GenericTCSButtonPressed;
                if (num == 0)
                {
                    estados_botones[PREC] = pressed ? 1 : 0;
                }
            }
        }
        /*public void Foo()
        {
            float distance = NextSignalDistanceM(1);
            float nextSpeed = MpS.FromKpH(220);
            float currentSpeed = MpS.FromKpH(220);
            switch (aspect)
            {
                case Aspecto.VíaLibre:
                    break;
                case Aspecto.VíaLibreCondicional:
                    nextSpeed = MpS.FromKpH(160);
                    break;
                case Aspecto.PreanuncioParada:
                    currentSpeed = MpS.FromKpH(160);
                    break;
                case Aspecto.AnuncioPrecaucion:
                    currentSpeed = MpS.FromKpH(160);
                    break;
                default:
                    nextSpeed = 0;
                    break;
            }
        }*/
    }
}
