using System;
using System.Collections.Generic;
using Orts.Common;
using ORTS.Common;
using ORTS.Scripting.Api;
using Event = Orts.Common.Event;
using Orts.Simulation.RollingStocks;
using Orts.Simulation.RollingStocks.SubSystems;
using Orts.Simulation.Signalling;
using Orts.Simulation;
namespace ORTS.Scripting.Script
{
    public class MetroMadrid : TrainControlSystem
    {
        public enum CodigoATP
        {
            Ninguno,
            ATP1P,
            ATP2P,
            ATPDO
        }
        float ATPCurrentSpeedMpS;
        float ATPNextSpeedMpS;
        float ATPCurrentBlockMaxSpeedLimitMpS;
        float ATPNextBlockMaxSpeedLimitMpS;
        float ATPTargetDistanceM;
        float ATPLastDisplayedSpeed;
        float ATPLastDisplaySpeedChange;
        bool ATPAutoBrake;
        bool ATPTCO;
        bool ATPServiceBrake;
        float prevSpeedMpS;
        int ControlExcesoVelocidadATP = 0;
        int ControlVelocidadATP = 2;
        int ControlCodigosATP = 3;
        int ControlM_20 = 4;
        int ControlATP = 5;
        int ControlATO = 6;
        int ControlLanzarATO = 1;
        ATO ATO;
        public bool ATOArranque1;
        public bool ATOArranque2;
        float ATOPrevStationDistanceM;
        CodigoATP ATPCodigoVia;
        public enum ModoConduccion
        {
            Inactivo,
            LlaveEspecial,
            M_20,
            M_ATP,
            ATO,
        }
        ModoConduccion ModoConduccionActual;
        public override void Initialize()
        {
            SetCustomizedCabviewControlName(ControlExcesoVelocidadATP, "Exceso velocidad");
            SetCustomizedCabviewControlName(ControlM_20, "Manual+20");
            SetCustomizedCabviewControlName(ControlATP, "Manual+ATP");
            SetCustomizedCabviewControlName(ControlATO, "ATO");
            SetCustomizedCabviewControlName(ControlLanzarATO, "Lanzar ATO");
            ATPAutoBrake = GetBoolParameter("ATP", "MantenerVelocidad", false);
            ATO = new ATO(this);
            ATO.Initialize();
        }
        public override void Update()
        {
            if (!IsCabPowerSupplyOn() || !IsLowVoltagePowerSupplyOn() || IsDirectionNeutral() || !IsTrainControlEnabled()) RequestMode(ModoConduccion.Inactivo);
            if (!IsDirectionForward() && ModoConduccionActual > ModoConduccion.M_20) RequestMode(ModoConduccion.M_20);
            
            UpdateSignalPassed();
            UpdatePostPassed();
            
            if (ModoConduccionActual >= ModoConduccion.M_20) UpdateATP();
            if (ModoConduccionActual == ModoConduccion.ATO && (TrainBrakeControllerState() != ControllerState.Release || IsBrakeEmergency())) RequestMode(ModoConduccion.M_ATP);
            if (ModoConduccionActual == ModoConduccion.ATO) UpdateATO();
            else ATO.Disable("ATO");
            ATO.Update();
            //UpdateMegafonia();
            SetEmergencyBrake(ModoConduccionActual == ModoConduccion.Inactivo && IsTrainControlEnabled());
            if  (ModoConduccionActual == ModoConduccion.ATO) SetFullBrake(false);
            else if (ModoConduccionActual == ModoConduccion.M_ATP) SetFullBrake(ATPServiceBrake);
            else SetFullBrake(false);
            UpdateLazoTraccion(ATPTCO);
        }
        float platformLocation;
        bool platformLock;
        bool platformSkip;
        float skippedPlatformLocation;
        float stopTime;
        float NextPlatformDistanceM(int reqNum)
        {
            int num = 0;
            for (int i=0; i<5; i++)
            {
                var feat = NextGenericSignalFeatures("ATO", i, float.MaxValue);
                var name = feat.MainHeadSignalTypeName.ToLowerInvariant();
                if (name == ((TrainLengthM() < 80) ? "parada_ato_simple" : "parada_ato"))
                {
                    if (num == reqNum) return feat.DistanceM;
                    else ++num;
                }
            }
            return float.MaxValue;
        }
        float NextPlatformDistanceM()
        {
            if (platformLock)
            {
                float d = platformLocation - DistanceM();
                if (d < -15) platformLock = false;
                if (Math.Abs(d) < 5 && SpeedMpS() < 0.1f)
                {
                    if (stopTime == 0) stopTime = ClockTime();
                    if (ClockTime() > stopTime + 4)
                    {
                        stopTime = 0;
                        platformLock = false;
                        platformSkip = true;
                        skippedPlatformLocation = platformLocation;
                    }
                }
                return d;
            }
            float dist = NextPlatformDistanceM(0);
            if (platformSkip)
            {
                if (Math.Abs(skippedPlatformLocation - DistanceM() - dist) > 30) platformSkip = false;
                else dist = NextPlatformDistanceM(1);
            }
            if (dist < 10)
            {
                platformLocation = DistanceM() + dist;
                platformLock = true;
            }
            return dist;
        }
        public void RequestMode(ModoConduccion modo)
        {
            if (modo == ModoConduccionActual) return;
            ModoConduccion prev = ModoConduccionActual;
            if (modo == ModoConduccion.M_20 && IsDirectionNeutral()) return;
            if (modo > ModoConduccion.M_20 && (!IsDirectionForward() || ATPCodigoVia == CodigoATP.Ninguno)) return;
            if (modo == ModoConduccion.ATO && SpeedMpS() > 0.1f) return;
            ModoConduccionActual = modo;
            if (ModoConduccionActual >= ModoConduccion.M_20 && prev < ModoConduccion.M_20)
            {
                ATPNextSpeedMpS = ATPCurrentSpeedMpS = MpS.FromKpH(20);
                ATPCurrentBlockMaxSpeedLimitMpS = 0;
            }
            if (ModoConduccionActual < ModoConduccion.M_20 && prev >= ModoConduccion.M_20)
            {
                ATPCodigoVia = CodigoATP.Ninguno;
                SetCabDisplayControl(ControlExcesoVelocidadATP, 0);
                SetCabDisplayControl(ControlCodigosATP, 0);
                SetCabDisplayControl(ControlVelocidadATP, 0);
            }
            if (ModoConduccionActual < ModoConduccion.ATO && prev == ModoConduccion.ATO)
            {
                SetThrottleController(0);
                SetDynamicBrakeController(0);
            }
            SetCabDisplayControl(ControlM_20, ModoConduccionActual == ModoConduccion.M_20 ? 1 : 0);
            SetCabDisplayControl(ControlATP, ModoConduccionActual == ModoConduccion.M_ATP ? 1 : 0);
            SetCabDisplayControl(ControlATO, ModoConduccionActual == ModoConduccion.ATO ? 1 : 0);
        }
        float GetATPBrakingDistanceM(float current, float target)
        {
            return DistanceCurve(current, target, 0, 5, 1);
        }
        /*float GetATPSpeedMpS(float speed, float distance)
        {
            if (speed > MpS.FromKpH(57.1f) && GetATPBrakingDistanceM(MpS.FromKpH(80), speed) < distance) return MpS.FromKpH(80);
            else if (speed > MpS.FromKpH(34.1f) && GetATPBrakingDistanceM(MpS.FromKpH(70), speed) < distance) return MpS.FromKpH(70);
            else if (speed > MpS.FromKpH(0.1f) && GetATPBrakingDistanceM(MpS.FromKpH(57), speed) < distance) return MpS.FromKpH(57);
            else if (GetATPBrakingDistanceM(MpS.FromKpH(34), speed) < distance) return MpS.FromKpH(34);
            return 0;
            if (speed > MpS.FromKpH(57.1f)) return MpS.FromKpH(80);
            else if (speed > MpS.FromKpH(34.1f)) return MpS.FromKpH(70);
            else if (speed > MpS.FromKpH(0.1f)) return MpS.FromKpH(57);
            else return MpS.FromKpH(34);
        }*/
        float GetATPSpeedMpS(float speed)
        {
            if (speed > MpS.FromKpH(70.1f))
                return MpS.FromKpH(80);
            if (speed > MpS.FromKpH(57.1f))
                return MpS.FromKpH(70);
            if (speed > MpS.FromKpH(34.1f))
                return MpS.FromKpH(57);
            return MpS.FromKpH(34);
        }
        float GetATPBlockMaxSpeedMpS(float startDistM, float endDistM)
        {
            float current = CurrentPostSpeedMpS;
            float post = MpS.FromKpH(80);
            for (int i=0; i<15; i++)
            {
                float dist = NextPostDistanceM(i);
                float spd = NextPostSpeedLimitMpS(i);
                if (dist > endDistM || dist < 0) break;
                else if (dist > startDistM) post = Math.Min(spd, post);
                if (dist < startDistM + 15) current = post;
            }
            post = Math.Min(post, current);
            return GetATPSpeedMpS(post);
        }
        int GetATP1PCode(string aspect)
        {
            if (!aspect.StartsWith("ATP1P_")) return 0;
            int.TryParse(aspect.Substring(6), out int code);
            return code;
        }
        (int,int) GetATP2PCodes(string aspect)
        {
            if (!aspect.StartsWith("ATP2P_")) return (0,0);
            bool err = !int.TryParse(aspect.Substring(6, aspect.IndexOf('/')-6), out int v1);
            err |= !int.TryParse(aspect.Substring(aspect.IndexOf('/')+1), out int v2);
            if (err) return (0,0);
            return (v1, v2);
        }
        int GetATPDOAhead(string aspect)
        {
            if (!aspect.StartsWith("ATPDO_")) return -1;
            bool err = int.TryParse(aspect.Substring(6), out int ahead);
            if (err) return -1;
            return ahead;
        }
        public void UpdateATP()
        {
            var txt = NextGenericSignalFeatures("NORMAL", 0, float.MaxValue).TextAspect;
            if (txt.Contains("ATPDO")) ATPCodigoVia = CodigoATP.ATPDO;
            else if (txt.Contains("ATP2P")) ATPCodigoVia = CodigoATP.ATP2P;
            else if (txt.Contains("ATP1P")) ATPCodigoVia = CodigoATP.ATP1P;
            else ATPCodigoVia = CodigoATP.Ninguno;
            if (ModoConduccionActual == ModoConduccion.M_20)
            {
                /*if (SignalPassedFeatures != null && SignalPassedFeatures.Value.Aspect == Aspect.Restricted) ATPCurrentSpeedMpS = 0;
                if (ATPCurrentSpeedMpS > 0)
                {
                    ATPNextSpeedMpS = ATPCurrentSpeedMpS = MpS.FromKpH(20);
                }
                else
                {
                    ATPCurrentSpeedMpS = ATPNextSpeedMpS = 0;
                }*/
                ATPNextSpeedMpS = ATPCurrentSpeedMpS = MpS.FromKpH(20);
                ATPCurrentBlockMaxSpeedLimitMpS = 0;
                ATPTargetDistanceM = 0;
            }
            else if (ATPCodigoVia == CodigoATP.ATP2P)
            {
                if (SignalPassedFeatures != null)
                {
                    (int,int) prevcodes = GetATP2PCodes(SignalPassedFeatures.Value.TextAspect);
                    if (prevcodes.Item2 == 0) ATPCurrentSpeedMpS = 0;
                }
                (int, int) codes = GetATP2PCodes(txt);
                if (ATPCurrentSpeedMpS == 0) codes = (0,0);
                
                if (SignalPassedFeatures != null) ATPCurrentBlockMaxSpeedLimitMpS = ATPNextBlockMaxSpeedLimitMpS;
                if (ATPCurrentBlockMaxSpeedLimitMpS == 0) ATPCurrentBlockMaxSpeedLimitMpS = GetATPBlockMaxSpeedMpS(0, NextSignalDistanceM(0));
                ATPNextBlockMaxSpeedLimitMpS = GetATPBlockMaxSpeedMpS(NextSignalDistanceM(0), NextSignalDistanceM(1));
                
                float prevATPSpeedMpS = ATPNextSpeedMpS;
                
                ATPCurrentSpeedMpS = Math.Min(MpS.FromKpH(codes.Item1), ATPCurrentBlockMaxSpeedLimitMpS);
                ATPNextSpeedMpS = Math.Min(Math.Min(MpS.FromKpH(codes.Item2), ATPNextBlockMaxSpeedLimitMpS), ATPCurrentSpeedMpS);
                
                if (prevATPSpeedMpS > ATPNextSpeedMpS && SpeedMpS() > ATPNextSpeedMpS - MpS.FromKpH(2) && ModoConduccionActual < ModoConduccion.ATO)
                {
                    SetATPOverspeedAlarm(true);
                }
                ATPTargetDistanceM = 0;
            }
            else if (ATPCodigoVia == CodigoATP.ATPDO)
            {
                if (SignalPassedFeatures != null)
                {
                    int prevahead = GetATPDOAhead(SignalPassedFeatures.Value.TextAspect);
                    if (prevahead <= 0) ATPCurrentSpeedMpS = 0;
                }
                int ahead = GetATPDOAhead(txt);
                if (ATPCurrentSpeedMpS == 0) ahead = -2;
                if (ahead <= -2)
                {
                    ATPCurrentSpeedMpS = ATPNextSpeedMpS = 0;
                }
                else
                {
                    if (ahead < 0) ATPTargetDistanceM = NextSignalDistanceM(0) - 50;
                    else ATPTargetDistanceM = NextSignalDistanceM(ahead) - 5;
                    ATPNextSpeedMpS = 0;
                    ATPCurrentSpeedMpS = Math.Min(MpS.FromKpH(110), CurrentPostSpeedMpS);
                    ATPCurrentSpeedMpS = Math.Min(ATPCurrentSpeedMpS, Math.Max(SpeedCurve(ATPTargetDistanceM, ATPNextSpeedMpS, 0, 0, 0.75f), ATPNextSpeedMpS));
                    float max = ATPTargetDistanceM;
                    for (int i=0; i<10; i++)
                    {
                        float dist = NextPostDistanceM(i);
                        float spd = NextPostSpeedLimitMpS(i);
                        if (dist > max || dist < 0) break;
                        if (spd > ATPCurrentSpeedMpS) continue;
                        float curv = Math.Max(SpeedCurve(dist, spd, 0, 0, 0.75f), spd);
                        if (curv < ATPCurrentSpeedMpS)
                        {
                            ATPCurrentSpeedMpS = curv;
                            ATPNextSpeedMpS = spd;
                            ATPTargetDistanceM = dist;
                        }
                    }
                }
            }
            else if (ATPCodigoVia == CodigoATP.ATP1P)
            {
                if (SignalPassedFeatures != null)
                {
                    int prevcode = GetATP1PCode(SignalPassedFeatures.Value.TextAspect);
                    if (prevcode == 0) ATPCurrentSpeedMpS = 0;
                }
                int code = GetATP1PCode(txt);
                if (ATPCurrentSpeedMpS == 0) code = 0;
                
                if (SignalPassedFeatures != null) ATPCurrentBlockMaxSpeedLimitMpS = ATPNextBlockMaxSpeedLimitMpS;
                if (ATPCurrentBlockMaxSpeedLimitMpS == 0) ATPCurrentBlockMaxSpeedLimitMpS = GetATPBlockMaxSpeedMpS(0, NextSignalDistanceM(0));
                ATPNextBlockMaxSpeedLimitMpS = GetATPBlockMaxSpeedMpS(NextSignalDistanceM(0), NextSignalDistanceM(1));
                
                ATPCurrentSpeedMpS = ATPNextSpeedMpS = Math.Min(ATPCurrentBlockMaxSpeedLimitMpS, code);
                ATPTargetDistanceM = 0;
            }
            else
            {
                ATPCurrentSpeedMpS = ATPNextSpeedMpS = 0;
                ATPTargetDistanceM = 0;
            }
            if (prevSpeedMpS <= ATPNextSpeedMpS - MpS.FromKpH(2) && SpeedMpS() > ATPNextSpeedMpS - MpS.FromKpH(2) && ModoConduccionActual < ModoConduccion.ATO) SetATPOverspeedAlarm(true);
            prevSpeedMpS = SpeedMpS();
            if (SpeedMpS() <= ATPNextSpeedMpS - MpS.FromKpH(3)) SetATPOverspeedAlarm(false);
            if (SpeedMpS() > ATPCurrentSpeedMpS || ATPCurrentSpeedMpS == 0) RequestMode(ModoConduccion.Inactivo);
            if (ATPAutoBrake && ModoConduccionActual == ModoConduccion.M_ATP)
            {
                if (SpeedMpS() > ATPNextSpeedMpS - MpS.FromKpH(2.8f)) ATPTCO = true;
                else if (SpeedMpS() <= ATPNextSpeedMpS - MpS.FromKpH(3))ATPTCO = false;
                if (SpeedMpS() > ATPNextSpeedMpS - MpS.FromKpH(1.5f)) ATPServiceBrake = true;
                else if (SpeedMpS() < ATPNextSpeedMpS - MpS.FromKpH(2.5f)) ATPServiceBrake = false;
            }
            
            if (ATPCodigoVia == CodigoATP.ATP2P)
            {
                if (ATPNextSpeedMpS < MpS.FromKpH(19)) SetCabDisplayControl(ControlVelocidadATP, 1);
                else if (ATPNextSpeedMpS < MpS.FromKpH(33)) SetCabDisplayControl(ControlVelocidadATP, 2);
                else if (ATPNextSpeedMpS < MpS.FromKpH(56)) SetCabDisplayControl(ControlVelocidadATP, 3);
                else if (ATPNextSpeedMpS < MpS.FromKpH(69)) SetCabDisplayControl(ControlVelocidadATP, 4);
                else if (ATPNextSpeedMpS < MpS.FromKpH(79)) SetCabDisplayControl(ControlVelocidadATP, 5);
                else SetCabDisplayControl(ControlVelocidadATP, 6);
            }
            else
            {
                if (ATPCurrentSpeedMpS < MpS.FromKpH(19)) SetCabDisplayControl(ControlVelocidadATP, 1);
                else if (ATPCurrentSpeedMpS < MpS.FromKpH(33)) SetCabDisplayControl(ControlVelocidadATP, 2);
                else if (ATPCurrentSpeedMpS < MpS.FromKpH(56)) SetCabDisplayControl(ControlVelocidadATP, 3);
                else if (ATPCurrentSpeedMpS < MpS.FromKpH(69)) SetCabDisplayControl(ControlVelocidadATP, 4);
                else if (ATPCurrentSpeedMpS < MpS.FromKpH(79)) SetCabDisplayControl(ControlVelocidadATP, 5);
                else SetCabDisplayControl(ControlVelocidadATP, 6);
            }
            SetCabDisplayControl(ControlCodigosATP, ATPCodigoVia > CodigoATP.ATP1P ? 1 : 0);
            SetCurrentSpeedLimitMpS(ATPCurrentSpeedMpS);
            float time = GameTime();
            float elapsed = Math.Max(time - ATPLastDisplaySpeedChange, 0);
            ATPLastDisplaySpeedChange = time;
            if (ATPLastDisplayedSpeed > ATPNextSpeedMpS)
            {
                ATPLastDisplayedSpeed = Math.Max(ATPLastDisplayedSpeed - elapsed * MpS.FromKpH(20), ATPNextSpeedMpS);
            }
            else if (ATPLastDisplayedSpeed < ATPNextSpeedMpS)
            {
                ATPLastDisplayedSpeed = Math.Min(ATPLastDisplayedSpeed + elapsed * MpS.FromKpH(20), ATPNextSpeedMpS);
            }
            SetNextSpeedLimitMpS(ATPLastDisplayedSpeed);
        }
        bool ATPOverspeedAlarm;
        void SetATPOverspeedAlarm(bool alarm)
        {
            if (ATPOverspeedAlarm != alarm)
            {
                ATPOverspeedAlarm = alarm;
                SetCabDisplayControl(ControlExcesoVelocidadATP, ATPOverspeedAlarm ? 1 : 0);
                if (ATPOverspeedAlarm) TriggerSoundAlert1();
                else
                {
                    TriggerSoundAlert2();
                }
            }
        }
        List<ATO.Target> ATOTargets = new List<ATO.Target>();
        public void UpdateATO()
        {
            ATOTargets.Clear();
            ATOTargets.Add(new ATO.Target()
            {
                TargetSpeedMpS = ATPNextSpeedMpS - MpS.FromKpH(3),
                TargetDistanceM = ATPTargetDistanceM > 0 ? ATPTargetDistanceM : NextSignalDistanceM(0)-5,
                CurveDelayS = 0,
                DecelerationMpSS = 0.75f,
            });
            ATOTargets.Add(new ATO.Target()
            {
                TargetSpeedMpS = 0,
                TargetDistanceM = NextPlatformDistanceM(),
                CurveDelayS = 0,
                DecelerationMpSS = 0.75f,
            });
            //Message(ConfirmLevel.None, String.Format("{0} {1}", NextPlatformDistanceM(), AccelerationMpSS()));
            ATO.SetSpeed("ATO", ATPCurrentSpeedMpS - MpS.FromKpH(3), ATOTargets);
        }
        bool prevTCO=false;
        void UpdateLazoTraccion(bool tcsTCO)
        {
            bool tco = false;
            tco |= tcsTCO;
            tco |= CurrentDoorState(DoorSide.Both) != DoorState.Closed/* && !byPassPuertas*/;
            tco |= TrainBrakeControllerState() != ControllerState.Release;
            //if (!tco && prevTCO && ThrottlePercent() > 0) tco = true;
            prevTCO = tco;
            tco |= IsBrakeFullService() || IsBrakeEmergency() || (DoesBrakeCutPower() && BrakeCutsPowerAtBrakeCylinderPressureBar() < LocomotiveBrakeCylinderPressureBar());
            SetTractionAuthorization(!tco);
        }
        /*bool MegafoniaStopChecking;
        float MegafoniaPrevStationDistanceM;
        int? MegafoniaRequestedIndex;
        int MegafoniaCurrentIndex;
        int MegafoniaMaxIndex = 4;
        bool MegafoniaRelease;
        int MegafoniaSkip = 0;
        public void UpdateMegafonia()
        {
            float dist = NextPlatformDistanceM();
            if (MegafoniaPrevStationDistanceM > 500 && dist < 500 && !MegafoniaStopChecking)
            {
                MegafoniaRequestedIndex = MegafoniaCurrentIndex;
                if (MegafoniaRequestedIndex < 0) MegafoniaRequestedIndex = MegafoniaMaxIndex - 1;
                if (MegafoniaRequestedIndex >= MegafoniaMaxIndex) MegafoniaRequestedIndex = 0;
                MegafoniaStopChecking = true;
                Console.WriteLine("Iniciar megafonia "+MegafoniaRequestedIndex.Value);
            }
            if (CurrentDoorState(DoorSide.Both) != DoorState.Closed) MegafoniaStopChecking = false;
            MegafoniaPrevStationDistanceM = dist;
            
            if (MegafoniaSkip++ < 10) return;
            MegafoniaSkip = 0;
            if (MegafoniaRequestedIndex != null)
            {
                if (MegafoniaRelease)
                {
                    if (MegafoniaCurrentIndex == MegafoniaRequestedIndex)
                    {
                        MegafoniaRequestedIndex = null;
                        TriggerSoundInfo1();
                    }
                    else TriggerSoundInfo2();
                    ++MegafoniaCurrentIndex;
                    MegafoniaRelease = false;
                }
                else
                {
                    TriggerSoundWarning1();
                    MegafoniaRelease = true;
                }
                Console.WriteLine("Megafonia: "+MegafoniaCurrentIndex);
                if (MegafoniaCurrentIndex == MegafoniaMaxIndex) MegafoniaCurrentIndex = 0;
            }
        }*/
        SignalFeatures? SignalPassedFeatures;
        SignalFeatures? PrevSignalFeatures;
        public void UpdateSignalPassed()
        {
            var feat = NextGenericSignalFeatures("NORMAL", 0, 30);
            if (PrevSignalFeatures != null && feat.DistanceM > PrevSignalFeatures.Value.DistanceM + 10 && PrevSignalFeatures.Value.DistanceM < 20)
            {
                SignalPassedFeatures = PrevSignalFeatures;
            }
            else
            {
                SignalPassedFeatures = null;
            }
            PrevSignalFeatures = feat;
        }
        float CurrentPostSpeedMpS;
        float PrevPostSpeedMpS;
        float PrevPostDistanceM;
        public void UpdatePostPassed()
        {
            if (CurrentPostSpeedMpS == 0) CurrentPostSpeedMpS = CurrentPostSpeedLimitMpS();
            if (NextPostDistanceM(0) > PrevPostDistanceM + 10 && PrevPostDistanceM < 20)
            {
                CurrentPostSpeedMpS = PrevPostSpeedMpS;
            }
            PrevPostSpeedMpS = NextPostSpeedLimitMpS(0);
            PrevPostDistanceM = NextPostDistanceM(0);
        }
        public override void HandleEvent(TCSEvent evt, string message) 
        {
            switch (evt)
            {
                case TCSEvent.GenericTCSButtonPressed:
                case TCSEvent.GenericTCSButtonReleased:
                {
                    int num = int.Parse(message);
                    bool pressed = evt == TCSEvent.GenericTCSButtonPressed;
                    if (pressed)
                    {
                        if (num == ControlExcesoVelocidadATP)
                        {
                            SetATPOverspeedAlarm(false);
                        }
                        else if (num == ControlM_20) RequestMode(ModoConduccion.M_20);
                        else if (num == ControlATP) RequestMode(ModoConduccion.M_ATP);
                        else if (num == ControlATO) RequestMode(ModoConduccion.ATO);
                    }
                    if (num == ControlLanzarATO) ATOArranque1 = ATOArranque2 = pressed;
                    break;
                }
            }
        }
    }
    public class ATO
    {
        float PermittedSpeedMpS;
        float PermittedSpeedAccelerationMpSS;
        float ReleaseSpeedMpS;
        private float prevPermittedSpeedMpS;
        private float prevTimeS;
        IIRFilter AccelerationFilter = new IIRFilter(IIRFilter.FilterTypes.Butterworth, 1, 1.0f, 0.1f);
        string ActiveSystem;
        public struct Target
        {
            public float TargetSpeedMpS;
            public float TargetDistanceM;
            public float DecelerationMpSS;
            public float CurveDelayS;
        }
        public Target TCSTarget;
        public List<Target> Targets = new List<Target>();
        public MetroMadrid tcs;
        public ATO(MetroMadrid tcs)
        {
            this.tcs = tcs;
        }
        public void Initialize()
        {

        }
        public void SetSpeed(string system, float vPerm, float vTarg=float.MaxValue, float dTarg=float.MaxValue, float delay=0, float dec=0)
        {
            if (ActiveSystem == null) ActiveSystem = system;
            if (ActiveSystem != system) return;

            PermittedSpeedMpS = vPerm;

            Targets.Clear();
            Targets.Add(new Target()
            {
                TargetSpeedMpS = vTarg,
                TargetDistanceM = dTarg,
                CurveDelayS = delay,
                DecelerationMpSS = dec,
            });
        }
        public void SetSpeed(string system, float vPerm, List<Target> targets, float vRelease=0)
        {
            if (ActiveSystem == null) ActiveSystem = system;
            if (ActiveSystem != system) return;

            PermittedSpeedMpS = vPerm;
            ReleaseSpeedMpS = vRelease;
            Targets.Clear();
            if (targets != null)
            {
                foreach (var targ in targets)
                {
                    Targets.Add(targ);
                }
            }
        }
        public void Disable(string system)
        {
            if (ActiveSystem == system)
            {
                ActiveSystem = null;
                Targets.Clear();
                ReleaseAccepted = false;
            }
        }
        void CalculateSetPoint(Target target, out float atospd, out float atoaccel)
        {
            float targetSpeedMpS = target.TargetSpeedMpS;
            float targetDistanceM = target.TargetDistanceM;
            float decelerationMpSS = target.DecelerationMpSS;
            float curveDelayS = target.CurveDelayS;
            bool precisionStop = targetSpeedMpS == 0 && true;
            float speedCurveMpS;
            if (precisionStop) speedCurveMpS = Math.Max(tcs.SpeedCurve(targetDistanceM - 10, MpS.FromKpH(5), 0, 1 + curveDelayS, decelerationMpSS), MpS.FromKpH(5));
            else speedCurveMpS = tcs.SpeedCurve(targetDistanceM, targetSpeedMpS, 0, curveDelayS, decelerationMpSS);
            if (precisionStop && (speedCurveMpS < MpS.FromKpH(15) || targetDistanceM <= 10))
            {
                if (targetDistanceM <= 0.05f || (targetDistanceM < 0.2f && tcs.SpeedMpS() < 0.25f))
                {
                    atospd = 0;
                    atoaccel = -0.3f;
                }
                else if (targetDistanceM <= 10)
                {
                    float curve = Math.Max(Math.Min(tcs.SpeedCurve(targetDistanceM, 0, 0, 0, 0.3f), MpS.FromKpH(5)), 0);
                    float dec = Math.Min(tcs.Deceleration(tcs.SpeedMpS(), 0, targetDistanceM), 0.45f);
                    atospd = Math.Min(tcs.SpeedMpS(), curve);
                    atoaccel = dec > 0.3f ? -dec : (dec > 0.2f ? -(dec-0.2f)/0.1f*0.3f : 0);
                }
                else
                {
                    float dec1 = tcs.Deceleration(speedCurveMpS, 0, targetDistanceM);
                    float dec2 = (MpS.ToKpH(speedCurveMpS)-5)/10*tcs.SpeedMpS()/speedCurveMpS*decelerationMpSS;
                    atospd = speedCurveMpS;
                    if (dec2 > Math.Max(dec1, 0.2f)) atoaccel = -dec2;
                    else atoaccel = dec1 > 0.2f ? -dec1 : 0;
                }
            }
            else if (targetSpeedMpS == 0 && (targetDistanceM < 1 || (targetDistanceM < 5 && Math.Min(speedCurveMpS, tcs.SpeedMpS()) < MpS.FromKpH(3))))
            {
                atospd = 0;
                atoaccel = -0.3f;
            }
            else if (targetDistanceM <= 0 || speedCurveMpS <= targetSpeedMpS)
            {
                atospd = targetSpeedMpS;
                atoaccel = 0;
            }
            else
            {
                atospd = speedCurveMpS;
                float targetDec = decelerationMpSS / (1 + decelerationMpSS * curveDelayS / speedCurveMpS);
                atoaccel = -targetDec;
            }
        }
        public void UpdateSetPoint(ref float? atospd, ref float atoaccel, ref float atotarget, float newspd, float newaccel, float newtarget)
        {
            if (atospd == null || atospd > newspd + MpS.FromKpH(5))
            {
                atospd = newspd;
                atoaccel = newaccel;
                atotarget = newtarget;
            }
            else if (atospd > newspd - MpS.FromKpH(5))
            {
                if (atospd >= newspd)
                {
                    atoaccel = Math.Min(newaccel, atoaccel * (1 - (atospd.Value - newspd) / MpS.FromKpH(5)));
                    atospd = newspd;
                }
                else
                {
                    atoaccel = Math.Min(atoaccel, newaccel * (1 - (newspd - atospd.Value) / MpS.FromKpH(5)));
                }
                atotarget = Math.Min(atotarget, newtarget);
            }
        }
        public void UpdateSetPoint(ref float? atospd, ref float atoaccel, ref float atotarget, Target target)
        {
            CalculateSetPoint(target, out float spd, out float accel);
            UpdateSetPoint(ref atospd, ref atoaccel, ref atotarget, spd, accel, target.TargetSpeedMpS);
        }
        bool ReleaseAccepted;
        bool ATOStopped;
        public void Update()
        {
            float? atospd = null;
            float atoaccel = 0;

            float atotarget = float.MaxValue;
            foreach (var target in Targets)
            {
                if (target.TargetDistanceM < 1.0e6f)
                {
                    UpdateSetPoint(ref atospd, ref atoaccel, ref atotarget, target);
                }
            }
            if (ActiveSystem != null)
            {
                float elapsedS = tcs.GameTime() - prevTimeS;
                if (elapsedS > 0)
                {
                    float acc = AccelerationFilter.Filter((PermittedSpeedMpS - prevPermittedSpeedMpS) / elapsedS);
                    if (acc > PermittedSpeedAccelerationMpSS)
                    {
                        PermittedSpeedAccelerationMpSS = Math.Min(acc, PermittedSpeedAccelerationMpSS + elapsedS * 0.25f);
                    }
                    else
                    {
                        PermittedSpeedAccelerationMpSS = Math.Max(acc, PermittedSpeedAccelerationMpSS - elapsedS * 0.25f);
                    }
                    if (PermittedSpeedAccelerationMpSS > 1) PermittedSpeedAccelerationMpSS = 1;
                    else if (PermittedSpeedAccelerationMpSS < -1) PermittedSpeedAccelerationMpSS = -1;
                }
                prevPermittedSpeedMpS = PermittedSpeedMpS;
                prevTimeS = tcs.GameTime();

                if (ReleaseAccepted && (ReleaseSpeedMpS > PermittedSpeedMpS || ReleaseSpeedMpS > atospd) && ReleaseSpeedMpS > MpS.FromKpH(5))
                {
                    atospd = ReleaseSpeedMpS - MpS.FromKpH(5);
                    atoaccel = 0;
                    atotarget = 0;
                }
                else if (atotarget == 0 && atospd < MpS.FromKpH(15))
                {

                }
                else if (PermittedSpeedMpS < MpS.FromKpH(3))
                {
                    UpdateSetPoint(ref atospd, ref atoaccel, ref atotarget, 0, -0.3f, 0);
                }
                else if (!atospd.HasValue || atospd > PermittedSpeedMpS + 0.01f)
                {
                    UpdateSetPoint(ref atospd, ref atoaccel, ref atotarget, PermittedSpeedMpS, PermittedSpeedAccelerationMpSS, 0);
                }

                if (ReleaseSpeedMpS < atospd) ReleaseAccepted = false;
                else if (!ReleaseAccepted && tcs.SpeedMpS() == 0 && tcs.ThrottlePercent() == 0) ReleaseAccepted = true;
            }

            if (atospd > tcs.SpeedMpS())
            {
                // TODO: energy savings
            }

            if (atospd == 0) ATOStopped = true;
            if (atospd == null) ATOStopped = tcs.SpeedMpS() < MpS.FromKpH(3);
            if (tcs.ATOArranque1 && tcs.ATOArranque2 && ATOStopped && atospd > 0 && tcs.SpeedMpS() > MpS.FromKpH(3)) ATOStopped = false;
            if (ATOStopped && (!tcs.ATOArranque1 || !tcs.ATOArranque2) && atospd != null)
            {
                atospd = 0;
                atoaccel = -0.75f;
            }

            tcs.SetSpeedMpS = atospd;
            if (atospd == null) tcs.SetSpeedAccelerationMpSS = 0;
            else tcs.SetSpeedAccelerationMpSS = atoaccel;
        }
    }
}
