using ORTS.Common;
using ORTS.Scripting.Api;
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO.Ports;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Linq;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using Orts.Common;
using Event = Orts.Common.Event;
namespace ORTS.Scripting.Script
{
    public class Freno449 : BrakeController
    {
       ControllerState CurrentState=ControllerState.Release;
        bool AuxiliaryBrake = false;
        bool FrenoResidual = false;
        float Value;
        public override void Initialize()
        {
        }
        public override void InitializeMoving()
        {
        }
        public override float Update(float elapsedSeconds)
        {
            Value = CurrentValue();
            if (IntermediateValue != Value) Value = IntermediateValue;
            if(UpdateValue()==1)
            {
                if(Value>0.9)
                {
                    Value = 1;
                    SetUpdateValue(0);
                }
                else
                {
                    Value += elapsedSeconds/3;
                    if (Value < 0.25f)
                    {
                        Value = 0.25f;
                    }
                    if(Value>=0.9&&CurrentValue()<0.9)
                    {
                        Value = 0.93f;
                        SetUpdateValue(0);
                    }
                }
            }
            else if(UpdateValue()==-1)
            {
                Value -= elapsedSeconds/3;
                if(Value<=0.25f&&CurrentValue()>0.25f)
                {
                    Value = 0.25f;
                    SetUpdateValue(0);
                }
                else if (Value <= 0.25f)
                {
                    Value = 0;
                    SetUpdateValue(0);
                }
            }
            else if (Value < 0.25f) Value = 0;
            if(Value > 0.95f) CurrentState = ControllerState.Emergency; 
            else if(Value > 0.90f) CurrentState = ControllerState.FullServ;
            else if(Value>0.01) CurrentState = ControllerState.GSelfLap;
            else CurrentState = ControllerState.Release;
            
            if (SpeedMpS() > MpS.FromKpH(3)/*|| traccion > 0.1f*/) FrenoResidual = false;
            
            if (Value != CurrentValue()) SetValue(Value);
            return CurrentValue();
        }
        void SetValue(float value)
        {
            Value = value;
            if (Value == 0 && CurrentValue() > 0)
            {
                SetDynamicBrakeIntervention(0);
                if (SpeedMpS() < MpS.FromKpH(3)) FrenoResidual = true;
            }
            SetCurrentValue(Value);
            IntermediateValue = Value;
        }
        
        int ejes_traccion=6;
        int ejes_freno=12;
        float MaxDynamicBrakeForce(float speed)
        {
            speed = MpS.ToKpH(speed);
            float force = 0;
            if (speed < 5) force = 0;
            else if (speed<7) force = (speed-5)*174/2;
            else if (speed<60) force = 174;
            else if (speed<100) force = 174-93*(speed-60)/40;
            else if (speed<120) force = 81-21*(speed-100)/20;
            else if (speed<160) force = 60-25*(speed-120)/40;
            else force = 35;
            return force*ejes_traccion/6/174.0f*0.8f;
        }
        float MaxAirBrakeForce(float speed)
        {
            float force = 207;
            /*if (speed<8) force = force * (1-speed/8*(1-0.35f/0.49f));
            else force = force * (0.35f/0.49f);*/
            return force*ejes_freno/12/207.0f;
        }
        
        
        public override void UpdatePressure(ref float pressureBar, float elapsedClockSeconds, ref float epPressureBar)
        {
            float intervention;//GetFloatValue("OrtsTrainBrakeIntervention");
            if (Value > 0.95f) intervention = 2;
            else if (Value > 0.9f) intervention = 1;
            else if (Value < 0.01f) intervention = 0;
            else intervention = Math.Min(Math.Max((Value-0.01f)/0.89f, 0), 1);
            
            if (EmergencyBrakingPushButton() || TCSEmergencyBraking() || intervention == 2)
            {
                //SetFloatValue("OrtsDynamicBrakeIntervention", -1);
                SetDynamicBrakeIntervention(0);
                epPressureBar = 1;
                DecreasePressure(ref pressureBar, 0, EmergencyRateBarpS(), elapsedClockSeconds);
                return;
            }
            else
            {
                float releasePressure = Math.Min(5, MainReservoirPressureBar());
                float fullServPressure = MaxPressureBar()-FullServReductionBar();
                if (AuxiliaryBrake)
                {
                    SetDynamicBrakeIntervention(intervention > 0 ? intervention : 0);
                    //SetFloatValue("OrtsDynamicBrakeIntervention", intervention > 0 ? intervention : -1);
                    epPressureBar = -1;
                    int auxval = 0;// GetIntValue("AuxiliaryBrake");
                    switch (auxval)
                    {
                        case -1:
                            IncreasePressure(ref pressureBar, releasePressure, ReleaseRateBarpS(), elapsedClockSeconds);
                            break;
                        case 1:
                            DecreasePressure(ref pressureBar, fullServPressure, ApplyRateBarpS(), elapsedClockSeconds);
                            break;
                    }
                }
                else
                {
                    if (TCSFullServiceBraking()) intervention = 1;
                    float speed = SpeedMpS();
                    float maxDynForce = MaxDynamicBrakeForce(speed);
                    float maxAirForce = MaxAirBrakeForce(speed);
                    float targetForce = intervention;
                    float targetDynamicForce = Math.Min(targetForce, maxDynForce);
                    float targetAirForce = targetForce-targetDynamicForce;
                    if (intervention>0) SetDynamicBrakeIntervention((maxDynForce==0 || targetDynamicForce == 0) ? 0 : targetDynamicForce/maxDynForce);
					else SetDynamicBrakeIntervention(0);
                    if (targetAirForce <= 0) epPressureBar = -1;
                    else epPressureBar = targetAirForce/maxAirForce;
                    
                    float targetPressureBar = 4.85f-1.35f*epPressureBar;
                    if (epPressureBar <= 0) targetPressureBar = 5;
                    
                    if (epPressureBar < 0.05f && FrenoResidual) epPressureBar = 0.05f;
                    IncreasePressure(ref pressureBar, Math.Min(targetPressureBar, releasePressure), ReleaseRateBarpS(), elapsedClockSeconds);
                    DecreasePressure(ref pressureBar, Math.Max(fullServPressure, targetPressureBar), ApplyRateBarpS(), elapsedClockSeconds);
                }
            }
        }
        public override void UpdateEngineBrakePressure(ref float pressureBar, float elapsedClockSeconds)
        {
            
        }
       public override void HandleEvent(BrakeControllerEvent evt)
        {
            switch (evt)
            {
                case BrakeControllerEvent.StartIncrease:
                    SetUpdateValue(1);
                    break;
                case BrakeControllerEvent.StartDecrease:
                    SetUpdateValue(-1);
                    break;
                case BrakeControllerEvent.StopIncrease:
                case BrakeControllerEvent.StopDecrease:
                    SetUpdateValue(0);
                    break;
            }
        }
        public override void HandleEvent(BrakeControllerEvent evt, float? value)
        {
            if(evt == BrakeControllerEvent.SetCurrentPercent)
            {
                SetValue(value.Value/100);
            }
            else if(evt == BrakeControllerEvent.SetCurrentValue)
            {
                SetValue(value.Value);
            }
            else HandleEvent(evt);
        }
        public override bool IsValid()
        {
            return true;
        }
        public override ControllerState GetState()
        {
            if(EmergencyBrakingPushButton()) return ControllerState.EBPB;
            if(TCSEmergencyBraking()) return ControllerState.TCSEmergency;
            if(CurrentState == ControllerState.Emergency) return ControllerState.Emergency;
            if(TCSFullServiceBraking()) return ControllerState.TCSFullServ;
            return CurrentState;
        }
        public override float? GetStateFraction()
        {
            float applyValue = 0;
            if (Value >= 0.01) applyValue = Math.Min(Math.Max((Value-0.01f)/0.89f, 0), 1);
            if(GetState()==ControllerState.GSelfLap) return applyValue;
            return null;
        }
        static void IncreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI < targetPSI)
            {
                pressurePSI += ratePSIpS * elapsedSeconds;
                if (pressurePSI > targetPSI)
                    pressurePSI = targetPSI;
            }
        }

        static void DecreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI > targetPSI)
            {
                pressurePSI -= ratePSIpS * elapsedSeconds;
                if (pressurePSI < targetPSI)
                    pressurePSI = targetPSI;
            }
        }
    }
}
