using System;
using Orts.Common;
using ORTS.Common;
using Orts.Simulation;
using ORTS.Scripting.Api;
using Event = Orts.Common.Event;
using System.Collections.Generic;
namespace ORTS.Scripting.Script
{
    public class CiviaPowerSupply : ElectricPowerSupply
    {
        private IIRFilter PantographFilter;
        private IIRFilter VoltageFilter;
        private Timer PowerOnTimer;
        private Timer AuxPowerOnTimer;
        private Timer ServiceRetentionTimer;

        bool QuickPowerOn = false;
        bool ConexionAutomatica = false;
        bool DesconexionAutomatica = false;

        bool AceleracionReducida;

        enum TipoCoche
        {
            A1,
            A2,
            A3,
            A4,
            A5,
        }
        TipoCoche EsteTipoCoche;
        
        bool CabinaHabilitada=false;
        bool OtraCabinaHabilitada=false;
        int LeadIndex=-1;

        public override void Initialize()
        {
            PantographFilter = new IIRFilter(IIRFilter.FilterTypes.Butterworth, 1, IIRFilter.HzToRad(0.7f), 0.001f);
            VoltageFilter = new IIRFilter(IIRFilter.FilterTypes.Butterworth, 1, IIRFilter.HzToRad(0.7f), 0.001f);
            
            PowerOnTimer = new Timer(this);
            PowerOnTimer.Setup(PowerOnDelayS());

            AuxPowerOnTimer = new Timer(this);
            AuxPowerOnTimer.Setup(AuxPowerOnDelayS());

            ServiceRetentionTimer = new Timer(this);
            ServiceRetentionTimer.Setup(15*60);
            
            Enum.TryParse(GetStringParameter("General", "TipoCoche", "A1").Trim('\0'), out EsteTipoCoche);

            SetCustomizedCabviewControlName(0, "Puesta en marcha automática");
            SetCustomizedCabviewControlName(1, "Aceleración reducida");
        }

        public override void Update(float elapsedClockSeconds)
        {
            SetCurrentBatteryState(BatterySwitchOn() ? PowerSupplyState.PowerOn : PowerSupplyState.PowerOff);
            SetCurrentLowVoltagePowerSupplyState(CurrentBatteryState());
            SetCurrentCabPowerSupplyState(MasterKeyOn() && CurrentBatteryState() == PowerSupplyState.PowerOn ? PowerSupplyState.PowerOn : PowerSupplyState.PowerOff);
            
            if (elapsedClockSeconds > 0)
            {
                SetPantographVoltageV(PantographFilter.Filter(CurrentPantographState() == PantographState.Up ? LineVoltageV() : 0, elapsedClockSeconds));
                SetFilterVoltageV(PantographFilter.Filter(CurrentCircuitBreakerState() == CircuitBreakerState.Closed ? PantographVoltageV() : 0, elapsedClockSeconds));
            }
            if (CurrentCircuitBreakerState() == CircuitBreakerState.Closed && !DesconexionAutomatica)
            {
                if (!AuxPowerOnTimer.Started)
                    AuxPowerOnTimer.Start();

                if (AuxPowerOnTimer.Triggered && CurrentAuxiliaryPowerSupplyState() == PowerSupplyState.PowerOff)
                {
                    SignalEvent(Event.PowerConverterOn);
                    SetCurrentAuxiliaryPowerSupplyState(PowerSupplyState.PowerOn);
                }
            }
            else
            {
                if (AuxPowerOnTimer.Started)
                    AuxPowerOnTimer.Stop();

                if (CurrentAuxiliaryPowerSupplyState() == PowerSupplyState.PowerOn)
                {
                    SignalEvent(Event.PowerConverterOff);
                    SetCurrentAuxiliaryPowerSupplyState(PowerSupplyState.PowerOff);
                }
            }
            if (CurrentCircuitBreakerState() == CircuitBreakerState.Closed && (CabinaHabilitada || OtraCabinaHabilitada) && !DesconexionAutomatica)
            {
                if (!PowerOnTimer.Started)
                    PowerOnTimer.Start();

                if (PowerOnTimer.Triggered && CurrentMainPowerSupplyState() == PowerSupplyState.PowerOff)
                {
                    SignalEvent(Event.EnginePowerOn);
                    SetCurrentMainPowerSupplyState(PowerSupplyState.PowerOn);
                }
            }
            else
            {

                if (PowerOnTimer.Started)
                    PowerOnTimer.Stop();

                if (CurrentMainPowerSupplyState() == PowerSupplyState.PowerOn)
                {
                    SignalEvent(Event.EnginePowerOff);
                    SetCurrentMainPowerSupplyState(PowerSupplyState.PowerOff);
                }
            }
            if (QuickPowerOn)
            {
                if (IsLocomotiveLeading && !CabinaHabilitada && !OtraCabinaHabilitada)
                {
                    HandleHabilitacionCabina(true, true);
                }
                ConexionAutomatica = true;
            }
            if (ConexionAutomatica)
            {
                SetPantograph(1, false);
                SetPantograph(2, true);
                if (CurrentCircuitBreakerState() == CircuitBreakerState.Open && CircuitBreakerClosingAuthorization())
                {
                    SignalEventToCircuitBreaker(PowerSupplyEvent.QuickPowerOn);
                }
                if (CurrentCircuitBreakerState() == CircuitBreakerState.Closed)
                {
                    ConexionAutomatica = QuickPowerOn = false;
                }
            }
            if (DesconexionAutomatica)
            {
                if (CurrentCircuitBreakerState() == CircuitBreakerState.Closed)
                    SignalEventToCircuitBreaker(PowerSupplyEvent.QuickPowerOff);
                else if (CurrentPantographState() == PantographState.Up)
                    SignalEventToPantographs(PowerSupplyEvent.LowerPantograph);
                else
                    DesconexionAutomatica = false;
            }

            if (AceleracionReducida && !CabinaHabilitada && !OtraCabinaHabilitada) AceleracionReducida = false;
            ThrottleReductionPercent = AceleracionReducida ? 50 : 0;
            SetCabDisplayControl(1, AceleracionReducida ? 1 : 0);

            SetCurrentDynamicBrakeAvailability(CurrentLowVoltagePowerSupplyState() == PowerSupplyState.PowerOn);
            SetCurrentElectricTrainSupplyState(CurrentAuxiliaryPowerSupplyState());
            
            if (ServiceRetentionTimer.Triggered || CurrentLowVoltagePowerSupplyState() != PowerSupplyState.PowerOn) ServiceRetentionTimer.Stop();
            ServiceRetentionActive = ServiceRetentionTimer.Started;
            if (!CabinaHabilitada && !OtraCabinaHabilitada && !ServiceRetentionActive && CurrentPantographState() == PantographState.Up)
            {
                DesconexionAutomatica = true;
            }

            if (CurrentLowVoltagePowerSupplyState() != PowerSupplyState.PowerOn && CurrentPantographState() == PantographState.Up)
            {
                SignalEventToPantographs(PowerSupplyEvent.LowerPantograph);
            }

            if (CabinaHabilitada)
            {
                LeadIndex = IndexOfLocomotive();
                SignalEventToOtherTrainVehiclesWithId(PowerSupplyEvent.TurnOnMasterKey, LeadIndex);
            }
            else if (!OtraCabinaHabilitada && IsLocomotiveLeading)
            {
                LeadIndex = -1;
                SignalEventToOtherTrainVehiclesWithId(PowerSupplyEvent.TurnOnMasterKey, LeadIndex);
            }
        }
        void HandleHabilitacionCabina(bool propia, bool on)
        {
            if (propia)
            {
                if (MasterKeyOn() == on) return;
                SignalEventToMasterKey(on ? PowerSupplyEvent.TurnOnMasterKey : PowerSupplyEvent.TurnOffMasterKey);
                Confirm(CabControl.MasterKey, on ? CabSetting.On : CabSetting.Off);
                bool habilitar = on && !OtraCabinaHabilitada;
                if (habilitar == CabinaHabilitada) return;
                CabinaHabilitada = habilitar;
            }
            else
            {
                if (OtraCabinaHabilitada == on) return;
                OtraCabinaHabilitada = on;
            }
            if (on && ServiceRetentionActive)
            {
                SetPantograph(1, false);
                ServiceRetentionTimer.Stop();
            }
            if (!on && CurrentCircuitBreakerState() == CircuitBreakerState.Closed)
            {
                SignalEventToPantographs(PowerSupplyEvent.RaisePantograph);
                ServiceRetentionTimer.Start();
            }
        }
        void SetPantograph(int num, bool up)
        {
            if (CurrentLowVoltagePowerSupplyState() != PowerSupplyState.PowerOn) return;
            SignalEventToPantograph(up ? PowerSupplyEvent.RaisePantograph : PowerSupplyEvent.LowerPantograph, num);
        }
        public override void HandleEvent(PowerSupplyEvent evt)
        {
            switch (evt)
            {
                case PowerSupplyEvent.TurnOnMasterKey:
                case PowerSupplyEvent.TurnOffMasterKey:
                    HandleHabilitacionCabina(true, evt == PowerSupplyEvent.TurnOnMasterKey);
                    break;
                case PowerSupplyEvent.QuickPowerOn:
                    SignalEventToBatterySwitch(PowerSupplyEvent.QuickPowerOn);
                    QuickPowerOn = true;
                    break;
                case PowerSupplyEvent.QuickPowerOff:
                    SignalEventToBatterySwitch(PowerSupplyEvent.QuickPowerOff);
                    HandleHabilitacionCabina(true, false);
                    QuickPowerOn = false;
                    DesconexionAutomatica = true;
                    break;
                case PowerSupplyEvent.LowerPantograph:
                case PowerSupplyEvent.RaisePantograph:
                    break;
                case PowerSupplyEvent.OpenBatterySwitchButtonPressed:
                case PowerSupplyEvent.OpenBatterySwitchButtonReleased:
                case PowerSupplyEvent.CloseBatterySwitchButtonPressed:
                case PowerSupplyEvent.CloseBatterySwitchButtonReleased:
                    if (!CabinaHabilitada) return;
                    SignalEventToBatterySwitch(evt);
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                case PowerSupplyEvent.OpenCircuitBreakerButtonPressed:
                case PowerSupplyEvent.OpenCircuitBreakerButtonReleased:
                case PowerSupplyEvent.CloseCircuitBreakerButtonPressed:
                case PowerSupplyEvent.CloseCircuitBreakerButtonReleased:
                    if (!CabinaHabilitada) return;
                    SignalEventToCircuitBreaker(evt);
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                default:
                    base.HandleEvent(evt);
                    break;
            }
        }
        public override void HandleEvent(PowerSupplyEvent evt, int id)
        {
            switch(evt)
            {
                case PowerSupplyEvent.LowerPantograph:
                case PowerSupplyEvent.RaisePantograph:
                    if (!CabinaHabilitada) return;
                    SetPantograph(id, evt == PowerSupplyEvent.RaisePantograph);
                    SignalEventToOtherTrainVehiclesWithId(evt, id);
                    break;
                case PowerSupplyEvent.GenericPowerSupplyButtonPressed:
                    if (!CabinaHabilitada) return;
                    switch (id)
                    {
                        case 0:
                            if (CurrentPantographState() == PantographState.Up)
                            {
                                ConexionAutomatica = QuickPowerOn = false;
                                DesconexionAutomatica = true;
                            }
                            else
                            {
                                ConexionAutomatica = true;
                                DesconexionAutomatica = false;
                            }
                            break;
                        case 1:
                            AceleracionReducida = !AceleracionReducida;
                            break;
                    }
                    SignalEventToOtherTrainVehiclesWithId(evt, id);
                    break;
            }
        }
        public override void HandleEventFromLeadLocomotive(PowerSupplyEvent evt)
        {
            switch (evt)
            {
                default:
                    base.HandleEventFromLeadLocomotive(evt);
                    break;
            }
        }
        public override void HandleEventFromLeadLocomotive(PowerSupplyEvent evt, int id)
        {
            switch (evt)
            {
                case PowerSupplyEvent.TurnOnMasterKey:
                    LeadIndex = id;
                    HandleHabilitacionCabina(false, id >= 0);
                    break;
                case PowerSupplyEvent.RaisePantograph:
                case PowerSupplyEvent.LowerPantograph:
                    if (!OtraCabinaHabilitada) return;
                    SignalEventToPantograph(evt, id);
                    break;
                case PowerSupplyEvent.GenericPowerSupplyButtonPressed:
                    if (!OtraCabinaHabilitada) return;
                    switch (id)
                    {
                        case 0:
                            if (CurrentPantographState() == PantographState.Up)
                            {
                                ConexionAutomatica = QuickPowerOn = false;
                                DesconexionAutomatica = true;
                            }
                            else
                            {
                                ConexionAutomatica = true;
                                DesconexionAutomatica = false;
                            }
                            break;
                        case 1:
                            AceleracionReducida = !AceleracionReducida;
                            break;
                    }
                    break;
            } 
        }
    }
}
