using ORTS.Common;
using ORTS.Scripting.Api;
using System;
using Event = Orts.Common.Event;
namespace ORTS.Scripting.Script
{
    public class Brake446 : BrakeController
    {
        enum State
        {
            Release,
            Apply,
            FullBrake,
            Emergency,
            AUXneutral,
            AUXincrease,
            AUXdecrease
        }
        bool Canal1Activo = true;
        State CurrentState=State.Apply;
        float Value=0;
        float applyValue=0;
        float currentDynamicBrakeValue=0;
        bool AuxiliaryBrake = false;
        public override void Initialize()
        {
        }
        public override void InitializeMoving()
        {
        }
        public override float Update(float elapsedSeconds)
        {
            if (IntermediateValue != Value) Value = IntermediateValue;
            if(UpdateValue()==1)
            {
                if(Value>0.9)
                {
                    Value = 1;
                    SetUpdateValue(0);
                }
                else
                {
                    float prev = Value;
                    Value += elapsedSeconds/3;
                    if(Value>=0.9&&prev<0.9)
                    {
                        Value = 0.93f;
                        SetUpdateValue(0);
                    }
                }
            }
            if(UpdateValue()==-1)
            {
                float prev = Value;
                Value -= elapsedSeconds/3;
                if(Value<=0)
                {
                    Value = 0;
                    SetUpdateValue(0);
                }
            }
            IntermediateValue = Value;
            SetCurrentValue(Value);
            return CurrentValue();
        }
        public override void UpdatePressure(ref float pressureBar, float elapsedClockSeconds, ref float epPressureBar)
        {
            if(EmergencyBrakingPushButton() || TCSEmergencyBraking() || Value > 0.95f) CurrentState = State.Emergency;
            else if(TCSFullServiceBraking() || Value > 0.90f) CurrentState = State.FullBrake;
            else if(Value>=0.01 || CruiseControlBrakeDemand() > 0) CurrentState = State.Apply;
            else CurrentState = State.Release;
            if(Value<0.01) applyValue = 0;
            else applyValue = Math.Min(Math.Max((Value-0.01f)/0.89f*0.85f+0.15f, 0.15f), 1);
            applyValue = Math.Max(applyValue, CruiseControlBrakeDemand());

            float airBrakeValue = applyValue;
            if (airBrakeValue < 0.15f) airBrakeValue = 0;
            float dynamicBrakeValue = Math.Min(applyValue/0.7f, 1);
            if (CurrentState == State.Emergency)
            {
                airBrakeValue = 1;
                currentDynamicBrakeValue = dynamicBrakeValue = 0;
            }
            else if (AuxiliaryBrake)
            {
                airBrakeValue = 0;
            }
            if (dynamicBrakeValue > currentDynamicBrakeValue)
            {
                currentDynamicBrakeValue = dynamicBrakeValue;//Math.Min(dynamicBrakeValue, currentDynamicBrakeValue + elapsedClockSeconds);
            }
            else if (dynamicBrakeValue < currentDynamicBrakeValue)
            {
                currentDynamicBrakeValue = Math.Max(dynamicBrakeValue, currentDynamicBrakeValue - 0.5f * elapsedClockSeconds);
            }
            //airBrakeValue = Math.Max(airBrakeValue, CruiseControlBrakeDemand());
            
            SetDynamicBrakeIntervention(currentDynamicBrakeValue);
            
            float releasePressure = Math.Min(MaxPressureBar(), MainReservoirPressureBar());
            float fullServPressure = MaxPressureBar()-FullServReductionBar();
            switch(CurrentState)
            {
                case State.Release:
                    if (pressureBar < releasePressure) pressureBar = Math.Min(releasePressure, pressureBar+elapsedClockSeconds*ReleaseRateBarpS());
                    break;
                case State.Apply:
                    float target = MaxPressureBar() - airBrakeValue*FullServReductionBar();
                    if(target<pressureBar) pressureBar = Math.Max(target, pressureBar-elapsedClockSeconds*ApplyRateBarpS());
                    else if (target < releasePressure) pressureBar = Math.Min(target, pressureBar+elapsedClockSeconds*ReleaseRateBarpS());
                    break;
                case State.FullBrake:
                    if (pressureBar > fullServPressure) pressureBar = Math.Max(fullServPressure, pressureBar-elapsedClockSeconds*ApplyRateBarpS());
                    break;
                case State.Emergency:
                    pressureBar = Math.Max(0, pressureBar-elapsedClockSeconds*EmergencyRateBarpS());
                    break;
                case State.AUXdecrease:
                    if (pressureBar < releasePressure) pressureBar = Math.Min(releasePressure, pressureBar+elapsedClockSeconds*ReleaseRateBarpS());
                    break;
                case State.AUXincrease:
                    pressureBar = Math.Max(0, pressureBar-elapsedClockSeconds*ApplyRateBarpS());
                    break;
            }
            if (CurrentState == State.Emergency)
            {
                epPressureBar = 1;
            }
            else if (Canal1Activo)
            {
                epPressureBar = Math.Min(airBrakeValue, 0.7f);
            }
            else
            {
                epPressureBar = -1;
            }
        }
        public override void UpdateEngineBrakePressure(ref float pressureBar, float elapsedClockSeconds)
        {
            
        }
        public override void HandleEvent(BrakeControllerEvent evt)
        {
            switch (evt)
            {
                case BrakeControllerEvent.StartIncrease:
                    SetUpdateValue(1);
                    break;
                case BrakeControllerEvent.StartDecrease:
                    SetUpdateValue(-1);
                    break;
                case BrakeControllerEvent.StopIncrease:
                case BrakeControllerEvent.StopDecrease:
                    SetUpdateValue(0);
                    break;
            }
        }
        public override void HandleEvent(BrakeControllerEvent evt, float? value)
        {
            if(evt == BrakeControllerEvent.SetCurrentPercent) Value = IntermediateValue = value.Value/100;
            else if(evt == BrakeControllerEvent.SetCurrentValue) Value = IntermediateValue = value.Value;
            else HandleEvent(evt);
        }
        public override bool IsValid()
        {
            return true;
        }
        public override ControllerState GetState()
        {
            switch(CurrentState)
            {
                case State.Release:
                    return ControllerState.Release;
                case State.Apply:
                    return ControllerState.GSelfLap;
                case State.FullBrake:
                    if(TCSFullServiceBraking()) return ControllerState.TCSFullServ;
                    return ControllerState.FullServ;
                case State.Emergency:
                    if (EmergencyBrakingPushButton()) return ControllerState.EBPB;
                    if (TCSEmergencyBraking()) return ControllerState.TCSEmergency;
                    return ControllerState.Emergency;
                case State.AUXdecrease:
                    return ControllerState.Release;
                case State.AUXincrease:
                    return ControllerState.Apply;
            }
            return ControllerState.Dummy;
        }
        public override float? GetStateFraction()
        {
            if(CurrentState==State.Apply) return Math.Max(applyValue, CruiseControlBrakeDemand());
            return null;
        }
    }
}
