class ATO
{
    float p_coef = 0;
    float i_coef = 0.3f;
    float d_coef = 0;
    float prev_error;
    float cum_error;
    float PermittedSpeed;
    float TargetSpeed;
    Odometer TargetDistance;
    bool HandleBrakingDistance()
    {
        float distance = TargetDistance.RemainingValue;
        if (TargetSpeed >= SpeedMpS() || distance <= 0)
        {
            cum_error = prev_error = 0;
            PermittedSpeed = TargetSpeed;
            return false;
        }
        float requiredDec = (SpeedMpS() * SpeedMpS() - TargetSpeed*TargetSpeed) / 2 / distance;
        if (requiredDec > 0.3f)
        {
            float error = requiredDec - DecelerationMpSpS();
            cum_error += error * dt;
            float p_out = p_coef*error;
            float i_out = i_coef*cum_error;
            float d_out = d_coef*(error-prev_error)/dt;
            float pid_out = d_out+p_out+i_out;
            prev_error = error;
            Locomotive().TrainBrakeController.SetValue(Math.Min(Math.Max((requiredDec + pid_out) / 1.1f, 0), 1));
            return true;
        }
        else
        {
            cum_error = prev_error = 0;
            return false;
        }
    }
    void Update(float dt)
    {
        if (!HandleBrakingDistance())
        {
            ATF(PermittedSpeed);
        }
    }
    void UpdateSpeed(float speed)
    {
        TargetSpeed = speed;
    }
    void UpdateDistance(float distance)
    {
        Distance.Setup(distance);
        Distance.Start();
    }
}
