using System;
using Orts.Common;
using ORTS.Common;
using Orts.Simulation;
using ORTS.Scripting.Api;
using Event = Orts.Common.Event;
using System.Collections.Generic;
namespace ORTS.Scripting.Script
{
    public class UT451PowerSupply : ControlCarPowerSupply
    {
        private Timer CambioCabinaTimer;
        private Timer DesconexionBateriaTimer;

        private bool QuickPowerOn = false;

        bool CabinaHabilitada;
        bool OtraCabinaHabilitada;
        int LeadIndex;
        int EstadoCabeza;

        bool MotrizImpar;

        bool ConvertidorEstatico;
        bool ControlAuxiliar;
        bool AceleracionReducida;
        bool CompresorManual;
        bool Panto1;
        bool Panto2;

        bool CompresorAuxiliar;

        int Serie;

        public static Random Random = new Random();

        Dictionary<int, bool> EstadoConvertidores = new Dictionary<int,bool>();
        Dictionary<int, bool> EstadoDisyuntores = new Dictionary<int,bool>();
        Dictionary<int, bool> FrenoElectricoAnulado = new Dictionary<int,bool>();
        Dictionary<int, bool> CocheSeccionado = new Dictionary<int,bool>();

        public enum Interruptor
        {
            ControlAuxiliar,
            ConvertidorEstatico,
            CompresorManual,
            AceleracionReducida,
            Panto1,
            Panto2,
            Seccionamiento,
            AnulacionFrenoElectrico,
            RearmeBBMM,
        }
        Dictionary<Interruptor, bool> EstadoInterruptores = new Dictionary<Interruptor,bool>();
        int ControlInicioInterruptores=0;
        public enum Lampara
        {
            DisyuntorPropioAbierto,
            DisyuntorAbierto,
            FaltaConvertidorPropio,
            FaltaConvertidor,
            BateriaDescargada,
            CocheSeccionado,
            CochePropioSeccionado,
            FrenoElectricoAnulado,
            FrenoElectricoPropioAnulado,
            CambioCabina,
        }
        int ControlInicioLamparas=10;
        Dictionary<Lampara, bool> EstadoLamparas = new Dictionary<Lampara, bool>();
        Dictionary<Interruptor, int> InterruptorToCabButton = new Dictionary<Interruptor, int>();
        Dictionary<int, Interruptor> CabButtonToInterruptor = new Dictionary<int, Interruptor>();
        Dictionary<Interruptor, int> InterruptorToCabSwitch = new Dictionary<Interruptor, int>();
        Dictionary<int, Interruptor> CabSwitchToInterruptor = new Dictionary<int, Interruptor>();
        int ControlAmperimetroConvertidor=30;

        bool CambioCabina
        {
            get
            {
                return ServiceRetentionActive;
            }
            set
            {
                ServiceRetentionActive = value;
            }
        }

        public override void Initialize()
        {
            Serie = GetIntParameter("General", "Serie", 451);
            DesconexionBateriaTimer = new Timer(this);
            DesconexionBateriaTimer.Setup(150);

            CambioCabinaTimer = new Timer(this);

            for (var i=Interruptor.ControlAuxiliar; i<=Interruptor.RearmeBBMM; i++)
            {
                EstadoInterruptores[i] = false;
            }
            for (var i=Lampara.DisyuntorPropioAbierto; i<=Lampara.FrenoElectricoPropioAnulado; i++)
            {
                EstadoLamparas[i] = false;
            }
            if (Serie == 446 || Serie == 447)
            {
                for (var i=Interruptor.ControlAuxiliar; i<=Interruptor.AnulacionFrenoElectrico; i++)
                {
                    InterruptorToCabSwitch[i] = (int)i+ControlInicioInterruptores;
                }
                SetCustomizedCabviewControlName(ControlInicioInterruptores, "Control auxiliar");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+1, "Convertidor estático");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+2, "Compresor manual");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+3, "Aceleración reducida");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+4, "Pantógrafo 1");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+5, "Pantógrafo 2");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+6, "Seccionamiento");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+7, "Anulación freno eléctrico");
            }
            else if (Serie == 450 || Serie == 451)
            {
                InterruptorToCabButton[Interruptor.RearmeBBMM] = ControlInicioInterruptores;
                InterruptorToCabSwitch[Interruptor.ConvertidorEstatico] = ControlInicioInterruptores + 1;
                InterruptorToCabSwitch[Interruptor.CompresorManual] = ControlInicioInterruptores + 2;
                InterruptorToCabSwitch[Interruptor.Panto1] = ControlInicioInterruptores + 4;
                SetCustomizedCabviewControlName(ControlInicioInterruptores, "Rearme BB/MM");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+1, "Convertidor estático");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+2, "Compresor manual");
                SetCustomizedCabviewControlName(ControlInicioInterruptores+4, "Pantógrafo");
            }
            foreach (var kvp in InterruptorToCabSwitch)
            {
                CabSwitchToInterruptor[kvp.Value] = kvp.Key;
            }
            foreach (var kvp in InterruptorToCabButton)
            {
                CabButtonToInterruptor[kvp.Value] = kvp.Key;
            }
        }

        private int prevNumberOfLocomotives;
        public override void Update(float elapsedClockSeconds)
        {
            if (prevNumberOfLocomotives != NumberOfLocomotives())
            {
                CabinaHabilitada = OtraCabinaHabilitada = false;
                LeadIndex = -1;
                prevNumberOfLocomotives = NumberOfLocomotives();
            }
            SetCurrentBatteryState(BatterySwitchOn() ? PowerSupplyState.PowerOn : PowerSupplyState.PowerOff);
            if (CurrentLowVoltagePowerSupplyState() == PowerSupplyState.PowerOn &&
                ((BatteryVoltageV < 55 && !CompresorAuxiliar) || BatteryVoltageV < 45 || (!CabinaHabilitada && !OtraCabinaHabilitada && !CambioCabina) || CurrentBatteryState() != PowerSupplyState.PowerOn || DesconexionBateriaTimer.Triggered)
            )
            {
                if (DesconexionBateriaTimer.Triggered)
                    Message(ConfirmLevel.Warning, "Circuito de batería desconectado por inactividad. Reinicie proceso de puesta en marcha");
                SetCurrentLowVoltagePowerSupplyState(PowerSupplyState.PowerOff);
            }
            if (CurrentLowVoltagePowerSupplyState() != PowerSupplyState.PowerOn || CompresorAuxiliar || (BatteryVoltageV >= 69 && (Panto1 || Panto2)))
            {
                if (DesconexionBateriaTimer.Started) DesconexionBateriaTimer.Stop();
            }
            else if (!DesconexionBateriaTimer.Started)
            {
                DesconexionBateriaTimer.Start();
            }
            SetCurrentCabPowerSupplyState(CurrentLowVoltagePowerSupplyState() == PowerSupplyState.PowerOn && CabinaHabilitada && (ControlAuxiliar || Serie == 450 || Serie == 451) ? PowerSupplyState.PowerOn : PowerSupplyState.PowerOff);

            MotrizImpar = (IndexOfLocomotive()%2) == 0;

            if (IsLocomotiveLeading && QuickPowerOn && !CabinaHabilitada)
            {
                OtraCabinaHabilitada = false;
                LeadIndex = -1;
                HandleHabilitacionCabina(true, true);
                if (Serie == 450 || Serie == 451)
                {
                    EstadoInterruptores[Interruptor.Panto1] = true;
                    EstadoInterruptores[Interruptor.ConvertidorEstatico] = true;
                }
                else
                {
                    EstadoInterruptores[Interruptor.Panto1] = false;
                    EstadoInterruptores[Interruptor.Panto2] = true;
                    EstadoInterruptores[Interruptor.ControlAuxiliar] = true;
                    EstadoInterruptores[Interruptor.ConvertidorEstatico] = true;
                }
            }
            QuickPowerOn = false;

            if (ServiceRetentionButton && !CambioCabina)
            {
                CambioCabina = true;
                CambioCabinaTimer.Setup(((Serie == 450 || Serie == 451) ? 30 : 15)*60);
                CambioCabinaTimer.Start();
                Panto1 = true;
                if (Serie == 446 || Serie == 447) Panto2 = true;
                Message(ConfirmLevel.Information, "Cambio de cabina activado");
            }
            if (CambioCabina && (CambioCabinaTimer.Triggered || ServiceRetentionCancellationButton || CurrentLowVoltagePowerSupplyState() != PowerSupplyState.PowerOn))
            {
                CambioCabina = false;
                Message(ConfirmLevel.Information, "Cambio de cabina anulado");
            }

            if (CabinaHabilitada)
            {
                if (EstadoInterruptores[Interruptor.Panto1] != Panto1 && (!Panto1 || !CambioCabina)) Panto1 = !Panto1;
                if (EstadoInterruptores[Interruptor.Panto2] != Panto2 && (!Panto2 || !CambioCabina)) Panto2 = !Panto2;
                if (Serie == 446 || Serie == 447) ControlAuxiliar = EstadoInterruptores[Interruptor.ControlAuxiliar];
                if (EstadoInterruptores[Interruptor.ConvertidorEstatico] != ConvertidorEstatico && (!ConvertidorEstatico || !CambioCabina)) ConvertidorEstatico = !ConvertidorEstatico;
                if (Serie == 446 || Serie == 447) AceleracionReducida = EstadoInterruptores[Interruptor.AceleracionReducida];
                LeadIndex = IndexOfLocomotive();
                SignalEventToOtherTrainVehiclesWithId(PowerSupplyEvent.CloseCircuitBreaker, SerializeInterruptores());
                SignalEventToOtherTrainVehiclesWithId(PowerSupplyEvent.TurnOnMasterKey, LeadIndex);
            }
            else if (OtraCabinaHabilitada)
            {
                if (((EstadoCabeza&1) != 0) != Panto1 && (!Panto1 || !CambioCabina)) Panto1 = !Panto1;
                if (((EstadoCabeza&2) != 0) != Panto2 && (!Panto2 || !CambioCabina)) Panto2 = !Panto2;
                AceleracionReducida = (EstadoCabeza&4) != 0;
                if (((EstadoCabeza&16) != 0) != ConvertidorEstatico && (!ConvertidorEstatico || !CambioCabina)) ConvertidorEstatico = !ConvertidorEstatico;
                ControlAuxiliar = (EstadoCabeza&32) != 0;
            }
            else if (!CambioCabina)
            {
                ConvertidorEstatico = false;
                ControlAuxiliar = false;
                AceleracionReducida = false;
                Panto1 = Panto2 = false;
            }
            if (IsLocomotiveLeading && !CabinaHabilitada && !OtraCabinaHabilitada)
            {
                SignalEventToOtherTrainVehiclesWithId(PowerSupplyEvent.TurnOnMasterKey, -1);
            }

            if (CabinaHabilitada && CurrentLowVoltagePowerSupplyState() == PowerSupplyState.PowerOn)
            {
                EstadoLamparas[Lampara.DisyuntorPropioAbierto] = false;
                EstadoLamparas[Lampara.FaltaConvertidorPropio] = false;
                EstadoLamparas[Lampara.CochePropioSeccionado] = false;
                EstadoLamparas[Lampara.FrenoElectricoPropioAnulado] = false;
                EstadoLamparas[Lampara.DisyuntorAbierto] = false;
                EstadoLamparas[Lampara.FaltaConvertidor] = false;
                EstadoLamparas[Lampara.CocheSeccionado] = false;
                EstadoLamparas[Lampara.FrenoElectricoAnulado] = false;
                foreach (var kvp in EstadoDisyuntores)
                {
                    if (kvp.Value) EstadoLamparas[Lampara.DisyuntorAbierto] = true;
                }
                foreach (var kvp in EstadoConvertidores)
                {
                    if (kvp.Value) EstadoLamparas[Lampara.FaltaConvertidor] = true;
                }
                foreach (var kvp in CocheSeccionado)
                {
                    if (kvp.Value) EstadoLamparas[Lampara.CocheSeccionado] = true;
                }
                foreach (var kvp in FrenoElectricoAnulado)
                {
                    if (kvp.Value) EstadoLamparas[Lampara.FrenoElectricoAnulado] = true;
                }
            }
            else
            {
                EstadoLamparas[Lampara.DisyuntorAbierto] = false;
                EstadoLamparas[Lampara.FaltaConvertidor] = false;
                EstadoLamparas[Lampara.FaltaConvertidorPropio] = false;
                EstadoLamparas[Lampara.CocheSeccionado] = false;
                EstadoLamparas[Lampara.CochePropioSeccionado] = false;
                EstadoLamparas[Lampara.FrenoElectricoAnulado] = false;
                EstadoLamparas[Lampara.FrenoElectricoPropioAnulado] = false;
            }
            EstadoLamparas[Lampara.BateriaDescargada] = BatteryVoltageV < 55 && CurrentBatteryState() == PowerSupplyState.PowerOn;
            EstadoLamparas[Lampara.CambioCabina] = CambioCabina;

            foreach (var kvp in EstadoInterruptores)
            {
                if (InterruptorToCabSwitch.TryGetValue(kvp.Key, out int cab))
                    SetCabDisplayControl(cab, kvp.Value ? 1 : 0);
                if (InterruptorToCabButton.TryGetValue(kvp.Key, out cab))
                    SetCabDisplayControl(cab, kvp.Value ? 1 : 0);
            }
            foreach (var kvp in EstadoLamparas)
            {
                SetCabDisplayControl((int)kvp.Key + ControlInicioLamparas, kvp.Value ? 1 : 0);
            }
        }

        void HandleHabilitacionCabina(bool propia, bool on)
        {
            if (propia)
            {
                if (MasterKeyOn() == on) return;
                SignalEventToMasterKey(on ? PowerSupplyEvent.TurnOnMasterKey : PowerSupplyEvent.TurnOffMasterKey);
                Confirm(CabControl.MasterKey, on ? CabSetting.On : CabSetting.Off);
                if (OtraCabinaHabilitada) on = false;
                if (CabinaHabilitada == on)
                {
                    if (OtraCabinaHabilitada && !CabinaHabilitada)
                    {
                        Message(ConfirmLevel.Warning, "Ya hay una cabina habilitada");
                    }
                    return;
                }
                CabinaHabilitada = on;
                EstadoConvertidores.Clear();
                EstadoDisyuntores.Clear();
                FrenoElectricoAnulado.Clear();
                CocheSeccionado.Clear();
            }
            else
            {
                if (OtraCabinaHabilitada == on) return;
                OtraCabinaHabilitada = on;
            }
            if (on && CambioCabina)
            {
                CambioCabinaTimer.Setup(10);
                CambioCabinaTimer.Start();
            }
            if (on)
            {
                if (CurrentBatteryState() == PowerSupplyState.PowerOn)
                    SetCurrentLowVoltagePowerSupplyState(PowerSupplyState.PowerOn);
                else
                    Message(ConfirmLevel.Warning, "Batería desconectada, conéctela y vuelva a habilitar la cabina");
            }
        }

        int SerializeInterruptores()
        {
            int state = 0;
            state |= Panto1 ? 1 : 0;
            if (Serie == 446 || Serie == 447) state |= Panto2 ? 2 : 0;
            if (Serie == 446 || Serie == 447) state |= AceleracionReducida ? 4 : 0;
            state |= CompresorManual ? 8 : 0;
            state |= ConvertidorEstatico ? 16 : 0;
            if (Serie == 446 || Serie == 447) state |= ControlAuxiliar ? 32 : 0;
            return state;
        }

        public override void HandleEvent(PowerSupplyEvent evt)
        {
            switch (evt)
            {
                case PowerSupplyEvent.TurnOnMasterKey:
                case PowerSupplyEvent.TurnOffMasterKey:
                    if (EstadoInterruptores[Interruptor.ControlAuxiliar] || EstadoInterruptores[Interruptor.ConvertidorEstatico]
                        || EstadoInterruptores[Interruptor.CompresorManual] || EstadoInterruptores[Interruptor.AceleracionReducida]
                        || EstadoInterruptores[Interruptor.Panto1] || EstadoInterruptores[Interruptor.Panto2])
                    {
                        Message(ConfirmLevel.Warning, "Desconecte todos los interruptores antes de deshabilitar la cabina");
                        return;
                    }
                    HandleHabilitacionCabina(true, evt == PowerSupplyEvent.TurnOnMasterKey);
                    break;
                case PowerSupplyEvent.ServiceRetentionButtonPressed:
                    if (!CabinaHabilitada) return;
                    ServiceRetentionButton = true;
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                case PowerSupplyEvent.ServiceRetentionButtonReleased:
                    ServiceRetentionButton = false;
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                case PowerSupplyEvent.ServiceRetentionCancellationButtonPressed:
                    ServiceRetentionCancellationButton = true;
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                case PowerSupplyEvent.ServiceRetentionCancellationButtonReleased:
                    ServiceRetentionCancellationButton = false;
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                case PowerSupplyEvent.RaisePantograph:
                case PowerSupplyEvent.LowerPantograph:
                    break;
                case PowerSupplyEvent.OpenBatterySwitch:
                case PowerSupplyEvent.CloseBatterySwitch:
                    SignalEventToBatterySwitch(evt);
                    if (Serie == 446 || Serie == 447) SignalEventToOtherLocomotive(IndexOfLocomotive() + (MotrizImpar ? 1 : -1), evt);
                    break;
                case PowerSupplyEvent.OpenCircuitBreakerButtonPressed:
                case PowerSupplyEvent.OpenCircuitBreakerButtonReleased:
                case PowerSupplyEvent.CloseCircuitBreakerButtonPressed:
                case PowerSupplyEvent.CloseCircuitBreakerButtonReleased:
                    if (!MasterKeyOn())
                    {
                        Message(ConfirmLevel.Warning, "Caja de interruptores enclavada");
                        return;
                    }
                    if (!CabinaHabilitada)
                    {
                        Message(ConfirmLevel.Warning, "Ya hay una cabina habilitada");
                        return;
                    }
                    SignalEventToOtherLocomotives(evt);
                    break;
                case PowerSupplyEvent.QuickPowerOn:
                    QuickPowerOn = true;
                    SignalEventToBatterySwitch(PowerSupplyEvent.CloseBatterySwitch);
                    if (Serie == 446 || Serie == 447) SignalEventToOtherLocomotive(IndexOfLocomotive() + (MotrizImpar ? 1 : -1), PowerSupplyEvent.CloseBatterySwitch);
                    break;

                case PowerSupplyEvent.QuickPowerOff:
                    QuickPowerOn = false;
                    EstadoInterruptores[Interruptor.Panto1] = false;
                    EstadoInterruptores[Interruptor.Panto2] = false;
                    EstadoInterruptores[Interruptor.ControlAuxiliar] = false;
                    EstadoInterruptores[Interruptor.ConvertidorEstatico] = false;
                    EstadoInterruptores[Interruptor.AceleracionReducida] = false;
                    EstadoInterruptores[Interruptor.CompresorManual] = false;
                    if (MasterKeyOn()) HandleHabilitacionCabina(true, false);
                    SignalEventToBatterySwitch(PowerSupplyEvent.OpenBatterySwitch);
                    if (Serie == 446 || Serie == 447) SignalEventToOtherLocomotive(IndexOfLocomotive() + (MotrizImpar ? 1 : -1), PowerSupplyEvent.OpenBatterySwitch);
                    break;

                default:
                    base.HandleEvent(evt);
                    break;
            }
        }
        public override void HandleEvent(PowerSupplyEvent evt, int id)
        {
            switch (evt)
            {
                case PowerSupplyEvent.RaisePantograph:
                case PowerSupplyEvent.LowerPantograph:
                    if (!MasterKeyOn())
                    {
                        Message(ConfirmLevel.Warning, "Caja de interruptores enclavada");
                        return;
                    }
                    if (!CabinaHabilitada)
                    {
                        Message(ConfirmLevel.Warning, "Ya hay una cabina habilitada");
                        return;
                    }
                    bool up = evt == PowerSupplyEvent.RaisePantograph;
                    if (id == 1) EstadoInterruptores[Interruptor.Panto1] = up;
                    if (id == 2 && (Serie == 446 || Serie == 447)) EstadoInterruptores[Interruptor.Panto2] = up;
                    break;
                case PowerSupplyEvent.GenericPowerSupplyButtonPressed:
                case PowerSupplyEvent.GenericPowerSupplyButtonReleased:
                {
                    if (!MasterKeyOn())
                    {
                        Message(ConfirmLevel.Warning, "Caja de interruptores enclavada");
                        return;
                    }
                    if (!CabinaHabilitada)
                    {
                        Message(ConfirmLevel.Warning, "Ya hay una cabina habilitada");
                        return;
                    }
                    bool pressed = evt == PowerSupplyEvent.GenericPowerSupplyButtonPressed;
                    if (pressed && CabSwitchToInterruptor.TryGetValue(id, out Interruptor i))
                    {
                        if (!EstadoInterruptores.TryGetValue(i, out bool state) || !state) EstadoInterruptores[i] = true;
                        else EstadoInterruptores[i] = false;
                    }
                    if (CabButtonToInterruptor.TryGetValue(id, out i))
                    {
                        EstadoInterruptores[i] = pressed;
                    }
                    break;
                }
            }
        }
        public override void HandleEventFromLeadLocomotive(PowerSupplyEvent evt)
        {
            switch (evt)
            {
                case PowerSupplyEvent.ServiceRetentionButtonPressed:
                    ServiceRetentionButton = true;
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                case PowerSupplyEvent.ServiceRetentionButtonReleased:
                    ServiceRetentionButton = false;
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                case PowerSupplyEvent.ServiceRetentionCancellationButtonPressed:
                    ServiceRetentionCancellationButton = true;
                    SignalEventToOtherTrainVehicles(evt);
                    break;
                case PowerSupplyEvent.ServiceRetentionCancellationButtonReleased:
                    ServiceRetentionCancellationButton = false;
                    SignalEventToOtherTrainVehicles(evt);
                    break;
            }
        }
        public override void HandleEventFromLeadLocomotive(PowerSupplyEvent evt, int id)
        {
            switch (evt)
            {
                case PowerSupplyEvent.TurnOnMasterKey:
                    HandleHabilitacionCabina(false, id >= 0);
                    LeadIndex = id;
                    break;
                case PowerSupplyEvent.CloseCircuitBreaker:
                    EstadoCabeza = id;
                    break;
            }
        }
        public override void HandleEventFromOtherLocomotive(int locoIndex, PowerSupplyEvent evt)
        {
            switch (evt)
            {
                case PowerSupplyEvent.CloseBatterySwitch:
                case PowerSupplyEvent.OpenBatterySwitch:
                    if ((Serie == 446 || Serie == 447)
                        && ((locoIndex == IndexOfLocomotive() + 1 && MotrizImpar) || (locoIndex == IndexOfLocomotive() - 1 && !MotrizImpar))
                    )
                    {
                        SignalEventToBatterySwitch(evt);
                    }
                    break;
            }
        }
        public override void HandleEventFromOtherLocomotive(int locoIndex, PowerSupplyEvent evt, int id)
        {
            switch (evt)
            {
                case PowerSupplyEvent.CloseCircuitBreaker:
                    if (!CabinaHabilitada) return;
                    EstadoDisyuntores[locoIndex] = (id&1) != 0;
                    EstadoConvertidores[locoIndex] = (id&2) != 0;
                    CocheSeccionado[locoIndex] = (id&4) != 0;
                    FrenoElectricoAnulado[locoIndex] = (id&8) != 0;
                    break;
            }
        }
    }
}
