using System;
using Orts.Common;
using ORTS.Common;
using ORTS.Scripting.Api;
using Event = Orts.Common.Event;
using Orts.Simulation.RollingStocks;
using Orts.Simulation.RollingStocks.SubSystems;
using Orts.Simulation.Signalling;
using Orts.Simulation;
namespace ORTS.Scripting.Script
{
    public class MetroMadrid : TrainControlSystem
    {
        public enum CodigoATP
        {
            Ninguno,
            ATP1P,
            ATP2P,
            ATPDO
        }
        float ATPCurrentSpeedMpS;
        float ATPNextSpeedMpS;
        float ATPCurrentBlockMaxSpeedLimitMpS;
        float ATPNextBlockMaxSpeedLimitMpS;
        float ATPTargetDistanceM;
        float ATPLastDisplayedSpeed;
        float ATPLastDisplaySpeedChange;
        bool ATPAutoBrake;
        bool ATPTCO;
        bool ATPServiceBrake;
        float prevSpeedMpS;
        int ControlExcesoVelocidadATP = 0;
        int ControlVelocidadATP = 2;
        int ControlCodigosATP = 3;
        int ControlM_20 = 4;
        int ControlATP = 5;
        int ControlATO = 6;
        int ControlLanzarATO = 1;
        bool ATOArranque1;
        bool ATOArranque2;
        bool ATOIgnoreStation;
        bool ATOStationMissed;
        bool ATOStopped;
        bool ATOServiceBrake;
        float ATOPrevStationDistanceM;
        CodigoATP ATPCodigoVia;
        public enum ModoConduccion
        {
            Inactivo,
            LlaveEspecial,
            M_20,
            M_ATP,
            ATO,
        }
        ModoConduccion ModoConduccionActual;
        public override void Initialize()
        {
            SetCustomizedCabviewControlName(ControlExcesoVelocidadATP, "Exceso velocidad");
            SetCustomizedCabviewControlName(ControlM_20, "Manual+20");
            SetCustomizedCabviewControlName(ControlATP, "Manual+ATP");
            SetCustomizedCabviewControlName(ControlATO, "ATO");
            SetCustomizedCabviewControlName(ControlLanzarATO, "Lanzar ATO");
            ATPAutoBrake = GetBoolParameter("ATP", "MantenerVelocidad", false);
        }
        public override void Update()
        {
            if (!IsCabPowerSupplyOn() || !IsLowVoltagePowerSupplyOn() || IsDirectionNeutral() || !IsTrainControlEnabled()) RequestMode(ModoConduccion.Inactivo);
            if (!IsDirectionForward() && ModoConduccionActual > ModoConduccion.M_20) RequestMode(ModoConduccion.M_20);
            
            UpdateSignalPassed();
            UpdatePostPassed();
            
            if (ModoConduccionActual >= ModoConduccion.M_20) UpdateATP();
            if (ModoConduccionActual == ModoConduccion.ATO && (TrainBrakeControllerState() != ControllerState.Release || IsBrakeEmergency())) RequestMode(ModoConduccion.M_ATP);
            if (ModoConduccionActual == ModoConduccion.ATO) UpdateATO();
            //UpdateMegafonia();
            SetEmergencyBrake(ModoConduccionActual == ModoConduccion.Inactivo && IsTrainControlEnabled());
            if  (ModoConduccionActual == ModoConduccion.ATO) SetFullBrake(ATOServiceBrake);
            else if (ModoConduccionActual == ModoConduccion.M_ATP) SetFullBrake(ATPServiceBrake);
            else SetFullBrake(false);
            UpdateLazoTraccion(ATPTCO);
        }
        public float NextPlatformDistanceM()
        {
            for (int i=0; i<5; i++)
            {
                var feat = NextGenericSignalFeatures("M_ATO", i, float.MaxValue);
                var name = feat.MainHeadSignalTypeName.ToLowerInvariant();
                if (name == ((TrainLengthM() < 80) ? "parada_ato_simple" : "parada_ato")) return feat.DistanceM;
            }
            return float.MaxValue;
        }
        public void RequestMode(ModoConduccion modo)
        {
            if (modo == ModoConduccionActual) return;
            ModoConduccion prev = ModoConduccionActual;
            if (modo == ModoConduccion.M_20 && IsDirectionNeutral()) return;
            if (modo > ModoConduccion.M_20 && (!IsDirectionForward() || ATPCodigoVia == CodigoATP.Ninguno)) return;
            if (modo == ModoConduccion.ATO && SpeedMpS() > 0.1f) return;
            ModoConduccionActual = modo;
            if (ModoConduccionActual >= ModoConduccion.M_20 && prev < ModoConduccion.M_20)
            {
                ATPNextSpeedMpS = ATPCurrentSpeedMpS = MpS.FromKpH(20);
                ATPCurrentBlockMaxSpeedLimitMpS = 0;
            }
            if (ModoConduccionActual < ModoConduccion.M_20 && prev >= ModoConduccion.M_20)
            {
                ATPCodigoVia = CodigoATP.Ninguno;
                SetCabDisplayControl(ControlExcesoVelocidadATP, 0);
                SetCabDisplayControl(ControlCodigosATP, 0);
                SetCabDisplayControl(ControlVelocidadATP, 0);
            }
            if (ModoConduccionActual == ModoConduccion.ATO)
            {
                ATOIgnoreStation = ATOStationMissed = false;
                ATOPrevStationDistanceM = float.MaxValue;
                ATOStopped = true;
            }
            if (ModoConduccionActual < ModoConduccion.ATO && prev == ModoConduccion.ATO)
            {
                SetThrottleController(0);
                SetDynamicBrakeController(0);
            }
            SetCabDisplayControl(ControlM_20, ModoConduccionActual == ModoConduccion.M_20 ? 1 : 0);
            SetCabDisplayControl(ControlATP, ModoConduccionActual == ModoConduccion.M_ATP ? 1 : 0);
            SetCabDisplayControl(ControlATO, ModoConduccionActual == ModoConduccion.ATO ? 1 : 0);
        }
        float GetATPBrakingDistanceM(float current, float target)
        {
            return DistanceCurve(current, target, 0, 5, 1);
        }
        /*float GetATPSpeedMpS(float speed, float distance)
        {
            if (speed > MpS.FromKpH(57.1f) && GetATPBrakingDistanceM(MpS.FromKpH(80), speed) < distance) return MpS.FromKpH(80);
            else if (speed > MpS.FromKpH(34.1f) && GetATPBrakingDistanceM(MpS.FromKpH(70), speed) < distance) return MpS.FromKpH(70);
            else if (speed > MpS.FromKpH(0.1f) && GetATPBrakingDistanceM(MpS.FromKpH(57), speed) < distance) return MpS.FromKpH(57);
            else if (GetATPBrakingDistanceM(MpS.FromKpH(34), speed) < distance) return MpS.FromKpH(34);
            return 0;
            if (speed > MpS.FromKpH(57.1f)) return MpS.FromKpH(80);
            else if (speed > MpS.FromKpH(34.1f)) return MpS.FromKpH(70);
            else if (speed > MpS.FromKpH(0.1f)) return MpS.FromKpH(57);
            else return MpS.FromKpH(34);
        }*/
        float GetATPSpeedMpS(float speed)
        {
            if (speed > MpS.FromKpH(70.1f))
                return MpS.FromKpH(80);
            if (speed > MpS.FromKpH(57.1f))
                return MpS.FromKpH(70);
            if (speed > MpS.FromKpH(34.1f))
                return MpS.FromKpH(57);
            return MpS.FromKpH(34);
        }
        float GetATPBlockMaxSpeedMpS(float startDistM, float endDistM)
        {
            float current = CurrentPostSpeedMpS;
            float post = MpS.FromKpH(80);
            for (int i=0; i<15; i++)
            {
                float dist = NextPostDistanceM(i);
                float spd = NextPostSpeedLimitMpS(i);
                if (dist > endDistM || dist < 0) break;
                else if (dist > startDistM) post = Math.Min(spd, post);
                if (dist < startDistM + 15) current = post;
            }
            post = Math.Min(post, current);
            return GetATPSpeedMpS(post);
        }
        int GetATP1PCode(string aspect)
        {
            if (!aspect.StartsWith("ATP1P_")) return 0;
            int.TryParse(aspect.Substring(6), out int code);
            return code;
        }
        (int,int) GetATP2PCodes(string aspect)
        {
            if (!aspect.StartsWith("ATP2P_")) return (0,0);
            bool err = !int.TryParse(aspect.Substring(6, aspect.IndexOf('/')-6), out int v1);
            err |= !int.TryParse(aspect.Substring(aspect.IndexOf('/')+1), out int v2);
            if (err) return (0,0);
            return (v1, v2);
        }
        int GetATPDOAhead(string aspect)
        {
            if (!aspect.StartsWith("ATPDO_")) return -1;
            bool err = int.TryParse(aspect.Substring(6), out int ahead);
            if (err) return -1;
            return ahead;
        }
        public void UpdateATP()
        {
            var txt = NextGenericSignalFeatures("NORMAL", 0, float.MaxValue).TextAspect;
            if (txt.Contains("ATPDO")) ATPCodigoVia = CodigoATP.ATPDO;
            else if (txt.Contains("ATP2P")) ATPCodigoVia = CodigoATP.ATP2P;
            else if (txt.Contains("ATP1P")) ATPCodigoVia = CodigoATP.ATP1P;
            else ATPCodigoVia = CodigoATP.Ninguno;
            if (ModoConduccionActual == ModoConduccion.M_20)
            {
                /*if (SignalPassedFeatures != null && SignalPassedFeatures.Value.Aspect == Aspect.Restricted) ATPCurrentSpeedMpS = 0;
                if (ATPCurrentSpeedMpS > 0)
                {
                    ATPNextSpeedMpS = ATPCurrentSpeedMpS = MpS.FromKpH(20);
                }
                else
                {
                    ATPCurrentSpeedMpS = ATPNextSpeedMpS = 0;
                }*/
                ATPNextSpeedMpS = ATPCurrentSpeedMpS = MpS.FromKpH(20);
                ATPCurrentBlockMaxSpeedLimitMpS = 0;
                ATPTargetDistanceM = 0;
            }
            else if (ATPCodigoVia == CodigoATP.ATP2P)
            {
                if (SignalPassedFeatures != null)
                {
                    (int,int) prevcodes = GetATP2PCodes(SignalPassedFeatures.Value.TextAspect);
                    if (prevcodes.Item2 == 0) ATPCurrentSpeedMpS = 0;
                }
                (int, int) codes = GetATP2PCodes(txt);
                if (ATPCurrentSpeedMpS == 0) codes = (0,0);
                
                if (SignalPassedFeatures != null) ATPCurrentBlockMaxSpeedLimitMpS = ATPNextBlockMaxSpeedLimitMpS;
                if (ATPCurrentBlockMaxSpeedLimitMpS == 0) ATPCurrentBlockMaxSpeedLimitMpS = GetATPBlockMaxSpeedMpS(0, NextSignalDistanceM(0));
                ATPNextBlockMaxSpeedLimitMpS = GetATPBlockMaxSpeedMpS(NextSignalDistanceM(0), NextSignalDistanceM(1));
                
                float prevATPSpeedMpS = ATPNextSpeedMpS;
                
                ATPCurrentSpeedMpS = Math.Min(MpS.FromKpH(codes.Item1), ATPCurrentBlockMaxSpeedLimitMpS);
                ATPNextSpeedMpS = Math.Min(Math.Min(MpS.FromKpH(codes.Item2), ATPNextBlockMaxSpeedLimitMpS), ATPCurrentSpeedMpS);
                
                if (prevATPSpeedMpS > ATPNextSpeedMpS && SpeedMpS() > ATPNextSpeedMpS - MpS.FromKpH(2) && ModoConduccionActual < ModoConduccion.ATO)
                {
                    SetATPOverspeedAlarm(true);
                }
                ATPTargetDistanceM = 0;
            }
            else if (ATPCodigoVia == CodigoATP.ATPDO)
            {
                if (SignalPassedFeatures != null)
                {
                    int prevahead = GetATPDOAhead(SignalPassedFeatures.Value.TextAspect);
                    if (prevahead <= 0) ATPCurrentSpeedMpS = 0;
                }
                int ahead = GetATPDOAhead(txt);
                if (ATPCurrentSpeedMpS == 0) ahead = -2;
                if (ahead <= -2)
                {
                    ATPCurrentSpeedMpS = ATPNextSpeedMpS = 0;
                }
                else
                {
                    if (ahead < 0) ATPTargetDistanceM = NextSignalDistanceM(0) - 50;
                    else ATPTargetDistanceM = NextSignalDistanceM(ahead) - 5;
                    ATPNextSpeedMpS = 0;
                    ATPCurrentSpeedMpS = Math.Min(MpS.FromKpH(110), CurrentPostSpeedMpS);
                    ATPCurrentSpeedMpS = Math.Min(ATPCurrentSpeedMpS, Math.Max(SpeedCurve(ATPTargetDistanceM, ATPNextSpeedMpS, 0, 0, 0.75f), ATPNextSpeedMpS));
                    float max = ATPTargetDistanceM;
                    for (int i=0; i<10; i++)
                    {
                        float dist = NextPostDistanceM(i);
                        float spd = NextPostSpeedLimitMpS(i);
                        if (dist > max || dist < 0) break;
                        if (spd > ATPCurrentSpeedMpS) continue;
                        float curv = Math.Max(SpeedCurve(dist, spd, 0, 0, 0.75f), spd);
                        if (curv < ATPCurrentSpeedMpS)
                        {
                            ATPCurrentSpeedMpS = curv;
                            ATPNextSpeedMpS = spd;
                            ATPTargetDistanceM = dist;
                        }
                    }
                }
            }
            else if (ATPCodigoVia == CodigoATP.ATP1P)
            {
                if (SignalPassedFeatures != null)
                {
                    int prevcode = GetATP1PCode(SignalPassedFeatures.Value.TextAspect);
                    if (prevcode == 0) ATPCurrentSpeedMpS = 0;
                }
                int code = GetATP1PCode(txt);
                if (ATPCurrentSpeedMpS == 0) code = 0;
                
                if (SignalPassedFeatures != null) ATPCurrentBlockMaxSpeedLimitMpS = ATPNextBlockMaxSpeedLimitMpS;
                if (ATPCurrentBlockMaxSpeedLimitMpS == 0) ATPCurrentBlockMaxSpeedLimitMpS = GetATPBlockMaxSpeedMpS(0, NextSignalDistanceM(0));
                ATPNextBlockMaxSpeedLimitMpS = GetATPBlockMaxSpeedMpS(NextSignalDistanceM(0), NextSignalDistanceM(1));
                
                ATPCurrentSpeedMpS = ATPNextSpeedMpS = Math.Min(ATPCurrentBlockMaxSpeedLimitMpS, code);
                ATPTargetDistanceM = 0;
            }
            else
            {
                ATPCurrentSpeedMpS = ATPNextSpeedMpS = 0;
                ATPTargetDistanceM = 0;
            }
            if (prevSpeedMpS <= ATPNextSpeedMpS - MpS.FromKpH(2) && SpeedMpS() > ATPNextSpeedMpS - MpS.FromKpH(2) && ModoConduccionActual < ModoConduccion.ATO) SetATPOverspeedAlarm(true);
            prevSpeedMpS = SpeedMpS();
            if (SpeedMpS() <= ATPNextSpeedMpS - MpS.FromKpH(3)) SetATPOverspeedAlarm(false);
            if (SpeedMpS() > ATPCurrentSpeedMpS || ATPCurrentSpeedMpS == 0) RequestMode(ModoConduccion.Inactivo);
            if (ATPAutoBrake && ModoConduccionActual == ModoConduccion.M_ATP)
            {
                if (SpeedMpS() > ATPNextSpeedMpS - MpS.FromKpH(2.8f)) ATPTCO = true;
                else if (SpeedMpS() <= ATPNextSpeedMpS - MpS.FromKpH(3))ATPTCO = false;
                if (SpeedMpS() > ATPNextSpeedMpS - MpS.FromKpH(1.5f)) ATPServiceBrake = true;
                else if (SpeedMpS() < ATPNextSpeedMpS - MpS.FromKpH(2.5f)) ATPServiceBrake = false;
            }
            
            if (ATPCodigoVia == CodigoATP.ATP2P)
            {
                if (ATPNextSpeedMpS < MpS.FromKpH(19)) SetCabDisplayControl(ControlVelocidadATP, 1);
                else if (ATPNextSpeedMpS < MpS.FromKpH(33)) SetCabDisplayControl(ControlVelocidadATP, 2);
                else if (ATPNextSpeedMpS < MpS.FromKpH(56)) SetCabDisplayControl(ControlVelocidadATP, 3);
                else if (ATPNextSpeedMpS < MpS.FromKpH(69)) SetCabDisplayControl(ControlVelocidadATP, 4);
                else if (ATPNextSpeedMpS < MpS.FromKpH(79)) SetCabDisplayControl(ControlVelocidadATP, 5);
                else SetCabDisplayControl(ControlVelocidadATP, 6);
            }
            else
            {
                if (ATPCurrentSpeedMpS < MpS.FromKpH(19)) SetCabDisplayControl(ControlVelocidadATP, 1);
                else if (ATPCurrentSpeedMpS < MpS.FromKpH(33)) SetCabDisplayControl(ControlVelocidadATP, 2);
                else if (ATPCurrentSpeedMpS < MpS.FromKpH(56)) SetCabDisplayControl(ControlVelocidadATP, 3);
                else if (ATPCurrentSpeedMpS < MpS.FromKpH(69)) SetCabDisplayControl(ControlVelocidadATP, 4);
                else if (ATPCurrentSpeedMpS < MpS.FromKpH(79)) SetCabDisplayControl(ControlVelocidadATP, 5);
                else SetCabDisplayControl(ControlVelocidadATP, 6);
            }
            SetCabDisplayControl(ControlCodigosATP, ATPCodigoVia > CodigoATP.ATP1P ? 1 : 0);
            SetCurrentSpeedLimitMpS(ATPCurrentSpeedMpS);
            float time = GameTime();
            float elapsed = Math.Max(time - ATPLastDisplaySpeedChange, 0);
            ATPLastDisplaySpeedChange = time;
            if (ATPLastDisplayedSpeed > ATPNextSpeedMpS)
            {
                ATPLastDisplayedSpeed = Math.Max(ATPLastDisplayedSpeed - elapsed * MpS.FromKpH(20), ATPNextSpeedMpS);
            }
            else if (ATPLastDisplayedSpeed < ATPNextSpeedMpS)
            {
                ATPLastDisplayedSpeed = Math.Min(ATPLastDisplayedSpeed + elapsed * MpS.FromKpH(20), ATPNextSpeedMpS);
            }
            SetNextSpeedLimitMpS(ATPLastDisplayedSpeed);
        }
        bool ATPOverspeedAlarm;
        void SetATPOverspeedAlarm(bool alarm)
        {
            if (ATPOverspeedAlarm != alarm)
            {
                ATPOverspeedAlarm = alarm;
                SetCabDisplayControl(ControlExcesoVelocidadATP, ATPOverspeedAlarm ? 1 : 0);
                if (ATPOverspeedAlarm) TriggerSoundAlert1();
                else
                {
                    TriggerSoundAlert2();
                }
            }
        }
        public void UpdateATO()
        {
            float spd = ATPCurrentSpeedMpS;
            float targdist = ATPTargetDistanceM > 0 ? ATPTargetDistanceM : NextSignalDistanceM(0)-5;
            float targspd = ATPNextSpeedMpS;
            spd = Math.Min(spd, Math.Max(SpeedCurve(targdist, targspd, 0, 0, 0.75f), targspd));
            float stationDistM = ATOStationMissed ? -500 : NextPlatformDistanceM();
            if (ATOPrevStationDistanceM < 100 && stationDistM > ATOPrevStationDistanceM + 10)
            {
                if (!ATOIgnoreStation) ATOStationMissed = true;
                ATOIgnoreStation = false;
            }
            ATOPrevStationDistanceM = stationDistM;
            if (!ATOIgnoreStation)
            {
                float spd2 = Math.Max(SpeedCurve(stationDistM, 0, 0, 0, 0.75f), 0);
                if (spd2 <= spd)
                {
                    targdist = stationDistM;
                    targspd = 0;
                    spd = spd2;
                }
            }
            /*spd = Math.Min(spd, CurrentPostSpeedLimitMpS());
            for (int i=0; i<10; i++)
            {
                float postdist = NextPostDistanceM(i);
                float postspd = NextPostSpeedLimitMpS(i);
                if (postdist > targdist || postdist < 0) break;
                if (postspd > spd) continue;
                float curv = Math.Max(SpeedCurve(postdist, postspd, 0, 0, 0.75f), postspd);
                if (curv < spd)
                {
                    spd = curv;
                    targspd = postspd;
                    targdist = postdist;
                }
            }*/
            if (((targdist < 15 && SpeedMpS() < 1) || targdist < 10) && targspd < 1) spd = 0;
            if (spd <= 0)
            {
                if (stationDistM < 15)
                {
                    ATOIgnoreStation = true;
                    ATOStationMissed = false;
                }
                ATOStopped = true;
            }
            if (ATOArranque1 && ATOArranque2 && ATOStopped && spd > 0 && SpeedMpS() > MpS.FromKpH(3)) ATOStopped = false;
            if (ATOStopped && (!ATOArranque1 || !ATOArranque2)) spd = 0;
            spd = Math.Max(spd - MpS.FromKpH(1), 0);
            bool coast = true;
            float coastSpeed = spd;
            if (coast) coastSpeed = Math.Min(Math.Max(SpeedCurve(spd, targspd, 0, 0, 0.4f), Math.Max(targspd, spd-MpS.FromKpH(20))), spd);
            if (coastSpeed > SpeedMpS()) spd = coastSpeed;
            float val = ATF(spd);
            if (val > 0 && coastSpeed < SpeedMpS()) val = 0;
            if (val < -0.85f || (val < -0.6f && targspd < 1 && spd < MpS.FromKpH(20) && DistanceCurve(SpeedMpS(), targspd, 0, 1.0f, 1.0f) > targdist) || spd == 0)
            {
                SetThrottleController(0);
                SetDynamicBrakeController(1);
                ATOServiceBrake = true;
            }
            else if (val >= 0)
            {
                SetThrottleController(val);
                SetDynamicBrakeController(0);
                ATOServiceBrake = false;
            }
            else
            {
                SetThrottleController(0);
                SetDynamicBrakeController(-val);
                ATOServiceBrake = false;
            }
        }
        float PrevValue;
        double LastTime=0;
        double LastError=0;
        double i_error=0;
        double p_coef = 2;
        double i_coef = 0.001;
        double d_coef = 0.4;
        protected float ATF(double limit)
        {
            double error = limit-SpeedMpS();
            double dt = ClockTime()-LastTime;
            if (dt < 0.0001f) return PrevValue;
            if(Math.Abs(error)<1)
            {
                i_error += (error+LastError)*dt/2;
            }
            else i_error = 0;
            double d_error = (error-LastError)/dt;
            double p_out = p_coef*error;
            double i_out = i_coef*i_error;
            double d_out = d_coef*d_error;
            double diff = d_out+p_out+i_out;
            LastTime = ClockTime();
            LastError = error;
            float value = Math.Max(Math.Min((float)diff,1),-1);
            PrevValue = value;
            return value;
        }
        bool prevTCO=false;
        void UpdateLazoTraccion(bool tcsTCO)
        {
            bool tco = false;
            tco |= tcsTCO;
            tco |= CurrentDoorState(DoorSide.Both) != DoorState.Closed/* && !byPassPuertas*/;
            tco |= TrainBrakeControllerState() != ControllerState.Release;
            //if (!tco && prevTCO && ThrottlePercent() > 0) tco = true;
            prevTCO = tco;
            tco |= IsBrakeFullService() || IsBrakeEmergency() || (DoesBrakeCutPower() && BrakeCutsPowerAtBrakeCylinderPressureBar() < LocomotiveBrakeCylinderPressureBar());
            SetTractionAuthorization(!tco);
        }
        /*bool MegafoniaStopChecking;
        float MegafoniaPrevStationDistanceM;
        int? MegafoniaRequestedIndex;
        int MegafoniaCurrentIndex;
        int MegafoniaMaxIndex = 4;
        bool MegafoniaRelease;
        int MegafoniaSkip = 0;
        public void UpdateMegafonia()
        {
            float dist = NextPlatformDistanceM();
            if (MegafoniaPrevStationDistanceM > 500 && dist < 500 && !MegafoniaStopChecking)
            {
                MegafoniaRequestedIndex = MegafoniaCurrentIndex;
                if (MegafoniaRequestedIndex < 0) MegafoniaRequestedIndex = MegafoniaMaxIndex - 1;
                if (MegafoniaRequestedIndex >= MegafoniaMaxIndex) MegafoniaRequestedIndex = 0;
                MegafoniaStopChecking = true;
                Console.WriteLine("Iniciar megafonia "+MegafoniaRequestedIndex.Value);
            }
            if (CurrentDoorState(DoorSide.Both) != DoorState.Closed) MegafoniaStopChecking = false;
            MegafoniaPrevStationDistanceM = dist;
            
            if (MegafoniaSkip++ < 10) return;
            MegafoniaSkip = 0;
            if (MegafoniaRequestedIndex != null)
            {
                if (MegafoniaRelease)
                {
                    if (MegafoniaCurrentIndex == MegafoniaRequestedIndex)
                    {
                        MegafoniaRequestedIndex = null;
                        TriggerSoundInfo1();
                    }
                    else TriggerSoundInfo2();
                    ++MegafoniaCurrentIndex;
                    MegafoniaRelease = false;
                }
                else
                {
                    TriggerSoundWarning1();
                    MegafoniaRelease = true;
                }
                Console.WriteLine("Megafonia: "+MegafoniaCurrentIndex);
                if (MegafoniaCurrentIndex == MegafoniaMaxIndex) MegafoniaCurrentIndex = 0;
            }
        }*/
        SignalFeatures? SignalPassedFeatures;
        SignalFeatures? PrevSignalFeatures;
        public void UpdateSignalPassed()
        {
            var feat = NextGenericSignalFeatures("NORMAL", 0, 30);
            if (PrevSignalFeatures != null && feat.DistanceM > PrevSignalFeatures.Value.DistanceM + 10 && PrevSignalFeatures.Value.DistanceM < 20)
            {
                SignalPassedFeatures = PrevSignalFeatures;
            }
            else
            {
                SignalPassedFeatures = null;
            }
            PrevSignalFeatures = feat;
        }
        float CurrentPostSpeedMpS;
        float PrevPostSpeedMpS;
        float PrevPostDistanceM;
        public void UpdatePostPassed()
        {
            if (CurrentPostSpeedMpS == 0) CurrentPostSpeedMpS = CurrentPostSpeedLimitMpS();
            if (NextPostDistanceM(0) > PrevPostDistanceM + 10 && PrevPostDistanceM < 20)
            {
                CurrentPostSpeedMpS = PrevPostSpeedMpS;
            }
            PrevPostSpeedMpS = NextPostSpeedLimitMpS(0);
            PrevPostDistanceM = NextPostDistanceM(0);
        }
        public override void HandleEvent(TCSEvent evt, string message) 
        {
            switch (evt)
            {
                case TCSEvent.GenericTCSButtonPressed:
                case TCSEvent.GenericTCSButtonReleased:
                {
                    int num = int.Parse(message);
                    bool pressed = evt == TCSEvent.GenericTCSButtonPressed;
                    if (pressed)
                    {
                        if (num == ControlExcesoVelocidadATP)
                        {
                            SetATPOverspeedAlarm(false);
                        }
                        else if (num == ControlM_20) RequestMode(ModoConduccion.M_20);
                        else if (num == ControlATP) RequestMode(ModoConduccion.M_ATP);
                        else if (num == ControlATO) RequestMode(ModoConduccion.ATO);
                    }
                    if (num == ControlLanzarATO) ATOArranque1 = ATOArranque2 = pressed;
                    break;
                }
            }
        }
    }
}
