using ORTS.Common;
using ORTS.Scripting.Api;
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO.Ports;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Linq;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using Orts.Common;
using Event = Orts.Common.Event;
namespace ORTS.Scripting.Script
{
    public class FrenoT250 : BrakeController
    {
        ControllerState CurrentState=ControllerState.Release;
        float SplitPos = 0.3f;
        float Value;
        float DynamicBrakeIntervention;
        public override void Initialize()
        {
        }
        public override void InitializeMoving()
        {
        }
        public override float Update(float elapsedSeconds)
        {
            float prevValue = Value;
            Value = CurrentValue();
            if (IntermediateValue != Value) Value = IntermediateValue;
            if(UpdateValue()==1)
            {
                if(Value > 0.95f)
                {
                    Value = 1;
                    SetUpdateValue(0);
                }
                else
                {
                    float prev = Value;
                    Value += elapsedSeconds/4;
                    if(Value>=0.94f&&prev<0.94f)
                    {
                        Value = 0.94f;
                        SetUpdateValue(0);
                    }
                    if(Value>=0.276f&&prev<0.276f)
                    {
                        Value = 0.276f;
                        SetUpdateValue(0);
                    }
                }
            }
            if(UpdateValue()==-1)
            {
                float prev = Value;
                Value -= elapsedSeconds/4;
                /*if(Value <= 0.01f && prev > 0.01f)
                {
                    Value = 0.01f;
                    SetUpdateValue(0);
                }*/
                if (Value <= 0)
                {
                    Value = 0;
                    SetUpdateValue(0);
                }
            }
            if(Value >= 0.95f) CurrentState = ControllerState.Emergency; 
            else if(Value >= 0.9f) CurrentState = ControllerState.FullServ;
            else if(Value >= 0.01) CurrentState = ControllerState.GSelfLap;
            else CurrentState = ControllerState.Release;
            
            SetValue(Value);
            return CurrentValue();
        }
        void SetValue(float value)
        {
            Value = value;
            SetCurrentValue(Value);
            IntermediateValue = Value;
        }
        
        
        public override void UpdatePressure(ref float pressureBar, float elapsedClockSeconds, ref float epPressureBar)
        {
            float intervention;//GetFloatValue("OrtsTrainBrakeIntervention");
            if (CurrentState == ControllerState.Emergency) intervention = 2;
            else if (TCSFullServiceBraking()) intervention = 1;
            else if (CurrentState == ControllerState.FullServ) intervention = 1;
            else if (CurrentState == ControllerState.Release) intervention = 0;
            else intervention = Math.Min(Math.Max((Value-0.01f)/0.89f, 0), 1);

            // Proportional mode. Only for S102
            /*if (SpeedMpS() < MpS.FromKpH(36)) SplitPos = 0;
            else if (SpeedMpS() > MpS.FromKpH(40)) SplitPos = 0.3f;*/

            if (EmergencyBrakingPushButton())
            {
                DynamicBrakeIntervention = 0;
                SetDynamicBrakeIntervention(DynamicBrakeIntervention);
                epPressureBar = 1;
                DecreasePressure(ref pressureBar, 0, EmergencyRateBarpS(), elapsedClockSeconds);
            }
            else if (TCSEmergencyBraking() || intervention == 2)
            {
                DynamicBrakeIntervention = 1;
                SetDynamicBrakeIntervention(DynamicBrakeIntervention);
                epPressureBar = 1;
                DecreasePressure(ref pressureBar, 0, EmergencyRateBarpS(), elapsedClockSeconds);
                return;
            }
            else
            {
                float releasePressure = Math.Min(MaxPressureBar(), MainReservoirPressureBar());
                float fullServPressure = MaxPressureBar()-FullServReductionBar();
                float targetPressureBar;
                float targetDynamicBrake = SplitPos == 0 ? 0 : Math.Min(intervention/SplitPos, 1);
                float targetAirBrake = Math.Max((intervention-SplitPos)/(1-SplitPos), 0);
                if (CruiseControlBrakeDemand() > 0)
                {
                    float target = Math.Max((FullServReductionBar() * CruiseControlBrakeDemand() - MinReductionBar()) / (FullServReductionBar() - MinReductionBar()), 0.001f);
                    if (target > targetAirBrake)
                    {
                        targetAirBrake = target;
                        targetDynamicBrake = 0;
                    }

                }
                if (targetAirBrake > 0) targetAirBrake = MinReductionBar() / FullServReductionBar() * (1 - targetAirBrake) + targetAirBrake;
                epPressureBar = targetAirBrake;
                targetPressureBar = releasePressure - targetAirBrake * FullServReductionBar();

                /*if (SpeedMpS() < MpS.FromKpH(15)) DynamicBrakeIntervention = Math.Max(Math.Min(DynamicBrakeIntervention - elapsedClockSeconds * 0.33f, targetDynamicBrake), 0);
                else if (SpeedMpS() > MpS.FromKpH(20) || targetDynamicBrake < DynamicBrakeIntervention) DynamicBrakeIntervention = targetDynamicBrake;*/
                DynamicBrakeIntervention = targetDynamicBrake;
                SetDynamicBrakeIntervention(DynamicBrakeIntervention);
                IncreasePressure(ref pressureBar, Math.Min(targetPressureBar, releasePressure), ReleaseRateBarpS(), elapsedClockSeconds);
                DecreasePressure(ref pressureBar, Math.Max(fullServPressure, targetPressureBar), ApplyRateBarpS(), elapsedClockSeconds);
            }
        }
        public override void UpdateEngineBrakePressure(ref float pressureBar, float elapsedClockSeconds)
        {
        }
        public override void HandleEvent(BrakeControllerEvent evt)
        {
            switch (evt)
            {
                case BrakeControllerEvent.StartIncrease:
                    if (Value < 1)
                        SetUpdateValue(1);
                    break;
                case BrakeControllerEvent.StartDecrease:
                    if (Value > 0)
                        SetUpdateValue(-1);
                    break;
                case BrakeControllerEvent.StopIncrease:
                case BrakeControllerEvent.StopDecrease:
                    SetUpdateValue(0);
                    break;
            }
        }
        public override void HandleEvent(BrakeControllerEvent evt, float? value)
        {
            if(evt == BrakeControllerEvent.SetCurrentPercent) Value = value.Value/100;
            if(evt == BrakeControllerEvent.SetCurrentValue) Value = value.Value;
            else HandleEvent(evt);
            SetValue(Value);
        }
        public override bool IsValid()
        {
            return true;
        }
        public override ControllerState GetState()
        {
            if(EmergencyBrakingPushButton()) return ControllerState.EBPB;
            if(TCSEmergencyBraking()) return ControllerState.TCSEmergency;
            if(CurrentState == ControllerState.Emergency) return ControllerState.Emergency;
            if(TCSFullServiceBraking()) return ControllerState.TCSFullServ;
            return CurrentState;
        }
        public override float? GetStateFraction()
        {
            float applyValue = 0;
            if (Value >= 0.01) applyValue = Math.Min(Math.Max((Value-0.01f)/0.89f, 0), 1);
            if(GetState()==ControllerState.GSelfLap) return applyValue;
            return null;
        }
        static void IncreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI < targetPSI)
            {
                pressurePSI += ratePSIpS * elapsedSeconds;
                if (pressurePSI > targetPSI)
                    pressurePSI = targetPSI;
            }
        }

        static void DecreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI > targetPSI)
            {
                pressurePSI -= ratePSIpS * elapsedSeconds;
                if (pressurePSI < targetPSI)
                    pressurePSI = targetPSI;
            }
        }
    }
}
