using ORTS.Common;
using ORTS.Scripting.Api;
using System;
using System.Collections.Generic;
using Orts.Common;
using Event = Orts.Common.Event;
using Orts.Simulation.RollingStocks.SubSystems.Controllers;
using System.Reflection;
namespace ORTS.Scripting.Script
{
    public class FrenoCivia : BrakeController
    {
        MSTSNotchController NotchController;
        ControllerState EQState = ControllerState.Release;
        bool AuxiliaryBrake = false;
        bool FrenoResidual = false;
        public override void Initialize()
        {
            var constructor = typeof(MSTSNotchController).GetConstructor(new[] { typeof(List<MSTSNotch>) });
            NotchController = (MSTSNotchController)constructor.Invoke(new[] {Notches() });
            NotchController.SetValue(CurrentValue());
            NotchController.IntermediateValue = CurrentValue();
            NotchController.MinimumValue = MinimumValue();
            NotchController.MaximumValue = MaximumValue();
            NotchController.StepSize = StepSize();
        }
        public override void InitializeMoving()
        {
            NotchController.SetValue(0);
            if (NotchController.NotchCount() > 0) NotchController.CurrentNotch = 0;
            else NotchController.CurrentNotch = -1;
            CurrentNotch = NotchController.CurrentNotch;
        }
        public override float Update(float elapsedSeconds)
        {
            /*Value = CurrentValue();
            if (IntermediateValue != Value) Value = IntermediateValue;
            if(UpdateValue()==1)
            {
                if(Value>0.9)
                {
                    Value = 1;
                    SetUpdateValue(0);
                }
                else
                {
                    Value += elapsedSeconds/3;
                    if (Value < 0.02f)
                    {
                        Value = 0.02f;
                    }
                    if(Value>=0.9&&CurrentValue()<0.9)
                    {
                        Value = 0.93f;
                        SetUpdateValue(0);
                    }
                }
            }
            else if(UpdateValue()==-1)
            {
                Value -= elapsedSeconds/3;
                if(Value<=0.02f&&CurrentValue()>0.02f)
                {
                    Value = 0.02f;
                    SetUpdateValue(0);
                }
                else if (Value <= 0.02f)
                {
                    Value = 0;
                    SetUpdateValue(0);
                }
            }
            else if (Value < 0.02f) Value = 0;
            if(Value > 0.95f) CurrentState = ControllerState.Emergency; 
            else if(Value > 0.90f) CurrentState = ControllerState.FullServ;
            else if(Value>0.01) CurrentState = ControllerState.GSelfLap;
            else CurrentState = ControllerState.Release;*/
            
            if (SpeedMpS() > MpS.FromKpH(3)/*|| traccion > 0.1f*/) FrenoResidual = false;
            
            /*if (Value != CurrentValue()) SetValue(Value);
            return CurrentValue();*/

            float value = NotchController.Update(elapsedSeconds);
            if (value == 0 && CurrentValue() > 0)
            {
                SetDynamicBrakeIntervention(0);
                if (SpeedMpS() < MpS.FromKpH(3)) FrenoResidual = true;
            }
            SetCurrentValue(value);
            IntermediateValue = NotchController.IntermediateValue;
            SetUpdateValue(NotchController.UpdateValue);
            CurrentNotch = NotchController.CurrentNotch;
            return value;
        }
        
        int bogies=6;
        int bogies_traccion=4;
        int bogies_freno=6;
        float MaxDynamicBrakeForce(float speed)
        {
            speed = MpS.ToKpH(speed);
            float force = 0;
            if (bogies == 6)
            {
                if (speed < 5) force = 210*speed/5;
                else if (speed<35) force = 210;
                else if (speed<65) force = 210-80*(speed-35)/30;
                else if (speed<130) force = 130-60*(speed-65)/65;
                force /= 210;
            }
            else
            {
                if (speed < 5) force = 110*speed/5;
                else if (speed<45) force = 110;
                else if (speed<80) force = 110-30*(speed-45)/35;
                else if (speed<130) force = 70-25*(speed-80)/40;
                force /= 110;
            }
            return force*bogies_traccion/(bogies-2)*1.1f;
        }
        float MaxAirBrakeForce(float speed)
        {
            return 1.1f*3.8f/2.9f;
        }
        float DecelToAirBrake(float force, float speed)
        {
            float maxdyn = MaxDynamicBrakeForce(speed);
            float maxair = MaxAirBrakeForce(speed);
            float cer = force / (maxair * 0.25f);
            if (cer > maxdyn / (maxair * 0.75f))
            {
                return (force - maxdyn * 0.25f / 0.75f)/(maxair-maxdyn) + maxdyn / (maxair * 0.75f);
            }
            else
            {
                return cer;
            }
        }
        
        public override void UpdatePressure(ref float pressureBar, float elapsedClockSeconds, ref float epPressureBar)
        {
            float intervention;
            MSTSNotch notch = NotchController.GetCurrentNotch();
            float x = NotchController.GetNotchFraction();
            switch (notch.Type)
            {
                case ControllerState.Release:
                    intervention = 0;
                    break;
                case ControllerState.Emergency:
                    intervention = 2;
                    break;
                default:
                    intervention = (x+0.25f)/1.25f;
                    break;
            }
            
            if (EmergencyBrakingPushButton() || TCSEmergencyBraking() || intervention == 2)
            {
                SetDynamicBrakeIntervention(0);
                epPressureBar = 1;
            }
            else
            {
                if (AuxiliaryBrake)
                {
                    SetDynamicBrakeIntervention(intervention > 0 ? intervention : 0);
                    epPressureBar = -1;
                }
                else
                {
                    if (TCSFullServiceBraking()) intervention = 1;
                    float speed = SpeedMpS();
                    float maxDynForce = MaxDynamicBrakeForce(speed);
                    float targetForce = intervention*1.1f;
                    float targetDynForce = Math.Min(targetForce, maxDynForce);
                    float targetAirForce = targetForce-targetDynForce;
                    if (intervention > 0 && maxDynForce > 0 && targetDynForce > 0) SetDynamicBrakeIntervention(targetDynForce/maxDynForce);
                    else SetDynamicBrakeIntervention(0);
                    if (targetAirForce <= 0) epPressureBar = 0;
                    else epPressureBar = DecelToAirBrake(targetAirForce, speed);
                    
                    if (epPressureBar < 0.055f && FrenoResidual) epPressureBar = 0.055f;
                }
            }
            
            if (AuxiliaryBrake)
            {
                int auxval = 0;
                switch (auxval)
                {
                    case -1:
                        EQState = ControllerState.Release;
                        break;
                    case 0:
                        EQState = ControllerState.Neutral;
                        break;
                    case 1:
                        EQState = ControllerState.Apply;
                        break;
                }
                if (EmergencyBrakingPushButton()) EQState = ControllerState.Emergency;

                float releasePressure = Math.Min(5, MainReservoirPressureBar());
                float fullServPressure = MaxPressureBar()-FullServReductionBar();
                switch(EQState)
                {
                    case ControllerState.Release:
                        IncreasePressure(ref pressureBar, releasePressure, ReleaseRateBarpS(), elapsedClockSeconds);
                        break;
                    case ControllerState.Apply:
                        DecreasePressure(ref pressureBar, fullServPressure, ApplyRateBarpS(), elapsedClockSeconds);
                        break;
                    case ControllerState.Emergency:
                        DecreasePressure(ref pressureBar, 0, EmergencyRateBarpS(), elapsedClockSeconds);
                        break;
                }
            }
            else
            {
                EQState = ControllerState.Neutral;
                pressureBar = 5;//0;
            }
        }
        public override void UpdateEngineBrakePressure(ref float pressureBar, float elapsedClockSeconds)
        {
            
        }
        public override void HandleEvent(BrakeControllerEvent evt)
        {
            switch (evt)
            {
                case BrakeControllerEvent.StartIncrease:
                    NotchController.StartIncrease();
                    break;

                case BrakeControllerEvent.StopIncrease:
                    NotchController.StopIncrease();
                    break;

                case BrakeControllerEvent.StartDecrease:
                    NotchController.StartDecrease();
                    break;

                case BrakeControllerEvent.StopDecrease:
                    NotchController.StopDecrease();
                    break;
            }
        }

        public override void HandleEvent(BrakeControllerEvent evt, float? value)
        {
            switch (evt)
            {
                case BrakeControllerEvent.StartIncrease:
                    NotchController.StartIncrease(value);
                    break;

                case BrakeControllerEvent.StartDecrease:
                    NotchController.StartDecrease(value);
                    break;

                case BrakeControllerEvent.SetCurrentPercent:
                    if (value != null)
                    {
                        float newValue = value ?? 0;
                        NotchController.SetPercent(newValue);
                    }
                    break;

                case BrakeControllerEvent.SetCurrentValue:
                    if (value != null)
                    {
                        float newValue = value ?? 0;
                        NotchController.SetValue(newValue);
                    }
                    break;

                case BrakeControllerEvent.StartDecreaseToZero:
                    NotchController.StartDecrease(value, true);
                    break;
            }
        }

        public override bool IsValid()
        {
            return NotchController.IsValid();
        }
        public override ControllerState GetState()
        {
            if (EmergencyBrakingPushButton())
                return ControllerState.EBPB;
            else if (TCSEmergencyBraking())
                return ControllerState.TCSEmergency;
            else if (TCSFullServiceBraking())
                return ControllerState.TCSFullServ;
            else if (AuxiliaryBrake)
                return EQState;
            else if (NotchController != null && NotchController.NotchCount() > 0)
                return NotchController.GetCurrentNotch().Type;
            else
                return ControllerState.Dummy;
        }
        public override float? GetStateFraction()
        {
            if (EmergencyBrakingPushButton() || TCSEmergencyBraking() || TCSFullServiceBraking() || QuickReleaseButtonPressed() || OverchargeButtonPressed() || AuxiliaryBrake)
            {
                return null;
            }
            else if (NotchController != null)
            {
                if (NotchController.NotchCount() == 0)
                    return NotchController.CurrentValue;
                else
                {
                    MSTSNotch notch = NotchController.GetCurrentNotch();

                    if (!notch.Smooth)
                    {
                        if (notch.Type == ControllerState.Dummy)
                            return NotchController.CurrentValue;
                        else
                            return null;
                    }
                    else
                    {
                        return NotchController.GetNotchFraction();
                    }
                }
            }
            else
            {
                return null;
            }
        }
        static void IncreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI < targetPSI)
            {
                pressurePSI += ratePSIpS * elapsedSeconds;
                if (pressurePSI > targetPSI)
                    pressurePSI = targetPSI;
            }
        }

        static void DecreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI > targetPSI)
            {
                pressurePSI -= ratePSIpS * elapsedSeconds;
                if (pressurePSI < targetPSI)
                    pressurePSI = targetPSI;
            }
        }
    }
}
