using ORTS.Common;
using ORTS.Scripting.Api;
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO.Ports;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Linq;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using Orts.Common;
using Event = Orts.Common.Event;
namespace ORTS.Scripting.Script
{
    public class Freno103 : BrakeController
    {
        ControllerState CurrentState=ControllerState.Release;
        public override void Initialize()
        {
        }
        public override void InitializeMoving()
        {
        }
        public override float Update(float elapsedSeconds)
        {
            Value = CurrentValue();
            if (IntermediateValue != Value) Value = IntermediateValue;
            if(UpdateValue()==1)
            {
                if(Value>0.9)
                {
                    Value = 1;
                    SetUpdateValue(0);
                }
                else
                {
                    Value += elapsedSeconds/3;
                    if (Value < 0.25f)
                    {
                        Value = 0.25f;
                    }
                    if(Value>=0.9&&CurrentValue()<0.9)
                    {
                        Value = 0.93f;
                        SetUpdateValue(0);
                    }
                }
            }
            else if(UpdateValue()==-1)
            {
                Value -= elapsedSeconds/3;
                if(Value<=0.25f&&CurrentValue()>0.25f)
                {
                    Value = 0.25f;
                    SetUpdateValue(0);
                }
                else if (Value <= 0.25f)
                {
                    Value = 0;
                    SetUpdateValue(0);
                }
            }
            else if (Value < 0.25f) Value = 0;
            if(Value > 0.95f) CurrentState = ControllerState.Emergency; 
            else if(Value > 0.90f) CurrentState = ControllerState.FullServ;
            else if(Value>0.01) CurrentState = ControllerState.GSelfLap;
            else CurrentState = ControllerState.Release;
            
            if (SpeedMpS() > MpS.FromKpH(3)/*|| traccion > 0.1f*/) FrenoResidual = false;
            
            if (Value != CurrentValue()) SetValue(Value);
            return CurrentValue();
        }
        void SetValue(float value)
        {
            Value = value;
            if (Value == 0 && CurrentValue() > 0)
            {
                SetDynamicBrakeIntervention(0);
                if (SpeedMpS() < MpS.FromKpH(3)) FrenoResidual = true;
            }
            SetCurrentValue(Value);
            IntermediateValue = Value;
        }
        
        public override void UpdatePressure(ref float pressureBar, float elapsedClockSeconds, ref float epPressureBar)
        {
            float intervention;
            if (Value > 0.95f) intervention = 2;
            else if (Value > 0.9f) intervention = 1;
            else if (Value >= 0.01f) intervention = Math.Min(Math.Max(Value/0.9f, 0), 1);
            else if (CruiseControlBrakeDemand() >= 0.01f) intervention = CruiseControlBrakeDemand();
            else intervention = 0;
            
            if (EmergencyBrakingPushButton() || TCSEmergencyBraking() || intervention == 2)
            {
                SetDynamicBrakeIntervention(0);
                epPressureBar = 1;
            }
            else
            {
                if (AuxiliaryBrake)
                {
                    SetDynamicBrakeIntervention(intervention > 0 ? intervention : 0);
                    epPressureBar = -1;
                }
                else
                {
                    if (TCSFullServiceBraking()) intervention = 1;
                    float speed = SpeedMpS();
                    float maxDynForce = MaxDynamicBrakeForce(speed);
                    float maxAirForce = MaxAirBrakeForce(speed);
                    float targetForce = intervention*1.1f;
                    float targetDynamicForce = Math.Min(targetForce, maxDynForce);
                    float targetAirForce = targetForce-targetDynamicForce;
                    if (intervention>0) SetDynamicBrakeIntervention((maxDynForce==0 || targetDynamicForce == 0) ? 0 : targetDynamicForce/maxDynForce);
                    else SetDynamicBrakeIntervention(0);
                    if (targetAirForce <= 0) epPressureBar = -1;
                    else epPressureBar = targetAirForce/maxAirForce;
                    
                    if (epPressureBar < 0.05f && FrenoResidual) epPressureBar = 0.05f;
                }
            }
            
            float releasePressure = Math.Min(5, MainReservoirPressureBar());
            float fullServPressure = MaxPressureBar()-FullServReductionBar();
            switch(EQState)
            {
                case ControllerState.Release:
                    IncreasePressure(ref pressureBar, releasePressure, ReleaseRateBarpS(), elapsedClockSeconds);
                    break;
                case ControllerState.Apply:
                    DecreasePressure(ref pressureBar, fullServPressure, ApplyRateBarpS(), elapsedClockSeconds);
                    break;
                case ControllerState.Emergency:
                    DecreasePressure(ref pressureBar, 0, EmergencyRateBarpS(), elapsedClockSeconds);
                    break;
            }
        }
        public override void UpdateEngineBrakePressure(ref float pressureBar, float elapsedClockSeconds)
        {
            
        }
        public override void HandleEvent(BrakeControllerEvent evt)
        {
            switch (evt)
            {
                case BrakeControllerEvent.StartIncrease:
                    SetUpdateValue(1);
                    break;
                case BrakeControllerEvent.StartDecrease:
                    SetUpdateValue(-1);
                    break;
                case BrakeControllerEvent.StopIncrease:
                case BrakeControllerEvent.StopDecrease:
                    SetUpdateValue(0);
                    break;
            }
        }
        public override void HandleEvent(BrakeControllerEvent evt, float? value)
        {
            if(evt == BrakeControllerEvent.SetCurrentPercent)
            {
                SetValue(value.Value/100);
            }
            else if(evt == BrakeControllerEvent.SetCurrentValue)
            {
                SetValue(value.Value);
            }
            else HandleEvent(evt);
        }
        public override bool IsValid()
        {
            return true;
        }
        public override ControllerState GetState()
        {
            if(EmergencyBrakingPushButton()) return ControllerState.EBPB;
            if(TCSEmergencyBraking()) return ControllerState.TCSEmergency;
            if(CurrentState == ControllerState.Emergency) return ControllerState.Emergency;
            if(TCSFullServiceBraking()) return ControllerState.TCSFullServ;
            return CurrentState;
        }
        public override float? GetStateFraction()
        {
            float applyValue = 0;
            if (Value >= 0.01) applyValue = Math.Min(Math.Max((Value-0.01f)/0.89f, 0), 1);
            if(GetState()==ControllerState.GSelfLap) return applyValue;
            return null;
        }
        static void IncreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI < targetPSI)
            {
                pressurePSI += ratePSIpS * elapsedSeconds;
                if (pressurePSI > targetPSI)
                    pressurePSI = targetPSI;
            }
        }

        static void DecreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI > targetPSI)
            {
                pressurePSI -= ratePSIpS * elapsedSeconds;
                if (pressurePSI < targetPSI)
                    pressurePSI = targetPSI;
            }
        }
    }
}
