﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using ORTS.Common;
using ORTS.Scripting.Api;
using Orts.Simulation;
using Orts.Common;

namespace ORTS.Scripting.Script
{
    public class Disyuntor_252 : CircuitBreaker
    {
        private Timer ClosingTimer;
        public override void Initialize()
        {
            ClosingTimer = new Timer(this);
            ClosingTimer.Setup(ClosingDelayS());
        }
        public override void Update(float elapsedSeconds)
        {
            if (CurrentState() == CircuitBreakerState.Closing)
            {
                if (!ClosingTimer.Started)
                {
                    ClosingTimer.Start();
                }
                if (ClosingTimer.Triggered)
                {
                    ClosingTimer.Stop();
                    SetCurrentState(CircuitBreakerState.Closed);
                    SignalEvent(Event.CircuitBreakerClosed);
                }
            }
            switch (CurrentState())
            {
                case CircuitBreakerState.Open:
                    if (DriverClosingOrder() && TCSClosingAuthorization() && CurrentPantographState() == PantographState.Up)
                    {
                        SetCurrentState(CircuitBreakerState.Closing);
                        SignalEvent(Event.CircuitBreakerClosing);
                    }
                    break;
                case CircuitBreakerState.Closing:
                case CircuitBreakerState.Closed:
                    if (!TCSClosingAuthorization() || CurrentPantographState() != PantographState.Up || DriverOpeningOrder())
                    {
                        SetCurrentState(CircuitBreakerState.Open);
                        SignalEvent(Event.CircuitBreakerOpen);
                    }
                    break;
            }
        }
        public override void HandleEvent(PowerSupplyEvent evt)
        {
            switch (evt)
            {
                case PowerSupplyEvent.CloseCircuitBreakerButtonPressed:
                    SetDriverClosingOrder(true);
                    break;
                case PowerSupplyEvent.CloseCircuitBreakerButtonReleased:
                    SetDriverClosingOrder(false);
                    break;
                case PowerSupplyEvent.OpenCircuitBreakerButtonPressed:
                    SetDriverOpeningOrder(true);
                    break;
                case PowerSupplyEvent.OpenCircuitBreakerButtonReleased:
                    SetDriverOpeningOrder(false);
                    break;
            }
        }
    }
}
