using ORTS.Common;
using ORTS.Scripting.Api;
using System;
using System.Collections.Generic;
using System.Text;
using Orts.Common;
using Event = Orts.Common.Event;
namespace ORTS.Scripting.Script
{
    public class COSMOS_civia : ControllerScript
    {
        enum ModoConduccion
        {
            Manual,
            VelPrefijada,
            Taller,
            Acople
        }
        public override void Initialize()
        {
        }
        float prevRegulador = 0;
        public override void Update(float elapsedClockSeconds)
        {
            if (GetIntVariable("OrtsDirection") == 0)
            {
                SetFloatVariable("OrtsThrottleController", 0);
                SetFloatVariable("OrtsTrainBrakeController", 0);
            }
            
            HiloLazo();
            UpdateTraccionFreno(elapsedClockSeconds);
        }
        void UpdateTraccionFreno(float elapsedClockSeconds)
        {
            ModoConduccion modo = (ModoConduccion)GetIntVariable("ModoConduccion");
            float regulador = GetFloatVariable("OrtsThrottle");
            if (regulador == 0) regulador = -GetFloatVariable("OrtsTrainBrake");
            float speed = GetFloatVariable("OrtsSpeedMpS");
            
            if (regulador > 0)
            {
                float traccion;
                if (modo == ModoConduccion.Manual)
                {
                    traccion = regulador;
                    SetFloatVariable("SPEED_PROJECTED", 0);
                }
                else
                {
                    float max = MpS.FromKpH(120);
                    float min = MpS.FromKpH(6);
                    if (modo == ModoConduccion.Taller)
                    {
                        max = MpS.FromKpH(20);
                        min = MpS.FromKpH(1);
                    }
                    else if (modo == ModoConduccion.Acople)
                    {
                        max = MpS.FromKpH(2.2f);
                        min = MpS.FromKpH(0.2f);
                    }
                    float velocidad = min + regulador * (max-min);
                    SetFloatVariable("SPEED_PROJECTED", velocidad);
                    traccion = ATF(velocidad);
                }
                if (speed > MpS.FromKpH(3) || traccion > 0.1f) FrenoResidual = false;
                if (GetBoolVariable("AceleracionReducida") && traccion > 0) traccion *= 0.5f;
                DemandaTCU = traccion;
                GestionarFrenoBCU(-1);
            }
            else
            {
                SetFloatVariable("SPEED_PROJECTED", 0);
                DemandaTCU = 0;
                GestionarFrenoBCU(regulador == -1 ? 2 : Math.Max(Math.Min(-regulador/0.9f, 1), 0));
            }
            if (regulador == 0 && prevRegulador < 0 && speed < MpS.FromKpH(3))
            {
                FrenoResidual = true;
            }
            prevRegulador = regulador;
            GestionarTraccionTCU();
            
            string disp_modocond = "";
            if (GetBoolVariable("AceleracionReducida")) disp_modocond = "------";
            else if (modo == ModoConduccion.Manual) disp_modocond = "MANUAL";
            else if (modo == ModoConduccion.VelPrefijada) disp_modocond = "VEL. PREFIJADA";
            else if (modo == ModoConduccion.Acople) disp_modocond = "ACOPLE";
            else if (modo == ModoConduccion.Taller) disp_modocond = "TALLER";
            SetStringVariable("ModoConduccion_display", disp_modocond);
        }
        void HiloLazo()
        {
            LazoFreno();
        }
        void LazoFreno()
        {
            bool urgencia = false;
            if (GetFloatVariable("OrtsBrakeLinePressureBar", 1) < 6) urgencia = true;
            SetBoolVariable("LazoFreno", urgencia);
        }
        float standstill_end;
        float DemandaTCU;
        void GestionarTraccionTCU()
        {
            float traccion = DemandaTCU;
            bool traccion_autorizada = GetBoolVariable("BypassLazoTraccion") || (GetBoolVariable("OrtsTractionAuthorization") ||
                ((!GetBoolVariable("OrtsDoors", 0) && !GetBoolVariable("OrtsDoors", 1)) || GetBoolVariable("BypassPuertas"));
            if (traccion <= 0 && speed < 0.1f) standstill_end = GetFloatVariable("OrtsClockTimeS");
            if (traccion >= 0 && traccion_autorizada && standstill_end + 3 < GetFloatVariable("OrtsClockTimeS") &&
                (!ControlTFA || GetFloatVariable("OrtsBrakeLinePressureBar", 2) > 4.7f)))
                SetFloatVariable("OrtsThrottleIntervention", traccion);
            else
                SetFloatVariable("OrtsThrottleIntervention", -1);
            SetFloatVariable("OrtsDynamicBrakeIntervention", traccion < 0 ? -traccion : -1);
        }
        int bogies=6;
        int bogies_traccion=4;
        int bogies_freno=6;
        float MaxDynamicBrakeForce(float speed)
        {
            speed = MpS.ToKpH(speed);
            float force = 0;
            if (bogies == 6)
            {
                if (speed < 5) force = 210*speed/5;
                else if (speed<35) force = 210;
                else if (speed<65) force = 210-80*(speed-35)/30;
                else if (speed<130) force = 130-60*(speed-65)/65;
            }
            else
            {
                if (speed < 5) force = 110*speed/5;
                else if (speed<45) force = 110;
                else if (speed<80) force = 110-30*(speed-45)/35;
                else if (speed<130) force = 70-25*(speed-80)/40;
            }
            return force*bogies_traccion/(bogies-2);
        }
        float MaxAirBrakeForce(float speed)
        {
            float force;
            if (bogies == 6) force = 294.25f;
            else force = 184.8f;
            return force*bogies_freno/bogies;
        }
        float RealMass;
        float NominalMass;
        float MaximumServiceBrakeForce()
        {
            float force;
            if (bogies == 6) force = 210;
            else force = 110;
            force = force*RealMass/NominalMass;
        }
        bool FrenoResidual = false;
        void GestionarFrenoBCU(float intervention)
        {
            SetFloatVariable("OrtsTrainBrakeIntervention", intervention);
            
            float epPressureBar = 1;
            bool Urgencia = false;
            
            if (GetBoolVariable("OrtsEmergencyPushButton") || GetBoolVariable("OrtsTCSEmergencyBraking") ||
                (GetBoolValue("LazoFreno") && !GetBoolValue("BypassLazoFreno")) || intervention == 2 || GetIntVariable("OrtsDirection") == 0 ||
                GetBoolVariable("OrtsSpeedMpS") > MpS.FromKpH(132) || (GetBoolVariable("AparatoAlarma") && !GetBoolVariable("AnulacionAlarma")))
            {
                DemandaTCU = 0;
                epPressureBar = 1;
                Urgencia = true;
            }
            else
            {
                if (GetBoolVariable("OrtsTCSFullServiceBraking")) intervention = 1;
                float speed = GetFloatVariable("OrtsSpeedMpS");
                float maxDynForce = MaxDynamicBrakeForce(speed);
                float maxAirForce = MaxAirBrakeForce(speed);
                float targetForce = intervention*MaximumServiceBrakeForce();
                float targetDynamicForce = Math.Min(targetForce, MaxDynForce);
                float targetAirForce = targetForce-targetDynamicForce;
                if (intervention != -1)
                    DemandaTCU = Math.Max(-targetDynamicForce/maxDynForce), -1);
                epPressureBar = targetAirForce/maxAirForce;
                if (epPressureBar < 0.05f && FrenoResidual) epPressureBar = 0.05f;
            }
            SetFloatVariable("OrtsBrakeLinePressureBar", epPressureBar, 4);
            
            PanelFreno24();
        }
        bool ControlTFA = false;
        void PanelFreno24()
        {
            bool EV24L = !GetBoolVariable("ConexionFrenoAuxilo");
            ControllerState ValvulaAuxilio = ControllerState.Lap;
            if (Urgencia) ValvulaAuxilio = ControllerState.Emergency;
            else if (!EV24L)
            {
                int auxval = GetIntVariable("AuxiliaryBrake");
                switch (auxval)
                {
                    case -1:
                        ValvulaAuxilio = ControllerState.Release;
                        break;
                    case 0:
                        ValvulaAuxilio = ControllerState.Lap;
                        break;
                    case 1:
                        ValvulaAuxilio = ControllerState.Apply;
                        break;
                }
            }
            float pressureBar = GetFloatVariable("OrtsBrakeLinePressureBar", 3);
            float releasePressure = Math.Min(5, GetFloatValue("OrtsBrakeLinePressureBar", 1));
            float fullServPressure = 3.5f;
            switch(ValvulaAuxilio)
            {
                case ControllerState.Release:
                    IncreasePressure(ref pressureBar, releasePressure, ReleaseRateBarpS(), elapsedClockSeconds);
                    break;
                case ControllerState.Apply:
                    DecreasePressure(ref pressureBar, fullServPressure, ApplyRateBarpS(), elapsedClockSeconds);
                    break;
                case ControllerState.Emergency:
                    pressureBar = 0;
                    break;
            }
            SetFloatVariable("OrtsBrakeLinePressureBar", pressureBar, 3);
        }
        void PanelFreno27()
        {
            float cylPressureBar = GetFloatVariable("OrtsBrakeCylinderPressureBar");
            float epPressureBar;
            bool EV27G = Urgencia || GetBoolVariable("ConexionFrenoAuxilo");
            bool EV27L = false;
        }
        double LastTime=0;
        double LastError=0;
        double i_error=0;
        float ATF_brake=0;
        double p_coef = 2;
        double i_coef = 0.001;
        double d_coef = 0.4;
        protected double ATF(double limit)
        {
            double error = limit-SpeedMpS();
            double dt = ClockTime()-LastTime;
            if (dt < 0.0001f) return;
            if(Math.Abs(error)<1)
            {
                i_error += (error+LastError)*dt/2;
            }
            else i_error = 0;
            double d_error = (error-LastError)/dt;
            double p_out = p_coef*error;
            double i_out = i_coef*i_error;
            double d_out = d_coef*d_error;
            double diff = d_out+p_out+i_out;
            LastTime = ClockTime();
            LastError = error;
            return Math.Max(Math.Min((float)diff,1),-1);
        }
        public override void HandleEvent(string controller, float? value)
        {
            if (value == null) return;
            float val = value.Value;
            /*if ((controller == "OrtsThrottle" || controller == "OrtsTrainBrake") && GetIntVariable("OrtsDirection") != 0)
            {
                SetFloatVariable(controller, val);
            }*/
        }
        static void IncreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI < targetPSI)
            {
                pressurePSI += ratePSIpS * elapsedSeconds;
                if (pressurePSI > targetPSI)
                    pressurePSI = targetPSI;
            }
        }

        static void DecreasePressure(ref float pressurePSI, float targetPSI, float ratePSIpS, float elapsedSeconds)
        {
            if (pressurePSI > targetPSI)
            {
                pressurePSI -= ratePSIpS * elapsedSeconds;
                if (pressurePSI < targetPSI)
                    pressurePSI = targetPSI;
            }
        }
    }
}
