using ORTS.Common;
using ORTS.Scripting.Api;
using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Linq;
using System.Threading.Tasks;
using Event = Orts.Common.Event;
namespace ORTS.Scripting.Script
{
    public class Brake450 : BrakeController
    {
        enum State
        {
            Release,
            Apply,
            FullBrake,
            Emergency,
            AUXneutral,
            AUXincrease,
            AUXdecrease
        }
        State CurrentState=State.Apply;
        float Value=0;
        float applyValue=0;
        float airBrakeValue=0;
        float dynamicBrakeValue=0;
        bool AuxiliaryBrake = false;
        public override void Initialize()
        {
        }
        public override void InitializeMoving()
        {
        }
        bool presostatoMinima = false;
        public override float Update(float elapsedSeconds)
        {
            if (IntermediateValue != Value) Value = IntermediateValue;
            if(UpdateValue()==1)
            {
                if(Value>0.9)
                {
                    Value = 1;
                    SetUpdateValue(0);
                }
                else
                {
                    float prev = Value;
                    Value += elapsedSeconds/3;
                    if(Value>=0.9&&prev<0.9)
                    {
                        Value = 0.93f;
                        SetUpdateValue(0);
                    }
                }
            }
            if(UpdateValue()==-1)
            {
                float prev = Value;
                Value -= elapsedSeconds/3;
                if(Value<=0)
                {
                    Value = 0;
                    SetUpdateValue(0);
                }
            }
            IntermediateValue = Value;
            SetCurrentValue(Value);
            return CurrentValue();
        }
        public override void UpdatePressure(ref float pressureBar, float elapsedClockSeconds, ref float epPressureBar)
        {
            if (MainReservoirPressureBar() < 6) presostatoMinima = true;
            else if (MainReservoirPressureBar() > 6.5) presostatoMinima = false;
            
            if(EmergencyBrakingPushButton() || TCSEmergencyBraking() || Value > 0.95f || presostatoMinima) CurrentState = State.Emergency; 
            else if(TCSFullServiceBraking() || Value > 0.90f) CurrentState = State.FullBrake;
            else if(Value>0.01) CurrentState = State.Apply;
            else CurrentState = State.Release;
            if(Value<0.01) applyValue = 0;
            else applyValue = Math.Min(Math.Max((Value-0.01f)/0.89f*0.85f+0.15f, 0.15f), 1);
            
            if (AuxiliaryBrake)
            {
                dynamicBrakeValue = applyValue;
                airBrakeValue = 0;
            }
            else if (CurrentState != State.Emergency)
            {
                dynamicBrakeValue = Math.Min(applyValue/0.3f, 1);
                if (applyValue > 0.3f) airBrakeValue = (applyValue-0.3f)/0.7f;
                else airBrakeValue = 0;
            }
            else
            {
                airBrakeValue = applyValue;
                dynamicBrakeValue = 0;
            }
            
            SetDynamicBrakeIntervention(dynamicBrakeValue);
            
            float releasePressure = Math.Min(MaxPressureBar(), MainReservoirPressureBar());
            float fullServPressure = MaxPressureBar()-FullServReductionBar();
            switch(CurrentState)
            {
                case State.Release:
                    if (pressureBar < releasePressure) pressureBar = Math.Min(releasePressure, pressureBar+elapsedClockSeconds*ReleaseRateBarpS());
                    break;
                case State.Apply:
                    float target = MaxPressureBar() - airBrakeValue*FullServReductionBar();
                    if(target<pressureBar) pressureBar = Math.Max(target, pressureBar-elapsedClockSeconds*ApplyRateBarpS());
                    else if (target < releasePressure) pressureBar = Math.Min(target, pressureBar+elapsedClockSeconds*ReleaseRateBarpS());
                    break;
                case State.FullBrake:
                    if (pressureBar > fullServPressure) pressureBar = Math.Max(fullServPressure, pressureBar-elapsedClockSeconds*ApplyRateBarpS());
                    break;
                case State.Emergency:
                    pressureBar = Math.Max(0, pressureBar-elapsedClockSeconds*EmergencyRateBarpS());;
                    break;
                case State.AUXdecrease:
                    if (pressureBar < releasePressure) pressureBar = Math.Min(releasePressure, pressureBar+elapsedClockSeconds*ReleaseRateBarpS());
                    break;
                case State.AUXincrease:
                    pressureBar = Math.Max(0, pressureBar-elapsedClockSeconds*ApplyRateBarpS());
                    break;
            }
        }
        public override void UpdateEngineBrakePressure(ref float pressureBar, float elapsedClockSeconds)
        {
            
        }
        public override void HandleEvent(BrakeControllerEvent evt)
        {
            switch (evt)
            {
                case BrakeControllerEvent.StartIncrease:
                    SetUpdateValue(1);
                    break;
                case BrakeControllerEvent.StartDecrease:
                    SetUpdateValue(-1);
                    break;
                case BrakeControllerEvent.StopIncrease:
                case BrakeControllerEvent.StopDecrease:
                    SetUpdateValue(0);
                    break;
            }
        }
        public override void HandleEvent(BrakeControllerEvent evt, float? value)
        {
            if(evt == BrakeControllerEvent.SetCurrentPercent) Value = value.Value/100;
            if(evt == BrakeControllerEvent.SetCurrentValue) Value = value.Value;
            else HandleEvent(evt);
        }
        public override bool IsValid()
        {
            return true;
        }
        public override ControllerState GetState()
        {
            switch(CurrentState)
            {
                case State.Release:
                    return ControllerState.Release;
                case State.Apply:
                    return ControllerState.GSelfLap;
                case State.FullBrake:
                    if(TCSFullServiceBraking()) return ControllerState.TCSFullServ;
                    return ControllerState.FullServ;
                case State.Emergency:
                    if(EmergencyBrakingPushButton()) return ControllerState.EBPB;
                    if(TCSEmergencyBraking()||presostatoMinima) return ControllerState.TCSEmergency;
                    return ControllerState.Emergency;
            }
            return ControllerState.Dummy;
        }
        public override float? GetStateFraction()
        {
            if(CurrentState==State.Apply) return applyValue;
            return null;
        }

    }
}
