using System;
using System.Collections.Generic;
using System.IO.Ports;
using ORTS.Common;
using ORTS.Scripting.Api;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Linq;
using System.Threading.Tasks;
using Event = Orts.Common.Event;
namespace ORTS.Scripting.Script
{
    public class 447cb : ElectricPowerSupply
    {
        private IIRFilter PantographFilter;
        private IIRFilter VoltageFilter;
        private Timer PowerOnTimer;
        private Timer AuxPowerOnTimer;
        private Timer ServiceRetentionTimer;
        private Timer CabConnectionTimer;

        private bool QuickPowerOn = false;
        private bool QuickPowerOff = false;
        
        bool FirstUpdate=true;
        
        bool AutoCabChange=false;
        
        bool ReversePantographs;
        bool FromRearCab;
        bool CocheIntermedio;
        
        bool CabinaHabilitada=false;
        bool CabinaPropiaHabilitada=false;
        
        bool ControlAuxiliar=true;
        
        bool LowPowerOn;
        bool PowerOn;
        bool MainPowerOn;
        bool AuxPowerOn;
        bool CabPowerOn;

        public override void Initialize()
        {
            PantographFilter = new IIRFilter(IIRFilter.FilterTypes.Butterworth, 1, IIRFilter.HzToRad(0.7f), 0.001f);
            VoltageFilter = new IIRFilter(IIRFilter.FilterTypes.Butterworth, 1, IIRFilter.HzToRad(0.7f), 0.001f);
            
            PowerOnTimer = new Timer(this);
            PowerOnTimer.Setup(PowerOnDelayS());

            AuxPowerOnTimer = new Timer(this);
            AuxPowerOnTimer.Setup(AuxPowerOnDelayS());
            
            ServiceRetentionTimer = new Timer(this);
            ServiceRetentionTimer.Setup(15*60);
            
            CabConnectionTimer = new Timer(this);
            CabConnectionTimer.Setup(30);
            
            ReversePantographs = ((int)Math.Round(PowerOnDelayS()*10))%2 == 1;
            CocheIntermedio = PowerOnDelayS() < 1;
        }

        public override void Update(float elapsedClockSeconds)
        {
            if (FirstUpdate)
            {
                FirstUpdate = false;
                SignalEventToBatterySwitch(PowerSupplyEvent.CloseBatterySwitch);
                SignalEventToOtherTrainVehicles(PowerSupplyEvent.CloseBatterySwitch);
            }
            if (!CabConnectionTimer.Started || BatterySwitchOn()) SetCurrentBatteryState(BatterySwitchOn() ? PowerSupplyState.PowerOn : PowerSupplyState.PowerOff);
            
            if (MasterKeyOn() != CabinaPropiaHabilitada)
            {
                HabilitarCabina(MasterKeyOn(), true);
            }
            if (!CabinaHabilitada || CabConnectionTimer.Triggered) CabConnectionTimer.Stop();
            
            LowPowerOn = CurrentBatteryState() == PowerSupplyState.PowerOn;
            PowerOn = LowPowerOn && CurrentPantographState() == PantographState.Up && CurrentCircuitBreakerState() == CircuitBreakerState.Closed;
            MainPowerOn = PowerOn && CabinaHabilitada;
            AuxPowerOn = PowerOn && CabinaHabilitada && ControlAuxiliar;
            CabPowerOn = LowPowerOn && CabinaPropiaHabilitada && ControlAuxiliar;
            SetCurrentLowVoltagePowerSupplyState(LowPowerOn ? PowerSupplyState.PowerOn : PowerSupplyState.PowerOff);
            SetCurrentCabPowerSupplyState(CabPowerOn ? PowerSupplyState.PowerOn : PowerSupplyState.PowerOff);
            
            if (MainPowerOn && CurrentMainPowerSupplyState() != PowerSupplyState.PowerOn)
            {
                if (PowerOnTimer.Triggered)
                {
                    SignalEvent(Event.EnginePowerOn);
                    SetCurrentMainPowerSupplyState(PowerSupplyState.PowerOn);
                }
                else if (!PowerOnTimer.Started) PowerOnTimer.Start();
            }
            else if (!MainPowerOn && CurrentMainPowerSupplyState() != PowerSupplyState.PowerOff)
            {
                PowerOnTimer.Stop();
                SignalEvent(Event.EnginePowerOff);
                SetCurrentMainPowerSupplyState(PowerSupplyState.PowerOff);
            }
            if (AuxPowerOn && CurrentAuxiliaryPowerSupplyState() != PowerSupplyState.PowerOn)
            {
                if (AuxPowerOnTimer.Triggered) SetCurrentAuxiliaryPowerSupplyState(PowerSupplyState.PowerOn);
                else if (!AuxPowerOnTimer.Started) AuxPowerOnTimer.Start();
            }
            else if (!AuxPowerOn && CurrentAuxiliaryPowerSupplyState() != PowerSupplyState.PowerOff)
            {
                AuxPowerOnTimer.Stop();
                SetCurrentAuxiliaryPowerSupplyState(PowerSupplyState.PowerOff);
            }
            
            if (QuickPowerOn)
            {
                if (CurrentPantographState() == PantographState.Down)
                {
                    SetPantograph(1, true);
                    SetPantograph(2, false);
                }
                if (CurrentPantographState() == PantographState.Up && CurrentCircuitBreakerState() == CircuitBreakerState.Open)
                {
                    SignalEventToCircuitBreaker(PowerSupplyEvent.CloseCircuitBreaker);
                    SignalEventToOtherTrainVehicles(PowerSupplyEvent.CloseCircuitBreaker);
                    QuickPowerOn = false;
                }
                if (CurrentCircuitBreakerState() == CircuitBreakerState.Closed) QuickPowerOn = false;
            }
            if (QuickPowerOff)
            {
                if (CurrentCircuitBreakerState() == CircuitBreakerState.Closed)
                {
                    SignalEventToCircuitBreaker(PowerSupplyEvent.OpenCircuitBreaker);
                    SignalEventToOtherTrainVehicles(PowerSupplyEvent.OpenCircuitBreaker);
                }
                if (CurrentPantographState() == PantographState.Up)
                {
                    SetPantograph(1, false);
                    SetPantograph(2, false);
                }
                else QuickPowerOff = false;
            }
            SetPantographVoltageV(PantographFilter.Filter(CurrentPantographState() == PantographState.Up ? PantographVoltageV() : 0.0f, elapsedClockSeconds));
            SetFilterVoltageV(VoltageFilter.Filter(CurrentCircuitBreakerState() == CircuitBreakerState.Closed ? PantographVoltageV() : 0.0f, elapsedClockSeconds));

            // By default, on electric locomotives, dynamic brake is always available (rheostatic brake is always available).
            SetCurrentDynamicBrakeAvailability(CabPowerOn);
            Calefa();
            
            if (ServiceRetentionTimer.Triggered || !LowPowerOn) ServiceRetentionTimer.Stop();
            
            if (((!CabinaHabilitada && !ServiceRetentionTimer.Started) || !LowPowerOn) && CurrentPantographState() == PantographState.Up)
            {
                SetPantographs(false, false);
            }
        }
        void Calefa()
        {
            if (ElectricTrainSupplyUnfitted())
            {
                SetCurrentElectricTrainSupplyState(PowerSupplyState.Unavailable);
            }
            else if (CurrentAuxiliaryPowerSupplyState() == PowerSupplyState.PowerOn
                    && ElectricTrainSupplySwitchOn())
            {
                SetCurrentElectricTrainSupplyState(PowerSupplyState.PowerOn);
            }
            else
            {
                SetCurrentElectricTrainSupplyState(PowerSupplyState.PowerOff);
            }
        }
        void CabChange(bool start)
        {
            if (start)
            {
                ServiceRetentionTimer.Start();
                SetPantographs(true, true);
                SignalEventToOtherTrainVehicles(PowerSupplyEvent.ServiceRetentionButtonPressed);
            }
            else
            {
                ServiceRetentionTimer.Stop();
                SignalEventToOtherTrainVehicles(PowerSupplyEvent.ServiceRetentionCancellationButtonPressed);
            }
        }
        void SetPantograph(int num, bool up)
        {
            SignalEventToPantograph(up ? PowerSupplyEvent.RaisePantograph : PowerSupplyEvent.LowerPantograph, FromRearCab && CocheIntermedio ? (3-num) : num);
            SignalEventToOtherTrainVehiclesWithId(up ? PowerSupplyEvent.RaisePantograph : PowerSupplyEvent.LowerPantograph, num);
        }
        void SetPantographs(bool panto1, bool panto2)
        {
            SetPantograph(1, panto1);
            SetPantograph(2, panto2);
        }
        void HabilitarCabina(bool hab, bool own, bool rev=false)
        {
            if (CurrentBatteryState() != PowerSupplyState.PowerOn) return;
            FromRearCab = rev;
            CabinaHabilitada = hab;
            if (own)
            {
                CabinaPropiaHabilitada = hab;
                SignalEventToOtherTrainVehiclesWithId(hab ? PowerSupplyEvent.TurnOnMasterKey : PowerSupplyEvent.TurnOffMasterKey, ReversePantographs ? 1 : 0);
                if (hab)
                {
                    if (ServiceRetentionTimer.Started && !ServiceRetentionTimer.Triggered)
                    {
                        SetPantographs(false, true);
                        CabChange(false);
                        CabConnectionTimer.Start();
                    }
                }
                else
                {
                    if (AutoCabChange) CabChange(true);
                }
            }
        }
        public override void HandleEvent(PowerSupplyEvent evt)
        {
            switch (evt)
            {
                case PowerSupplyEvent.ServiceRetentionButtonPressed:
                case PowerSupplyEvent.ServiceRetentionCancellationButtonPressed:
                    if (!AutoCabChange)
                    {
                        bool start = evt == PowerSupplyEvent.ServiceRetentionButtonPressed;
                        CabChange(start);
                    }
                    break;
                case PowerSupplyEvent.TurnOnMasterKey:
                case PowerSupplyEvent.TurnOffMasterKey:
                    SignalEventToMasterKey(evt);
                    break;
                case PowerSupplyEvent.QuickPowerOn:
                    if (CurrentCabPowerSupplyState() == PowerSupplyState.PowerOn) QuickPowerOn = true;
                    /*SignalEventToBatterySwitch(PowerSupplyEvent.CloseBatterySwitch);
                    SignalEventToMasterKey(PowerSupplyEvent.TurnOnMasterKey);
                    SignalEventToPantograph(PowerSupplyEvent.RaisePantograph, 1);
                    SignalEventToOtherTrainVehiclesWithId(PowerSupplyEvent.RaisePantograph, 1);
                    SignalEventToElectricTrainSupplySwitch(PowerSupplyEvent.SwitchOnElectricTrainSupply);*/
                    break;

                case PowerSupplyEvent.QuickPowerOff:
                    QuickPowerOff = true;
                    /*SignalEventToElectricTrainSupplySwitch(PowerSupplyEvent.SwitchOffElectricTrainSupply);
                    SignalEventToCircuitBreaker(PowerSupplyEvent.OpenCircuitBreaker);
                    SignalEventToPantographs(PowerSupplyEvent.LowerPantograph);
                    SignalEventToOtherTrainVehicles(PowerSupplyEvent.LowerPantograph);
                    SignalEventToMasterKey(PowerSupplyEvent.TurnOffMasterKey);
                    SignalEventToBatterySwitch(PowerSupplyEvent.OpenBatterySwitch);*/
                    break;
                /*case PowerSupplyEvent.RaisePantograph:
                    if (CurrentCabPowerSupplyState() == PowerSupplyState.PowerOn) 
                    break;*/
                case PowerSupplyEvent.LowerPantograph:
                case PowerSupplyEvent.RaisePantograph:
                    break;
                default:
                    base.HandleEvent(evt);
                    break;
            }
        }
        public override void HandleEvent(PowerSupplyEvent evt, int id)
        {
            switch(evt)
            {
                case PowerSupplyEvent.LowerPantograph:
                case PowerSupplyEvent.RaisePantograph:
                    if (!CabinaPropiaHabilitada || !LowPowerOn) return;
                    bool up = evt == PowerSupplyEvent.RaisePantograph;
                    SetPantograph(id, up);
                    break;
                default:
                    base.HandleEvent(evt, id);
                    break;
            }
        }
        public override void HandleEventFromLeadLocomotive(PowerSupplyEvent evt)
        {
            switch (evt)
            {
                case PowerSupplyEvent.ServiceRetentionButtonPressed:
                    ServiceRetentionTimer.Start();
                    break;
                case PowerSupplyEvent.ServiceRetentionCancellationButtonPressed:
                    ServiceRetentionTimer.Stop();
                    break;
                case PowerSupplyEvent.TurnOnMasterKey:
                case PowerSupplyEvent.TurnOffMasterKey:
                    HabilitarCabina(evt == PowerSupplyEvent.TurnOnMasterKey, false);
                    break;
                default:
                    base.HandleEventFromLeadLocomotive(evt);
                    break;
            }
        }
        public override void HandleEventFromLeadLocomotive(PowerSupplyEvent evt, int id)
        {
            switch (evt)
            {
                case PowerSupplyEvent.TurnOnMasterKey:
                case PowerSupplyEvent.TurnOffMasterKey:
                    HabilitarCabina(evt == PowerSupplyEvent.TurnOnMasterKey, false, id == 1);
                    break;
                default:
                    base.HandleEventFromLeadLocomotive(evt, id);
                    break;
            } 
        }
    }
}
